/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.connectionpool2;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.exceptions.PlcUnsupportedOperationException;
import org.apache.plc4x.java.api.messages.PlcBrowseRequest;
import org.apache.plc4x.java.api.messages.PlcBrowseResponse;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.metadata.PlcConnectionMetadata;
import org.apache.plc4x.java.utils.connectionpool2.CachedBrowseRequestBuilder;
import org.apache.plc4x.java.utils.connectionpool2.CachedDriverManager;
import org.apache.plc4x.java.utils.connectionpool2.CachedReadRequestBuilder;
import org.apache.plc4x.java.utils.connectionpool2.CachedWriteRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedPlcConnection
implements PlcConnection,
PlcConnectionMetadata {
    private static final Logger logger = LoggerFactory.getLogger(CachedPlcConnection.class);
    private static final ScheduledExecutorService schedulerExecutor = Executors.newScheduledThreadPool(10);
    private final CachedDriverManager parent;
    private volatile PlcConnection activeConnection;
    private volatile boolean closed = false;

    public CachedPlcConnection(CachedDriverManager parent, PlcConnection activeConnection) {
        this.parent = parent;
        this.activeConnection = activeConnection;
    }

    public void connect() throws PlcConnectionException {
        logger.warn(".connect() is called on a Cached Connection. This has no effect but should not happen.");
    }

    public boolean isConnected() {
        if (this.closed) {
            return false;
        }
        return this.activeConnection.isConnected();
    }

    private CompletableFuture<? extends PlcBrowseResponse> wrapBrowseWithTimeout(CompletableFuture<? extends PlcBrowseResponse> future, long timeoutMillis) {
        final CompletableFuture responseFuture = new CompletableFuture();
        schedulerExecutor.schedule(() -> {
            if (!future.isDone()) {
                logger.debug("Timing out the PLC request!");
                future.cancel(true);
                responseFuture.completeExceptionally(new TimeoutException("Response did not finish in Time!"));
            } else {
                logger.trace("Unnecessary to cancel the request!");
            }
        }, timeoutMillis, TimeUnit.MILLISECONDS);
        future.handle(new BiFunction<PlcBrowseResponse, Throwable, Object>(){

            @Override
            public Object apply(PlcBrowseResponse plcBrowseResponse, Throwable throwable) {
                if (plcBrowseResponse != null) {
                    logger.debug("Request finsihed successfull!");
                    responseFuture.complete(plcBrowseResponse);
                } else {
                    logger.debug("Request failed", throwable);
                    responseFuture.completeExceptionally(throwable);
                }
                return null;
            }
        });
        return responseFuture;
    }

    private CompletableFuture<? extends PlcReadResponse> wrapReadWithTimeout(CompletableFuture<? extends PlcReadResponse> future, long timeoutMillis) {
        final CompletableFuture responseFuture = new CompletableFuture();
        schedulerExecutor.schedule(() -> {
            if (!future.isDone()) {
                logger.debug("Timing out the PLC request!");
                future.cancel(true);
                responseFuture.completeExceptionally(new TimeoutException("Response did not finish in Time!"));
            } else {
                logger.trace("Unnecessary to cancel the request!");
            }
        }, timeoutMillis, TimeUnit.MILLISECONDS);
        future.handle(new BiFunction<PlcReadResponse, Throwable, Object>(){

            @Override
            public Object apply(PlcReadResponse plcReadResponse, Throwable throwable) {
                if (plcReadResponse != null) {
                    logger.debug("Request finsihed successfull!");
                    responseFuture.complete(plcReadResponse);
                } else {
                    logger.debug("Request failed", throwable);
                    responseFuture.completeExceptionally(throwable);
                }
                return null;
            }
        });
        return responseFuture;
    }

    private CompletableFuture<? extends PlcWriteResponse> wrapWriteWithTimeout(CompletableFuture<? extends PlcWriteResponse> future, long timeoutMillis) {
        final CompletableFuture responseFuture = new CompletableFuture();
        schedulerExecutor.schedule(() -> {
            if (!future.isDone()) {
                logger.debug("Timing out the PLC request!");
                future.cancel(true);
                responseFuture.completeExceptionally(new TimeoutException("Response did not finish in Time!"));
            } else {
                logger.trace("Unnecessary to cancel the request!");
            }
        }, timeoutMillis, TimeUnit.MILLISECONDS);
        future.handle(new BiFunction<PlcWriteResponse, Throwable, Object>(){

            @Override
            public Object apply(PlcWriteResponse plcWriteResponse, Throwable throwable) {
                if (plcWriteResponse != null) {
                    logger.debug("Request finsihed successfull!");
                    responseFuture.complete(plcWriteResponse);
                } else {
                    logger.debug("Request failed", throwable);
                    responseFuture.completeExceptionally(throwable);
                }
                return null;
            }
        });
        return responseFuture;
    }

    public CompletableFuture<? extends PlcBrowseResponse> execute(PlcBrowseRequest request) {
        logger.trace("Trying to executing Request {}", (Object)request);
        if (this.closed) {
            throw new IllegalStateException("Trying to execute a Request on a closed Connection!");
        }
        try {
            logger.trace("Executing Request {}", (Object)request);
            CompletableFuture<? extends PlcBrowseResponse> responseFuture = this.wrapBrowseWithTimeout(request.execute(), 5000L);
            CompletionStage handledResponseFuture = responseFuture.handleAsync(new BiFunction<PlcBrowseResponse, Throwable, PlcBrowseResponse>(){

                @Override
                public PlcBrowseResponse apply(PlcBrowseResponse plcBrowseResponse, Throwable throwable) {
                    if (throwable != null) {
                        logger.warn("Request finished with exception. Reporting Connection as Broken", throwable);
                        CachedPlcConnection.this.closeConnectionExceptionally(null);
                    }
                    return plcBrowseResponse;
                }
            });
            return handledResponseFuture;
        }
        catch (Exception e) {
            return this.closeConnectionExceptionally(e);
        }
    }

    public CompletableFuture<? extends PlcReadResponse> execute(PlcReadRequest request) {
        logger.trace("Trying to executing Request {}", (Object)request);
        if (this.closed) {
            throw new IllegalStateException("Trying to execute a Request on a closed Connection!");
        }
        try {
            logger.trace("Executing Request {}", (Object)request);
            CompletableFuture<? extends PlcReadResponse> responseFuture = this.wrapReadWithTimeout(request.execute(), 5000L);
            CompletionStage handledResponseFuture = responseFuture.handleAsync(new BiFunction<PlcReadResponse, Throwable, PlcReadResponse>(){

                @Override
                public PlcReadResponse apply(PlcReadResponse plcReadResponse, Throwable throwable) {
                    if (throwable != null) {
                        logger.warn("Request finished with exception. Reporting Connection as Broken", throwable);
                        CachedPlcConnection.this.closeConnectionExceptionally(null);
                    }
                    return plcReadResponse;
                }
            });
            return handledResponseFuture;
        }
        catch (Exception e) {
            return this.closeConnectionExceptionally(e);
        }
    }

    public CompletableFuture<? extends PlcWriteResponse> execute(PlcWriteRequest request) {
        logger.trace("Trying to executing Request {}", (Object)request);
        if (this.closed) {
            throw new IllegalStateException("Trying to execute a Request on a closed Connection!");
        }
        try {
            logger.trace("Executing Request {}", (Object)request);
            CompletableFuture<? extends PlcWriteResponse> responseFuture = this.wrapWriteWithTimeout(request.execute(), 5000L);
            CompletionStage handledResponseFuture = responseFuture.handleAsync(new BiFunction<PlcWriteResponse, Throwable, PlcWriteResponse>(){

                @Override
                public PlcWriteResponse apply(PlcWriteResponse plcWriteResponse, Throwable throwable) {
                    if (throwable != null) {
                        logger.warn("Request finished with exception. Reporting Connection as Broken", throwable);
                        CachedPlcConnection.this.closeConnectionExceptionally(null);
                    }
                    return plcWriteResponse;
                }
            });
            return handledResponseFuture;
        }
        catch (Exception e) {
            return this.closeConnectionExceptionally(e);
        }
    }

    private CompletableFuture<? extends PlcResponse> closeConnectionExceptionally(Exception e) {
        this.closed = true;
        this.parent.handleBrokenConnection();
        this.activeConnection = null;
        throw new PlcRuntimeException("Unable to finish Request!", (Throwable)e);
    }

    PlcConnection getActiveConnection() {
        return this.activeConnection;
    }

    public synchronized void close() throws Exception {
        logger.debug("Closing cached connection and returning borrowed connection to pool.");
        this.closed = true;
        this.parent.returnConnection(this.activeConnection);
        this.activeConnection = null;
    }

    public PlcConnectionMetadata getMetadata() {
        if (this.closed) {
            throw new IllegalStateException("Trying to get Metadata on a closed Connection!");
        }
        return this;
    }

    public CompletableFuture<Void> ping() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        future.completeExceptionally((Throwable)new PlcUnsupportedOperationException("The connection does not support pinging"));
        return future;
    }

    public PlcBrowseRequest.Builder browseRequestBuilder() {
        if (this.closed) {
            throw new IllegalStateException("Trying to build a Request on a closed Connection!");
        }
        return new CachedBrowseRequestBuilder(this, this.getActiveConnection().browseRequestBuilder());
    }

    public PlcReadRequest.Builder readRequestBuilder() {
        if (this.closed) {
            throw new IllegalStateException("Trying to build a Request on a closed Connection!");
        }
        return new CachedReadRequestBuilder(this, this.getActiveConnection().readRequestBuilder());
    }

    public PlcWriteRequest.Builder writeRequestBuilder() {
        if (this.closed) {
            throw new IllegalStateException("Trying to build a Request on a closed Connection!");
        }
        return new CachedWriteRequestBuilder(this, this.getActiveConnection().writeRequestBuilder());
    }

    public PlcSubscriptionRequest.Builder subscriptionRequestBuilder() {
        throw new UnsupportedOperationException();
    }

    public PlcUnsubscriptionRequest.Builder unsubscriptionRequestBuilder() {
        throw new UnsupportedOperationException();
    }

    public boolean canBrowse() {
        if (this.closed) {
            return false;
        }
        return this.activeConnection.getMetadata().canBrowse();
    }

    public boolean canRead() {
        if (this.closed) {
            return false;
        }
        return this.activeConnection.getMetadata().canRead();
    }

    public boolean canWrite() {
        if (this.closed) {
            return false;
        }
        return this.activeConnection.getMetadata().canWrite();
    }

    public boolean canSubscribe() {
        if (this.closed) {
            return false;
        }
        return this.activeConnection.getMetadata().canSubscribe();
    }
}

