/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.connectionpool2;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.management.ObjectName;
import org.apache.plc4x.java.PlcDriverManager;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.utils.connectionpool2.CachedDriverManager;
import org.apache.plc4x.java.utils.connectionpool2.PooledDriverManagerMBean;

public class PooledDriverManager
extends PlcDriverManager
implements PooledDriverManagerMBean {
    private final Function<String, CachedDriverManager> factory;
    private final Map<String, CachedDriverManager> cachedManagers = new ConcurrentHashMap<String, CachedDriverManager>();

    public PooledDriverManager() {
        this(new PlcDriverManager());
    }

    public PooledDriverManager(PlcDriverManager driverManager) {
        this.factory = key -> new CachedDriverManager((String)key, () -> {
            try {
                return driverManager.getConnection(key);
            }
            catch (PlcConnectionException e) {
                throw new RuntimeException(e);
            }
        });
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(this, new ObjectName("org.pragmaticindustries.cockpit.plc:name=connection-pool"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    PooledDriverManager(Function<String, CachedDriverManager> factory) {
        this.factory = factory;
    }

    public PlcConnection getConnection(String url) throws PlcConnectionException {
        return this.cachedManagers.computeIfAbsent(url, this.factory).getConnection(url);
    }

    public PlcConnection getConnection(String url, PlcAuthentication authentication) throws PlcConnectionException {
        throw new UnsupportedOperationException();
    }

    Map<String, CachedDriverManager> getCachedManagers() {
        return this.cachedManagers;
    }

    @Override
    public String[] getConnectedUrls() {
        return this.cachedManagers.keySet().toArray(new String[0]);
    }
}

