/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.connectionpool;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.plc4x.java.PlcDriverManager;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.utils.connectionpool.PoolKey;
import org.apache.plc4x.java.utils.connectionpool.PoolKeyFactory;
import org.apache.plc4x.java.utils.connectionpool.PooledPlcConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledPlcDriverManager
extends PlcDriverManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PooledPlcDriverManager.class);
    private KeyedObjectPool<PoolKey, PlcConnection> keyedObjectPool;
    static final NoPlcAuthentication noPlcAuthentication = new NoPlcAuthentication();
    private final PoolKeyFactory poolKeyFactory;

    public PooledPlcDriverManager() {
        this(GenericKeyedObjectPool::new);
    }

    public PooledPlcDriverManager(PoolKeyFactory poolKeyFactory) {
        this(GenericKeyedObjectPool::new, poolKeyFactory);
    }

    public PooledPlcDriverManager(ClassLoader classLoader) {
        this(classLoader, new PoolKeyFactory());
    }

    public PooledPlcDriverManager(ClassLoader classLoader, PoolKeyFactory poolKeyFactory) {
        super(classLoader);
        this.setFromPoolCreator(GenericKeyedObjectPool::new);
        this.poolKeyFactory = poolKeyFactory;
    }

    public PooledPlcDriverManager(PoolCreator poolCreator) {
        this(poolCreator, new PoolKeyFactory());
    }

    public PooledPlcDriverManager(PoolCreator poolCreator, PoolKeyFactory poolKeyFactory) {
        this.setFromPoolCreator(poolCreator);
        this.poolKeyFactory = poolKeyFactory;
    }

    public PooledPlcDriverManager(ClassLoader classLoader, PoolCreator poolCreator) {
        super(classLoader);
        this.setFromPoolCreator(poolCreator);
        this.poolKeyFactory = new PoolKeyFactory();
    }

    private void setFromPoolCreator(PoolCreator poolCreator) {
        this.keyedObjectPool = poolCreator.createPool(new PooledPlcConnectionFactory(){

            public PlcConnection create(PoolKey key) throws Exception {
                PlcAuthentication plcAuthentication = key.plcAuthentication;
                String url = key.url;
                if (plcAuthentication == noPlcAuthentication) {
                    LOGGER.debug("getting actual connection for {}", (Object)url);
                    return PooledPlcDriverManager.super.getConnection(url);
                }
                LOGGER.debug("getting actual connection for {} and plcAuthentication {}", (Object)url, (Object)plcAuthentication);
                return PooledPlcDriverManager.super.getConnection(url, plcAuthentication);
            }
        });
    }

    public PlcConnection getConnection(String url) throws PlcConnectionException {
        return this.getConnection(url, noPlcAuthentication);
    }

    public PlcConnection getConnection(String url, PlcAuthentication authentication) throws PlcConnectionException {
        PlcConnection plcConnection;
        PoolKey poolKey = this.poolKeyFactory.getPoolKey(url, authentication);
        if (LOGGER.isDebugEnabled()) {
            if (authentication != noPlcAuthentication) {
                LOGGER.debug("Try to borrow an object for url {} and authentication {}", (Object)url, (Object)authentication);
            } else {
                LOGGER.debug("Try to borrow an object for url {}", (Object)url);
            }
        }
        try {
            plcConnection = (PlcConnection)this.keyedObjectPool.borrowObject((Object)poolKey);
            if (!plcConnection.isConnected()) {
                LOGGER.debug("Attempting to reconnect to device");
                plcConnection.connect();
            }
        }
        catch (Exception e) {
            throw new PlcConnectionException((Throwable)e);
        }
        AtomicBoolean proxyInvalidated = new AtomicBoolean(false);
        return (PlcConnection)Proxy.newProxyInstance(this.classLoader, new Class[]{PlcConnection.class}, (proxy, method, args) -> {
            if (proxyInvalidated.get()) {
                throw new IllegalStateException("Proxy not valid anymore");
            }
            if ("close".equals(method.getName())) {
                LOGGER.debug("close called on {}", (Object)plcConnection);
                proxyInvalidated.set(true);
                this.keyedObjectPool.returnObject((Object)poolKey, (Object)plcConnection);
                return null;
            }
            try {
                return method.invoke((Object)plcConnection, args);
            }
            catch (InvocationTargetException e) {
                if (e.getCause().getClass() == PlcConnectionException.class) {
                    this.keyedObjectPool.invalidateObject((Object)poolKey, (Object)plcConnection);
                    proxyInvalidated.set(true);
                }
                throw e;
            }
        });
    }

    public Map<String, Number> getStatistics() {
        HashMap<String, Number> statistics = new HashMap<String, Number>();
        statistics.put("numActive", this.keyedObjectPool.getNumActive());
        statistics.put("numIdle", this.keyedObjectPool.getNumIdle());
        if (this.keyedObjectPool instanceof GenericKeyedObjectPool) {
            GenericKeyedObjectPool genericKeyedObjectPool = (GenericKeyedObjectPool)this.keyedObjectPool;
            try {
                Map poolMap = (Map)FieldUtils.getField(GenericKeyedObjectPool.class, (String)"poolMap", (boolean)true).get(this.keyedObjectPool);
                statistics.put("pools.count", poolMap.size());
            }
            catch (IllegalAccessException e) {
                throw new PlcRuntimeException((Throwable)e);
            }
            Map numActivePerKey = genericKeyedObjectPool.getNumActivePerKey();
            for (Map.Entry entry : numActivePerKey.entrySet()) {
                statistics.put((String)entry.getKey() + ".numActive", (Number)entry.getValue());
            }
        }
        return statistics;
    }

    @FunctionalInterface
    public static interface PoolCreator {
        public KeyedObjectPool<PoolKey, PlcConnection> createPool(PooledPlcConnectionFactory var1);
    }

    private static final class NoPlcAuthentication
    implements PlcAuthentication {
        private NoPlcAuthentication() {
        }
    }
}

