/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.abeth.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class DF1ResponseMessage implements Message {

  // Abstract accessors for discriminator values.
  public abstract Short getCommandCode();

  // Properties.
  protected final short destinationAddress;
  protected final short sourceAddress;
  protected final short status;
  protected final int transactionCounter;

  public DF1ResponseMessage(
      short destinationAddress, short sourceAddress, short status, int transactionCounter) {
    super();
    this.destinationAddress = destinationAddress;
    this.sourceAddress = sourceAddress;
    this.status = status;
    this.transactionCounter = transactionCounter;
  }

  public short getDestinationAddress() {
    return destinationAddress;
  }

  public short getSourceAddress() {
    return sourceAddress;
  }

  public short getStatus() {
    return status;
  }

  public int getTransactionCounter() {
    return transactionCounter;
  }

  protected abstract void serializeDF1ResponseMessageChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("DF1ResponseMessage");

    // Reserved Field (reserved)
    writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (destinationAddress)
    writeSimpleField("destinationAddress", destinationAddress, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (sourceAddress)
    writeSimpleField("sourceAddress", sourceAddress, writeUnsignedShort(writeBuffer, 8));

    // Reserved Field (reserved)
    writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

    // Discriminator Field (commandCode) (Used as input to a switch field)
    writeDiscriminatorField("commandCode", getCommandCode(), writeUnsignedShort(writeBuffer, 8));

    // Simple Field (status)
    writeSimpleField("status", status, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (transactionCounter)
    writeSimpleField("transactionCounter", transactionCounter, writeUnsignedInt(writeBuffer, 16));

    // Switch field (Serialize the sub-type)
    serializeDF1ResponseMessageChild(writeBuffer);

    writeBuffer.popContext("DF1ResponseMessage");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    DF1ResponseMessage _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Simple field (destinationAddress)
    lengthInBits += 8;

    // Simple field (sourceAddress)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Discriminator Field (commandCode)
    lengthInBits += 8;

    // Simple field (status)
    lengthInBits += 8;

    // Simple field (transactionCounter)
    lengthInBits += 16;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static DF1ResponseMessage staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 1)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 1, but got " + args.length);
    }
    Integer payloadLength;
    if (args[0] instanceof Integer) {
      payloadLength = (Integer) args[0];
    } else if (args[0] instanceof String) {
      payloadLength = Integer.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type Integer or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    return staticParse(readBuffer, payloadLength);
  }

  public static DF1ResponseMessage staticParse(ReadBuffer readBuffer, Integer payloadLength)
      throws ParseException {
    readBuffer.pullContext("DF1ResponseMessage");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

    short destinationAddress =
        readSimpleField("destinationAddress", readUnsignedShort(readBuffer, 8));

    short sourceAddress = readSimpleField("sourceAddress", readUnsignedShort(readBuffer, 8));

    Short reservedField1 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

    short commandCode = readDiscriminatorField("commandCode", readUnsignedShort(readBuffer, 8));

    short status = readSimpleField("status", readUnsignedShort(readBuffer, 8));

    int transactionCounter = readSimpleField("transactionCounter", readUnsignedInt(readBuffer, 16));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    DF1ResponseMessageBuilder builder = null;
    if (EvaluationHelper.equals(commandCode, (short) 0x4F)) {
      builder =
          DF1CommandResponseMessageProtectedTypedLogicalRead.staticParseDF1ResponseMessageBuilder(
              readBuffer, payloadLength);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "commandCode="
              + commandCode
              + "]");
    }

    readBuffer.closeContext("DF1ResponseMessage");
    // Create the instance
    DF1ResponseMessage _dF1ResponseMessage =
        builder.build(destinationAddress, sourceAddress, status, transactionCounter);
    return _dF1ResponseMessage;
  }

  public interface DF1ResponseMessageBuilder {
    DF1ResponseMessage build(
        short destinationAddress, short sourceAddress, short status, int transactionCounter);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DF1ResponseMessage)) {
      return false;
    }
    DF1ResponseMessage that = (DF1ResponseMessage) o;
    return (getDestinationAddress() == that.getDestinationAddress())
        && (getSourceAddress() == that.getSourceAddress())
        && (getStatus() == that.getStatus())
        && (getTransactionCounter() == that.getTransactionCounter())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getDestinationAddress(), getSourceAddress(), getStatus(), getTransactionCounter());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
