/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth.types;

import java.util.HashMap;
import java.util.Map;
import org.apache.plc4x.java.api.types.PlcValueType;

public enum FileType {
    STATUS(132, PlcValueType.RAW_BYTE_ARRAY),
    BIT(133, PlcValueType.BOOL),
    TIMER(134, PlcValueType.TIME),
    COUNTER(135, PlcValueType.RAW_BYTE_ARRAY),
    CONTROL(136, PlcValueType.RAW_BYTE_ARRAY),
    INTEGER(137, PlcValueType.INT),
    FLOAT(138, PlcValueType.REAL),
    OUTPUT(139, PlcValueType.RAW_BYTE_ARRAY),
    INPUT(140, PlcValueType.RAW_BYTE_ARRAY),
    STRING(141, PlcValueType.STRING),
    ASCII(142, PlcValueType.STRING),
    BCD(143, PlcValueType.RAW_BYTE_ARRAY),
    WORD(137, PlcValueType.WORD),
    DWORD(137, PlcValueType.DWORD),
    SINGLEBIT(137, PlcValueType.WORD);

    private final short typeCode;
    private final PlcValueType plcValueType;
    private static final Map<Short, FileType> map;

    static {
        map = new HashMap<Short, FileType>();
        FileType[] fileTypeArray = FileType.values();
        int n = fileTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileType dataType = fileTypeArray[n2];
            map.put(dataType.typeCode, dataType);
            ++n2;
        }
    }

    private FileType(short typeCode, PlcValueType plcValueType) {
        this.typeCode = typeCode;
        this.plcValueType = plcValueType;
    }

    public short getTypeCode() {
        return this.typeCode;
    }

    public PlcValueType getPlcValueType() {
        return this.plcValueType;
    }

    public static FileType valueOf(String string) {
        return Enum.valueOf(FileType.class, string);
    }
}

