/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.ads.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AdsReadStateResponse extends AmsPacket implements Message {

  // Accessors for discriminator values.
  public CommandId getCommandId() {
    return CommandId.ADS_READ_STATE;
  }

  public Boolean getResponse() {
    return (boolean) true;
  }

  // Properties.
  protected final ReturnCode result;
  protected final int adsState;
  protected final int deviceState;

  public AdsReadStateResponse(
      AmsNetId targetAmsNetId,
      int targetAmsPort,
      AmsNetId sourceAmsNetId,
      int sourceAmsPort,
      long errorCode,
      long invokeId,
      ReturnCode result,
      int adsState,
      int deviceState) {
    super(targetAmsNetId, targetAmsPort, sourceAmsNetId, sourceAmsPort, errorCode, invokeId);
    this.result = result;
    this.adsState = adsState;
    this.deviceState = deviceState;
  }

  public ReturnCode getResult() {
    return result;
  }

  public int getAdsState() {
    return adsState;
  }

  public int getDeviceState() {
    return deviceState;
  }

  @Override
  protected void serializeAmsPacketChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("AdsReadStateResponse");

    // Simple Field (result)
    writeSimpleEnumField(
        "result",
        "ReturnCode",
        result,
        new DataWriterEnumDefault<>(
            ReturnCode::getValue, ReturnCode::name, writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (adsState)
    writeSimpleField("adsState", adsState, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (deviceState)
    writeSimpleField("deviceState", deviceState, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("AdsReadStateResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AdsReadStateResponse _value = this;

    // Simple field (result)
    lengthInBits += 32;

    // Simple field (adsState)
    lengthInBits += 16;

    // Simple field (deviceState)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static AdsReadStateResponseBuilder staticParseBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("AdsReadStateResponse");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    ReturnCode result =
        readEnumField(
            "result",
            "ReturnCode",
            new DataReaderEnumDefault<>(
                ReturnCode::enumForValue, readUnsignedLong(readBuffer, 32)));

    int adsState = readSimpleField("adsState", readUnsignedInt(readBuffer, 16));

    int deviceState = readSimpleField("deviceState", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("AdsReadStateResponse");
    // Create the instance
    return new AdsReadStateResponseBuilder(result, adsState, deviceState);
  }

  public static class AdsReadStateResponseBuilder implements AmsPacket.AmsPacketBuilder {
    private final ReturnCode result;
    private final int adsState;
    private final int deviceState;

    public AdsReadStateResponseBuilder(ReturnCode result, int adsState, int deviceState) {

      this.result = result;
      this.adsState = adsState;
      this.deviceState = deviceState;
    }

    public AdsReadStateResponse build(
        AmsNetId targetAmsNetId,
        int targetAmsPort,
        AmsNetId sourceAmsNetId,
        int sourceAmsPort,
        long errorCode,
        long invokeId) {
      AdsReadStateResponse adsReadStateResponse =
          new AdsReadStateResponse(
              targetAmsNetId,
              targetAmsPort,
              sourceAmsNetId,
              sourceAmsPort,
              errorCode,
              invokeId,
              result,
              adsState,
              deviceState);
      return adsReadStateResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AdsReadStateResponse)) {
      return false;
    }
    AdsReadStateResponse that = (AdsReadStateResponse) o;
    return (getResult() == that.getResult())
        && (getAdsState() == that.getAdsState())
        && (getDeviceState() == that.getDeviceState())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getResult(), getAdsState(), getDeviceState());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
