/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.ads.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AdsWriteRequest extends AmsPacket implements Message {

  // Accessors for discriminator values.
  public CommandId getCommandId() {
    return CommandId.ADS_WRITE;
  }

  public Boolean getResponse() {
    return (boolean) false;
  }

  // Properties.
  protected final long indexGroup;
  protected final long indexOffset;
  protected final byte[] data;

  public AdsWriteRequest(
      AmsNetId targetAmsNetId,
      int targetAmsPort,
      AmsNetId sourceAmsNetId,
      int sourceAmsPort,
      long errorCode,
      long invokeId,
      long indexGroup,
      long indexOffset,
      byte[] data) {
    super(targetAmsNetId, targetAmsPort, sourceAmsNetId, sourceAmsPort, errorCode, invokeId);
    this.indexGroup = indexGroup;
    this.indexOffset = indexOffset;
    this.data = data;
  }

  public long getIndexGroup() {
    return indexGroup;
  }

  public long getIndexOffset() {
    return indexOffset;
  }

  public byte[] getData() {
    return data;
  }

  @Override
  protected void serializeAmsPacketChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("AdsWriteRequest");

    // Simple Field (indexGroup)
    writeSimpleField("indexGroup", indexGroup, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (indexOffset)
    writeSimpleField("indexOffset", indexOffset, writeUnsignedLong(writeBuffer, 32));

    // Implicit Field (length) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    long length = (long) (COUNT(getData()));
    writeImplicitField("length", length, writeUnsignedLong(writeBuffer, 32));

    // Array Field (data)
    writeByteArrayField("data", data, writeByteArray(writeBuffer, 8));

    writeBuffer.popContext("AdsWriteRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AdsWriteRequest _value = this;

    // Simple field (indexGroup)
    lengthInBits += 32;

    // Simple field (indexOffset)
    lengthInBits += 32;

    // Implicit Field (length)
    lengthInBits += 32;

    // Array field
    if (data != null) {
      lengthInBits += 8 * data.length;
    }

    return lengthInBits;
  }

  public static AdsWriteRequestBuilder staticParseBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("AdsWriteRequest");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    long indexGroup = readSimpleField("indexGroup", readUnsignedLong(readBuffer, 32));

    long indexOffset = readSimpleField("indexOffset", readUnsignedLong(readBuffer, 32));

    long length = readImplicitField("length", readUnsignedLong(readBuffer, 32));

    byte[] data = readBuffer.readByteArray("data", Math.toIntExact(length));

    readBuffer.closeContext("AdsWriteRequest");
    // Create the instance
    return new AdsWriteRequestBuilder(indexGroup, indexOffset, data);
  }

  public static class AdsWriteRequestBuilder implements AmsPacket.AmsPacketBuilder {
    private final long indexGroup;
    private final long indexOffset;
    private final byte[] data;

    public AdsWriteRequestBuilder(long indexGroup, long indexOffset, byte[] data) {

      this.indexGroup = indexGroup;
      this.indexOffset = indexOffset;
      this.data = data;
    }

    public AdsWriteRequest build(
        AmsNetId targetAmsNetId,
        int targetAmsPort,
        AmsNetId sourceAmsNetId,
        int sourceAmsPort,
        long errorCode,
        long invokeId) {
      AdsWriteRequest adsWriteRequest =
          new AdsWriteRequest(
              targetAmsNetId,
              targetAmsPort,
              sourceAmsNetId,
              sourceAmsPort,
              errorCode,
              invokeId,
              indexGroup,
              indexOffset,
              data);
      return adsWriteRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AdsWriteRequest)) {
      return false;
    }
    AdsWriteRequest that = (AdsWriteRequest) o;
    return (getIndexGroup() == that.getIndexGroup())
        && (getIndexOffset() == that.getIndexOffset())
        && (getData() == that.getData())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getIndexGroup(), getIndexOffset(), getData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
