/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.ads.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum ReturnCode {
  OK((long) 0x00L),
  INTERNAL_ERROR((long) 0x01L),
  NO_REALTIME((long) 0x02L),
  SAVE_ERROR((long) 0x03L),
  MAILBOX_FULL((long) 0x04L),
  WRONG_HMSG((long) 0x05L),
  TARGET_PORT_NOT_FOUND((long) 0x06L),
  TARGET_HOST_NOT_FOUND((long) 0x07L),
  UNKNOWN_COMMAND_ID((long) 0x08L),
  UNKNOWN_TASK_ID((long) 0x09L),
  NO_IO((long) 0x0AL),
  UNKNOWN_ADS_COMMAND((long) 0x0BL),
  WIN32_ERROR((long) 0x0CL),
  PORT_NOT_CONNECTED((long) 0x0DL),
  INVALID_ADS_LENGTH((long) 0x0EL),
  INVALID_AMS_NET_ID((long) 0x0FL),
  LOW_INSTALLATION_LEVEL((long) 0x10L),
  NO_DEBUGGING_AVAILABLE((long) 0x11L),
  PORT_DEACTIVATED((long) 0x12L),
  PORT_ALREADY_CONNECTED((long) 0x13L),
  ADS_SYNC_WIN32_ERROR((long) 0x14L),
  ADS_SYNC_TIMEOUT((long) 0x15L),
  ADS_SYNC_AMS_ERROR((long) 0x16L),
  NO_INDEX_MAP_FOR_ADS_AVAILABLE((long) 0x17L),
  INVALID_ADS_PORT((long) 0x18L),
  NO_MEMORY((long) 0x19L),
  TCP_SENDING_ERROR((long) 0x1AL),
  HOST_NOT_REACHABLE((long) 0x1BL),
  INVALID_AMS_FRAGMENT((long) 0x1CL),
  ROUTERERR_NOLOCKEDMEMORY((long) 0x500L),
  ROUTERERR_RESIZEMEMORY((long) 0x501L),
  ROUTERERR_MAILBOXFULL((long) 0x502L),
  ROUTERERR_DEBUGBOXFULL((long) 0x503L),
  ROUTERERR_UNKNOWNPORTTYPE((long) 0x504L),
  ROUTERERR_NOTINITIALIZED((long) 0x505L),
  ROUTERERR_PORTALREADYINUSE((long) 0x506L),
  ROUTERERR_NOTREGISTERED((long) 0x507L),
  ROUTERERR_NOMOREQUEUES((long) 0x508L),
  ROUTERERR_INVALIDPORT((long) 0x509L),
  ROUTERERR_NOTACTIVATED((long) 0x50AL),
  ADSERR_DEVICE_ERROR((long) 0x700L),
  ADSERR_DEVICE_SRVNOTSUPP((long) 0x701L),
  ADSERR_DEVICE_INVALIDGRP((long) 0x702L),
  ADSERR_DEVICE_INVALIDOFFSET((long) 0x703L),
  ADSERR_DEVICE_INVALIDACCESS((long) 0x704L),
  ADSERR_DEVICE_INVALIDSIZE((long) 0x705L),
  ADSERR_DEVICE_INVALIDDATA((long) 0x706L),
  ADSERR_DEVICE_NOTREADY((long) 0x707L),
  ADSERR_DEVICE_BUSY((long) 0x708L),
  ADSERR_DEVICE_INVALIDCONTEXT((long) 0x709L),
  ADSERR_DEVICE_NOMEMORY((long) 0x70AL),
  ADSERR_DEVICE_INVALIDPARM((long) 0x70BL),
  ADSERR_DEVICE_NOTFOUND((long) 0x70CL),
  ADSERR_DEVICE_SYNTAX((long) 0x70DL),
  ADSERR_DEVICE_INCOMPATIBLE((long) 0x70EL),
  ADSERR_DEVICE_EXISTS((long) 0x70FL),
  ADSERR_DEVICE_SYMBOLNOTFOUND((long) 0x710L),
  ADSERR_DEVICE_SYMBOLVERSIONINVALID((long) 0x711L),
  ADSERR_DEVICE_INVALIDSTATE((long) 0x712L),
  ADSERR_DEVICE_TRANSMODENOTSUPP((long) 0x713L),
  ADSERR_DEVICE_NOTIFYHNDINVALID((long) 0x714L),
  ADSERR_DEVICE_CLIENTUNKNOWN((long) 0x715L),
  ADSERR_DEVICE_NOMOREHDLS((long) 0x716L),
  ADSERR_DEVICE_INVALIDWATCHSIZE((long) 0x717L),
  ADSERR_DEVICE_NOTINIT((long) 0x718L),
  ADSERR_DEVICE_TIMEOUT((long) 0x719L),
  ADSERR_DEVICE_NOINTERFACE((long) 0x71AL),
  ADSERR_DEVICE_INVALIDINTERFACE((long) 0x71BL),
  ADSERR_DEVICE_INVALIDCLSID((long) 0x71CL),
  ADSERR_DEVICE_INVALIDOBJID((long) 0x71DL),
  ADSERR_DEVICE_PENDING((long) 0x71EL),
  ADSERR_DEVICE_ABORTED((long) 0x71FL),
  ADSERR_DEVICE_WARNING((long) 0x720L),
  ADSERR_DEVICE_INVALIDARRAYIDX((long) 0x721L),
  ADSERR_DEVICE_SYMBOLNOTACTIVE((long) 0x722L),
  ADSERR_DEVICE_ACCESSDENIED((long) 0x723L),
  ADSERR_DEVICE_LICENSENOTFOUND((long) 0x724L),
  ADSERR_DEVICE_LICENSEEXPIRED((long) 0x725L),
  ADSERR_DEVICE_LICENSEEXCEEDED((long) 0x726L),
  ADSERR_DEVICE_LICENSEINVALID((long) 0x727L),
  ADSERR_DEVICE_LICENSESYSTEMID((long) 0x728L),
  ADSERR_DEVICE_LICENSENOTIMELIMIT((long) 0x729L),
  ADSERR_DEVICE_LICENSEFUTUREISSUE((long) 0x72AL),
  ADSERR_DEVICE_LICENSETIMETOLONG((long) 0x72BL),
  ADSERR_DEVICE_EXCEPTION((long) 0x72cL),
  ADSERR_DEVICE_LICENSEDUPLICATED((long) 0x72DL),
  ADSERR_DEVICE_SIGNATUREINVALID((long) 0x72EL),
  ADSERR_DEVICE_CERTIFICATEINVALID((long) 0x72FL),
  ADSERR_CLIENT_ERROR((long) 0x740L),
  ADSERR_CLIENT_INVALIDPARM((long) 0x741L),
  ADSERR_CLIENT_LISTEMPTY((long) 0x742L),
  ADSERR_CLIENT_VARUSED((long) 0x743L),
  ADSERR_CLIENT_DUPLINVOKEID((long) 0x744L),
  ADSERR_CLIENT_SYNCTIMEOUT((long) 0x745L),
  ADSERR_CLIENT_W32ERROR((long) 0x746L),
  ADSERR_CLIENT_TIMEOUTINVALID((long) 0x747L),
  ADSERR_CLIENT_PORTNOTOPEN((long) 0x748L),
  ADSERR_CLIENT_NOAMSADDR((long) 0x750L),
  ADSERR_CLIENT_SYNCINTERNAL((long) 0x751L),
  ADSERR_CLIENT_ADDHASH((long) 0x752L),
  ADSERR_CLIENT_REMOVEHASH((long) 0x753L),
  ADSERR_CLIENT_NOMORESYM((long) 0x754L),
  ADSERR_CLIENT_SYNCRESINVALID((long) 0x755L),
  RTERR_INTERNAL((long) 0x1000L),
  RTERR_BADTIMERPERIODS((long) 0x1001L),
  RTERR_INVALIDTASKPTR((long) 0x1002L),
  RTERR_INVALIDSTACKPTR((long) 0x1003L),
  RTERR_PRIOEXISTS((long) 0x1004L),
  RTERR_NOMORETCB((long) 0x1005L),
  RTERR_NOMORESEMAS((long) 0x1006L),
  RTERR_NOMOREQUEUES((long) 0x1007L),
  RTERR_EXTIRQALREADYDEF((long) 0x100DL),
  RTERR_EXTIRQNOTDEF((long) 0x100EL),
  RTERR_EXTIRQINSTALLFAILED((long) 0x100FL),
  RTERR_IRQLNOTLESSOREQUAL((long) 0x1010L),
  RTERR_VMXNOTSUPPORTED((long) 0x1017L),
  RTERR_VMXDISABLED((long) 0x1018L),
  RTERR_VMXCONTROLSMISSING((long) 0x1019L),
  RTERR_VMXENABLEFAILS((long) 0x101AL),
  WSAETIMEDOUT((long) 0x274CL),
  WSAECONNREFUSED((long) 0x274DL),
  WSAEHOSTUNREACH((long) 0x2751L);
  private static final Map<Long, ReturnCode> map;

  static {
    map = new HashMap<>();
    for (ReturnCode value : ReturnCode.values()) {
      map.put((long) value.getValue(), value);
    }
  }

  private long value;

  ReturnCode(long value) {
    this.value = value;
  }

  public long getValue() {
    return value;
  }

  public static ReturnCode enumForValue(long value) {
    return map.get(value);
  }

  public static Boolean isDefined(long value) {
    return map.containsKey(value);
  }
}
