/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.configuration;

import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.plc4x.java.ads.readwrite.AdsConstants;
import org.apache.plc4x.java.ads.readwrite.AmsNetId;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.configuration.ConfigurationParameterConverter;
import org.apache.plc4x.java.spi.configuration.annotations.ConfigurationParameter;
import org.apache.plc4x.java.spi.configuration.annotations.ParameterConverter;
import org.apache.plc4x.java.spi.configuration.annotations.Required;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.BooleanDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.IntDefaultValue;
import org.apache.plc4x.java.transport.serial.SerialTransportConfiguration;
import org.apache.plc4x.java.transport.tcp.TcpTransportConfiguration;

public class AdsConfiguration
implements Configuration,
TcpTransportConfiguration,
SerialTransportConfiguration {
    public static final Pattern AMS_NET_ID_PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    @Required
    @ConfigurationParameter
    @ParameterConverter(value=AmsNetIdConverter.class)
    protected AmsNetId targetAmsNetId;
    @Required
    @ConfigurationParameter
    protected int targetAmsPort;
    @Required
    @ConfigurationParameter
    @ParameterConverter(value=AmsNetIdConverter.class)
    protected AmsNetId sourceAmsNetId;
    @Required
    @ConfigurationParameter
    protected int sourceAmsPort;
    @ConfigurationParameter(value="timeout-symbolic-address-resolution")
    @IntDefaultValue(value=2000)
    protected int timeoutSymbolicAddressResolution;
    @ConfigurationParameter(value="timeout-request")
    @IntDefaultValue(value=4000)
    protected int timeoutRequest;
    @ConfigurationParameter(value="load-symbol-and-data-type-tables")
    @BooleanDefaultValue(value=true)
    protected boolean loadSymbolAndDataTypeTables;

    public AmsNetId getTargetAmsNetId() {
        return this.targetAmsNetId;
    }

    public void setTargetAmsNetId(AmsNetId targetAmsNetId) {
        this.targetAmsNetId = targetAmsNetId;
    }

    public int getTargetAmsPort() {
        return this.targetAmsPort;
    }

    public void setTargetAmsPort(int targetAmsPort) {
        this.targetAmsPort = targetAmsPort;
    }

    public AmsNetId getSourceAmsNetId() {
        return this.sourceAmsNetId;
    }

    public void setSourceAmsNetId(AmsNetId sourceAmsNetId) {
        this.sourceAmsNetId = sourceAmsNetId;
    }

    public int getSourceAmsPort() {
        return this.sourceAmsPort;
    }

    public void setSourceAmsPort(int sourceAmsPort) {
        this.sourceAmsPort = sourceAmsPort;
    }

    public int getTimeoutSymbolicAddressResolution() {
        return this.timeoutSymbolicAddressResolution;
    }

    public void setTimeoutSymbolicAddressResolution(int timeoutSymbolicAddressResolution) {
        this.timeoutSymbolicAddressResolution = timeoutSymbolicAddressResolution;
    }

    public int getTimeoutRequest() {
        return this.timeoutRequest;
    }

    public void setTimeoutRequest(int timeoutRequest) {
        this.timeoutRequest = timeoutRequest;
    }

    public boolean isLoadSymbolAndDataTypeTables() {
        return this.loadSymbolAndDataTypeTables;
    }

    public void setLoadSymbolAndDataTypeTables(boolean loadSymbolAndDataTypeTables) {
        this.loadSymbolAndDataTypeTables = loadSymbolAndDataTypeTables;
    }

    public int getDefaultPort() {
        return AdsConstants.ADSTCPDEFAULTPORT;
    }

    public int getBaudRate() {
        return 57600;
    }

    public static AmsNetId amsNetIdOf(String address) {
        if (!AMS_NET_ID_PATTERN.matcher(address).matches()) {
            throw new IllegalArgumentException(address + " must match " + AMS_NET_ID_PATTERN);
        }
        String[] split = address.split("\\.");
        short[] shorts = ArrayUtils.toPrimitive((Short[])((Short[])Stream.of(split).map(Integer::parseInt).map(Integer::shortValue).toArray(Short[]::new)));
        return new AmsNetId(shorts[0], shorts[1], shorts[2], shorts[3], shorts[4], shorts[5]);
    }

    public static class AmsNetIdConverter
    implements ConfigurationParameterConverter<AmsNetId> {
        public Class<AmsNetId> getType() {
            return AmsNetId.class;
        }

        public AmsNetId convert(String value) {
            return AdsConfiguration.amsNetIdOf(value);
        }
    }
}

