/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscovery;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlock;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockFingerprint;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockHostName;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockOsData;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlockVersion;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsPortNumbers;
import org.apache.plc4x.java.ads.discovery.readwrite.AmsNetId;
import org.apache.plc4x.java.ads.discovery.readwrite.Operation;
import org.apache.plc4x.java.ads.readwrite.AdsConstants;
import org.apache.plc4x.java.api.messages.PlcDiscoveryItem;
import org.apache.plc4x.java.api.messages.PlcDiscoveryItemHandler;
import org.apache.plc4x.java.api.messages.PlcDiscoveryRequest;
import org.apache.plc4x.java.api.messages.PlcDiscoveryResponse;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcDiscoveryItem;
import org.apache.plc4x.java.spi.messages.PlcDiscoverer;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdsPlcDiscoverer
implements PlcDiscoverer {
    private final Logger logger = LoggerFactory.getLogger(AdsPlcDiscoverer.class);

    public CompletableFuture<PlcDiscoveryResponse> discover(PlcDiscoveryRequest discoveryRequest) {
        return this.discoverWithHandler(discoveryRequest, null);
    }

    /*
     * Exception decompiling
     */
    public CompletableFuture<PlcDiscoveryResponse> discoverWithHandler(PlcDiscoveryRequest discoveryRequest, PlcDiscoveryItemHandler handler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] args) throws Exception {
        AdsPlcDiscoverer discoverer = new AdsPlcDiscoverer();
        CompletableFuture<PlcDiscoveryResponse> discover = discoverer.discover(null);
        PlcDiscoveryResponse plcDiscoveryResponse = discover.get(6000L, TimeUnit.MILLISECONDS);
        System.out.println(plcDiscoveryResponse);
    }

    private /* synthetic */ void lambda$discoverWithHandler$0(DatagramSocket adsDiscoverySocket, Inet4Address inet4Address, PlcDiscoveryItemHandler handler, Queue values) {
        try {
            while (true) {
                byte[] buffer = new byte[512];
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                adsDiscoverySocket.receive(packet);
                InetAddress plcAddress = packet.getAddress();
                ReadBufferByteBased readBuffer = new ReadBufferByteBased(packet.getData(), ByteOrder.LITTLE_ENDIAN);
                AdsDiscovery adsDiscoveryResponse = AdsDiscovery.staticParse((ReadBuffer)readBuffer);
                if (adsDiscoveryResponse.getRequestId() != 0L || adsDiscoveryResponse.getPortNumber() != AdsPortNumbers.SYSTEM_SERVICE || adsDiscoveryResponse.getOperation() != Operation.DISCOVERY_RESPONSE) continue;
                AmsNetId remoteAmsNetId = adsDiscoveryResponse.getAmsNetId();
                AdsDiscoveryBlockHostName hostNameBlock = null;
                AdsDiscoveryBlockOsData osDataBlock = null;
                AdsDiscoveryBlockVersion versionBlock = null;
                AdsDiscoveryBlockFingerprint fingerprintBlock = null;
                block11: for (AdsDiscoveryBlock block : adsDiscoveryResponse.getBlocks()) {
                    switch (block.getBlockType()) {
                        case HOST_NAME: {
                            hostNameBlock = (AdsDiscoveryBlockHostName)block;
                            continue block11;
                        }
                        case OS_DATA: {
                            osDataBlock = (AdsDiscoveryBlockOsData)block;
                            continue block11;
                        }
                        case VERSION: {
                            versionBlock = (AdsDiscoveryBlockVersion)block;
                            continue block11;
                        }
                        case FINGERPRINT: {
                            fingerprintBlock = (AdsDiscoveryBlockFingerprint)block;
                            continue block11;
                        }
                    }
                    this.logger.info(String.format("Unexpected block type: %s", block.getBlockType().toString()));
                }
                if (hostNameBlock == null) continue;
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("sourceAmsNetId", inet4Address.getHostAddress() + ".1.1");
                options.put("sourceAmsPort", "65534");
                options.put("targetAmsNetId", remoteAmsNetId.getOctet1() + "." + remoteAmsNetId.getOctet2() + "." + remoteAmsNetId.getOctet3() + "." + remoteAmsNetId.getOctet4() + "." + remoteAmsNetId.getOctet5() + "." + remoteAmsNetId.getOctet6());
                options.put("targetAmsPort", "851");
                HashMap<String, PlcSTRING> attributes = new HashMap<String, PlcSTRING>();
                attributes.put("hostName", new PlcSTRING(hostNameBlock.getHostName().getText()));
                if (versionBlock != null) {
                    byte[] versionData = versionBlock.getVersionData();
                    int patchVersion = (versionData[3] & 0xFF) << 8 | versionData[2] & 0xFF;
                    attributes.put("twinCatVersion", new PlcSTRING(String.format("%d.%d.%d", (short)versionData[0] & 0xFF, (short)versionData[1] & 0xFF, patchVersion)));
                }
                if (fingerprintBlock != null) {
                    attributes.put("fingerprint", new PlcSTRING(new String(fingerprintBlock.getData())));
                }
                DefaultPlcDiscoveryItem plcDiscoveryItem = new DefaultPlcDiscoveryItem("ads", "tcp", plcAddress.getHostAddress() + ":" + AdsConstants.ADSTCPDEFAULTPORT, options, hostNameBlock.getHostName().getText(), attributes);
                if (handler != null) {
                    handler.handle((PlcDiscoveryItem)plcDiscoveryItem);
                }
                values.add(plcDiscoveryItem);
            }
        }
        catch (SocketException e) {
            if (!"Socket closed".equals(e.getMessage())) {
                this.logger.error("Error receiving ADS discovery response", (Throwable)e);
            }
        }
        catch (IOException e) {
            this.logger.error("Error reading ADS discovery response", (Throwable)e);
        }
        catch (ParseException e) {
            this.logger.error("Error parsing ADS discovery response", (Throwable)e);
        }
    }
}

