/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.ads.readwrite.AmsNetId;
import org.apache.plc4x.java.ads.readwrite.AmsPacket;
import org.apache.plc4x.java.ads.readwrite.CommandId;
import org.apache.plc4x.java.ads.readwrite.ReturnCode;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class AdsReadWriteResponse
extends AmsPacket
implements Message {
    protected final ReturnCode result;
    protected final byte[] data;

    @Override
    public CommandId getCommandId() {
        return CommandId.ADS_READ_WRITE;
    }

    @Override
    public Boolean getResponse() {
        return true;
    }

    public AdsReadWriteResponse(AmsNetId targetAmsNetId, int targetAmsPort, AmsNetId sourceAmsNetId, int sourceAmsPort, long errorCode, long invokeId, ReturnCode result, byte[] data) {
        super(targetAmsNetId, targetAmsPort, sourceAmsNetId, sourceAmsPort, errorCode, invokeId);
        this.result = result;
        this.data = data;
    }

    public ReturnCode getResult() {
        return this.result;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected void serializeAmsPacketChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("AdsReadWriteResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"result", (String)"ReturnCode", (Object)((Object)this.result), (DataWriter)new DataWriterEnumDefault(ReturnCode::getValue, Enum::name, DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        long length = StaticHelper.COUNT((Object)this.getData());
        FieldWriterFactory.writeImplicitField((String)"length", (Object)length, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"data", (byte[])this.data, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("AdsReadWriteResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        AdsReadWriteResponse _value = this;
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public static AdsReadWriteResponseBuilder staticParseBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("AdsReadWriteResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        ReturnCode result = (ReturnCode)((Object)FieldReaderFactory.readEnumField((String)"result", (String)"ReturnCode", (DataReader)new DataReaderEnumDefault(ReturnCode::enumForValue, DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        long length = (Long)FieldReaderFactory.readImplicitField((String)"length", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(length), new WithReaderArgs[0]);
        readBuffer.closeContext("AdsReadWriteResponse", new WithReaderArgs[0]);
        return new AdsReadWriteResponseBuilder(result, data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdsReadWriteResponse)) {
            return false;
        }
        AdsReadWriteResponse that = (AdsReadWriteResponse)o;
        return this.getResult() == that.getResult() && this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getResult(), this.getData()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class AdsReadWriteResponseBuilder
    implements AmsPacket.AmsPacketBuilder {
        private final ReturnCode result;
        private final byte[] data;

        public AdsReadWriteResponseBuilder(ReturnCode result, byte[] data) {
            this.result = result;
            this.data = data;
        }

        @Override
        public AdsReadWriteResponse build(AmsNetId targetAmsNetId, int targetAmsPort, AmsNetId sourceAmsNetId, int sourceAmsPort, long errorCode, long invokeId) {
            AdsReadWriteResponse adsReadWriteResponse = new AdsReadWriteResponse(targetAmsNetId, targetAmsPort, sourceAmsNetId, sourceAmsPort, errorCode, invokeId, this.result, this.data);
            return adsReadWriteResponse;
        }
    }
}

