/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.readwrite;

import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.plc4x.java.ads.readwrite.PlcValueType;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcCHAR;
import org.apache.plc4x.java.spi.values.PlcDATE;
import org.apache.plc4x.java.spi.values.PlcDATE_AND_TIME;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcDWORD;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcLTIME;
import org.apache.plc4x.java.spi.values.PlcLWORD;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcTIME;
import org.apache.plc4x.java.spi.values.PlcTIME_OF_DAY;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.apache.plc4x.java.spi.values.PlcWCHAR;
import org.apache.plc4x.java.spi.values.PlcWORD;
import org.apache.plc4x.java.spi.values.PlcWSTRING;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataItem.class);

    public static PlcValue staticParse(ReadBuffer readBuffer, PlcValueType plcValueType, Integer stringLength) throws ParseException {
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.BOOL))) {
            short reserved = readBuffer.readUnsignedShort("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.BYTE))) {
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcBYTE(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.WORD))) {
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcWORD(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.DWORD))) {
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcDWORD(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.LWORD))) {
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcLWORD(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.SINT))) {
            Byte value = readBuffer.readSignedByte("", 8, new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.USINT))) {
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.INT))) {
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.UINT))) {
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.DINT))) {
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.UDINT))) {
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.LINT))) {
            Long value = readBuffer.readLong("", 64, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.ULINT))) {
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.REAL))) {
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.LREAL))) {
            Double value = readBuffer.readDouble("", 64, new WithReaderArgs[0]);
            return new PlcLREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.CHAR))) {
            String value = readBuffer.readString("", 8, "UTF-8", new WithReaderArgs[0]);
            return new PlcCHAR(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.WCHAR))) {
            String value = readBuffer.readString("", 16, "UTF-16LE", new WithReaderArgs[0]);
            return new PlcWCHAR(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.STRING))) {
            String value = readBuffer.readString("", stringLength * 8, "UTF-8", new WithReaderArgs[0]);
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.WSTRING))) {
            String value = readBuffer.readString("", stringLength * 8 * 2, "UTF-16LE", new WithReaderArgs[0]);
            int reserved = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            return new PlcWSTRING(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.TIME))) {
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcTIME(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.LTIME))) {
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcLTIME(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.DATE))) {
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcDATE(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.TIME_OF_DAY))) {
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcTIME_OF_DAY(value);
        }
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.DATE_AND_TIME))) {
            Long secondsSinceEpoch = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            LocalDateTime value = LocalDateTime.ofEpochSecond(secondsSinceEpoch, 0, ZoneOffset.UTC);
            return new PlcDATE_AND_TIME(value);
        }
        return null;
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, PlcValueType plcValueType, Integer stringLength) throws SerializationException {
        DataItem.staticSerialize(writeBuffer, _value, plcValueType, stringLength, ByteOrder.BIG_ENDIAN);
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, PlcValueType plcValueType, Integer stringLength, ByteOrder byteOrder) throws SerializationException {
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.BOOL))) {
            writeBuffer.writeUnsignedShort("", 7, ((Number)0).shortValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.BYTE))) {
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.WORD))) {
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.DWORD))) {
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.LWORD))) {
            BigInteger value = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.SINT))) {
            byte value = _value.getByte();
            writeBuffer.writeSignedByte("", 8, ((Number)value).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.USINT))) {
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.INT))) {
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.UINT))) {
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.DINT))) {
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.UDINT))) {
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.LINT))) {
            long value = _value.getLong();
            writeBuffer.writeLong("", 64, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.ULINT))) {
            BigInteger value = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.REAL))) {
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.LREAL))) {
            double value = _value.getDouble();
            writeBuffer.writeDouble("", 64, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.CHAR))) {
            String value = _value.getString();
            writeBuffer.writeString("", 8, "UTF-8", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.WCHAR))) {
            String value = _value.getString();
            writeBuffer.writeString("", 16, "UTF-16LE", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.STRING))) {
            String value = _value.getString();
            writeBuffer.writeString("", stringLength * 8, "UTF-8", value, new WithWriterArgs[0]);
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.WSTRING))) {
            String value = _value.getString();
            writeBuffer.writeString("", stringLength * 8 * 2, "UTF-16LE", value, new WithWriterArgs[0]);
            writeBuffer.writeUnsignedInt("", 16, ((Number)0).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.TIME))) {
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.LTIME))) {
            BigInteger value = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.DATE))) {
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.TIME_OF_DAY))) {
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.DATE_AND_TIME))) {
            long secondsSinceEpoch = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)secondsSinceEpoch).longValue(), new WithWriterArgs[0]);
        }
    }

    public static int getLengthInBytes(PlcValue _value, PlcValueType plcValueType, Integer stringLength) {
        return (int)Math.ceil((double)DataItem.getLengthInBits(_value, plcValueType, stringLength) / 8.0);
    }

    public static int getLengthInBits(PlcValue _value, PlcValueType plcValueType, Integer stringLength) {
        int sizeInBits = 0;
        if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.BOOL))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.BYTE))) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.WORD))) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.DWORD))) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.LWORD))) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.SINT))) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.USINT))) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.INT))) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.UINT))) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.DINT))) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.UDINT))) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.LINT))) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.ULINT))) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.REAL))) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.LREAL))) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.CHAR))) {
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.WCHAR))) {
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.STRING))) {
            --sizeInBits;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.WSTRING))) {
            --sizeInBits;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.TIME))) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.LTIME))) {
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.DATE))) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.TIME_OF_DAY))) {
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)plcValueType), (Object)((Object)PlcValueType.DATE_AND_TIME))) {
            sizeInBits += 32;
        }
        return sizeInBits;
    }
}

