/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.ads.readwrite.AdsStampHeader;
import org.apache.plc4x.java.ads.readwrite.AmsNetId;
import org.apache.plc4x.java.ads.readwrite.AmsPacket;
import org.apache.plc4x.java.ads.readwrite.CommandId;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class AdsDeviceNotificationRequest
extends AmsPacket
implements Message {
    protected final long length;
    protected final long stamps;
    protected final List<AdsStampHeader> adsStampHeaders;

    @Override
    public CommandId getCommandId() {
        return CommandId.ADS_DEVICE_NOTIFICATION;
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    public AdsDeviceNotificationRequest(AmsNetId targetAmsNetId, int targetAmsPort, AmsNetId sourceAmsNetId, int sourceAmsPort, long errorCode, long invokeId, long length, long stamps, List<AdsStampHeader> adsStampHeaders) {
        super(targetAmsNetId, targetAmsPort, sourceAmsNetId, sourceAmsPort, errorCode, invokeId);
        this.length = length;
        this.stamps = stamps;
        this.adsStampHeaders = adsStampHeaders;
    }

    public long getLength() {
        return this.length;
    }

    public long getStamps() {
        return this.stamps;
    }

    public List<AdsStampHeader> getAdsStampHeaders() {
        return this.adsStampHeaders;
    }

    @Override
    protected void serializeAmsPacketChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("AdsDeviceNotificationRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"length", (Object)this.length, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"stamps", (Object)this.stamps, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"adsStampHeaders", this.adsStampHeaders, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("AdsDeviceNotificationRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        AdsDeviceNotificationRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.adsStampHeaders != null) {
            int i = 0;
            for (AdsStampHeader element : this.adsStampHeaders) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.adsStampHeaders.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static AmsPacket.AmsPacketBuilder staticParseAmsPacketBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("AdsDeviceNotificationRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long length = (Long)FieldReaderFactory.readSimpleField((String)"length", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long stamps = (Long)FieldReaderFactory.readSimpleField((String)"stamps", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List adsStampHeaders = FieldReaderFactory.readCountArrayField((String)"adsStampHeaders", (DataReader)new DataReaderComplexDefault(() -> AdsStampHeader.staticParse(readBuffer), readBuffer), (long)stamps, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("AdsDeviceNotificationRequest", new WithReaderArgs[0]);
        return new AdsDeviceNotificationRequestBuilderImpl(length, stamps, adsStampHeaders);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdsDeviceNotificationRequest)) {
            return false;
        }
        AdsDeviceNotificationRequest that = (AdsDeviceNotificationRequest)o;
        return this.getLength() == that.getLength() && this.getStamps() == that.getStamps() && this.getAdsStampHeaders() == that.getAdsStampHeaders() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getLength(), this.getStamps(), this.getAdsStampHeaders());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class AdsDeviceNotificationRequestBuilderImpl
    implements AmsPacket.AmsPacketBuilder {
        private final long length;
        private final long stamps;
        private final List<AdsStampHeader> adsStampHeaders;

        public AdsDeviceNotificationRequestBuilderImpl(long length, long stamps, List<AdsStampHeader> adsStampHeaders) {
            this.length = length;
            this.stamps = stamps;
            this.adsStampHeaders = adsStampHeaders;
        }

        @Override
        public AdsDeviceNotificationRequest build(AmsNetId targetAmsNetId, int targetAmsPort, AmsNetId sourceAmsNetId, int sourceAmsPort, long errorCode, long invokeId) {
            AdsDeviceNotificationRequest adsDeviceNotificationRequest = new AdsDeviceNotificationRequest(targetAmsNetId, targetAmsPort, sourceAmsNetId, sourceAmsPort, errorCode, invokeId, this.length, this.stamps, this.adsStampHeaders);
            return adsDeviceNotificationRequest;
        }
    }
}

