/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum PlcValueType {
    NULL(0),
    BOOL(1),
    BYTE(2),
    WORD(3),
    DWORD(4),
    LWORD(5),
    USINT(17),
    UINT(18),
    UDINT(19),
    ULINT(20),
    SINT(33),
    INT(34),
    DINT(35),
    LINT(36),
    REAL(49),
    LREAL(50),
    CHAR(65),
    WCHAR(66),
    STRING(67),
    WSTRING(68),
    TIME(81),
    LTIME(82),
    DATE(83),
    LDATE(84),
    TIME_OF_DAY(85),
    LTIME_OF_DAY(86),
    DATE_AND_TIME(87),
    LDATE_AND_TIME(88),
    Struct(97),
    List(98),
    RAW_BYTE_ARRAY(113);

    private static final Map<Short, PlcValueType> map;
    private final short value;

    static {
        map = new HashMap<Short, PlcValueType>();
        PlcValueType[] plcValueTypeArray = PlcValueType.values();
        int n = plcValueTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlcValueType value = plcValueTypeArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private PlcValueType(short value) {
        this.value = value;
    }

    public short getValue() {
        return this.value;
    }

    public static PlcValueType enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }
}

