/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.discovery.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsDiscoveryBlock;
import org.apache.plc4x.java.ads.discovery.readwrite.AdsPortNumbers;
import org.apache.plc4x.java.ads.discovery.readwrite.AmsNetId;
import org.apache.plc4x.java.ads.discovery.readwrite.Operation;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class AdsDiscovery
implements Message {
    public static final Long HEADER = 1897162243L;
    protected final long requestId;
    protected final Operation operation;
    protected final AmsNetId amsNetId;
    protected final AdsPortNumbers portNumber;
    protected final List<AdsDiscoveryBlock> blocks;

    public AdsDiscovery(long requestId, Operation operation, AmsNetId amsNetId, AdsPortNumbers portNumber, List<AdsDiscoveryBlock> blocks) {
        this.requestId = requestId;
        this.operation = operation;
        this.amsNetId = amsNetId;
        this.portNumber = portNumber;
        this.blocks = blocks;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public AmsNetId getAmsNetId() {
        return this.amsNetId;
    }

    public AdsPortNumbers getPortNumber() {
        return this.portNumber;
    }

    public List<AdsDiscoveryBlock> getBlocks() {
        return this.blocks;
    }

    public long getHeader() {
        return HEADER;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("AdsDiscovery", new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField((String)"header", (Object)HEADER, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        FieldWriterFactory.writeSimpleField((String)"requestId", (Object)this.requestId, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        FieldWriterFactory.writeSimpleEnumField((String)"operation", (String)"Operation", (Object)((Object)this.operation), (DataWriter)DataWriterFactory.writeEnum(Operation::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        FieldWriterFactory.writeSimpleField((String)"amsNetId", (Object)this.amsNetId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        FieldWriterFactory.writeSimpleEnumField((String)"portNumber", (String)"AdsPortNumbers", (Object)((Object)this.portNumber), (DataWriter)DataWriterFactory.writeEnum(AdsPortNumbers::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16)), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        long numBlocks = StaticHelper.COUNT(this.getBlocks());
        FieldWriterFactory.writeImplicitField((String)"numBlocks", (Object)numBlocks, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        FieldWriterFactory.writeComplexTypeArrayField((String)"blocks", this.blocks, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        writeBuffer.popContext("AdsDiscovery", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        AdsDiscovery _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += this.amsNetId.getLengthInBits();
        lengthInBits += 16;
        lengthInBits += 32;
        if (this.blocks != null) {
            int i = 0;
            for (AdsDiscoveryBlock element : this.blocks) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.blocks.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static AdsDiscovery staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("AdsDiscovery", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long header = (Long)FieldReaderFactory.readConstField((String)"header", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (Object)HEADER, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        long requestId = (Long)FieldReaderFactory.readSimpleField((String)"requestId", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        Operation operation = (Operation)((Object)FieldReaderFactory.readEnumField((String)"operation", (String)"Operation", (DataReader)DataReaderFactory.readEnum(Operation::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)}));
        AmsNetId amsNetId = (AmsNetId)FieldReaderFactory.readSimpleField((String)"amsNetId", (DataReader)DataReaderFactory.readComplex(() -> AmsNetId.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        AdsPortNumbers portNumber = (AdsPortNumbers)((Object)FieldReaderFactory.readEnumField((String)"portNumber", (String)"AdsPortNumbers", (DataReader)DataReaderFactory.readEnum(AdsPortNumbers::enumForValue, (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16)), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)}));
        long numBlocks = (Long)FieldReaderFactory.readImplicitField((String)"numBlocks", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        List blocks = FieldReaderFactory.readCountArrayField((String)"blocks", (DataReader)DataReaderFactory.readComplex(() -> AdsDiscoveryBlock.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)numBlocks, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        readBuffer.closeContext("AdsDiscovery", new WithReaderArgs[0]);
        AdsDiscovery _adsDiscovery = new AdsDiscovery(requestId, operation, amsNetId, portNumber, blocks);
        return _adsDiscovery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AdsDiscovery)) {
            return false;
        }
        AdsDiscovery that = (AdsDiscovery)o;
        return this.getRequestId() == that.getRequestId() && this.getOperation() == that.getOperation() && this.getAmsNetId() == that.getAmsNetId() && this.getPortNumber() == that.getPortNumber() && this.getBlocks() == that.getBlocks();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getRequestId(), this.getOperation(), this.getAmsNetId(), this.getPortNumber(), this.getBlocks()});
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

