/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.can.adapter.conversation;

import java.time.Duration;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.plc4x.java.spi.ConversationContext;

public class DeferredRequestContextWrapper<T>
implements ConversationContext.SendRequestContext<T> {
    private String name;
    private final ConversationContext.SendRequestContext<T> delegate;
    private final Function<ConversationContext.SendRequestContext<?>, ConversationContext.SendRequestContext<?>> completer;
    protected final Consumer<TimeoutException> onTimeoutConsumer;
    protected final BiConsumer<?, ? extends Throwable> errorConsumer;

    public DeferredRequestContextWrapper(String name, ConversationContext.SendRequestContext<T> delegate, Function<ConversationContext.SendRequestContext<?>, ConversationContext.SendRequestContext<?>> completer, Consumer<TimeoutException> onTimeoutConsumer, BiConsumer<?, ? extends Throwable> errorConsumer) {
        this.name = name;
        this.delegate = delegate;
        this.completer = completer;
        this.onTimeoutConsumer = onTimeoutConsumer;
        this.errorConsumer = errorConsumer;
    }

    public ConversationContext.SendRequestContext<T> name(String name) {
        this.name = name;
        return this;
    }

    public ConversationContext.SendRequestContext<T> expectResponse(Class<T> clazz, Duration timeout) {
        throw new IllegalStateException("Response type is already specified");
    }

    public ConversationContext.SendRequestContext<T> check(Predicate<T> checker) {
        this.delegate.check(checker);
        return this;
    }

    public ConversationContext.ContextHandler handle(Consumer<T> packetConsumer) {
        return this.delegate.handle(packetConsumer);
    }

    public ConversationContext.SendRequestContext<T> onTimeout(Consumer<TimeoutException> packetConsumer) {
        return new DeferredRequestContextWrapper<T>(this.name, this.delegate, this.completer, packetConsumer, this.errorConsumer);
    }

    public <E extends Throwable> ConversationContext.SendRequestContext<T> onError(BiConsumer<T, E> packetConsumer) {
        return new DeferredRequestContextWrapper<T>(this.name, this.delegate, this.completer, this.onTimeoutConsumer, this.errorConsumer);
    }

    public <R> ConversationContext.SendRequestContext<R> unwrap(Function<T, R> unwrapper) {
        return this.resolve(new DeferredRequestContextWrapper<T>(this.name, this.delegate.unwrap(unwrapper), this.completer, this.onTimeoutConsumer, this.errorConsumer));
    }

    private <R> ConversationContext.SendRequestContext<R> resolve(DeferredRequestContextWrapper<R> contextWrapper) {
        if (contextWrapper.errorConsumer != null && contextWrapper.onTimeoutConsumer != null) {
            return contextWrapper.completer.apply(contextWrapper);
        }
        return contextWrapper;
    }

    public <R> ConversationContext.SendRequestContext<R> only(Class<R> clazz) {
        return this.resolve(new DeferredRequestContextWrapper<T>(this.name, this.delegate.only(clazz), this.completer, this.onTimeoutConsumer, this.errorConsumer));
    }
}

