/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.can.generic.tag;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.genericcan.readwrite.GenericCANDataType;
import org.apache.plc4x.java.spi.model.DefaultArrayInfo;

public class GenericCANTag
implements PlcTag {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("(?<nodeId>\\d+):(?<dataType>\\w+)(?:\\[(?<arraySize>\\d+)\\])?");
    private final int nodeId;
    private final GenericCANDataType dataType;
    private final int arraySize;

    public GenericCANTag(int nodeId, GenericCANDataType dataType, int arraySize) {
        this.nodeId = nodeId;
        this.dataType = dataType;
        this.arraySize = arraySize;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getAddressString() {
        String address = String.valueOf(this.nodeId) + ":" + this.dataType.name();
        if (this.arraySize != 1) {
            address = String.valueOf(address) + "[" + this.arraySize + "]";
        }
        return address;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.valueOf((String)this.dataType.getPlcValueName());
    }

    public List<ArrayInfo> getArrayInfo() {
        if (this.arraySize > 1) {
            return Collections.singletonList(new DefaultArrayInfo(0, this.arraySize));
        }
        return Collections.emptyList();
    }

    public int getArraySize() {
        return this.arraySize;
    }

    public GenericCANDataType getDataType() {
        return this.dataType;
    }

    public static Optional<GenericCANTag> matches(String tagQuery) {
        Matcher matcher = ADDRESS_PATTERN.matcher(tagQuery);
        return matcher.matches() ? Optional.of(GenericCANTag.create(matcher)) : Optional.empty();
    }

    static GenericCANTag create(Matcher tagQuery) {
        GenericCANDataType dataType;
        int nodeId = Integer.parseInt(tagQuery.group("nodeId"));
        String type = tagQuery.group("dataType");
        try {
            dataType = GenericCANDataType.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            throw new PlcRuntimeException("Could not create tag with data type " + type, (Throwable)e);
        }
        int arraySize = tagQuery.group("arraySize") != null ? Integer.parseInt(tagQuery.group("arraySize")) : 0;
        return new GenericCANTag(nodeId, dataType, arraySize);
    }

    public String toString() {
        return "GenericCANTag(" + this.nodeId + ":" + this.dataType.name() + (this.arraySize == 0 ? "" : "[" + this.arraySize + "]");
    }
}

