/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.genericcan.readwrite;

import java.math.BigInteger;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.genericcan.readwrite.GenericCANDataType;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcRawByteArray;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataItem.class);

    public static PlcValue staticParse(ReadBuffer readBuffer, GenericCANDataType dataType, Integer size) throws ParseException {
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.BYTE))) {
            byte value = (Byte)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readByte((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcBYTE((short)value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.BOOLEAN))) {
            boolean value = (Boolean)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED8))) {
            short value = (Short)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED16))) {
            int value = (Integer)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED24))) {
            int value = (Integer)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)24), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcUDINT((long)value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED32))) {
            long value = (Long)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED40))) {
            long value = (Long)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)40), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcULINT(Long.valueOf(value));
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED48))) {
            long value = (Long)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)48), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcULINT(Long.valueOf(value));
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED56))) {
            long value = (Long)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)56), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcULINT(Long.valueOf(value));
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED64))) {
            BigInteger value = (BigInteger)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readUnsignedBigInteger((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER8))) {
            byte value = (Byte)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readSignedByte((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER16))) {
            short value = (Short)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readSignedShort((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER24))) {
            int value = (Integer)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)24), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER32))) {
            int value = (Integer)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER40))) {
            long value = (Long)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)40), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER48))) {
            long value = (Long)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)48), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER56))) {
            long value = (Long)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)56), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER64))) {
            long value = (Long)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.REAL32))) {
            float value = ((Float)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readFloat((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0])).floatValue();
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.REAL64))) {
            double value = (Double)FieldReaderFactory.readSimpleField((String)"value", (DataReader)DataReaderFactory.readDouble((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
            return new PlcLREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.RAW))) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(size.intValue()), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        return null;
    }

    public static int getLengthInBytes(PlcValue _value, GenericCANDataType dataType, Integer size) {
        return (int)Math.ceil((double)DataItem.getLengthInBits(_value, dataType, size) / 8.0);
    }

    public static int getLengthInBits(PlcValue _value, GenericCANDataType dataType, Integer size) {
        int lengthInBits = 0;
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.BYTE))) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.BOOLEAN))) {
            ++lengthInBits;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED8))) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED16))) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED24))) {
            lengthInBits += 24;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED32))) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED40))) {
            lengthInBits += 40;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED48))) {
            lengthInBits += 48;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED56))) {
            lengthInBits += 56;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED64))) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER8))) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER16))) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER24))) {
            lengthInBits += 24;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER32))) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER40))) {
            lengthInBits += 40;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER48))) {
            lengthInBits += 48;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER56))) {
            lengthInBits += 56;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER64))) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.REAL32))) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.REAL64))) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.RAW)) && _value != null) {
            lengthInBits += 8 * _value.getRaw().length;
        }
        return lengthInBits;
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, GenericCANDataType dataType, Integer size) throws SerializationException {
        DataItem.staticSerialize(writeBuffer, _value, dataType, size, ByteOrder.BIG_ENDIAN);
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, GenericCANDataType dataType, Integer size, ByteOrder byteOrder) throws SerializationException {
        if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.BYTE))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getByte(), (DataWriter)DataWriterFactory.writeByte((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.BOOLEAN))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getBoolean(), (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED8))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getShort(), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED16))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getInteger(), (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED24))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getInteger(), (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)24), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED32))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getLong(), (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED40))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getLong(), (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)40), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED48))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getLong(), (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)48), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED56))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getLong(), (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)56), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.UNSIGNED64))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getBigInteger(), (DataWriter)DataWriterFactory.writeUnsignedBigInteger((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER8))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getByte(), (DataWriter)DataWriterFactory.writeSignedByte((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER16))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getShort(), (DataWriter)DataWriterFactory.writeSignedShort((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER24))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getInteger(), (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)24), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER32))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getInteger(), (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER40))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getLong(), (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)40), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER48))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getLong(), (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)48), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER56))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getLong(), (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)56), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.INTEGER64))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getLong(), (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.REAL32))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)Float.valueOf(_value.getFloat()), (DataWriter)DataWriterFactory.writeFloat((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.REAL64))) {
            FieldWriterFactory.writeSimpleField((String)"value", (Object)_value.getDouble(), (DataWriter)DataWriterFactory.writeDouble((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)dataType), (Object)((Object)GenericCANDataType.RAW))) {
            FieldWriterFactory.writeByteArrayField((String)"value", (byte[])_value.getRaw(), (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        }
    }
}

