/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum CANOpenService {
  NMT((byte) 0b0000, (short) 0, (short) 0, (boolean) false),
  SYNC((byte) 0b0001, (short) 0x80, (short) 0x80, (boolean) false),
  EMCY((byte) 0b0001, (short) 0x81, (short) 0xFF, (boolean) false),
  TIME((byte) 0b0010, (short) 0x100, (short) 0x100, (boolean) false),
  TRANSMIT_PDO_1((byte) 0b0011, (short) 0x180, (short) 0x1FF, (boolean) true),
  RECEIVE_PDO_1((byte) 0b0100, (short) 0x200, (short) 0x27F, (boolean) true),
  TRANSMIT_PDO_2((byte) 0b0101, (short) 0x280, (short) 0x2FF, (boolean) true),
  RECEIVE_PDO_2((byte) 0b0110, (short) 0x300, (short) 0x37F, (boolean) true),
  TRANSMIT_PDO_3((byte) 0b0111, (short) 0x380, (short) 0x3FF, (boolean) true),
  RECEIVE_PDO_3((byte) 0b1000, (short) 0x400, (short) 0x47F, (boolean) true),
  TRANSMIT_PDO_4((byte) 0b1001, (short) 0x480, (short) 0x4FF, (boolean) true),
  RECEIVE_PDO_4((byte) 0b1010, (short) 0x500, (short) 0x57F, (boolean) true),
  TRANSMIT_SDO((byte) 0b1011, (short) 0x580, (short) 0x5FF, (boolean) false),
  RECEIVE_SDO((byte) 0b1100, (short) 0x600, (short) 0x67F, (boolean) false),
  HEARTBEAT((byte) 0b1110, (short) 0x700, (short) 0x77F, (boolean) false);
  private static final Map<Byte, CANOpenService> map;

  static {
    map = new HashMap<>();
    for (CANOpenService value : CANOpenService.values()) {
      map.put((byte) value.getValue(), value);
    }
  }

  private byte value;
  private short min;
  private short max;
  private boolean pdo;

  CANOpenService(byte value, short min, short max, boolean pdo) {
    this.value = value;
    this.min = min;
    this.max = max;
    this.pdo = pdo;
  }

  public byte getValue() {
    return value;
  }

  public short getMin() {
    return min;
  }

  public static CANOpenService firstEnumForFieldMin(short fieldValue) {
    for (CANOpenService _val : CANOpenService.values()) {
      if (_val.getMin() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<CANOpenService> enumsForFieldMin(short fieldValue) {
    List<CANOpenService> _values = new ArrayList();
    for (CANOpenService _val : CANOpenService.values()) {
      if (_val.getMin() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public short getMax() {
    return max;
  }

  public static CANOpenService firstEnumForFieldMax(short fieldValue) {
    for (CANOpenService _val : CANOpenService.values()) {
      if (_val.getMax() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<CANOpenService> enumsForFieldMax(short fieldValue) {
    List<CANOpenService> _values = new ArrayList();
    for (CANOpenService _val : CANOpenService.values()) {
      if (_val.getMax() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public boolean getPdo() {
    return pdo;
  }

  public static CANOpenService firstEnumForFieldPdo(boolean fieldValue) {
    for (CANOpenService _val : CANOpenService.values()) {
      if (_val.getPdo() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<CANOpenService> enumsForFieldPdo(boolean fieldValue) {
    List<CANOpenService> _values = new ArrayList();
    for (CANOpenService _val : CANOpenService.values()) {
      if (_val.getPdo() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static CANOpenService enumForValue(byte value) {
    return map.get(value);
  }

  public static Boolean isDefined(byte value) {
    return map.containsKey(value);
  }
}
