/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.canopen.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SDOInitiateExpeditedUploadResponse extends SDOInitiateUploadResponsePayload
    implements Message {

  // Accessors for discriminator values.
  public Boolean getExpedited() {
    return (boolean) true;
  }

  public Boolean getIndicated() {
    return (boolean) true;
  }

  // Properties.
  protected final byte[] data;

  // Arguments.
  protected final Byte size;

  public SDOInitiateExpeditedUploadResponse(byte[] data, Byte size) {
    super(size);
    this.data = data;
    this.size = size;
  }

  public byte[] getData() {
    return data;
  }

  @Override
  protected void serializeSDOInitiateUploadResponsePayloadChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("SDOInitiateExpeditedUploadResponse");

    // Array Field (data)
    writeByteArrayField("data", data, writeByteArray(writeBuffer, 8));

    // Padding Field (padding)
    writePaddingField(
        "padding", (int) ((4) - (COUNT(data))), (short) 0x00, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("SDOInitiateExpeditedUploadResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SDOInitiateExpeditedUploadResponse _value = this;

    // Array field
    if (data != null) {
      lengthInBits += 8 * data.length;
    }

    // Padding Field (padding)
    int _timesPadding = (int) ((4) - (COUNT(data)));
    while (_timesPadding-- > 0) {
      lengthInBits += 8;
    }

    return lengthInBits;
  }

  public static SDOInitiateExpeditedUploadResponseBuilder staticParseBuilder(
      ReadBuffer readBuffer, Boolean expedited, Boolean indicated, Byte size)
      throws ParseException {
    readBuffer.pullContext("SDOInitiateExpeditedUploadResponse");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    byte[] data = readBuffer.readByteArray("data", Math.toIntExact((4) - (size)));

    readPaddingField(readUnsignedShort(readBuffer, 8), (int) ((4) - (COUNT(data))));

    readBuffer.closeContext("SDOInitiateExpeditedUploadResponse");
    // Create the instance
    return new SDOInitiateExpeditedUploadResponseBuilder(data, size);
  }

  public static class SDOInitiateExpeditedUploadResponseBuilder
      implements SDOInitiateUploadResponsePayload.SDOInitiateUploadResponsePayloadBuilder {
    private final byte[] data;
    private final Byte size;

    public SDOInitiateExpeditedUploadResponseBuilder(byte[] data, Byte size) {

      this.data = data;
      this.size = size;
    }

    public SDOInitiateExpeditedUploadResponse build(Byte size) {

      SDOInitiateExpeditedUploadResponse sDOInitiateExpeditedUploadResponse =
          new SDOInitiateExpeditedUploadResponse(data, size);
      return sDOInitiateExpeditedUploadResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SDOInitiateExpeditedUploadResponse)) {
      return false;
    }
    SDOInitiateExpeditedUploadResponse that = (SDOInitiateExpeditedUploadResponse) o;
    return (getData() == that.getData()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
