/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.canopen.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class SDOInitiateUploadResponsePayload implements Message {

  // Abstract accessors for discriminator values.
  public abstract Boolean getExpedited();

  public abstract Boolean getIndicated();

  // Arguments.
  protected final Byte size;

  public SDOInitiateUploadResponsePayload(Byte size) {
    super();
    this.size = size;
  }

  protected abstract void serializeSDOInitiateUploadResponsePayloadChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("SDOInitiateUploadResponsePayload");

    // Switch field (Serialize the sub-type)
    serializeSDOInitiateUploadResponsePayloadChild(writeBuffer);

    writeBuffer.popContext("SDOInitiateUploadResponsePayload");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    SDOInitiateUploadResponsePayload _value = this;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static SDOInitiateUploadResponsePayload staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 3)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 3, but got " + args.length);
    }
    Boolean expedited;
    if (args[0] instanceof Boolean) {
      expedited = (Boolean) args[0];
    } else if (args[0] instanceof String) {
      expedited = Boolean.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type Boolean or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    Boolean indicated;
    if (args[1] instanceof Boolean) {
      indicated = (Boolean) args[1];
    } else if (args[1] instanceof String) {
      indicated = Boolean.valueOf((String) args[1]);
    } else {
      throw new PlcRuntimeException(
          "Argument 1 expected to be of type Boolean or a string which is parseable but was "
              + args[1].getClass().getName());
    }
    Byte size;
    if (args[2] instanceof Byte) {
      size = (Byte) args[2];
    } else if (args[2] instanceof String) {
      size = Byte.valueOf((String) args[2]);
    } else {
      throw new PlcRuntimeException(
          "Argument 2 expected to be of type Byte or a string which is parseable but was "
              + args[2].getClass().getName());
    }
    return staticParse(readBuffer, expedited, indicated, size);
  }

  public static SDOInitiateUploadResponsePayload staticParse(
      ReadBuffer readBuffer, Boolean expedited, Boolean indicated, Byte size)
      throws ParseException {
    readBuffer.pullContext("SDOInitiateUploadResponsePayload");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    SDOInitiateUploadResponsePayloadBuilder builder = null;
    if (EvaluationHelper.equals(expedited, (boolean) true)
        && EvaluationHelper.equals(indicated, (boolean) true)) {
      builder =
          SDOInitiateExpeditedUploadResponse.staticParseBuilder(
              readBuffer, expedited, indicated, size);
    } else if (EvaluationHelper.equals(expedited, (boolean) false)
        && EvaluationHelper.equals(indicated, (boolean) true)) {
      builder =
          SDOInitiateSegmentedUploadResponse.staticParseBuilder(
              readBuffer, expedited, indicated, size);
    } else if (EvaluationHelper.equals(expedited, (boolean) false)
        && EvaluationHelper.equals(indicated, (boolean) false)) {
      builder =
          SDOInitiateSegmentedReservedResponse.staticParseBuilder(
              readBuffer, expedited, indicated, size);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "expedited="
              + expedited
              + " "
              + "indicated="
              + indicated
              + "]");
    }

    readBuffer.closeContext("SDOInitiateUploadResponsePayload");
    // Create the instance
    SDOInitiateUploadResponsePayload _sDOInitiateUploadResponsePayload = builder.build(size);

    return _sDOInitiateUploadResponsePayload;
  }

  public static interface SDOInitiateUploadResponsePayloadBuilder {
    SDOInitiateUploadResponsePayload build(Byte size);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SDOInitiateUploadResponsePayload)) {
      return false;
    }
    SDOInitiateUploadResponsePayload that = (SDOInitiateUploadResponsePayload) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
