/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.field;

import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.canopen.field.CANOpenField;
import org.apache.plc4x.java.canopen.field.CANOpenSubscriptionField;
import org.apache.plc4x.java.canopen.readwrite.CANOpenDataType;
import org.apache.plc4x.java.canopen.readwrite.CANOpenService;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class CANOpenPDOField
extends CANOpenField
implements CANOpenSubscriptionField {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("(?<pdo>(?:RECEIVE|TRANSMIT)_PDO_[1-4]):" + NODE_PATTERN + ":(?<canDataType>\\w+)(\\[(?<numberOfElements>\\d)])?");
    private final CANOpenService service;
    private final CANOpenDataType canOpenDataType;

    public CANOpenPDOField(int node, CANOpenService service, CANOpenDataType canOpenDataType) {
        super(node);
        this.service = service;
        this.canOpenDataType = canOpenDataType;
    }

    public CANOpenDataType getCanOpenDataType() {
        return this.canOpenDataType;
    }

    public static boolean matches(String addressString) {
        return ADDRESS_PATTERN.matcher(addressString).matches();
    }

    public static Matcher getMatcher(String addressString) throws PlcInvalidFieldException {
        Matcher matcher = ADDRESS_PATTERN.matcher(addressString);
        if (matcher.matches()) {
            return matcher;
        }
        throw new PlcInvalidFieldException(addressString, ADDRESS_PATTERN);
    }

    public static CANOpenPDOField of(String addressString) {
        Matcher matcher = CANOpenPDOField.getMatcher(addressString);
        int nodeId = Integer.parseInt(matcher.group("nodeId"));
        String pdo = matcher.group("pdo");
        CANOpenService service = CANOpenService.valueOf(pdo);
        String canDataTypeString = matcher.group("canDataType");
        CANOpenDataType canOpenDataType = CANOpenDataType.valueOf(canDataTypeString);
        return new CANOpenPDOField(nodeId, service, canOpenDataType);
    }

    @Override
    public CANOpenService getService() {
        return this.service;
    }

    @Override
    public boolean isWildcard() {
        return false;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        String serviceName = this.getService().name();
        writeBuffer.writeString("service", serviceName.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), serviceName, new WithWriterArgs[0]);
        writeBuffer.writeInt("node", 64, this.getNodeId(), new WithWriterArgs[0]);
        String dataTypeName = this.getCanOpenDataType().name();
        writeBuffer.writeString("dataType", dataTypeName.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), dataTypeName, new WithWriterArgs[0]);
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

