/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.field;

import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.canopen.field.CANOpenField;
import org.apache.plc4x.java.canopen.readwrite.CANOpenDataType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class CANOpenSDOField
extends CANOpenField {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("SDO:" + NODE_PATTERN + "(?:/(?<answerNodeId>\\d+))?:" + CANOpenField.ADDRESS_PATTERN);
    private final int answerNode;
    private final short index;
    private final short subIndex;
    private final CANOpenDataType canOpenDataType;

    public CANOpenSDOField(int node, short index, short subIndex, CANOpenDataType canOpenDataType) {
        this(node, node, index, subIndex, canOpenDataType);
    }

    public CANOpenSDOField(int node, int answerNode, short index, short subIndex, CANOpenDataType canOpenDataType) {
        super(node);
        this.answerNode = answerNode;
        this.index = index;
        this.subIndex = subIndex;
        this.canOpenDataType = canOpenDataType;
    }

    public int getAnswerNodeId() {
        return this.answerNode;
    }

    public short getIndex() {
        return this.index;
    }

    public short getSubIndex() {
        return this.subIndex;
    }

    public CANOpenDataType getCanOpenDataType() {
        return this.canOpenDataType;
    }

    public static boolean matches(String addressString) {
        return ADDRESS_PATTERN.matcher(addressString).matches();
    }

    public static Matcher getMatcher(String addressString) throws PlcInvalidFieldException {
        Matcher matcher = ADDRESS_PATTERN.matcher(addressString);
        if (matcher.matches()) {
            return matcher;
        }
        throw new PlcInvalidFieldException(addressString, ADDRESS_PATTERN);
    }

    public static CANOpenSDOField of(String addressString) {
        Matcher matcher = CANOpenSDOField.getMatcher(addressString);
        int nodeId = Integer.parseInt(matcher.group("nodeId"));
        short index = CANOpenSDOField.parseHex(matcher.group("indexHex"), matcher.group("index"));
        short subIndex = CANOpenSDOField.parseHex(matcher.group("subIndexHex"), matcher.group("subIndex"));
        String canDataTypeString = matcher.group("canDataType");
        CANOpenDataType canOpenDataType = CANOpenDataType.valueOf(canDataTypeString);
        String answerNode = matcher.group("answerNodeId");
        if (answerNode != null) {
            int answerNodeId = Integer.parseInt(matcher.group("answerNodeId"));
            return new CANOpenSDOField(nodeId, answerNodeId, index, subIndex, canOpenDataType);
        }
        return new CANOpenSDOField(nodeId, index, subIndex, canOpenDataType);
    }

    private static Short parseHex(String hex, String dec) {
        if (hex != null) {
            return Short.parseShort(hex, 16);
        }
        return Short.parseShort(dec);
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        writeBuffer.writeInt("node", 64, this.getNodeId(), new WithWriterArgs[0]);
        writeBuffer.writeInt("index", 64, (int)this.getIndex(), new WithWriterArgs[0]);
        writeBuffer.writeInt("subIndex", 64, (int)this.getSubIndex(), new WithWriterArgs[0]);
        String dataTypeName = this.getCanOpenDataType().name();
        writeBuffer.writeString("dataType", dataTypeName.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), dataTypeName, new WithWriterArgs[0]);
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

