/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.canopen.readwrite.CANOpenPayload;
import org.apache.plc4x.java.canopen.readwrite.CANOpenService;
import org.apache.plc4x.java.canopen.readwrite.SDORequest;
import org.apache.plc4x.java.canopen.readwrite.SDORequestCommand;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class CANOpenSDORequest
extends CANOpenPayload
implements Message {
    protected final SDORequestCommand command;
    protected final SDORequest request;

    @Override
    public CANOpenService getService() {
        return CANOpenService.RECEIVE_SDO;
    }

    public CANOpenSDORequest(SDORequestCommand command, SDORequest request) {
        this.command = command;
        this.request = request;
    }

    public SDORequestCommand getCommand() {
        return this.command;
    }

    public SDORequest getRequest() {
        return this.request;
    }

    @Override
    protected void serializeCANOpenPayloadChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CANOpenSDORequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"command", (String)"SDORequestCommand", (Object)((Object)this.command), (DataWriter)new DataWriterEnumDefault(SDORequestCommand::getValue, Enum::name, DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)3)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"request", (Object)this.request, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("CANOpenSDORequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CANOpenSDORequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 3;
        return lengthInBits += this.request.getLengthInBits();
    }

    public static CANOpenPayload.CANOpenPayloadBuilder staticParseCANOpenPayloadBuilder(ReadBuffer readBuffer, CANOpenService service) throws ParseException {
        readBuffer.pullContext("CANOpenSDORequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        SDORequestCommand command = (SDORequestCommand)((Object)FieldReaderFactory.readEnumField((String)"command", (String)"SDORequestCommand", (DataReader)new DataReaderEnumDefault(SDORequestCommand::enumForValue, DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)3)), (WithReaderArgs[])new WithReaderArgs[0]));
        SDORequest request = (SDORequest)FieldReaderFactory.readSimpleField((String)"request", (DataReader)new DataReaderComplexDefault(() -> SDORequest.staticParse(readBuffer, command), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("CANOpenSDORequest", new WithReaderArgs[0]);
        return new CANOpenSDORequestBuilderImpl(command, request);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CANOpenSDORequest)) {
            return false;
        }
        CANOpenSDORequest that = (CANOpenSDORequest)o;
        return this.getCommand() == that.getCommand() && this.getRequest() == that.getRequest() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getCommand(), this.getRequest()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CANOpenSDORequestBuilderImpl
    implements CANOpenPayload.CANOpenPayloadBuilder {
        private final SDORequestCommand command;
        private final SDORequest request;

        public CANOpenSDORequestBuilderImpl(SDORequestCommand command, SDORequest request) {
            this.command = command;
            this.request = request;
        }

        @Override
        public CANOpenSDORequest build() {
            CANOpenSDORequest cANOpenSDORequest = new CANOpenSDORequest(this.command, this.request);
            return cANOpenSDORequest;
        }
    }
}

