/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.canopen.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class CANOpenPayload implements Message {

  // Abstract accessors for discriminator values.
  public abstract CANOpenService getService();

  public CANOpenPayload() {
    super();
  }

  protected abstract void serializeCANOpenPayloadChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CANOpenPayload");

    // Switch field (Serialize the sub-type)
    serializeCANOpenPayloadChild(writeBuffer);

    writeBuffer.popContext("CANOpenPayload");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    CANOpenPayload _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static CANOpenPayload staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 1)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 1, but got " + args.length);
    }
    CANOpenService service;
    if (args[0] instanceof CANOpenService) {
      service = (CANOpenService) args[0];
    } else if (args[0] instanceof String) {
      service = CANOpenService.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type CANOpenService or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    return staticParse(readBuffer, service);
  }

  public static CANOpenPayload staticParse(ReadBuffer readBuffer, CANOpenService service)
      throws ParseException {
    readBuffer.pullContext("CANOpenPayload");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    CANOpenPayloadBuilder builder = null;
    if (EvaluationHelper.equals(service, CANOpenService.NMT)) {
      builder = CANOpenNetworkPayload.staticParseCANOpenPayloadBuilder(readBuffer, service);
    } else if (EvaluationHelper.equals(service, CANOpenService.TIME)) {
      builder = CANOpenTimeSynchronization.staticParseCANOpenPayloadBuilder(readBuffer, service);
    } else if (EvaluationHelper.equals(service, CANOpenService.RECEIVE_PDO_1)) {
      builder = CANOpenPDOPayload.staticParseCANOpenPayloadBuilder(readBuffer, service);
    } else if (EvaluationHelper.equals(service, CANOpenService.TRANSMIT_PDO_1)) {
      builder = CANOpenPDOPayload.staticParseCANOpenPayloadBuilder(readBuffer, service);
    } else if (EvaluationHelper.equals(service, CANOpenService.RECEIVE_PDO_2)) {
      builder = CANOpenPDOPayload.staticParseCANOpenPayloadBuilder(readBuffer, service);
    } else if (EvaluationHelper.equals(service, CANOpenService.TRANSMIT_PDO_2)) {
      builder = CANOpenPDOPayload.staticParseCANOpenPayloadBuilder(readBuffer, service);
    } else if (EvaluationHelper.equals(service, CANOpenService.RECEIVE_PDO_3)) {
      builder = CANOpenPDOPayload.staticParseCANOpenPayloadBuilder(readBuffer, service);
    } else if (EvaluationHelper.equals(service, CANOpenService.TRANSMIT_PDO_3)) {
      builder = CANOpenPDOPayload.staticParseCANOpenPayloadBuilder(readBuffer, service);
    } else if (EvaluationHelper.equals(service, CANOpenService.RECEIVE_PDO_4)) {
      builder = CANOpenPDOPayload.staticParseCANOpenPayloadBuilder(readBuffer, service);
    } else if (EvaluationHelper.equals(service, CANOpenService.TRANSMIT_PDO_4)) {
      builder = CANOpenPDOPayload.staticParseCANOpenPayloadBuilder(readBuffer, service);
    } else if (EvaluationHelper.equals(service, CANOpenService.RECEIVE_SDO)) {
      builder = CANOpenSDORequest.staticParseCANOpenPayloadBuilder(readBuffer, service);
    } else if (EvaluationHelper.equals(service, CANOpenService.TRANSMIT_SDO)) {
      builder = CANOpenSDOResponse.staticParseCANOpenPayloadBuilder(readBuffer, service);
    } else if (EvaluationHelper.equals(service, CANOpenService.HEARTBEAT)) {
      builder = CANOpenHeartbeatPayload.staticParseCANOpenPayloadBuilder(readBuffer, service);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type" + " parameters [" + "service=" + service + "]");
    }

    readBuffer.closeContext("CANOpenPayload");
    // Create the instance
    CANOpenPayload _cANOpenPayload = builder.build();
    return _cANOpenPayload;
  }

  public interface CANOpenPayloadBuilder {
    CANOpenPayload build();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CANOpenPayload)) {
      return false;
    }
    CANOpenPayload that = (CANOpenPayload) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
