/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.canopen.readwrite.CANOpenPayload;
import org.apache.plc4x.java.canopen.readwrite.CANOpenService;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class CANOpenFrame
implements Message {
    public static final Byte ALIGNMENT = 0;
    protected final short nodeId;
    protected final CANOpenService service;
    protected final CANOpenPayload payload;

    public CANOpenFrame(short nodeId, CANOpenService service, CANOpenPayload payload) {
        this.nodeId = nodeId;
        this.service = service;
        this.payload = payload;
    }

    public short getNodeId() {
        return this.nodeId;
    }

    public CANOpenService getService() {
        return this.service;
    }

    public CANOpenPayload getPayload() {
        return this.payload;
    }

    public byte getAlignment() {
        return ALIGNMENT;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CANOpenFrame", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"nodeId", (Object)this.nodeId, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        FieldWriterFactory.writeSimpleEnumField((String)"service", (String)"CANOpenService", (Object)((Object)this.service), (DataWriter)new DataWriterEnumDefault(CANOpenService::getValue, Enum::name, DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)4)), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        FieldWriterFactory.writeConstField((String)"alignment", (Object)ALIGNMENT, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)4), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        FieldWriterFactory.writeSimpleField((String)"payload", (Object)this.payload, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        FieldWriterFactory.writePaddingField((String)"padding", (int)(8 - this.payload.getLengthInBytes()), (Object)0, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        writeBuffer.popContext("CANOpenFrame", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        CANOpenFrame _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 4;
        lengthInBits += 4;
        lengthInBits += this.payload.getLengthInBits();
        int _timesPadding = 8 - this.payload.getLengthInBytes();
        while (_timesPadding-- > 0) {
            lengthInBits += 8;
        }
        return lengthInBits;
    }

    public static CANOpenFrame staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return CANOpenFrame.staticParse(readBuffer);
    }

    public static CANOpenFrame staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("CANOpenFrame", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        short nodeId = (Short)FieldReaderFactory.readSimpleField((String)"nodeId", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        CANOpenService service = (CANOpenService)((Object)FieldReaderFactory.readEnumField((String)"service", (String)"CANOpenService", (DataReader)new DataReaderEnumDefault(CANOpenService::enumForValue, DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)4)), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)}));
        byte alignment = (Byte)FieldReaderFactory.readConstField((String)"alignment", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)4), (Object)ALIGNMENT, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        CANOpenPayload payload = (CANOpenPayload)FieldReaderFactory.readSimpleField((String)"payload", (DataReader)new DataReaderComplexDefault(() -> CANOpenPayload.staticParse(readBuffer, service), readBuffer), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        FieldReaderFactory.readPaddingField((DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (int)(8 - payload.getLengthInBytes()), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.LITTLE_ENDIAN)});
        readBuffer.closeContext("CANOpenFrame", new WithReaderArgs[0]);
        CANOpenFrame _cANOpenFrame = new CANOpenFrame(nodeId, service, payload);
        return _cANOpenFrame;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CANOpenFrame)) {
            return false;
        }
        CANOpenFrame that = (CANOpenFrame)o;
        return this.getNodeId() == that.getNodeId() && this.getService() == that.getService() && this.getPayload() == that.getPayload();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getNodeId(), this.getService(), this.getPayload()});
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

