/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CipRRData extends EipPacket implements Message {

  // Accessors for discriminator values.
  public Integer getCommand() {
    return (int) 0x006F;
  }

  // Properties.
  protected final CipExchange exchange;

  // Arguments.
  protected final Integer packetLength;
  // Reserved Fields
  private Long reservedField0;
  private Integer reservedField1;

  public CipRRData(
      long sessionHandle,
      long status,
      List<Short> senderContext,
      long options,
      CipExchange exchange,
      Integer packetLength) {
    super(sessionHandle, status, senderContext, options);
    this.exchange = exchange;
    this.packetLength = packetLength;
  }

  public CipExchange getExchange() {
    return exchange;
  }

  @Override
  protected void serializeEipPacketChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("CipRRData");

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (long) 0x00000000,
        writeUnsignedLong(writeBuffer, 32));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField1 != null ? reservedField1 : (int) 0x0000,
        writeUnsignedInt(writeBuffer, 16));

    // Simple Field (exchange)
    writeSimpleField(
        "exchange",
        exchange,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("CipRRData");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CipRRData _value = this;

    // Reserved Field (reserved)
    lengthInBits += 32;

    // Reserved Field (reserved)
    lengthInBits += 16;

    // Simple field (exchange)
    lengthInBits += exchange.getLengthInBits();

    return lengthInBits;
  }

  public static CipRRDataBuilder staticParseBuilder(ReadBuffer readBuffer, Integer packetLength)
      throws ParseException {
    readBuffer.pullContext("CipRRData");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    Long reservedField0 =
        readReservedField(
            "reserved",
            readUnsignedLong(readBuffer, 32),
            (long) 0x00000000,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    Integer reservedField1 =
        readReservedField(
            "reserved",
            readUnsignedInt(readBuffer, 16),
            (int) 0x0000,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    CipExchange exchange =
        readSimpleField(
            "exchange",
            new DataReaderComplexDefault<>(
                () -> CipExchange.staticParse(readBuffer, (int) ((packetLength) - (6))),
                readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("CipRRData");
    // Create the instance
    return new CipRRDataBuilder(exchange, packetLength, reservedField0, reservedField1);
  }

  public static class CipRRDataBuilder implements EipPacket.EipPacketBuilder {
    private final CipExchange exchange;
    private final Integer packetLength;
    private final Long reservedField0;
    private final Integer reservedField1;

    public CipRRDataBuilder(
        CipExchange exchange, Integer packetLength, Long reservedField0, Integer reservedField1) {
      this.exchange = exchange;
      this.packetLength = packetLength;
      this.reservedField0 = reservedField0;
      this.reservedField1 = reservedField1;
    }

    public CipRRData build(
        long sessionHandle, long status, List<Short> senderContext, long options) {
      CipRRData cipRRData =
          new CipRRData(sessionHandle, status, senderContext, options, exchange, packetLength);
      cipRRData.reservedField0 = reservedField0;
      cipRRData.reservedField1 = reservedField1;
      return cipRRData;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CipRRData)) {
      return false;
    }
    CipRRData that = (CipRRData) o;
    return (getExchange() == that.getExchange()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getExchange());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
