/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CipReadRequest extends CipService implements Message {

  // Accessors for discriminator values.
  public Short getService() {
    return (short) 0x4C;
  }

  // Properties.
  protected final byte requestPathSize;
  protected final byte[] tag;
  protected final int elementNb;

  // Arguments.
  protected final Integer serviceLen;

  public CipReadRequest(byte requestPathSize, byte[] tag, int elementNb, Integer serviceLen) {
    super(serviceLen);
    this.requestPathSize = requestPathSize;
    this.tag = tag;
    this.elementNb = elementNb;
    this.serviceLen = serviceLen;
  }

  public byte getRequestPathSize() {
    return requestPathSize;
  }

  public byte[] getTag() {
    return tag;
  }

  public int getElementNb() {
    return elementNb;
  }

  @Override
  protected void serializeCipServiceChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("CipReadRequest");

    // Simple Field (requestPathSize)
    writeSimpleField("requestPathSize", requestPathSize, writeSignedByte(writeBuffer, 8));

    // Array Field (tag)
    writeByteArrayField("tag", tag, writeByteArray(writeBuffer, 8));

    // Simple Field (elementNb)
    writeSimpleField("elementNb", elementNb, writeUnsignedInt(writeBuffer, 16));

    writeBuffer.popContext("CipReadRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CipReadRequest _value = this;

    // Simple field (requestPathSize)
    lengthInBits += 8;

    // Array field
    if (tag != null) {
      lengthInBits += 8 * tag.length;
    }

    // Simple field (elementNb)
    lengthInBits += 16;

    return lengthInBits;
  }

  public static CipReadRequestBuilder staticParseBuilder(ReadBuffer readBuffer, Integer serviceLen)
      throws ParseException {
    readBuffer.pullContext("CipReadRequest");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    byte requestPathSize = readSimpleField("requestPathSize", readSignedByte(readBuffer, 8));

    byte[] tag = readBuffer.readByteArray("tag", Math.toIntExact(((requestPathSize) * (2))));

    int elementNb = readSimpleField("elementNb", readUnsignedInt(readBuffer, 16));

    readBuffer.closeContext("CipReadRequest");
    // Create the instance
    return new CipReadRequestBuilder(requestPathSize, tag, elementNb, serviceLen);
  }

  public static class CipReadRequestBuilder implements CipService.CipServiceBuilder {
    private final byte requestPathSize;
    private final byte[] tag;
    private final int elementNb;
    private final Integer serviceLen;

    public CipReadRequestBuilder(
        byte requestPathSize, byte[] tag, int elementNb, Integer serviceLen) {

      this.requestPathSize = requestPathSize;
      this.tag = tag;
      this.elementNb = elementNb;
      this.serviceLen = serviceLen;
    }

    public CipReadRequest build(Integer serviceLen) {

      CipReadRequest cipReadRequest =
          new CipReadRequest(requestPathSize, tag, elementNb, serviceLen);
      return cipReadRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CipReadRequest)) {
      return false;
    }
    CipReadRequest that = (CipReadRequest) o;
    return (getRequestPathSize() == that.getRequestPathSize())
        && (getTag() == that.getTag())
        && (getElementNb() == that.getElementNb())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getRequestPathSize(), getTag(), getElementNb());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
