/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CipUnconnectedRequest extends CipService implements Message {

  // Accessors for discriminator values.
  public Short getService() {
    return (short) 0x52;
  }

  // Constant values.
  public static final Integer ROUTE = 0x0001;

  // Properties.
  protected final CipService unconnectedService;
  protected final byte backPlane;
  protected final byte slot;

  // Arguments.
  protected final Integer serviceLen;
  // Reserved Fields
  private Short reservedField0;
  private Short reservedField1;
  private Short reservedField2;
  private Short reservedField3;
  private Short reservedField4;
  private Integer reservedField5;

  public CipUnconnectedRequest(
      CipService unconnectedService, byte backPlane, byte slot, Integer serviceLen) {
    super(serviceLen);
    this.unconnectedService = unconnectedService;
    this.backPlane = backPlane;
    this.slot = slot;
    this.serviceLen = serviceLen;
  }

  public CipService getUnconnectedService() {
    return unconnectedService;
  }

  public byte getBackPlane() {
    return backPlane;
  }

  public byte getSlot() {
    return slot;
  }

  public int getRoute() {
    return ROUTE;
  }

  @Override
  protected void serializeCipServiceChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("CipUnconnectedRequest");

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (short) 0x02,
        writeUnsignedShort(writeBuffer, 8));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField1 != null ? reservedField1 : (short) 0x20,
        writeUnsignedShort(writeBuffer, 8));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField2 != null ? reservedField2 : (short) 0x06,
        writeUnsignedShort(writeBuffer, 8));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField3 != null ? reservedField3 : (short) 0x24,
        writeUnsignedShort(writeBuffer, 8));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField4 != null ? reservedField4 : (short) 0x01,
        writeUnsignedShort(writeBuffer, 8));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField5 != null ? reservedField5 : (int) 0x9D05,
        writeUnsignedInt(writeBuffer, 16));

    // Implicit Field (messageSize) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int messageSize = (int) (((getLengthInBytes()) - (10)) - (4));
    writeImplicitField("messageSize", messageSize, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (unconnectedService)
    writeSimpleField(
        "unconnectedService", unconnectedService, new DataWriterComplexDefault<>(writeBuffer));

    // Const Field (route)
    writeConstField("route", ROUTE, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (backPlane)
    writeSimpleField("backPlane", backPlane, writeSignedByte(writeBuffer, 8));

    // Simple Field (slot)
    writeSimpleField("slot", slot, writeSignedByte(writeBuffer, 8));

    writeBuffer.popContext("CipUnconnectedRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CipUnconnectedRequest _value = this;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 16;

    // Implicit Field (messageSize)
    lengthInBits += 16;

    // Simple field (unconnectedService)
    lengthInBits += unconnectedService.getLengthInBits();

    // Const Field (route)
    lengthInBits += 16;

    // Simple field (backPlane)
    lengthInBits += 8;

    // Simple field (slot)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static CipUnconnectedRequestBuilder staticParseBuilder(
      ReadBuffer readBuffer, Integer serviceLen) throws ParseException {
    readBuffer.pullContext("CipUnconnectedRequest");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x02);

    Short reservedField1 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x20);

    Short reservedField2 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x06);

    Short reservedField3 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x24);

    Short reservedField4 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x01);

    Integer reservedField5 =
        readReservedField("reserved", readUnsignedInt(readBuffer, 16), (int) 0x9D05);

    int messageSize = readImplicitField("messageSize", readUnsignedInt(readBuffer, 16));

    CipService unconnectedService =
        readSimpleField(
            "unconnectedService",
            new DataReaderComplexDefault<>(
                () -> CipService.staticParse(readBuffer, (int) (messageSize)), readBuffer));

    int route =
        readConstField("route", readUnsignedInt(readBuffer, 16), CipUnconnectedRequest.ROUTE);

    byte backPlane = readSimpleField("backPlane", readSignedByte(readBuffer, 8));

    byte slot = readSimpleField("slot", readSignedByte(readBuffer, 8));

    readBuffer.closeContext("CipUnconnectedRequest");
    // Create the instance
    return new CipUnconnectedRequestBuilder(
        unconnectedService,
        backPlane,
        slot,
        serviceLen,
        reservedField0,
        reservedField1,
        reservedField2,
        reservedField3,
        reservedField4,
        reservedField5);
  }

  public static class CipUnconnectedRequestBuilder implements CipService.CipServiceBuilder {
    private final CipService unconnectedService;
    private final byte backPlane;
    private final byte slot;
    private final Integer serviceLen;
    private final Short reservedField0;
    private final Short reservedField1;
    private final Short reservedField2;
    private final Short reservedField3;
    private final Short reservedField4;
    private final Integer reservedField5;

    public CipUnconnectedRequestBuilder(
        CipService unconnectedService,
        byte backPlane,
        byte slot,
        Integer serviceLen,
        Short reservedField0,
        Short reservedField1,
        Short reservedField2,
        Short reservedField3,
        Short reservedField4,
        Integer reservedField5) {
      this.unconnectedService = unconnectedService;
      this.backPlane = backPlane;
      this.slot = slot;
      this.serviceLen = serviceLen;
      this.reservedField0 = reservedField0;
      this.reservedField1 = reservedField1;
      this.reservedField2 = reservedField2;
      this.reservedField3 = reservedField3;
      this.reservedField4 = reservedField4;
      this.reservedField5 = reservedField5;
    }

    public CipUnconnectedRequest build(Integer serviceLen) {

      CipUnconnectedRequest cipUnconnectedRequest =
          new CipUnconnectedRequest(unconnectedService, backPlane, slot, serviceLen);
      cipUnconnectedRequest.reservedField0 = reservedField0;
      cipUnconnectedRequest.reservedField1 = reservedField1;
      cipUnconnectedRequest.reservedField2 = reservedField2;
      cipUnconnectedRequest.reservedField3 = reservedField3;
      cipUnconnectedRequest.reservedField4 = reservedField4;
      cipUnconnectedRequest.reservedField5 = reservedField5;
      return cipUnconnectedRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CipUnconnectedRequest)) {
      return false;
    }
    CipUnconnectedRequest that = (CipUnconnectedRequest) o;
    return (getUnconnectedService() == that.getUnconnectedService())
        && (getBackPlane() == that.getBackPlane())
        && (getSlot() == that.getSlot())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getUnconnectedService(), getBackPlane(), getSlot());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
