/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class MultipleServiceResponse extends CipService implements Message {

  // Accessors for discriminator values.
  public Short getService() {
    return (short) 0x8A;
  }

  // Properties.
  protected final short status;
  protected final short extStatus;
  protected final int serviceNb;
  protected final List<Integer> offsets;
  protected final byte[] servicesData;

  // Arguments.
  protected final Integer serviceLen;
  // Reserved Fields
  private Short reservedField0;

  public MultipleServiceResponse(
      short status,
      short extStatus,
      int serviceNb,
      List<Integer> offsets,
      byte[] servicesData,
      Integer serviceLen) {
    super(serviceLen);
    this.status = status;
    this.extStatus = extStatus;
    this.serviceNb = serviceNb;
    this.offsets = offsets;
    this.servicesData = servicesData;
    this.serviceLen = serviceLen;
  }

  public short getStatus() {
    return status;
  }

  public short getExtStatus() {
    return extStatus;
  }

  public int getServiceNb() {
    return serviceNb;
  }

  public List<Integer> getOffsets() {
    return offsets;
  }

  public byte[] getServicesData() {
    return servicesData;
  }

  @Override
  protected void serializeCipServiceChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("MultipleServiceResponse");

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (short) 0x0,
        writeUnsignedShort(writeBuffer, 8));

    // Simple Field (status)
    writeSimpleField("status", status, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (extStatus)
    writeSimpleField("extStatus", extStatus, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (serviceNb)
    writeSimpleField("serviceNb", serviceNb, writeUnsignedInt(writeBuffer, 16));

    // Array Field (offsets)
    writeSimpleTypeArrayField("offsets", offsets, writeUnsignedInt(writeBuffer, 16));

    // Array Field (servicesData)
    writeByteArrayField("servicesData", servicesData, writeByteArray(writeBuffer, 8));

    writeBuffer.popContext("MultipleServiceResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    MultipleServiceResponse _value = this;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Simple field (status)
    lengthInBits += 8;

    // Simple field (extStatus)
    lengthInBits += 8;

    // Simple field (serviceNb)
    lengthInBits += 16;

    // Array field
    if (offsets != null) {
      lengthInBits += 16 * offsets.size();
    }

    // Array field
    if (servicesData != null) {
      lengthInBits += 8 * servicesData.length;
    }

    return lengthInBits;
  }

  public static MultipleServiceResponseBuilder staticParseBuilder(
      ReadBuffer readBuffer, Integer serviceLen) throws ParseException {
    readBuffer.pullContext("MultipleServiceResponse");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x0);

    short status = readSimpleField("status", readUnsignedShort(readBuffer, 8));

    short extStatus = readSimpleField("extStatus", readUnsignedShort(readBuffer, 8));

    int serviceNb = readSimpleField("serviceNb", readUnsignedInt(readBuffer, 16));

    List<Integer> offsets =
        readCountArrayField("offsets", readUnsignedInt(readBuffer, 16), serviceNb);

    byte[] servicesData =
        readBuffer.readByteArray(
            "servicesData", Math.toIntExact(((serviceLen) - (6)) - (((2) * (serviceNb)))));

    readBuffer.closeContext("MultipleServiceResponse");
    // Create the instance
    return new MultipleServiceResponseBuilder(
        status, extStatus, serviceNb, offsets, servicesData, serviceLen, reservedField0);
  }

  public static class MultipleServiceResponseBuilder implements CipService.CipServiceBuilder {
    private final short status;
    private final short extStatus;
    private final int serviceNb;
    private final List<Integer> offsets;
    private final byte[] servicesData;
    private final Integer serviceLen;
    private final Short reservedField0;

    public MultipleServiceResponseBuilder(
        short status,
        short extStatus,
        int serviceNb,
        List<Integer> offsets,
        byte[] servicesData,
        Integer serviceLen,
        Short reservedField0) {
      this.status = status;
      this.extStatus = extStatus;
      this.serviceNb = serviceNb;
      this.offsets = offsets;
      this.servicesData = servicesData;
      this.serviceLen = serviceLen;
      this.reservedField0 = reservedField0;
    }

    public MultipleServiceResponse build(Integer serviceLen) {

      MultipleServiceResponse multipleServiceResponse =
          new MultipleServiceResponse(
              status, extStatus, serviceNb, offsets, servicesData, serviceLen);
      multipleServiceResponse.reservedField0 = reservedField0;
      return multipleServiceResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof MultipleServiceResponse)) {
      return false;
    }
    MultipleServiceResponse that = (MultipleServiceResponse) o;
    return (getStatus() == that.getStatus())
        && (getExtStatus() == that.getExtStatus())
        && (getServiceNb() == that.getServiceNb())
        && (getOffsets() == that.getOffsets())
        && (getServicesData() == that.getServicesData())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getStatus(),
        getExtStatus(),
        getServiceNb(),
        getOffsets(),
        getServicesData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
