/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.eip.readwrite.CipService;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class CipExchange
implements Message {
    public static final Integer ITEMCOUNT = 2;
    public static final Long NULLPTR = 0L;
    public static final Integer UNCONNECTEDDATA = 178;
    protected final CipService service;
    protected final Integer exchangeLen;

    public CipExchange(CipService service, Integer exchangeLen) {
        this.service = service;
        this.exchangeLen = exchangeLen;
    }

    public CipService getService() {
        return this.service;
    }

    public int getItemCount() {
        return ITEMCOUNT;
    }

    public long getNullPtr() {
        return NULLPTR;
    }

    public int getUnconnectedData() {
        return UNCONNECTEDDATA;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("CipExchange", new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField((String)"itemCount", (Object)ITEMCOUNT, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField((String)"nullPtr", (Object)NULLPTR, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField((String)"unconnectedData", (Object)UNCONNECTEDDATA, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        int size = this.getLengthInBytes() - 8 - 2;
        FieldWriterFactory.writeImplicitField((String)"size", (Object)size, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"service", (Object)this.service, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("CipExchange", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        CipExchange _value = this;
        lengthInBits += 16;
        lengthInBits += 32;
        lengthInBits += 16;
        lengthInBits += 16;
        return lengthInBits += this.service.getLengthInBits();
    }

    public static CipExchange staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Integer exchangeLen;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Integer) {
            exchangeLen = (Integer)args[0];
        } else if (args[0] instanceof String) {
            exchangeLen = Integer.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Integer or a string which is parseable but was " + args[0].getClass().getName());
        }
        return CipExchange.staticParse(readBuffer, exchangeLen);
    }

    public static CipExchange staticParse(ReadBuffer readBuffer, Integer exchangeLen) throws ParseException {
        readBuffer.pullContext("CipExchange", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        int itemCount = (Integer)FieldReaderFactory.readConstField((String)"itemCount", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (Object)ITEMCOUNT, (WithReaderArgs[])new WithReaderArgs[0]);
        long nullPtr = (Long)FieldReaderFactory.readConstField((String)"nullPtr", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (Object)NULLPTR, (WithReaderArgs[])new WithReaderArgs[0]);
        int unconnectedData = (Integer)FieldReaderFactory.readConstField((String)"unconnectedData", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (Object)UNCONNECTEDDATA, (WithReaderArgs[])new WithReaderArgs[0]);
        int size = (Integer)FieldReaderFactory.readImplicitField((String)"size", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        CipService service = (CipService)FieldReaderFactory.readSimpleField((String)"service", (DataReader)new DataReaderComplexDefault(() -> CipService.staticParse(readBuffer, exchangeLen - 10), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("CipExchange", new WithReaderArgs[0]);
        CipExchange _cipExchange = new CipExchange(service, exchangeLen);
        return _cipExchange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CipExchange)) {
            return false;
        }
        CipExchange that = (CipExchange)o;
        return this.getService() == that.getService();
    }

    public int hashCode() {
        return Objects.hash(this.getService());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

