/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.eip.readwrite.CipReadRequest;
import org.apache.plc4x.java.eip.readwrite.CipReadResponse;
import org.apache.plc4x.java.eip.readwrite.CipUnconnectedRequest;
import org.apache.plc4x.java.eip.readwrite.CipWriteRequest;
import org.apache.plc4x.java.eip.readwrite.CipWriteResponse;
import org.apache.plc4x.java.eip.readwrite.MultipleServiceRequest;
import org.apache.plc4x.java.eip.readwrite.MultipleServiceResponse;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class CipService
implements Message {
    protected final Integer serviceLen;

    public abstract Short getService();

    public CipService(Integer serviceLen) {
        this.serviceLen = serviceLen;
    }

    protected abstract void serializeCipServiceChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("CipService", new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField((String)"service", (Object)this.getService(), (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        this.serializeCipServiceChild(writeBuffer);
        writeBuffer.popContext("CipService", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        CipService _value = this;
        return lengthInBits += 8;
    }

    public static CipService staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Integer serviceLen;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Integer) {
            serviceLen = (Integer)args[0];
        } else if (args[0] instanceof String) {
            serviceLen = Integer.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Integer or a string which is parseable but was " + args[0].getClass().getName());
        }
        return CipService.staticParse(readBuffer, serviceLen);
    }

    public static CipService staticParse(ReadBuffer readBuffer, Integer serviceLen) throws ParseException {
        readBuffer.pullContext("CipService", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        short service = (Short)FieldReaderFactory.readDiscriminatorField((String)"service", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        CipServiceBuilder builder = null;
        if (EvaluationHelper.equals((Object)service, (Object)76)) {
            builder = CipReadRequest.staticParseBuilder(readBuffer, serviceLen);
        } else if (EvaluationHelper.equals((Object)service, (Object)204)) {
            builder = CipReadResponse.staticParseBuilder(readBuffer, serviceLen);
        } else if (EvaluationHelper.equals((Object)service, (Object)77)) {
            builder = CipWriteRequest.staticParseBuilder(readBuffer, serviceLen);
        } else if (EvaluationHelper.equals((Object)service, (Object)205)) {
            builder = CipWriteResponse.staticParseBuilder(readBuffer, serviceLen);
        } else if (EvaluationHelper.equals((Object)service, (Object)10)) {
            builder = MultipleServiceRequest.staticParseBuilder(readBuffer, serviceLen);
        } else if (EvaluationHelper.equals((Object)service, (Object)138)) {
            builder = MultipleServiceResponse.staticParseBuilder(readBuffer, serviceLen);
        } else if (EvaluationHelper.equals((Object)service, (Object)82)) {
            builder = CipUnconnectedRequest.staticParseBuilder(readBuffer, serviceLen);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [service=" + service + "]");
        }
        readBuffer.closeContext("CipService", new WithReaderArgs[0]);
        CipService _cipService = builder.build(serviceLen);
        return _cipService;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CipService)) {
            return false;
        }
        CipService that = (CipService)o;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface CipServiceBuilder {
        public CipService build(Integer var1);
    }
}

