/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.CipRRData;
import org.apache.plc4x.java.eip.readwrite.EipConnectionRequest;
import org.apache.plc4x.java.eip.readwrite.EipDisconnectRequest;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class EipPacket
implements Message {
    protected final long sessionHandle;
    protected final long status;
    protected final List<Short> senderContext;
    protected final long options;

    public abstract Integer getCommand();

    public EipPacket(long sessionHandle, long status, List<Short> senderContext, long options) {
        this.sessionHandle = sessionHandle;
        this.status = status;
        this.senderContext = senderContext;
        this.options = options;
    }

    public long getSessionHandle() {
        return this.sessionHandle;
    }

    public long getStatus() {
        return this.status;
    }

    public List<Short> getSenderContext() {
        return this.senderContext;
    }

    public long getOptions() {
        return this.options;
    }

    protected abstract void serializeEipPacketChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("EipPacket", new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField((String)"command", (Object)this.getCommand(), (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        int packetLength = this.getLengthInBytes() - 24;
        FieldWriterFactory.writeImplicitField((String)"packetLength", (Object)packetLength, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sessionHandle", (Object)this.sessionHandle, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleField((String)"status", (Object)this.status, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FieldWriterFactory.writeSimpleTypeArrayField((String)"senderContext", this.senderContext, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"options", (Object)this.options, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        this.serializeEipPacketChild(writeBuffer);
        writeBuffer.popContext("EipPacket", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        EipPacket _value = this;
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.senderContext != null) {
            lengthInBits += 8 * this.senderContext.size();
        }
        return lengthInBits += 32;
    }

    public static EipPacket staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return EipPacket.staticParse(readBuffer);
    }

    public static EipPacket staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("EipPacket", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        int command = (Integer)FieldReaderFactory.readDiscriminatorField((String)"command", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        int packetLength = (Integer)FieldReaderFactory.readImplicitField((String)"packetLength", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        long sessionHandle = (Long)FieldReaderFactory.readSimpleField((String)"sessionHandle", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        long status = (Long)FieldReaderFactory.readSimpleField((String)"status", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        List senderContext = FieldReaderFactory.readCountArrayField((String)"senderContext", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (long)8L, (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        long options = (Long)FieldReaderFactory.readSimpleField((String)"options", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        EipPacketBuilder builder = null;
        if (EvaluationHelper.equals((Object)command, (Object)101)) {
            builder = EipConnectionRequest.staticParseBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)command, (Object)102)) {
            builder = EipDisconnectRequest.staticParseBuilder(readBuffer);
        } else if (EvaluationHelper.equals((Object)command, (Object)111)) {
            builder = CipRRData.staticParseBuilder(readBuffer, packetLength);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [command=" + command + "]");
        }
        readBuffer.closeContext("EipPacket", new WithReaderArgs[0]);
        EipPacket _eipPacket = builder.build(sessionHandle, status, senderContext, options);
        return _eipPacket;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EipPacket)) {
            return false;
        }
        EipPacket that = (EipPacket)o;
        return this.getSessionHandle() == that.getSessionHandle() && this.getStatus() == that.getStatus() && this.getSenderContext() == that.getSenderContext() && this.getOptions() == that.getOptions();
    }

    public int hashCode() {
        return Objects.hash(this.getSessionHandle(), this.getStatus(), this.getSenderContext(), this.getOptions());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface EipPacketBuilder {
        public EipPacket build(long var1, long var3, List<Short> var5, long var6);
    }
}

