/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.CipService;
import org.apache.plc4x.java.eip.readwrite.TypeId;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ConnectedDataItem
extends TypeId
implements Message {
    protected final int sequenceCount;
    protected final CipService service;

    @Override
    public Integer getId() {
        return 177;
    }

    public ConnectedDataItem(int sequenceCount, CipService service) {
        this.sequenceCount = sequenceCount;
        this.service = service;
    }

    public int getSequenceCount() {
        return this.sequenceCount;
    }

    public CipService getService() {
        return this.service;
    }

    @Override
    protected void serializeTypeIdChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ConnectedDataItem", new WithWriterArgs[0]);
        int packetSize = this.getService().getLengthInBytes() + 2;
        FieldWriterFactory.writeImplicitField((String)"packetSize", (Object)packetSize, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"sequenceCount", (Object)this.sequenceCount, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"service", (Object)this.service, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ConnectedDataItem", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ConnectedDataItem _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 16;
        return lengthInBits += this.service.getLengthInBits();
    }

    public static TypeId.TypeIdBuilder staticParseTypeIdBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("ConnectedDataItem", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int packetSize = (Integer)FieldReaderFactory.readImplicitField((String)"packetSize", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        int sequenceCount = (Integer)FieldReaderFactory.readSimpleField((String)"sequenceCount", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        CipService service = (CipService)FieldReaderFactory.readSimpleField((String)"service", (DataReader)new DataReaderComplexDefault(() -> CipService.staticParse(readBuffer, true, packetSize - 2), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ConnectedDataItem", new WithReaderArgs[0]);
        return new ConnectedDataItemBuilderImpl(sequenceCount, service);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectedDataItem)) {
            return false;
        }
        ConnectedDataItem that = (ConnectedDataItem)o;
        return this.getSequenceCount() == that.getSequenceCount() && this.getService() == that.getService() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSequenceCount(), this.getService());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ConnectedDataItemBuilderImpl
    implements TypeId.TypeIdBuilder {
        private final int sequenceCount;
        private final CipService service;

        public ConnectedDataItemBuilderImpl(int sequenceCount, CipService service) {
            this.sequenceCount = sequenceCount;
            this.service = service;
        }

        @Override
        public ConnectedDataItem build() {
            ConnectedDataItem connectedDataItem = new ConnectedDataItem(this.sequenceCount, this.service);
            return connectedDataItem;
        }
    }
}

