/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.EipPacket;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class EipConnectionResponse
extends EipPacket
implements Message {
    public static final Integer PROTOCOLVERSION = 1;
    public static final Integer FLAGS = 0;

    @Override
    public Integer getCommand() {
        return 101;
    }

    @Override
    public Boolean getResponse() {
        return true;
    }

    @Override
    public Integer getPacketLength() {
        return 0;
    }

    public EipConnectionResponse(long sessionHandle, long status, byte[] senderContext, long options) {
        super(sessionHandle, status, senderContext, options);
    }

    public int getProtocolVersion() {
        return PROTOCOLVERSION;
    }

    public int getFlags() {
        return FLAGS;
    }

    @Override
    protected void serializeEipPacketChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("EipConnectionResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField((String)"protocolVersion", (Object)PROTOCOLVERSION, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeConstField((String)"flags", (Object)FLAGS, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("EipConnectionResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        EipConnectionResponse _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        return lengthInBits += 16;
    }

    public static EipPacket.EipPacketBuilder staticParseEipPacketBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("EipConnectionResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int protocolVersion = (Integer)FieldReaderFactory.readConstField((String)"protocolVersion", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (Object)PROTOCOLVERSION, (WithReaderArgs[])new WithReaderArgs[0]);
        int flags = (Integer)FieldReaderFactory.readConstField((String)"flags", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (Object)FLAGS, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("EipConnectionResponse", new WithReaderArgs[0]);
        return new EipConnectionResponseBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EipConnectionResponse)) {
            return false;
        }
        EipConnectionResponse that = (EipConnectionResponse)o;
        return super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class EipConnectionResponseBuilderImpl
    implements EipPacket.EipPacketBuilder {
        @Override
        public EipConnectionResponse build(long sessionHandle, long status, byte[] senderContext, long options) {
            EipConnectionResponse eipConnectionResponse = new EipConnectionResponse(sessionHandle, status, senderContext, options);
            return eipConnectionResponse;
        }
    }
}

