/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.base.configuration;

import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.annotations.ConfigurationParameter;
import org.apache.plc4x.java.spi.configuration.annotations.Description;
import org.apache.plc4x.java.spi.generation.ByteOrder;

public class EIPConfiguration
implements PlcConnectionConfiguration {
    @ConfigurationParameter
    @Description(value="Without using routing information the backplane defaults to 1. This is overridden if communicationPath is provided.")
    private int backplane = 1;
    @ConfigurationParameter
    @Description(value="The slot within the backplane the CPU is located.")
    private int slot = 0;
    @ConfigurationParameter
    @Description(value="Configure if the connection should be set to transport data in Big-Endian format, or not.")
    private boolean bigEndian = true;

    public int getBackplane() {
        return this.backplane;
    }

    public void setBackplane(int backplane) {
        this.backplane = backplane;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public ByteOrder getByteOrder() {
        return this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.bigEndian = byteOrder == ByteOrder.BIG_ENDIAN;
    }
}

