/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum CIPDataTypeCode {
    BOOL(193, 1),
    SINT(194, 1),
    INT(195, 2),
    DINT(196, 4),
    LINT(197, 8),
    USINT(198, 1),
    UINT(199, 2),
    UDINT(200, 4),
    ULINT(201, 8),
    REAL(202, 4),
    LREAL(203, 8),
    STIME(204, 4),
    DATE(205, 2),
    TIME_OF_DAY(206, 4),
    DATE_AND_TIME(207, 6),
    STRING(208, 0),
    BYTE(209, 1),
    WORD(210, 2),
    DWORD(211, 4),
    LWORD(211, 8),
    STRING2(213, 0),
    FTIME(214, 4),
    LTIME(215, 8),
    ITIME(216, 2),
    STRINGN(217, 0),
    SHORT_STRING(218, 0),
    TIME(219, 4),
    EPATH(220, 0),
    ENGUNIT(221, 0),
    STRINGI(221, 0),
    STRUCTURED(672, 88);

    private static final Map<Integer, CIPDataTypeCode> map;
    private final int value;
    private final short size;

    static {
        map = new HashMap<Integer, CIPDataTypeCode>();
        CIPDataTypeCode[] cIPDataTypeCodeArray = CIPDataTypeCode.values();
        int n = cIPDataTypeCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CIPDataTypeCode value = cIPDataTypeCodeArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private CIPDataTypeCode(int value, short size) {
        this.value = value;
        this.size = size;
    }

    public int getValue() {
        return this.value;
    }

    public short getSize() {
        return this.size;
    }

    public static CIPDataTypeCode firstEnumForFieldSize(short fieldValue) {
        CIPDataTypeCode[] cIPDataTypeCodeArray = CIPDataTypeCode.values();
        int n = cIPDataTypeCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CIPDataTypeCode _val = cIPDataTypeCodeArray[n2];
            if (_val.getSize() == fieldValue) {
                return _val;
            }
            ++n2;
        }
        return null;
    }

    public static List<CIPDataTypeCode> enumsForFieldSize(short fieldValue) {
        ArrayList<CIPDataTypeCode> _values = new ArrayList<CIPDataTypeCode>();
        CIPDataTypeCode[] cIPDataTypeCodeArray = CIPDataTypeCode.values();
        int n = cIPDataTypeCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CIPDataTypeCode _val = cIPDataTypeCodeArray[n2];
            if (_val.getSize() == fieldValue) {
                _values.add(_val);
            }
            ++n2;
        }
        return _values;
    }

    public static CIPDataTypeCode enumForValue(int value) {
        return map.get(value);
    }

    public static Boolean isDefined(int value) {
        return map.containsKey(value);
    }
}

