/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class CIPAttributes
implements Message {
    protected final List<Integer> classId;
    protected final Integer numberAvailable;
    protected final Integer numberActive;
    protected final byte[] data;

    public CIPAttributes(List<Integer> classId, Integer numberAvailable, Integer numberActive, byte[] data) {
        this.classId = classId;
        this.numberAvailable = numberAvailable;
        this.numberActive = numberActive;
        this.data = data;
    }

    public List<Integer> getClassId() {
        return this.classId;
    }

    public Integer getNumberAvailable() {
        return this.numberAvailable;
    }

    public Integer getNumberActive() {
        return this.numberActive;
    }

    public byte[] getData() {
        return this.data;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CIPAttributes", new WithWriterArgs[0]);
        int numberOfClasses = StaticHelper.COUNT(this.getClassId());
        FieldWriterFactory.writeImplicitField((String)"numberOfClasses", (Object)numberOfClasses, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"classId", this.classId, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"numberAvailable", (Object)this.numberAvailable, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"numberActive", (Object)this.numberActive, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"data", (byte[])this.data, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("CIPAttributes", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        CIPAttributes _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        if (this.classId != null) {
            lengthInBits += 16 * this.classId.size();
        }
        if (this.numberAvailable != null) {
            lengthInBits += 16;
        }
        if (this.numberActive != null) {
            lengthInBits += 16;
        }
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public static CIPAttributes staticParse(ReadBuffer readBuffer, Integer packetLength) throws ParseException {
        readBuffer.pullContext("CIPAttributes", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int numberOfClasses = (Integer)FieldReaderFactory.readImplicitField((String)"numberOfClasses", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        List classId = FieldReaderFactory.readCountArrayField((String)"classId", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (long)numberOfClasses, (WithReaderArgs[])new WithReaderArgs[0]);
        Integer numberAvailable = (Integer)FieldReaderFactory.readOptionalField((String)"numberAvailable", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (packetLength >= numberOfClasses * 2 + 4 ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]);
        Integer numberActive = (Integer)FieldReaderFactory.readOptionalField((String)"numberActive", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (packetLength >= numberOfClasses * 2 + 6 ? 1 : 0) != 0, (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(packetLength > numberOfClasses * 2 + 6 ? packetLength - (numberOfClasses * 2 + 6) : 0), new WithReaderArgs[0]);
        readBuffer.closeContext("CIPAttributes", new WithReaderArgs[0]);
        CIPAttributes _cIPAttributes = new CIPAttributes(classId, numberAvailable, numberActive, data);
        return _cIPAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CIPAttributes)) {
            return false;
        }
        CIPAttributes that = (CIPAttributes)o;
        return this.getClassId() == that.getClassId() && this.getNumberAvailable() == that.getNumberAvailable() && this.getNumberActive() == that.getNumberActive() && this.getData() == that.getData();
    }

    public int hashCode() {
        return Objects.hash(this.getClassId(), this.getNumberAvailable(), this.getNumberActive(), this.getData());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

