/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum CIPStatus {
    Success(0L),
    ConnectionFailure(1L),
    ResourceUnAvailable(2L),
    InvalidParameterValue(3L),
    PathSegmentError(4L),
    PathDestinationUnknown(5L),
    PartialTransfer(6L),
    ConnectionIDNotValid(7L),
    ServiceNotSupported(8L),
    InvalidAttributeValue(9L),
    AttributeListError(10L),
    AlreadyInRequestedState(11L),
    ObjectStateConflict(12L),
    ObjectAlreadyExists(13L),
    AttributeNotSettable(14L),
    PrivilegeViolation(15L),
    DeviceStateConflict(16L),
    ReplyDataTooLarge(17L),
    FragmentationOfPrimitiveValue(18L),
    NotEnoughData(19L),
    AttributeNotSupported(20L),
    TooMuchData(21L),
    ObjectDoesNotExist(22L),
    ServiceFragmentation(23L),
    NoStoredAttributeData(24L),
    StoreOperationFailure(25L),
    RequestPacketTooLarge(26L),
    ResponsePacketTooLarge(27L),
    MissingAttributeListEntryData(28L),
    InvalidAttributeValueList(29L),
    EmbeddedServiceError(30L),
    VendorSpecificError(31L),
    InvalidCommandWithWrongEndianess(0x1000000L);

    private static final Map<Long, CIPStatus> map;
    private final long value;

    static {
        map = new HashMap<Long, CIPStatus>();
        CIPStatus[] cIPStatusArray = CIPStatus.values();
        int n = cIPStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            CIPStatus value = cIPStatusArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private CIPStatus(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    public static CIPStatus enumForValue(long value) {
        return map.get(value);
    }

    public static Boolean isDefined(long value) {
        return map.containsKey(value);
    }
}

