/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.firmata.readwrite;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessage;
import org.apache.plc4x.java.firmata.readwrite.configuration.FirmataConfiguration;
import org.apache.plc4x.java.firmata.readwrite.context.FirmataDriverContext;
import org.apache.plc4x.java.firmata.readwrite.protocol.FirmataProtocolLogic;
import org.apache.plc4x.java.firmata.readwrite.tag.FirmataTag;
import org.apache.plc4x.java.firmata.readwrite.tag.FirmataTagHandler;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.values.PlcValueHandler;

public class FirmataDriver
extends GeneratedDriverBase<FirmataMessage> {
    public String getProtocolCode() {
        return "firmata";
    }

    public String getProtocolName() {
        return "Firmata";
    }

    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return FirmataConfiguration.class;
    }

    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("serial");
    }

    protected List<String> getSupportedTransportCodes() {
        return Collections.singletonList("serial");
    }

    protected boolean canWrite() {
        return true;
    }

    protected boolean canSubscribe() {
        return true;
    }

    protected PlcTagHandler getTagHandler() {
        return new FirmataTagHandler();
    }

    protected org.apache.plc4x.java.api.value.PlcValueHandler getValueHandler() {
        return new PlcValueHandler();
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected ProtocolStackConfigurer<FirmataMessage> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(FirmataMessage.class, (readBuffer, objectArray) -> FirmataMessage.staticParse(readBuffer, objectArray)).withProtocol(FirmataProtocolLogic.class).withDriverContext(FirmataDriverContext.class).withPacketSizeEstimator(ByteLengthEstimator.class).withCorruptPacketRemover(CorruptPackageCleaner.class).withParserArgs(new Object[]{true}).build();
    }

    public FirmataTag prepareTag(String tagAddress) {
        return FirmataTag.of(tagAddress);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 1) {
                int type = byteBuf.getByte(byteBuf.readerIndex()) & 0xF0;
                switch (type) {
                    case 144: 
                    case 224: {
                        return 3;
                    }
                    case 192: 
                    case 208: {
                        return 2;
                    }
                    case 240: {
                        int commandType = byteBuf.getByte(byteBuf.readerIndex()) & 0xF;
                        switch (commandType) {
                            case 0: {
                                try {
                                    int curPos = 1;
                                    while (byteBuf.readableBytes() > curPos + 1 && byteBuf.getByte(byteBuf.readerIndex() + curPos) != -9) {
                                        ++curPos;
                                    }
                                    if (byteBuf.getByte(byteBuf.readerIndex() + curPos) == -9) {
                                        return curPos + 1;
                                    }
                                    return -1;
                                }
                                catch (Exception e) {
                                    throw new PlcRuntimeException("Invalid packet content", (Throwable)e);
                                }
                            }
                            case 4: 
                            case 5: 
                            case 9: {
                                return 3;
                            }
                            case 15: {
                                return 1;
                            }
                        }
                        throw new PlcRuntimeException("Invalid command type");
                    }
                }
                throw new PlcRuntimeException("Invalid packet type");
            }
            return -1;
        }
    }

    public static class CorruptPackageCleaner
    implements Consumer<ByteBuf> {
        @Override
        public void accept(ByteBuf byteBuf) {
            while (!this.isPotentialStart(byteBuf.getUnsignedByte(byteBuf.readerIndex()))) {
                byteBuf.readByte();
            }
        }

        private boolean isPotentialStart(short value) {
            switch (value & 0xF0) {
                case 144: 
                case 192: 
                case 208: 
                case 224: 
                case 240: {
                    return true;
                }
            }
            return false;
        }
    }
}

