/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.firmata.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessageAnalogIO;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessageCommand;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessageDigitalIO;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessageSubscribeAnalogPinValue;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessageSubscribeDigitalPinValue;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public abstract class FirmataMessage
implements Message {
    public abstract Byte getMessageType();

    protected abstract void serializeFirmataMessageChild(WriteBuffer var1) throws SerializationException;

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("FirmataMessage", new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField((String)"messageType", (Object)this.getMessageType(), (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)4), (WithWriterArgs[])new WithWriterArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        this.serializeFirmataMessageChild(writeBuffer);
        writeBuffer.popContext("FirmataMessage", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        FirmataMessage _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += 4;
    }

    public static FirmataMessage staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Boolean response;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Boolean) {
            response = (Boolean)args[0];
        } else if (args[0] instanceof String) {
            response = Boolean.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Boolean or a string which is parseable but was " + args[0].getClass().getName());
        }
        return FirmataMessage.staticParse(readBuffer, response);
    }

    public static FirmataMessage staticParse(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("FirmataMessage", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        byte messageType = (Byte)FieldReaderFactory.readDiscriminatorField((String)"messageType", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)4), (WithReaderArgs[])new WithReaderArgs[]{WithOption.WithByteOrder((ByteOrder)ByteOrder.BIG_ENDIAN)});
        FirmataMessageBuilder builder = null;
        if (EvaluationHelper.equals((Object)messageType, (Object)14)) {
            builder = FirmataMessageAnalogIO.staticParseFirmataMessageBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)messageType, (Object)9)) {
            builder = FirmataMessageDigitalIO.staticParseFirmataMessageBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)messageType, (Object)12)) {
            builder = FirmataMessageSubscribeAnalogPinValue.staticParseFirmataMessageBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)messageType, (Object)13)) {
            builder = FirmataMessageSubscribeDigitalPinValue.staticParseFirmataMessageBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals((Object)messageType, (Object)15)) {
            builder = FirmataMessageCommand.staticParseFirmataMessageBuilder(readBuffer, response);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [messageType=" + messageType + "]");
        }
        readBuffer.closeContext("FirmataMessage", new WithReaderArgs[0]);
        FirmataMessage _firmataMessage = builder.build();
        return _firmataMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FirmataMessage)) {
            return false;
        }
        FirmataMessage that = (FirmataMessage)o;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface FirmataMessageBuilder {
        public FirmataMessage build();
    }
}

