/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.firmata.readwrite.context;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.firmata.readwrite.FirmataCommandSetDigitalPinValue;
import org.apache.plc4x.java.firmata.readwrite.FirmataCommandSetPinMode;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessage;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessageCommand;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessageSubscribeAnalogPinValue;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessageSubscribeDigitalPinValue;
import org.apache.plc4x.java.firmata.readwrite.PinMode;
import org.apache.plc4x.java.firmata.readwrite.tag.FirmataTagAnalog;
import org.apache.plc4x.java.firmata.readwrite.tag.FirmataTagDigital;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionTag;
import org.apache.plc4x.java.spi.values.PlcList;

public class FirmataDriverContext
implements DriverContext {
    private final List<PlcSubscriptionRequest> subscriptions = new LinkedList<PlcSubscriptionRequest>();
    private final Map<Integer, PinMode> digitalPins = new HashMap<Integer, PinMode>();
    private final Map<Integer, PinMode> analogPins = new HashMap<Integer, PinMode>();

    public List<FirmataMessage> processWriteRequest(PlcWriteRequest writeRequest) {
        LinkedList<FirmataMessage> messages = new LinkedList<FirmataMessage>();
        for (String tagName : writeRequest.getTagNames()) {
            PlcList plcList;
            if (!(writeRequest.getTag(tagName) instanceof FirmataTagDigital)) {
                throw new PlcRuntimeException("Writing only supported for digital pins");
            }
            FirmataTagDigital digitalTag = (FirmataTagDigital)writeRequest.getTag(tagName);
            PlcValue plcValue = writeRequest.getPlcValue(tagName);
            if (digitalTag.getNumberOfElements() > 1 && plcValue.isList() && (plcList = (PlcList)plcValue).getList().size() != digitalTag.getNumberOfElements()) {
                throw new PlcRuntimeException("Required " + digitalTag.getNumberOfElements() + " but got " + plcList.getList().size());
            }
            int i = 0;
            while (i < digitalTag.getNumberOfElements()) {
                int pin = digitalTag.getAddress() + i;
                if (!this.digitalPins.containsKey(pin)) {
                    this.digitalPins.put(pin, PinMode.PinModeOutput);
                    messages.add(new FirmataMessageCommand(new FirmataCommandSetPinMode((byte)pin, PinMode.PinModeOutput)));
                } else if (!this.digitalPins.get(pin).equals((Object)PinMode.PinModeOutput)) {
                    throw new PlcRuntimeException("Pin " + pin + " already configured as " + this.digitalPins.get(pin).name());
                }
                messages.add(new FirmataMessageCommand(new FirmataCommandSetDigitalPinValue((short)pin, plcValue.getIndex(i).getBoolean())));
                ++i;
            }
        }
        return messages;
    }

    public List<FirmataMessage> processSubscriptionRequest(PlcSubscriptionRequest subscriptionRequest) {
        HashMap<Integer, PinMode> requestDigitalTagPinModes = new HashMap<Integer, PinMode>();
        HashMap<Integer, PinMode> requestAnalogTagPinModes = new HashMap<Integer, PinMode>();
        for (String string : subscriptionRequest.getTagNames()) {
            PlcSubscriptionTag tag = subscriptionRequest.getTag(string);
            DefaultPlcSubscriptionTag subscriptionTag = (DefaultPlcSubscriptionTag)tag;
            if (subscriptionTag.getTag() instanceof FirmataTagDigital) {
                PinMode tagPinMode;
                FirmataTagDigital tagDigital = (FirmataTagDigital)subscriptionTag.getTag();
                PinMode pinMode = tagPinMode = tagDigital.getPinMode() != null ? tagDigital.getPinMode() : PinMode.PinModeInput;
                if (!tagPinMode.equals((Object)PinMode.PinModeInput) && !tagPinMode.equals((Object)PinMode.PinModePullup)) {
                    throw new PlcInvalidTagException("Subscription tag must be of type 'INPUT' (default) or 'PULLUP'");
                }
                int pin = tagDigital.getAddress();
                while (pin < tagDigital.getAddress() + tagDigital.getNumberOfElements()) {
                    requestDigitalTagPinModes.put(pin, tagPinMode);
                    ++pin;
                }
                continue;
            }
            if (subscriptionTag.getTag() instanceof FirmataTagAnalog) {
                FirmataTagAnalog tagAnalog = (FirmataTagAnalog)subscriptionTag.getTag();
                int pin = tagAnalog.getAddress();
                while (pin < tagAnalog.getAddress() + tagAnalog.getNumberOfElements()) {
                    requestAnalogTagPinModes.put(pin, PinMode.PinModeInput);
                    ++pin;
                }
                continue;
            }
            throw new PlcRuntimeException("Unsupported tag type " + tag.getClass().getSimpleName());
        }
        for (Map.Entry entry : requestDigitalTagPinModes.entrySet()) {
            int pin = (Integer)entry.getKey();
            PinMode pinMode = (PinMode)((Object)entry.getValue());
            if (!this.digitalPins.containsKey(pin)) continue;
            if (!this.digitalPins.get(pin).equals((Object)pinMode)) {
                throw new PlcInvalidTagException(String.format("Error setting digital pin to mode %s, pin is already set to mode %s", pinMode.toString(), this.digitalPins.get(pin).toString()));
            }
            requestDigitalTagPinModes.remove(pin);
        }
        for (Map.Entry entry : requestAnalogTagPinModes.entrySet()) {
            int pin = (Integer)entry.getKey();
            if (!this.analogPins.containsKey(pin)) continue;
            requestAnalogTagPinModes.remove(pin);
        }
        this.subscriptions.add(subscriptionRequest);
        LinkedList<FirmataMessage> linkedList = new LinkedList<FirmataMessage>();
        for (Map.Entry entry : requestDigitalTagPinModes.entrySet()) {
            int pin = (Integer)entry.getKey();
            PinMode pinMode = (PinMode)((Object)entry.getValue());
            linkedList.add(new FirmataMessageCommand(new FirmataCommandSetPinMode((byte)pin, pinMode)));
            linkedList.add(new FirmataMessageSubscribeDigitalPinValue((byte)pin, true));
        }
        for (Map.Entry entry : requestAnalogTagPinModes.entrySet()) {
            int pin = (Integer)entry.getKey();
            linkedList.add(new FirmataMessageSubscribeAnalogPinValue((byte)pin, true));
        }
        return linkedList;
    }
}

