/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.firmata.readwrite.tag;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.firmata.readwrite.tag.FirmataTagAnalog;
import org.apache.plc4x.java.firmata.readwrite.tag.FirmataTagDigital;

public abstract class FirmataTag
implements PlcTag {
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("(?<address>\\d+)(\\[(?<quantity>\\d+)])?");
    private final int address;
    private final int quantity;

    public static FirmataTag of(String tagString) {
        Matcher matcher = FirmataTagAnalog.ADDRESS_PATTERN.matcher(tagString);
        if (matcher.matches()) {
            return FirmataTagAnalog.of(tagString);
        }
        matcher = FirmataTagDigital.ADDRESS_PATTERN.matcher(tagString);
        if (matcher.matches()) {
            return FirmataTagDigital.of(tagString);
        }
        throw new PlcInvalidTagException("Unable to parse address: " + tagString);
    }

    protected FirmataTag(int address, Integer quantity) {
        this.address = address;
        int n = this.quantity = quantity != null ? quantity : 1;
        if (this.quantity <= 0) {
            throw new IllegalArgumentException("quantity must be greater then zero. Was " + this.quantity);
        }
    }

    public int getAddress() {
        return this.address;
    }

    public int getNumberOfElements() {
        return this.quantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FirmataTag)) {
            return false;
        }
        FirmataTag that = (FirmataTag)o;
        return this.address == that.address;
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }

    public String toString() {
        return "FirmataTag{address=" + this.address + "quantity=" + this.quantity + '}';
    }
}

