/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class DeviceConfigurationAck extends KnxNetIpMessage implements Message {

  // Accessors for discriminator values.
  public Integer getMsgType() {
    return (int) 0x0311;
  }

  // Properties.
  protected final DeviceConfigurationAckDataBlock deviceConfigurationAckDataBlock;

  public DeviceConfigurationAck(DeviceConfigurationAckDataBlock deviceConfigurationAckDataBlock) {
    super();
    this.deviceConfigurationAckDataBlock = deviceConfigurationAckDataBlock;
  }

  public DeviceConfigurationAckDataBlock getDeviceConfigurationAckDataBlock() {
    return deviceConfigurationAckDataBlock;
  }

  @Override
  protected void serializeKnxNetIpMessageChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("DeviceConfigurationAck");

    // Simple Field (deviceConfigurationAckDataBlock)
    writeSimpleField(
        "deviceConfigurationAckDataBlock",
        deviceConfigurationAckDataBlock,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("DeviceConfigurationAck");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    DeviceConfigurationAck _value = this;

    // Simple field (deviceConfigurationAckDataBlock)
    lengthInBits += deviceConfigurationAckDataBlock.getLengthInBits();

    return lengthInBits;
  }

  public static DeviceConfigurationAckBuilder staticParseBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("DeviceConfigurationAck");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    DeviceConfigurationAckDataBlock deviceConfigurationAckDataBlock =
        readSimpleField(
            "deviceConfigurationAckDataBlock",
            new DataReaderComplexDefault<>(
                () -> DeviceConfigurationAckDataBlock.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("DeviceConfigurationAck");
    // Create the instance
    return new DeviceConfigurationAckBuilder(deviceConfigurationAckDataBlock);
  }

  public static class DeviceConfigurationAckBuilder
      implements KnxNetIpMessage.KnxNetIpMessageBuilder {
    private final DeviceConfigurationAckDataBlock deviceConfigurationAckDataBlock;

    public DeviceConfigurationAckBuilder(
        DeviceConfigurationAckDataBlock deviceConfigurationAckDataBlock) {

      this.deviceConfigurationAckDataBlock = deviceConfigurationAckDataBlock;
    }

    public DeviceConfigurationAck build() {
      DeviceConfigurationAck deviceConfigurationAck =
          new DeviceConfigurationAck(deviceConfigurationAckDataBlock);
      return deviceConfigurationAck;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DeviceConfigurationAck)) {
      return false;
    }
    DeviceConfigurationAck that = (DeviceConfigurationAck) o;
    return (getDeviceConfigurationAckDataBlock() == that.getDeviceConfigurationAckDataBlock())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getDeviceConfigurationAckDataBlock());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
