/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.math.BigInteger;
import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

// Code generated by code-generation. DO NOT EDIT.

public class KnxDatapoint {

  private static final Logger LOGGER = LoggerFactory.getLogger(KnxDatapoint.class);

  public static PlcValue staticParse(ReadBuffer readBuffer, KnxDatapointType datapointType)
      throws ParseException {
    if (EvaluationHelper.equals(datapointType, KnxDatapointType.BOOL)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.BYTE)) { // BYTE

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcBYTE(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.WORD)) { // WORD

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcWORD(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DWORD)) { // DWORD

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcDWORD(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LWORD)) { // LWORD

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      BigInteger value = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedBigInteger("", 64);

      return new PlcLWORD(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.USINT)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.SINT)) { // SINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Byte value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readSignedByte("", 8);

      return new PlcSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.UINT)) { // UINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.INT)) { // INT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readShort("", 16);

      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.UDINT)) { // UDINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DINT)) { // DINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readInt("", 32);

      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.ULINT)) { // ULINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      BigInteger value = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedBigInteger("", 64);

      return new PlcULINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LINT)) { // LINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readLong("", 64);

      return new PlcLINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.REAL)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LREAL)) { // LREAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Double value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readDouble("", 64);

      return new PlcLREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.CHAR)) { // CHAR

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      String value = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readString("", 8, "UTF-8");

      return new PlcCHAR(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.WCHAR)) { // WCHAR

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      String value = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readString("", 16, "UTF-16");

      return new PlcWCHAR(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.TIME)) { // TIME

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcTIME(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LTIME)) { // LTIME

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      BigInteger value = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedBigInteger("", 64);

      return new PlcLTIME(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DATE)) { // DATE

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcDATE(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.TIME_OF_DAY)) { // TIME_OF_DAY

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcTIME_OF_DAY(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.TOD)) { // TIME_OF_DAY

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcTIME_OF_DAY(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DATE_AND_TIME)) { // DATE_AND_TIME

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (year)
      Integer year = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      // Simple Field (month)
      Short month = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      // Simple Field (day)
      Short day = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      // Simple Field (dayOfWeek)
      Short dayOfWeek = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Simple Field (hour)
      Short hour = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      // Simple Field (minutes)
      Short minutes = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      // Simple Field (seconds)
      Short seconds = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      // Simple Field (nanos)
      Long nanos = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      LocalDateTime value =
          LocalDateTime.of(
              year.intValue(),
              (month == 0) ? 1 : month.intValue(),
              (day == 0) ? 1 : day.intValue(),
              hour.intValue(),
              minutes.intValue(),
              seconds.intValue(),
              nanos.intValue());
      return new PlcDATE_AND_TIME(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DT)) { // DATE_AND_TIME

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (year)
      Integer year = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      // Simple Field (month)
      Short month = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      // Simple Field (day)
      Short day = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      // Simple Field (dayOfWeek)
      Short dayOfWeek = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Simple Field (hour)
      Short hour = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      // Simple Field (minutes)
      Short minutes = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      // Simple Field (seconds)
      Short seconds = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      // Simple Field (nanos)
      Long nanos = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      LocalDateTime value =
          LocalDateTime.of(
              year.intValue(),
              (month == 0) ? 1 : month.intValue(),
              (day == 0) ? 1 : day.intValue(),
              hour.intValue(),
              minutes.intValue(),
              seconds.intValue(),
              nanos.intValue());
      return new PlcDATE_AND_TIME(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Switch)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Bool)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Enable)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Ramp)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Alarm)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BinaryValue)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Step)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_UpDown)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OpenClose)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Start)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_State)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Invert)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DimSendStyle)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_InputSource)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Reset)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Ack)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Trigger)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Occupancy)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Window_Door)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LogicalFunction)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Scene_AB)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ShutterBlinds_Mode)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DayNight)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Heat_Cool)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Switch_Control)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (control)
      Boolean control = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (on)
      Boolean on = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("on", new PlcBOOL(on));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Bool_Control)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (control)
      Boolean control = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (valueTrue)
      Boolean valueTrue = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("valueTrue", new PlcBOOL(valueTrue));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Enable_Control)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (control)
      Boolean control = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (enable)
      Boolean enable = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("enable", new PlcBOOL(enable));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Ramp_Control)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (control)
      Boolean control = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (ramp)
      Boolean ramp = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("ramp", new PlcBOOL(ramp));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Alarm_Control)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (control)
      Boolean control = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (alarm)
      Boolean alarm = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("alarm", new PlcBOOL(alarm));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_BinaryValue_Control)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (control)
      Boolean control = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (high)
      Boolean high = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("high", new PlcBOOL(high));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Step_Control)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (control)
      Boolean control = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (increase)
      Boolean increase = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("increase", new PlcBOOL(increase));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Direction1_Control)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (control)
      Boolean control = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (down)
      Boolean down = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("down", new PlcBOOL(down));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Direction2_Control)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (control)
      Boolean control = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (close)
      Boolean close = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("close", new PlcBOOL(close));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Start_Control)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (control)
      Boolean control = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (start)
      Boolean start = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("start", new PlcBOOL(start));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_State_Control)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (control)
      Boolean control = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (active)
      Boolean active = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("active", new PlcBOOL(active));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Invert_Control)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (control)
      Boolean control = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (inverted)
      Boolean inverted = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("control", new PlcBOOL(control));
      _map.put("inverted", new PlcBOOL(inverted));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Control_Dimming)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (increase)
      Boolean increase = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (stepcode)
      Byte stepcode = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 3);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("increase", new PlcBOOL(increase));
      _map.put("stepcode", new PlcSINT(stepcode));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Control_Blinds)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (down)
      Boolean down = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (stepcode)
      Byte stepcode = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 3);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("down", new PlcBOOL(down));
      _map.put("stepcode", new PlcSINT(stepcode));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Char_ASCII)) { // STRING

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      String value = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readString("", 8, "ASCII");

      return new PlcSTRING(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Char_8859_1)) { // STRING

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      String value = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readString("", 8, "ISO-8859-1");

      return new PlcSTRING(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Scaling)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Angle)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_U8)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DecimalFactor)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Tariff)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_1_Ucount)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FanStage)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_V8)) { // SINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Byte value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readSignedByte("", 8);

      return new PlcSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_1_Count)) { // SINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Byte value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readSignedByte("", 8);

      return new PlcSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Status_Mode3)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (statusA)
      Boolean statusA = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (statusB)
      Boolean statusB = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (statusC)
      Boolean statusC = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (statusD)
      Boolean statusD = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (statusE)
      Boolean statusE = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (mode)
      Byte mode = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 3);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("statusA", new PlcBOOL(statusA));
      _map.put("statusB", new PlcBOOL(statusB));
      _map.put("statusC", new PlcBOOL(statusC));
      _map.put("statusD", new PlcBOOL(statusD));
      _map.put("statusE", new PlcBOOL(statusE));
      _map.put("mode", new PlcSINT(mode));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_2_Ucount)) { // UINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriodMsec)) { // UINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriod10Msec)) { // UINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriod100Msec)) { // UINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodSec)) { // UINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodMin)) { // UINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodHrs)) { // UINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PropDataType)) { // UINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Length_mm)) { // UINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_UElCurrentmA)) { // UINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Brightness)) { // UINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Absolute_Colour_Temperature)) { // UINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      return new PlcUINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_2_Count)) { // INT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readShort("", 16);

      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeMsec)) { // INT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readShort("", 16);

      return new PlcINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaTime10Msec)) { // INT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readShort("", 16);

      return new PlcINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaTime100Msec)) { // INT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readShort("", 16);

      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeSec)) { // INT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readShort("", 16);

      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeMin)) { // INT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readShort("", 16);

      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeHrs)) { // INT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readShort("", 16);

      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_V16)) { // INT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readShort("", 16);

      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Rotation_Angle)) { // INT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readShort("", 16);

      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Length_m)) { // INT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readShort("", 16);

      return new PlcINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Temp)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Tempd)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Tempa)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Lux)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Wsp)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Pres)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Humidity)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AirQuality)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_AirFlow)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time1)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time2)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Volt)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Curr)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PowerDensity)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_KelvinPerPercent)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Power)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Volume_Flow)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Rain_Amount)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Temp_F)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Wsp_kmh)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Absolute_Humidity)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Concentration_ygm3)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimeOfDay)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (day)
      Byte day = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 3);

      // Simple Field (hour)
      Short hour = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 5);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 2);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (minutes)
      Short minutes = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 6);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 2);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (seconds)
      Short seconds = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 6);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("day", new PlcSINT(day));
      _map.put("hour", new PlcINT(hour));
      _map.put("minutes", new PlcINT(minutes));
      _map.put("seconds", new PlcINT(seconds));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Date)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 3);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (dayOfMonth)
      Short dayOfMonth = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 5);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (month)
      Byte month = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 4);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 1);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (year)
      Short year = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 7);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("dayOfMonth", new PlcINT(dayOfMonth));
      _map.put("month", new PlcSINT(month));
      _map.put("year", new PlcINT(year));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_4_Ucount)) { // UDINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Sec)) { // UDINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Min)) { // UDINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Hrs)) { // UDINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_VolumeLiquid_Litre)) { // UDINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Volume_m_3)) { // UDINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedLong("", 32);

      return new PlcUDINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_4_Count)) { // DINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readInt("", 32);

      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FlowRate_m3h)) { // DINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readInt("", 32);

      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ActiveEnergy)) { // DINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readInt("", 32);

      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy)) { // DINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readInt("", 32);

      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy)) { // DINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readInt("", 32);

      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_kWh)) { // DINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readInt("", 32);

      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy_kVAh)) { // DINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readInt("", 32);

      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy_kVARh)) { // DINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readInt("", 32);

      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_MWh)) { // DINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readInt("", 32);

      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongDeltaTimeSec)) { // DINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readInt("", 32);

      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaVolumeLiquid_Litre)) { // DINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readInt("", 32);

      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaVolume_m_3)) { // DINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Integer value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readInt("", 32);

      return new PlcDINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Acceleration)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Acceleration_Angular)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Activation_Energy)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Activity)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Mol)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Amplitude)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AngleRad)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AngleDeg)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Momentum)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Velocity)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Area)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Capacitance)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Charge_DensitySurface)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Charge_DensityVolume)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Compressibility)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Conductance)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electrical_Conductivity)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Density)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Charge)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Current)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_CurrentDensity)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_DipoleMoment)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Displacement)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_FieldStrength)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Flux)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_FluxDensity)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Polarization)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Potential)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_PotentialDifference)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_ElectromagneticMoment)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electromotive_Force)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Energy)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Force)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Frequency)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Frequency)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_Capacity)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_FlowRate)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_Quantity)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Impedance)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Length)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Light_Quantity)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminance)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminous_Flux)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminous_Intensity)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_FieldStrength)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Flux)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_FluxDensity)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Moment)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Polarization)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetization)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_MagnetomotiveForce)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Mass)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_MassFlux)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Momentum)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Phase_AngleRad)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Phase_AngleDeg)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Power)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Power_Factor)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Pressure)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Reactance)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Resistance)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Resistivity)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_SelfInductance)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_SolidAngle)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Sound_Intensity)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Speed)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Stress)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Surface_Tension)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Common_Temperature)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Absolute_Temperature)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_TemperatureDifference)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Thermal_Capacity)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Thermal_Conductivity)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_ThermoelectricPower)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Torque)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Volume)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Volume_Flux)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Weight)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Work)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Volume_Flux_Meter)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Volume_Flux_ls)) { // REAL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Float value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      return new PlcREAL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Access_Data)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (hurz)
      Byte hurz = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 4);

      // Simple Field (value1)
      Byte value1 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 4);

      // Simple Field (value2)
      Byte value2 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 4);

      // Simple Field (value3)
      Byte value3 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 4);

      // Simple Field (value4)
      Byte value4 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 4);

      // Simple Field (value5)
      Byte value5 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 4);

      // Simple Field (detectionError)
      Boolean detectionError = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (permission)
      Boolean permission = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (readDirection)
      Boolean readDirection = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (encryptionOfAccessInformation)
      Boolean encryptionOfAccessInformation = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (indexOfAccessIdentificationCode)
      Byte indexOfAccessIdentificationCode = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedByte("", 4);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("hurz", new PlcSINT(hurz));
      _map.put("value1", new PlcSINT(value1));
      _map.put("value2", new PlcSINT(value2));
      _map.put("value3", new PlcSINT(value3));
      _map.put("value4", new PlcSINT(value4));
      _map.put("value5", new PlcSINT(value5));
      _map.put("detectionError", new PlcBOOL(detectionError));
      _map.put("permission", new PlcBOOL(permission));
      _map.put("readDirection", new PlcBOOL(readDirection));
      _map.put("encryptionOfAccessInformation", new PlcBOOL(encryptionOfAccessInformation));
      _map.put("indexOfAccessIdentificationCode", new PlcSINT(indexOfAccessIdentificationCode));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_String_ASCII)) { // STRING

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      String value = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readString("", 112, "ASCII");

      return new PlcSTRING(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_String_8859_1)) { // STRING

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      String value = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readString("", 112, "ISO-8859-1");

      return new PlcSTRING(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SceneNumber)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 2);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 6);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SceneControl)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (learnTheSceneCorrespondingToTheFieldSceneNumber)
      Boolean
          learnTheSceneCorrespondingToTheFieldSceneNumber = /*TODO: migrate me*/ /*TODO: migrate me*/
              readBuffer.readBit("");

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 1);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (sceneNumber)
      Short sceneNumber = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 6);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put(
          "learnTheSceneCorrespondingToTheFieldSceneNumber",
          new PlcBOOL(learnTheSceneCorrespondingToTheFieldSceneNumber));
      _map.put("sceneNumber", new PlcINT(sceneNumber));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DateTime)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (year)
      Short year = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (month)
      Byte month = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 4);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 3);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (dayofmonth)
      Short dayofmonth = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 5);

      // Simple Field (dayofweek)
      Byte dayofweek = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 3);

      // Simple Field (hourofday)
      Short hourofday = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 5);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 2);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (minutes)
      Short minutes = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 6);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 2);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (seconds)
      Short seconds = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 6);

      // Simple Field (fault)
      Boolean fault = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (workingDay)
      Boolean workingDay = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (noWd)
      Boolean noWd = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (noYear)
      Boolean noYear = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (noDate)
      Boolean noDate = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (noDayOfWeek)
      Boolean noDayOfWeek = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (noTime)
      Boolean noTime = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (standardSummerTime)
      Boolean standardSummerTime = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (qualityOfClock)
      Boolean qualityOfClock = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("year", new PlcINT(year));
      _map.put("month", new PlcSINT(month));
      _map.put("dayofmonth", new PlcINT(dayofmonth));
      _map.put("dayofweek", new PlcSINT(dayofweek));
      _map.put("hourofday", new PlcINT(hourofday));
      _map.put("minutes", new PlcINT(minutes));
      _map.put("seconds", new PlcINT(seconds));
      _map.put("fault", new PlcBOOL(fault));
      _map.put("workingDay", new PlcBOOL(workingDay));
      _map.put("noWd", new PlcBOOL(noWd));
      _map.put("noYear", new PlcBOOL(noYear));
      _map.put("noDate", new PlcBOOL(noDate));
      _map.put("noDayOfWeek", new PlcBOOL(noDayOfWeek));
      _map.put("noTime", new PlcBOOL(noTime));
      _map.put("standardSummerTime", new PlcBOOL(standardSummerTime));
      _map.put("qualityOfClock", new PlcBOOL(qualityOfClock));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SCLOMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BuildingMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OccMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Priority)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LightApplicationMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApplicationArea)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_AlarmClassType)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PSUMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ErrorClass_System)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ErrorClass_HVAC)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Time_Delay)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Beaufort_Wind_Force_Scale)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SensorSelect)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActuatorConnectType)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Cloud_Cover)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_PowerReturnMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FuelType)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BurnerType)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HVACMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DHWMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_LoadPriority)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVACContrMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVACEmergMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ChangeoverMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ValveMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DamperMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HeaterMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FanMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_MasterSlaveMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_StatusRoomSetp)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Metering_DeviceType)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HumDehumMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_EnableHCStage)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ADAType)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BackupMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_StartSynchronization)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Behaviour_Lock_Unlock)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Behaviour_Bus_Power_Up_Down)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DALI_Fade_Time)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BlinkingMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LightControlMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SwitchPBModel)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PBAction)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DimmPBModel)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SwitchOnMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_LoadTypeSet)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LoadTypeDetected)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Converter_Test_Control)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SABExcept_Behaviour)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SABBehaviour_Lock_Unlock)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SSSBMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_BlindsControlMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_CommMode)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_AddInfoTypes)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_RF_ModeSelect)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_RF_FilterSelect)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Short value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusGen)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 3);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (alarmStatusOfCorrespondingDatapointIsNotAcknowledged)
      Boolean
          alarmStatusOfCorrespondingDatapointIsNotAcknowledged = /*TODO: migrate me*/ /*TODO: migrate me*/
              readBuffer.readBit("");

      // Simple Field (correspondingDatapointIsInAlarm)
      Boolean correspondingDatapointIsInAlarm = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (correspondingDatapointMainValueIsOverridden)
      Boolean
          correspondingDatapointMainValueIsOverridden = /*TODO: migrate me*/ /*TODO: migrate me*/
              readBuffer.readBit("");

      // Simple Field (correspondingDatapointMainValueIsCorruptedDueToFailure)
      Boolean
          correspondingDatapointMainValueIsCorruptedDueToFailure = /*TODO: migrate me*/ /*TODO: migrate me*/
              readBuffer.readBit("");

      // Simple Field (correspondingDatapointValueIsOutOfService)
      Boolean correspondingDatapointValueIsOutOfService = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put(
          "alarmStatusOfCorrespondingDatapointIsNotAcknowledged",
          new PlcBOOL(alarmStatusOfCorrespondingDatapointIsNotAcknowledged));
      _map.put("correspondingDatapointIsInAlarm", new PlcBOOL(correspondingDatapointIsInAlarm));
      _map.put(
          "correspondingDatapointMainValueIsOverridden",
          new PlcBOOL(correspondingDatapointMainValueIsOverridden));
      _map.put(
          "correspondingDatapointMainValueIsCorruptedDueToFailure",
          new PlcBOOL(correspondingDatapointMainValueIsCorruptedDueToFailure));
      _map.put(
          "correspondingDatapointValueIsOutOfService",
          new PlcBOOL(correspondingDatapointValueIsOutOfService));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Device_Control)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 5);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (verifyModeIsOn)
      Boolean verifyModeIsOn = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived)
      Boolean
          aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived = /*TODO: migrate me*/ /*TODO: migrate me*/
              readBuffer.readBit("");

      // Simple Field (theUserApplicationIsStopped)
      Boolean theUserApplicationIsStopped = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("verifyModeIsOn", new PlcBOOL(verifyModeIsOn));
      _map.put(
          "aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived",
          new PlcBOOL(aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived));
      _map.put("theUserApplicationIsStopped", new PlcBOOL(theUserApplicationIsStopped));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ForceSign)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (roomhmax)
      Boolean roomhmax = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (roomhconf)
      Boolean roomhconf = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (dhwlegio)
      Boolean dhwlegio = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (dhwnorm)
      Boolean dhwnorm = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (overrun)
      Boolean overrun = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (oversupply)
      Boolean oversupply = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (protection)
      Boolean protection = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (forcerequest)
      Boolean forcerequest = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("roomhmax", new PlcBOOL(roomhmax));
      _map.put("roomhconf", new PlcBOOL(roomhconf));
      _map.put("dhwlegio", new PlcBOOL(dhwlegio));
      _map.put("dhwnorm", new PlcBOOL(dhwnorm));
      _map.put("overrun", new PlcBOOL(overrun));
      _map.put("oversupply", new PlcBOOL(oversupply));
      _map.put("protection", new PlcBOOL(protection));
      _map.put("forcerequest", new PlcBOOL(forcerequest));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ForceSignCool)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusRHC)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (summermode)
      Boolean summermode = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (statusstopoptim)
      Boolean statusstopoptim = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (statusstartoptim)
      Boolean statusstartoptim = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (statusmorningboost)
      Boolean statusmorningboost = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (tempreturnlimit)
      Boolean tempreturnlimit = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (tempflowlimit)
      Boolean tempflowlimit = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (satuseco)
      Boolean satuseco = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (fault)
      Boolean fault = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("summermode", new PlcBOOL(summermode));
      _map.put("statusstopoptim", new PlcBOOL(statusstopoptim));
      _map.put("statusstartoptim", new PlcBOOL(statusstartoptim));
      _map.put("statusmorningboost", new PlcBOOL(statusmorningboost));
      _map.put("tempreturnlimit", new PlcBOOL(tempreturnlimit));
      _map.put("tempflowlimit", new PlcBOOL(tempflowlimit));
      _map.put("satuseco", new PlcBOOL(satuseco));
      _map.put("fault", new PlcBOOL(fault));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusSDHWC)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 5);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (solarloadsufficient)
      Boolean solarloadsufficient = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (sdhwloadactive)
      Boolean sdhwloadactive = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (fault)
      Boolean fault = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("solarloadsufficient", new PlcBOOL(solarloadsufficient));
      _map.put("sdhwloadactive", new PlcBOOL(sdhwloadactive));
      _map.put("fault", new PlcBOOL(fault));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FuelTypeSet)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 5);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (solidstate)
      Boolean solidstate = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (gas)
      Boolean gas = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (oil)
      Boolean oil = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("solidstate", new PlcBOOL(solidstate));
      _map.put("gas", new PlcBOOL(gas));
      _map.put("oil", new PlcBOOL(oil));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusRCC)) { // BOOL

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Boolean value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      return new PlcBOOL(value);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusAHU)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (cool)
      Boolean cool = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (heat)
      Boolean heat = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (fanactive)
      Boolean fanactive = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (fault)
      Boolean fault = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("cool", new PlcBOOL(cool));
      _map.put("heat", new PlcBOOL(heat));
      _map.put("fanactive", new PlcBOOL(fanactive));
      _map.put("fault", new PlcBOOL(fault));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedStatus_RTSM)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 3);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (statusOfHvacModeUser)
      Boolean statusOfHvacModeUser = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (statusOfComfortProlongationUser)
      Boolean statusOfComfortProlongationUser = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (effectiveValueOfTheComfortPushButton)
      Boolean effectiveValueOfTheComfortPushButton = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (effectiveValueOfThePresenceStatus)
      Boolean effectiveValueOfThePresenceStatus = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (effectiveValueOfTheWindowStatus)
      Boolean effectiveValueOfTheWindowStatus = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("statusOfHvacModeUser", new PlcBOOL(statusOfHvacModeUser));
      _map.put("statusOfComfortProlongationUser", new PlcBOOL(statusOfComfortProlongationUser));
      _map.put(
          "effectiveValueOfTheComfortPushButton",
          new PlcBOOL(effectiveValueOfTheComfortPushButton));
      _map.put("effectiveValueOfThePresenceStatus", new PlcBOOL(effectiveValueOfThePresenceStatus));
      _map.put("effectiveValueOfTheWindowStatus", new PlcBOOL(effectiveValueOfTheWindowStatus));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LightActuatorErrorInfo)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 1);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (overheat)
      Boolean overheat = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (lampfailure)
      Boolean lampfailure = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (defectiveload)
      Boolean defectiveload = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (underload)
      Boolean underload = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (overcurrent)
      Boolean overcurrent = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (undervoltage)
      Boolean undervoltage = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (loaddetectionerror)
      Boolean loaddetectionerror = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("overheat", new PlcBOOL(overheat));
      _map.put("lampfailure", new PlcBOOL(lampfailure));
      _map.put("defectiveload", new PlcBOOL(defectiveload));
      _map.put("underload", new PlcBOOL(underload));
      _map.put("overcurrent", new PlcBOOL(overcurrent));
      _map.put("undervoltage", new PlcBOOL(undervoltage));
      _map.put("loaddetectionerror", new PlcBOOL(loaddetectionerror));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_RF_ModeInfo)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 5);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (bibatSlave)
      Boolean bibatSlave = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (bibatMaster)
      Boolean bibatMaster = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (asynchronous)
      Boolean asynchronous = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("bibatSlave", new PlcBOOL(bibatSlave));
      _map.put("bibatMaster", new PlcBOOL(bibatMaster));
      _map.put("asynchronous", new PlcBOOL(asynchronous));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_RF_FilterInfo)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 5);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (doa)
      Boolean doa = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (knxSn)
      Boolean knxSn = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (doaAndKnxSn)
      Boolean doaAndKnxSn = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("doa", new PlcBOOL(doa));
      _map.put("knxSn", new PlcBOOL(knxSn));
      _map.put("doaAndKnxSn", new PlcBOOL(doaAndKnxSn));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Channel_Activation_8)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (activationStateOfChannel1)
      Boolean activationStateOfChannel1 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel2)
      Boolean activationStateOfChannel2 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel3)
      Boolean activationStateOfChannel3 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel4)
      Boolean activationStateOfChannel4 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel5)
      Boolean activationStateOfChannel5 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel6)
      Boolean activationStateOfChannel6 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel7)
      Boolean activationStateOfChannel7 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel8)
      Boolean activationStateOfChannel8 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("activationStateOfChannel1", new PlcBOOL(activationStateOfChannel1));
      _map.put("activationStateOfChannel2", new PlcBOOL(activationStateOfChannel2));
      _map.put("activationStateOfChannel3", new PlcBOOL(activationStateOfChannel3));
      _map.put("activationStateOfChannel4", new PlcBOOL(activationStateOfChannel4));
      _map.put("activationStateOfChannel5", new PlcBOOL(activationStateOfChannel5));
      _map.put("activationStateOfChannel6", new PlcBOOL(activationStateOfChannel6));
      _map.put("activationStateOfChannel7", new PlcBOOL(activationStateOfChannel7));
      _map.put("activationStateOfChannel8", new PlcBOOL(activationStateOfChannel8));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusDHWC)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (tempoptimshiftactive)
      Boolean tempoptimshiftactive = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (solarenergysupport)
      Boolean solarenergysupport = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (solarenergyonly)
      Boolean solarenergyonly = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (otherenergysourceactive)
      Boolean otherenergysourceactive = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (dhwpushactive)
      Boolean dhwpushactive = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (legioprotactive)
      Boolean legioprotactive = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (dhwloadactive)
      Boolean dhwloadactive = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (fault)
      Boolean fault = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("tempoptimshiftactive", new PlcBOOL(tempoptimshiftactive));
      _map.put("solarenergysupport", new PlcBOOL(solarenergysupport));
      _map.put("solarenergyonly", new PlcBOOL(solarenergyonly));
      _map.put("otherenergysourceactive", new PlcBOOL(otherenergysourceactive));
      _map.put("dhwpushactive", new PlcBOOL(dhwpushactive));
      _map.put("legioprotactive", new PlcBOOL(legioprotactive));
      _map.put("dhwloadactive", new PlcBOOL(dhwloadactive));
      _map.put("fault", new PlcBOOL(fault));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusRHCC)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 1);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (overheatalarm)
      Boolean overheatalarm = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (frostalarm)
      Boolean frostalarm = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (dewpointstatus)
      Boolean dewpointstatus = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (coolingdisabled)
      Boolean coolingdisabled = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (statusprecool)
      Boolean statusprecool = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (statusecoc)
      Boolean statusecoc = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (heatcoolmode)
      Boolean heatcoolmode = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (heatingdiabled)
      Boolean heatingdiabled = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (statusstopoptim)
      Boolean statusstopoptim = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (statusstartoptim)
      Boolean statusstartoptim = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (statusmorningboosth)
      Boolean statusmorningboosth = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (tempflowreturnlimit)
      Boolean tempflowreturnlimit = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (tempflowlimit)
      Boolean tempflowlimit = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (statusecoh)
      Boolean statusecoh = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (fault)
      Boolean fault = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("overheatalarm", new PlcBOOL(overheatalarm));
      _map.put("frostalarm", new PlcBOOL(frostalarm));
      _map.put("dewpointstatus", new PlcBOOL(dewpointstatus));
      _map.put("coolingdisabled", new PlcBOOL(coolingdisabled));
      _map.put("statusprecool", new PlcBOOL(statusprecool));
      _map.put("statusecoc", new PlcBOOL(statusecoc));
      _map.put("heatcoolmode", new PlcBOOL(heatcoolmode));
      _map.put("heatingdiabled", new PlcBOOL(heatingdiabled));
      _map.put("statusstopoptim", new PlcBOOL(statusstopoptim));
      _map.put("statusstartoptim", new PlcBOOL(statusstartoptim));
      _map.put("statusmorningboosth", new PlcBOOL(statusmorningboosth));
      _map.put("tempflowreturnlimit", new PlcBOOL(tempflowreturnlimit));
      _map.put("tempflowlimit", new PlcBOOL(tempflowlimit));
      _map.put("statusecoh", new PlcBOOL(statusecoh));
      _map.put("fault", new PlcBOOL(fault));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedStatus_HVA)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (calibrationMode)
      Boolean calibrationMode = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (lockedPosition)
      Boolean lockedPosition = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (forcedPosition)
      Boolean forcedPosition = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (manuaOperationOverridden)
      Boolean manuaOperationOverridden = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (serviceMode)
      Boolean serviceMode = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (valveKick)
      Boolean valveKick = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (overload)
      Boolean overload = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (shortCircuit)
      Boolean shortCircuit = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (currentValvePosition)
      Boolean currentValvePosition = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("calibrationMode", new PlcBOOL(calibrationMode));
      _map.put("lockedPosition", new PlcBOOL(lockedPosition));
      _map.put("forcedPosition", new PlcBOOL(forcedPosition));
      _map.put("manuaOperationOverridden", new PlcBOOL(manuaOperationOverridden));
      _map.put("serviceMode", new PlcBOOL(serviceMode));
      _map.put("valveKick", new PlcBOOL(valveKick));
      _map.put("overload", new PlcBOOL(overload));
      _map.put("shortCircuit", new PlcBOOL(shortCircuit));
      _map.put("currentValvePosition", new PlcBOOL(currentValvePosition));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedStatus_RTC)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 7);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (coolingModeEnabled)
      Boolean coolingModeEnabled = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (heatingModeEnabled)
      Boolean heatingModeEnabled = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (additionalHeatingCoolingStage2Stage)
      Boolean additionalHeatingCoolingStage2Stage = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (controllerInactive)
      Boolean controllerInactive = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (overheatAlarm)
      Boolean overheatAlarm = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (frostAlarm)
      Boolean frostAlarm = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (dewPointStatus)
      Boolean dewPointStatus = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (activeMode)
      Boolean activeMode = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (generalFailureInformation)
      Boolean generalFailureInformation = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("coolingModeEnabled", new PlcBOOL(coolingModeEnabled));
      _map.put("heatingModeEnabled", new PlcBOOL(heatingModeEnabled));
      _map.put(
          "additionalHeatingCoolingStage2Stage", new PlcBOOL(additionalHeatingCoolingStage2Stage));
      _map.put("controllerInactive", new PlcBOOL(controllerInactive));
      _map.put("overheatAlarm", new PlcBOOL(overheatAlarm));
      _map.put("frostAlarm", new PlcBOOL(frostAlarm));
      _map.put("dewPointStatus", new PlcBOOL(dewPointStatus));
      _map.put("activeMode", new PlcBOOL(activeMode));
      _map.put("generalFailureInformation", new PlcBOOL(generalFailureInformation));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Media)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        int reserved = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 10);
        if (reserved != (int) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (knxIp)
      Boolean knxIp = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (rf)
      Boolean rf = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 1);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (pl110)
      Boolean pl110 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (tp1)
      Boolean tp1 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 1);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("knxIp", new PlcBOOL(knxIp));
      _map.put("rf", new PlcBOOL(rf));
      _map.put("pl110", new PlcBOOL(pl110));
      _map.put("tp1", new PlcBOOL(tp1));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Channel_Activation_16)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (activationStateOfChannel1)
      Boolean activationStateOfChannel1 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel2)
      Boolean activationStateOfChannel2 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel3)
      Boolean activationStateOfChannel3 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel4)
      Boolean activationStateOfChannel4 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel5)
      Boolean activationStateOfChannel5 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel6)
      Boolean activationStateOfChannel6 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel7)
      Boolean activationStateOfChannel7 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel8)
      Boolean activationStateOfChannel8 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel9)
      Boolean activationStateOfChannel9 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel10)
      Boolean activationStateOfChannel10 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel11)
      Boolean activationStateOfChannel11 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel12)
      Boolean activationStateOfChannel12 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel13)
      Boolean activationStateOfChannel13 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel14)
      Boolean activationStateOfChannel14 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel15)
      Boolean activationStateOfChannel15 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel16)
      Boolean activationStateOfChannel16 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("activationStateOfChannel1", new PlcBOOL(activationStateOfChannel1));
      _map.put("activationStateOfChannel2", new PlcBOOL(activationStateOfChannel2));
      _map.put("activationStateOfChannel3", new PlcBOOL(activationStateOfChannel3));
      _map.put("activationStateOfChannel4", new PlcBOOL(activationStateOfChannel4));
      _map.put("activationStateOfChannel5", new PlcBOOL(activationStateOfChannel5));
      _map.put("activationStateOfChannel6", new PlcBOOL(activationStateOfChannel6));
      _map.put("activationStateOfChannel7", new PlcBOOL(activationStateOfChannel7));
      _map.put("activationStateOfChannel8", new PlcBOOL(activationStateOfChannel8));
      _map.put("activationStateOfChannel9", new PlcBOOL(activationStateOfChannel9));
      _map.put("activationStateOfChannel10", new PlcBOOL(activationStateOfChannel10));
      _map.put("activationStateOfChannel11", new PlcBOOL(activationStateOfChannel11));
      _map.put("activationStateOfChannel12", new PlcBOOL(activationStateOfChannel12));
      _map.put("activationStateOfChannel13", new PlcBOOL(activationStateOfChannel13));
      _map.put("activationStateOfChannel14", new PlcBOOL(activationStateOfChannel14));
      _map.put("activationStateOfChannel15", new PlcBOOL(activationStateOfChannel15));
      _map.put("activationStateOfChannel16", new PlcBOOL(activationStateOfChannel16));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OnOffAction)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Byte value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 2);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Alarm_Reaction)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Byte value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 2);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_UpDown_Action)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Byte value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 2);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVAC_PB_Action)) { // USINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Byte value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 2);

      return new PlcUSINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DoubleNibble)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (busy)
      Byte busy = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 4);

      // Simple Field (nak)
      Byte nak = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 4);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("busy", new PlcSINT(busy));
      _map.put("nak", new PlcSINT(nak));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SceneInfo)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 1);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (sceneIsInactive)
      Boolean sceneIsInactive = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (scenenumber)
      Short scenenumber = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 6);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("sceneIsInactive", new PlcBOOL(sceneIsInactive));
      _map.put("scenenumber", new PlcINT(scenenumber));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedInfoOnOff)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (maskBitInfoOnOffOutput16)
      Boolean maskBitInfoOnOffOutput16 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (maskBitInfoOnOffOutput15)
      Boolean maskBitInfoOnOffOutput15 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (maskBitInfoOnOffOutput14)
      Boolean maskBitInfoOnOffOutput14 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (maskBitInfoOnOffOutput13)
      Boolean maskBitInfoOnOffOutput13 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (maskBitInfoOnOffOutput12)
      Boolean maskBitInfoOnOffOutput12 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (maskBitInfoOnOffOutput11)
      Boolean maskBitInfoOnOffOutput11 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (maskBitInfoOnOffOutput10)
      Boolean maskBitInfoOnOffOutput10 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (maskBitInfoOnOffOutput9)
      Boolean maskBitInfoOnOffOutput9 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (maskBitInfoOnOffOutput8)
      Boolean maskBitInfoOnOffOutput8 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (maskBitInfoOnOffOutput7)
      Boolean maskBitInfoOnOffOutput7 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (maskBitInfoOnOffOutput6)
      Boolean maskBitInfoOnOffOutput6 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (maskBitInfoOnOffOutput5)
      Boolean maskBitInfoOnOffOutput5 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (maskBitInfoOnOffOutput4)
      Boolean maskBitInfoOnOffOutput4 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (maskBitInfoOnOffOutput3)
      Boolean maskBitInfoOnOffOutput3 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (maskBitInfoOnOffOutput2)
      Boolean maskBitInfoOnOffOutput2 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (maskBitInfoOnOffOutput1)
      Boolean maskBitInfoOnOffOutput1 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (infoOnOffOutput16)
      Boolean infoOnOffOutput16 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (infoOnOffOutput15)
      Boolean infoOnOffOutput15 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (infoOnOffOutput14)
      Boolean infoOnOffOutput14 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (infoOnOffOutput13)
      Boolean infoOnOffOutput13 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (infoOnOffOutput12)
      Boolean infoOnOffOutput12 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (infoOnOffOutput11)
      Boolean infoOnOffOutput11 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (infoOnOffOutput10)
      Boolean infoOnOffOutput10 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (infoOnOffOutput9)
      Boolean infoOnOffOutput9 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (infoOnOffOutput8)
      Boolean infoOnOffOutput8 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (infoOnOffOutput7)
      Boolean infoOnOffOutput7 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (infoOnOffOutput6)
      Boolean infoOnOffOutput6 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (infoOnOffOutput5)
      Boolean infoOnOffOutput5 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (infoOnOffOutput4)
      Boolean infoOnOffOutput4 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (infoOnOffOutput3)
      Boolean infoOnOffOutput3 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (infoOnOffOutput2)
      Boolean infoOnOffOutput2 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (infoOnOffOutput1)
      Boolean infoOnOffOutput1 = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("maskBitInfoOnOffOutput16", new PlcBOOL(maskBitInfoOnOffOutput16));
      _map.put("maskBitInfoOnOffOutput15", new PlcBOOL(maskBitInfoOnOffOutput15));
      _map.put("maskBitInfoOnOffOutput14", new PlcBOOL(maskBitInfoOnOffOutput14));
      _map.put("maskBitInfoOnOffOutput13", new PlcBOOL(maskBitInfoOnOffOutput13));
      _map.put("maskBitInfoOnOffOutput12", new PlcBOOL(maskBitInfoOnOffOutput12));
      _map.put("maskBitInfoOnOffOutput11", new PlcBOOL(maskBitInfoOnOffOutput11));
      _map.put("maskBitInfoOnOffOutput10", new PlcBOOL(maskBitInfoOnOffOutput10));
      _map.put("maskBitInfoOnOffOutput9", new PlcBOOL(maskBitInfoOnOffOutput9));
      _map.put("maskBitInfoOnOffOutput8", new PlcBOOL(maskBitInfoOnOffOutput8));
      _map.put("maskBitInfoOnOffOutput7", new PlcBOOL(maskBitInfoOnOffOutput7));
      _map.put("maskBitInfoOnOffOutput6", new PlcBOOL(maskBitInfoOnOffOutput6));
      _map.put("maskBitInfoOnOffOutput5", new PlcBOOL(maskBitInfoOnOffOutput5));
      _map.put("maskBitInfoOnOffOutput4", new PlcBOOL(maskBitInfoOnOffOutput4));
      _map.put("maskBitInfoOnOffOutput3", new PlcBOOL(maskBitInfoOnOffOutput3));
      _map.put("maskBitInfoOnOffOutput2", new PlcBOOL(maskBitInfoOnOffOutput2));
      _map.put("maskBitInfoOnOffOutput1", new PlcBOOL(maskBitInfoOnOffOutput1));
      _map.put("infoOnOffOutput16", new PlcBOOL(infoOnOffOutput16));
      _map.put("infoOnOffOutput15", new PlcBOOL(infoOnOffOutput15));
      _map.put("infoOnOffOutput14", new PlcBOOL(infoOnOffOutput14));
      _map.put("infoOnOffOutput13", new PlcBOOL(infoOnOffOutput13));
      _map.put("infoOnOffOutput12", new PlcBOOL(infoOnOffOutput12));
      _map.put("infoOnOffOutput11", new PlcBOOL(infoOnOffOutput11));
      _map.put("infoOnOffOutput10", new PlcBOOL(infoOnOffOutput10));
      _map.put("infoOnOffOutput9", new PlcBOOL(infoOnOffOutput9));
      _map.put("infoOnOffOutput8", new PlcBOOL(infoOnOffOutput8));
      _map.put("infoOnOffOutput7", new PlcBOOL(infoOnOffOutput7));
      _map.put("infoOnOffOutput6", new PlcBOOL(infoOnOffOutput6));
      _map.put("infoOnOffOutput5", new PlcBOOL(infoOnOffOutput5));
      _map.put("infoOnOffOutput4", new PlcBOOL(infoOnOffOutput4));
      _map.put("infoOnOffOutput3", new PlcBOOL(infoOnOffOutput3));
      _map.put("infoOnOffOutput2", new PlcBOOL(infoOnOffOutput2));
      _map.put("infoOnOffOutput1", new PlcBOOL(infoOnOffOutput1));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_V64)) { // LINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readLong("", 64);

      return new PlcLINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy_V64)) { // LINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readLong("", 64);

      return new PlcLINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy_V64)) { // LINT

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      Long value = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readLong("", 64);

      return new PlcLINT(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Channel_Activation_24)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (activationStateOfChannel1)
      Boolean activationStateOfChannel1 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel2)
      Boolean activationStateOfChannel2 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel3)
      Boolean activationStateOfChannel3 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel4)
      Boolean activationStateOfChannel4 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel5)
      Boolean activationStateOfChannel5 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel6)
      Boolean activationStateOfChannel6 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel7)
      Boolean activationStateOfChannel7 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel8)
      Boolean activationStateOfChannel8 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel9)
      Boolean activationStateOfChannel9 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel10)
      Boolean activationStateOfChannel10 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel11)
      Boolean activationStateOfChannel11 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel12)
      Boolean activationStateOfChannel12 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel13)
      Boolean activationStateOfChannel13 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel14)
      Boolean activationStateOfChannel14 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel15)
      Boolean activationStateOfChannel15 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel16)
      Boolean activationStateOfChannel16 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel17)
      Boolean activationStateOfChannel17 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel18)
      Boolean activationStateOfChannel18 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel19)
      Boolean activationStateOfChannel19 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel20)
      Boolean activationStateOfChannel20 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel21)
      Boolean activationStateOfChannel21 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel22)
      Boolean activationStateOfChannel22 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel23)
      Boolean activationStateOfChannel23 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (activationStateOfChannel24)
      Boolean activationStateOfChannel24 = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("activationStateOfChannel1", new PlcBOOL(activationStateOfChannel1));
      _map.put("activationStateOfChannel2", new PlcBOOL(activationStateOfChannel2));
      _map.put("activationStateOfChannel3", new PlcBOOL(activationStateOfChannel3));
      _map.put("activationStateOfChannel4", new PlcBOOL(activationStateOfChannel4));
      _map.put("activationStateOfChannel5", new PlcBOOL(activationStateOfChannel5));
      _map.put("activationStateOfChannel6", new PlcBOOL(activationStateOfChannel6));
      _map.put("activationStateOfChannel7", new PlcBOOL(activationStateOfChannel7));
      _map.put("activationStateOfChannel8", new PlcBOOL(activationStateOfChannel8));
      _map.put("activationStateOfChannel9", new PlcBOOL(activationStateOfChannel9));
      _map.put("activationStateOfChannel10", new PlcBOOL(activationStateOfChannel10));
      _map.put("activationStateOfChannel11", new PlcBOOL(activationStateOfChannel11));
      _map.put("activationStateOfChannel12", new PlcBOOL(activationStateOfChannel12));
      _map.put("activationStateOfChannel13", new PlcBOOL(activationStateOfChannel13));
      _map.put("activationStateOfChannel14", new PlcBOOL(activationStateOfChannel14));
      _map.put("activationStateOfChannel15", new PlcBOOL(activationStateOfChannel15));
      _map.put("activationStateOfChannel16", new PlcBOOL(activationStateOfChannel16));
      _map.put("activationStateOfChannel17", new PlcBOOL(activationStateOfChannel17));
      _map.put("activationStateOfChannel18", new PlcBOOL(activationStateOfChannel18));
      _map.put("activationStateOfChannel19", new PlcBOOL(activationStateOfChannel19));
      _map.put("activationStateOfChannel20", new PlcBOOL(activationStateOfChannel20));
      _map.put("activationStateOfChannel21", new PlcBOOL(activationStateOfChannel21));
      _map.put("activationStateOfChannel22", new PlcBOOL(activationStateOfChannel22));
      _map.put("activationStateOfChannel23", new PlcBOOL(activationStateOfChannel23));
      _map.put("activationStateOfChannel24", new PlcBOOL(activationStateOfChannel24));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVACModeNext)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (delayTimeMin)
      Integer delayTimeMin = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedInt("", 16);

      // Simple Field (hvacMode)
      Short hvacMode = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("delayTimeMin", new PlcDINT(delayTimeMin));
      _map.put("hvacMode", new PlcINT(hvacMode));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DHWModeNext)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (delayTimeMin)
      Integer delayTimeMin = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedInt("", 16);

      // Simple Field (dhwMode)
      Short dhwMode = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("delayTimeMin", new PlcDINT(delayTimeMin));
      _map.put("dhwMode", new PlcINT(dhwMode));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OccModeNext)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (delayTimeMin)
      Integer delayTimeMin = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedInt("", 16);

      // Simple Field (occupancyMode)
      Short occupancyMode = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("delayTimeMin", new PlcDINT(delayTimeMin));
      _map.put("occupancyMode", new PlcINT(occupancyMode));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_BuildingModeNext)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (delayTimeMin)
      Integer delayTimeMin = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedInt("", 16);

      // Simple Field (buildingMode)
      Short buildingMode = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("delayTimeMin", new PlcDINT(delayTimeMin));
      _map.put("buildingMode", new PlcINT(buildingMode));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_StatusLightingActuator)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (validactualvalue)
      Boolean validactualvalue = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (locked)
      Boolean locked = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (forced)
      Boolean forced = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (nightmodeactive)
      Boolean nightmodeactive = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (staircaselightingFunction)
      Boolean staircaselightingFunction = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (dimming)
      Boolean dimming = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (localoverride)
      Boolean localoverride = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (failure)
      Boolean failure = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (actualvalue)
      Short actualvalue = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("validactualvalue", new PlcBOOL(validactualvalue));
      _map.put("locked", new PlcBOOL(locked));
      _map.put("forced", new PlcBOOL(forced));
      _map.put("nightmodeactive", new PlcBOOL(nightmodeactive));
      _map.put("staircaselightingFunction", new PlcBOOL(staircaselightingFunction));
      _map.put("dimming", new PlcBOOL(dimming));
      _map.put("localoverride", new PlcBOOL(localoverride));
      _map.put("failure", new PlcBOOL(failure));
      _map.put("actualvalue", new PlcINT(actualvalue));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Version)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (magicNumber)
      Short magicNumber = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 5);

      // Simple Field (versionNumber)
      Short versionNumber = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 5);

      // Simple Field (revisionNumber)
      Short revisionNumber = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 6);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("magicNumber", new PlcINT(magicNumber));
      _map.put("versionNumber", new PlcINT(versionNumber));
      _map.put("revisionNumber", new PlcINT(revisionNumber));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_AlarmInfo)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (logNumber)
      Short logNumber = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Simple Field (alarmPriority)
      Short alarmPriority = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Simple Field (applicationArea)
      Short applicationArea = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Simple Field (errorClass)
      Short errorClass = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (errorcodeSup)
      Boolean errorcodeSup = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (alarmtextSup)
      Boolean alarmtextSup = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (timestampSup)
      Boolean timestampSup = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (ackSup)
      Boolean ackSup = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 5);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (locked)
      Boolean locked = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (alarmunack)
      Boolean alarmunack = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (inalarm)
      Boolean inalarm = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("logNumber", new PlcINT(logNumber));
      _map.put("alarmPriority", new PlcINT(alarmPriority));
      _map.put("applicationArea", new PlcINT(applicationArea));
      _map.put("errorClass", new PlcINT(errorClass));
      _map.put("errorcodeSup", new PlcBOOL(errorcodeSup));
      _map.put("alarmtextSup", new PlcBOOL(alarmtextSup));
      _map.put("timestampSup", new PlcBOOL(timestampSup));
      _map.put("ackSup", new PlcBOOL(ackSup));
      _map.put("locked", new PlcBOOL(locked));
      _map.put("alarmunack", new PlcBOOL(alarmunack));
      _map.put("inalarm", new PlcBOOL(inalarm));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetF16_3)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (tempsetpcomf)
      Float tempsetpcomf = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      // Simple Field (tempsetpstdby)
      Float tempsetpstdby = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      // Simple Field (tempsetpeco)
      Float tempsetpeco = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 16);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("tempsetpcomf", new PlcREAL(tempsetpcomf));
      _map.put("tempsetpstdby", new PlcREAL(tempsetpstdby));
      _map.put("tempsetpeco", new PlcREAL(tempsetpeco));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetShiftF16_3)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (tempsetpshiftcomf)
      Float tempsetpshiftcomf = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readFloat("", 16);

      // Simple Field (tempsetpshiftstdby)
      Float tempsetpshiftstdby = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readFloat("", 16);

      // Simple Field (tempsetpshifteco)
      Float tempsetpshifteco = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readFloat("", 16);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("tempsetpshiftcomf", new PlcREAL(tempsetpshiftcomf));
      _map.put("tempsetpshiftstdby", new PlcREAL(tempsetpshiftstdby));
      _map.put("tempsetpshifteco", new PlcREAL(tempsetpshifteco));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Scaling_Speed)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (timePeriod)
      Integer timePeriod = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedInt("", 16);

      // Simple Field (percent)
      Short percent = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("timePeriod", new PlcDINT(timePeriod));
      _map.put("percent", new PlcINT(percent));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Scaling_Step_Time)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (timePeriod)
      Integer timePeriod = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedInt("", 16);

      // Simple Field (percent)
      Short percent = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("timePeriod", new PlcDINT(timePeriod));
      _map.put("percent", new PlcINT(percent));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_MeteringValue)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (countval)
      Integer countval = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readInt("", 32);

      // Simple Field (valinffield)
      Short valinffield = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 3);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (alarmunack)
      Boolean alarmunack = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (inalarm)
      Boolean inalarm = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (overridden)
      Boolean overridden = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (fault)
      Boolean fault = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (outofservice)
      Boolean outofservice = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("countval", new PlcDINT(countval));
      _map.put("valinffield", new PlcINT(valinffield));
      _map.put("alarmunack", new PlcBOOL(alarmunack));
      _map.put("inalarm", new PlcBOOL(inalarm));
      _map.put("overridden", new PlcBOOL(overridden));
      _map.put("fault", new PlcBOOL(fault));
      _map.put("outofservice", new PlcBOOL(outofservice));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_MBus_Address)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (manufactid)
      Integer manufactid = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedInt("", 16);

      // Simple Field (identnumber)
      Long identnumber = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedLong("", 32);

      // Simple Field (version)
      Short version = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      // Simple Field (medium)
      Short medium = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("manufactid", new PlcDINT(manufactid));
      _map.put("identnumber", new PlcLINT(identnumber));
      _map.put("version", new PlcINT(version));
      _map.put("medium", new PlcINT(medium));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Colour_RGB)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (r)
      Short r = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      // Simple Field (g)
      Short g = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      // Simple Field (b)
      Short b = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("r", new PlcINT(r));
      _map.put("g", new PlcINT(g));
      _map.put("b", new PlcINT(b));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LanguageCodeAlpha2_ASCII)) { // STRING

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (value)
      String value = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readString("", 16, "ASCII");

      return new PlcSTRING(value);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Tariff_ActiveEnergy)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (activeelectricalenergy)
      Integer activeelectricalenergy = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readInt("", 32);

      // Simple Field (tariff)
      Short tariff = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (electricalengergyvalidity)
      Boolean electricalengergyvalidity = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (tariffvalidity)
      Boolean tariffvalidity = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("activeelectricalenergy", new PlcDINT(activeelectricalenergy));
      _map.put("tariff", new PlcINT(tariff));
      _map.put("electricalengergyvalidity", new PlcBOOL(electricalengergyvalidity));
      _map.put("tariffvalidity", new PlcBOOL(tariffvalidity));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Prioritised_Mode_Control)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (deactivationOfPriority)
      Boolean deactivationOfPriority = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (priorityLevel)
      Byte priorityLevel = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedByte("", 3);

      // Simple Field (modeLevel)
      Byte modeLevel = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 4);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("deactivationOfPriority", new PlcBOOL(deactivationOfPriority));
      _map.put("priorityLevel", new PlcSINT(priorityLevel));
      _map.put("modeLevel", new PlcSINT(modeLevel));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DALI_Control_Gear_Diagnostic)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 5);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (convertorError)
      Boolean convertorError = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (ballastFailure)
      Boolean ballastFailure = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (lampFailure)
      Boolean lampFailure = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (readOrResponse)
      Boolean readOrResponse = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (addressIndicator)
      Boolean addressIndicator = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (daliDeviceAddressOrDaliGroupAddress)
      Short daliDeviceAddressOrDaliGroupAddress = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 6);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("convertorError", new PlcBOOL(convertorError));
      _map.put("ballastFailure", new PlcBOOL(ballastFailure));
      _map.put("lampFailure", new PlcBOOL(lampFailure));
      _map.put("readOrResponse", new PlcBOOL(readOrResponse));
      _map.put("addressIndicator", new PlcBOOL(addressIndicator));
      _map.put(
          "daliDeviceAddressOrDaliGroupAddress", new PlcINT(daliDeviceAddressOrDaliGroupAddress));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DALI_Diagnostics)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (ballastFailure)
      Boolean ballastFailure = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (lampFailure)
      Boolean lampFailure = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (deviceAddress)
      Short deviceAddress = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 6);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("ballastFailure", new PlcBOOL(ballastFailure));
      _map.put("lampFailure", new PlcBOOL(lampFailure));
      _map.put("deviceAddress", new PlcINT(deviceAddress));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedPosition)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (heightPosition)
      Short heightPosition = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Simple Field (slatsPosition)
      Short slatsPosition = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (validityHeightPosition)
      Boolean validityHeightPosition = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (validitySlatsPosition)
      Boolean validitySlatsPosition = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("heightPosition", new PlcINT(heightPosition));
      _map.put("slatsPosition", new PlcINT(slatsPosition));
      _map.put("validityHeightPosition", new PlcBOOL(validityHeightPosition));
      _map.put("validitySlatsPosition", new PlcBOOL(validitySlatsPosition));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusSAB)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (heightPosition)
      Short heightPosition = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Simple Field (slatsPosition)
      Short slatsPosition = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Simple Field (upperEndPosReached)
      Boolean upperEndPosReached = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (lowerEndPosReached)
      Boolean lowerEndPosReached = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent)
      Boolean
          lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent = /*TODO: migrate me*/ /*TODO: migrate me*/
              readBuffer.readBit("");

      // Simple Field (targetPosDrive)
      Boolean targetPosDrive = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (restrictionOfTargetHeightPosPosCanNotBeReached)
      Boolean
          restrictionOfTargetHeightPosPosCanNotBeReached = /*TODO: migrate me*/ /*TODO: migrate me*/
              readBuffer.readBit("");

      // Simple Field (restrictionOfSlatsHeightPosPosCanNotBeReached)
      Boolean
          restrictionOfSlatsHeightPosPosCanNotBeReached = /*TODO: migrate me*/ /*TODO: migrate me*/
              readBuffer.readBit("");

      // Simple Field (atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm)
      Boolean
          atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm = /*TODO: migrate me*/ /*TODO: migrate me*/
              readBuffer.readBit("");

      // Simple Field (upDownPositionIsForcedByMoveupdownforcedInput)
      Boolean
          upDownPositionIsForcedByMoveupdownforcedInput = /*TODO: migrate me*/ /*TODO: migrate me*/
              readBuffer.readBit("");

      // Simple Field (movementIsLockedEGByDevicelockedInput)
      Boolean movementIsLockedEGByDevicelockedInput = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface)
      Boolean
          actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface = /*TODO: migrate me*/ /*TODO: migrate me*/
              readBuffer.readBit("");

      // Simple Field (generalFailureOfTheActuatorOrTheDrive)
      Boolean generalFailureOfTheActuatorOrTheDrive = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 3);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (validityHeightPos)
      Boolean validityHeightPos = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (validitySlatsPos)
      Boolean validitySlatsPos = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("heightPosition", new PlcINT(heightPosition));
      _map.put("slatsPosition", new PlcINT(slatsPosition));
      _map.put("upperEndPosReached", new PlcBOOL(upperEndPosReached));
      _map.put("lowerEndPosReached", new PlcBOOL(lowerEndPosReached));
      _map.put(
          "lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent",
          new PlcBOOL(lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent));
      _map.put("targetPosDrive", new PlcBOOL(targetPosDrive));
      _map.put(
          "restrictionOfTargetHeightPosPosCanNotBeReached",
          new PlcBOOL(restrictionOfTargetHeightPosPosCanNotBeReached));
      _map.put(
          "restrictionOfSlatsHeightPosPosCanNotBeReached",
          new PlcBOOL(restrictionOfSlatsHeightPosPosCanNotBeReached));
      _map.put(
          "atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm",
          new PlcBOOL(atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm));
      _map.put(
          "upDownPositionIsForcedByMoveupdownforcedInput",
          new PlcBOOL(upDownPositionIsForcedByMoveupdownforcedInput));
      _map.put(
          "movementIsLockedEGByDevicelockedInput",
          new PlcBOOL(movementIsLockedEGByDevicelockedInput));
      _map.put(
          "actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface",
          new PlcBOOL(actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface));
      _map.put(
          "generalFailureOfTheActuatorOrTheDrive",
          new PlcBOOL(generalFailureOfTheActuatorOrTheDrive));
      _map.put("validityHeightPos", new PlcBOOL(validityHeightPos));
      _map.put("validitySlatsPos", new PlcBOOL(validitySlatsPos));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Colour_xyY)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (xAxis)
      Integer xAxis = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      // Simple Field (yAxis)
      Integer yAxis = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      // Simple Field (brightness)
      Short brightness = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (validityXy)
      Boolean validityXy = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (validityBrightness)
      Boolean validityBrightness = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("xAxis", new PlcDINT(xAxis));
      _map.put("yAxis", new PlcDINT(yAxis));
      _map.put("brightness", new PlcINT(brightness));
      _map.put("validityXy", new PlcBOOL(validityXy));
      _map.put("validityBrightness", new PlcBOOL(validityBrightness));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Converter_Status)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (converterModeAccordingToTheDaliConverterStateMachine)
      Byte
          converterModeAccordingToTheDaliConverterStateMachine = /*TODO: migrate me*/ /*TODO: migrate me*/
              readBuffer.readUnsignedByte("", 4);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 2);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (hardwiredSwitchIsActive)
      Boolean hardwiredSwitchIsActive = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (hardwiredInhibitIsActive)
      Boolean hardwiredInhibitIsActive = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (functionTestPending)
      Byte functionTestPending = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedByte("", 2);

      // Simple Field (durationTestPending)
      Byte durationTestPending = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedByte("", 2);

      // Simple Field (partialDurationTestPending)
      Byte partialDurationTestPending = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedByte("", 2);

      // Simple Field (converterFailure)
      Byte converterFailure = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedByte("", 2);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put(
          "converterModeAccordingToTheDaliConverterStateMachine",
          new PlcSINT(converterModeAccordingToTheDaliConverterStateMachine));
      _map.put("hardwiredSwitchIsActive", new PlcBOOL(hardwiredSwitchIsActive));
      _map.put("hardwiredInhibitIsActive", new PlcBOOL(hardwiredInhibitIsActive));
      _map.put("functionTestPending", new PlcSINT(functionTestPending));
      _map.put("durationTestPending", new PlcSINT(durationTestPending));
      _map.put("partialDurationTestPending", new PlcSINT(partialDurationTestPending));
      _map.put("converterFailure", new PlcSINT(converterFailure));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Converter_Test_Result)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (ltrf)
      Byte ltrf = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 4);

      // Simple Field (ltrd)
      Byte ltrd = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 4);

      // Simple Field (ltrp)
      Byte ltrp = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 4);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (sf)
      Byte sf = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 2);

      // Simple Field (sd)
      Byte sd = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 2);

      // Simple Field (sp)
      Byte sp = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedByte("", 2);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 2);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (ldtr)
      Integer ldtr = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      // Simple Field (lpdtr)
      Short lpdtr = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("ltrf", new PlcSINT(ltrf));
      _map.put("ltrd", new PlcSINT(ltrd));
      _map.put("ltrp", new PlcSINT(ltrp));
      _map.put("sf", new PlcSINT(sf));
      _map.put("sd", new PlcSINT(sd));
      _map.put("sp", new PlcSINT(sp));
      _map.put("ldtr", new PlcDINT(ldtr));
      _map.put("lpdtr", new PlcINT(lpdtr));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Battery_Info)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 5);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (batteryFailure)
      Boolean batteryFailure = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (batteryDurationFailure)
      Boolean batteryDurationFailure = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (batteryFullyCharged)
      Boolean batteryFullyCharged = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (batteryChargeLevel)
      Short batteryChargeLevel = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("batteryFailure", new PlcBOOL(batteryFailure));
      _map.put("batteryDurationFailure", new PlcBOOL(batteryDurationFailure));
      _map.put("batteryFullyCharged", new PlcBOOL(batteryFullyCharged));
      _map.put("batteryChargeLevel", new PlcINT(batteryChargeLevel));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Brightness_Colour_Temperature_Transition)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (ms)
      Integer ms = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedInt("", 16);

      // Simple Field (temperatureK)
      Integer temperatureK = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedInt("", 16);

      // Simple Field (percent)
      Short percent = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readUnsignedShort("", 8);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 5);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (validityOfTheTimePeriod)
      Boolean validityOfTheTimePeriod = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (validityOfTheAbsoluteColourTemperature)
      Boolean validityOfTheAbsoluteColourTemperature = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (validityOfTheAbsoluteBrightness)
      Boolean validityOfTheAbsoluteBrightness = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("ms", new PlcDINT(ms));
      _map.put("temperatureK", new PlcDINT(temperatureK));
      _map.put("percent", new PlcINT(percent));
      _map.put("validityOfTheTimePeriod", new PlcBOOL(validityOfTheTimePeriod));
      _map.put(
          "validityOfTheAbsoluteColourTemperature",
          new PlcBOOL(validityOfTheAbsoluteColourTemperature));
      _map.put("validityOfTheAbsoluteBrightness", new PlcBOOL(validityOfTheAbsoluteBrightness));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Brightness_Colour_Temperature_Control)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (cct)
      Boolean cct = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (stepCodeColourTemperature)
      Byte stepCodeColourTemperature = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedByte("", 3);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (cb)
      Boolean cb = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (stepCodeBrightness)
      Byte stepCodeBrightness = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedByte("", 3);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 6);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (cctAndStepCodeColourValidity)
      Boolean cctAndStepCodeColourValidity = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      // Simple Field (cbAndStepCodeBrightnessValidity)
      Boolean cbAndStepCodeBrightnessValidity = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("cct", new PlcBOOL(cct));
      _map.put("stepCodeColourTemperature", new PlcSINT(stepCodeColourTemperature));
      _map.put("cb", new PlcBOOL(cb));
      _map.put("stepCodeBrightness", new PlcSINT(stepCodeBrightness));
      _map.put("cctAndStepCodeColourValidity", new PlcBOOL(cctAndStepCodeColourValidity));
      _map.put("cbAndStepCodeBrightnessValidity", new PlcBOOL(cbAndStepCodeBrightnessValidity));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Colour_RGBW)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (colourLevelRed)
      Short colourLevelRed = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Simple Field (colourLevelGreen)
      Short colourLevelGreen = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Simple Field (colourLevelBlue)
      Short colourLevelBlue = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Simple Field (colourLevelWhite)
      Short colourLevelWhite = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedShort("", 8);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (mr)
      Boolean mr = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (mg)
      Boolean mg = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (mb)
      Boolean mb = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (mw)
      Boolean mw = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("colourLevelRed", new PlcINT(colourLevelRed));
      _map.put("colourLevelGreen", new PlcINT(colourLevelGreen));
      _map.put("colourLevelBlue", new PlcINT(colourLevelBlue));
      _map.put("colourLevelWhite", new PlcINT(colourLevelWhite));
      _map.put("mr", new PlcBOOL(mr));
      _map.put("mg", new PlcBOOL(mg));
      _map.put("mb", new PlcBOOL(mb));
      _map.put("mw", new PlcBOOL(mw));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Relative_Control_RGBW)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (maskcw)
      Boolean maskcw = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (maskcb)
      Boolean maskcb = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (maskcg)
      Boolean maskcg = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (maskcr)
      Boolean maskcr = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (cw)
      Boolean cw = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (stepCodeColourWhite)
      Byte stepCodeColourWhite = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedByte("", 3);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (cb)
      Boolean cb = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (stepCodeColourBlue)
      Byte stepCodeColourBlue = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedByte("", 3);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (cg)
      Boolean cg = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (stepCodeColourGreen)
      Byte stepCodeColourGreen = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedByte("", 3);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (cr)
      Boolean cr = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (stepCodeColourRed)
      Byte stepCodeColourRed = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedByte("", 3);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("maskcw", new PlcBOOL(maskcw));
      _map.put("maskcb", new PlcBOOL(maskcb));
      _map.put("maskcg", new PlcBOOL(maskcg));
      _map.put("maskcr", new PlcBOOL(maskcr));
      _map.put("cw", new PlcBOOL(cw));
      _map.put("stepCodeColourWhite", new PlcSINT(stepCodeColourWhite));
      _map.put("cb", new PlcBOOL(cb));
      _map.put("stepCodeColourBlue", new PlcSINT(stepCodeColourBlue));
      _map.put("cg", new PlcBOOL(cg));
      _map.put("stepCodeColourGreen", new PlcSINT(stepCodeColourGreen));
      _map.put("cr", new PlcBOOL(cr));
      _map.put("stepCodeColourRed", new PlcSINT(stepCodeColourRed));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Relative_Control_RGB)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (cb)
      Boolean cb = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (stepCodeColourBlue)
      Byte stepCodeColourBlue = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedByte("", 3);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (cg)
      Boolean cg = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (stepCodeColourGreen)
      Byte stepCodeColourGreen = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedByte("", 3);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (cr)
      Boolean cr = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readBit("");

      // Simple Field (stepCodeColourRed)
      Byte stepCodeColourRed = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readUnsignedByte("", 3);

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        byte reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedByte("", 4);
        if (reserved != (byte) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("cb", new PlcBOOL(cb));
      _map.put("stepCodeColourBlue", new PlcSINT(stepCodeColourBlue));
      _map.put("cg", new PlcBOOL(cg));
      _map.put("stepCodeColourGreen", new PlcSINT(stepCodeColourGreen));
      _map.put("cr", new PlcBOOL(cr));
      _map.put("stepCodeColourRed", new PlcSINT(stepCodeColourRed));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_GeographicalLocation)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (longitude)
      Float longitude = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      // Simple Field (latitude)
      Float latitude = /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.readFloat("", 32);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("longitude", new PlcREAL(longitude));
      _map.put("latitude", new PlcREAL(latitude));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetF16_4)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (roomTemperatureSetpointComfort)
      Float roomTemperatureSetpointComfort = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readFloat("", 16);

      // Simple Field (roomTemperatureSetpointStandby)
      Float roomTemperatureSetpointStandby = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readFloat("", 16);

      // Simple Field (roomTemperatureSetpointEconomy)
      Float roomTemperatureSetpointEconomy = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readFloat("", 16);

      // Simple Field (roomTemperatureSetpointBuildingProtection)
      Float roomTemperatureSetpointBuildingProtection = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readFloat("", 16);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put("roomTemperatureSetpointComfort", new PlcREAL(roomTemperatureSetpointComfort));
      _map.put("roomTemperatureSetpointStandby", new PlcREAL(roomTemperatureSetpointStandby));
      _map.put("roomTemperatureSetpointEconomy", new PlcREAL(roomTemperatureSetpointEconomy));
      _map.put(
          "roomTemperatureSetpointBuildingProtection",
          new PlcREAL(roomTemperatureSetpointBuildingProtection));

      return new PlcStruct(_map);
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetShiftF16_4)) { // Struct

      // Reserved Field (Compartmentalized so the "reserved" variable can't leak)
      {
        short reserved = /*TODO: migrate me*/ /*TODO: migrate me*/
            readBuffer.readUnsignedShort("", 8);
        if (reserved != (short) 0x00) {
          LOGGER.info(
              "Expected constant value " + 0x00 + " but got " + reserved + " for reserved field.");
        }
      }

      // Simple Field (roomTemperatureSetpointShiftComfort)
      Float roomTemperatureSetpointShiftComfort = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readFloat("", 16);

      // Simple Field (roomTemperatureSetpointShiftStandby)
      Float roomTemperatureSetpointShiftStandby = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readFloat("", 16);

      // Simple Field (roomTemperatureSetpointShiftEconomy)
      Float roomTemperatureSetpointShiftEconomy = /*TODO: migrate me*/ /*TODO: migrate me*/
          readBuffer.readFloat("", 16);

      // Simple Field (roomTemperatureSetpointShiftBuildingProtection)
      Float
          roomTemperatureSetpointShiftBuildingProtection = /*TODO: migrate me*/ /*TODO: migrate me*/
              readBuffer.readFloat("", 16);

      Map<String, PlcValue> _map = new HashMap<>();
      _map.put(
          "roomTemperatureSetpointShiftComfort", new PlcREAL(roomTemperatureSetpointShiftComfort));
      _map.put(
          "roomTemperatureSetpointShiftStandby", new PlcREAL(roomTemperatureSetpointShiftStandby));
      _map.put(
          "roomTemperatureSetpointShiftEconomy", new PlcREAL(roomTemperatureSetpointShiftEconomy));
      _map.put(
          "roomTemperatureSetpointShiftBuildingProtection",
          new PlcREAL(roomTemperatureSetpointShiftBuildingProtection));

      return new PlcStruct(_map);
    }
    return null;
  }

  public static void staticSerialize(
      WriteBuffer writeBuffer, PlcValue _value, KnxDatapointType datapointType)
      throws SerializationException {
    staticSerialize(writeBuffer, _value, datapointType, ByteOrder.BIG_ENDIAN);
  }

  public static void staticSerialize(
      WriteBuffer writeBuffer, PlcValue _value, KnxDatapointType datapointType, ByteOrder byteOrder)
      throws SerializationException {
    if (EvaluationHelper.equals(datapointType, KnxDatapointType.BOOL)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.BYTE)) { // BYTE
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.WORD)) { // WORD
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DWORD)) { // DWORD
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LWORD)) { // LWORD
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      BigInteger value = (BigInteger) _value.getBigInteger();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedBigInteger("", 64, (BigInteger) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.USINT)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.SINT)) { // SINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      byte value = (byte) _value.getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeSignedByte("", 8, ((Number) (value)).byteValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.UINT)) { // UINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.INT)) { // INT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeShort("", 16, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.UDINT)) { // UDINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DINT)) { // DINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeInt("", 32, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.ULINT)) { // ULINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      BigInteger value = (BigInteger) _value.getBigInteger();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedBigInteger("", 64, (BigInteger) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LINT)) { // LINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeLong("", 64, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.REAL)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LREAL)) { // LREAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      double value = (double) _value.getDouble();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeDouble("", 64, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.CHAR)) { // CHAR
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      String value = (String) _value.getString();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeString("", 8, "UTF-8", (String) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.WCHAR)) { // WCHAR
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      String value = (String) _value.getString();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeString("", 16, "UTF-16", (String) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.TIME)) { // TIME
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LTIME)) { // LTIME
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      BigInteger value = (BigInteger) _value.getBigInteger();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedBigInteger("", 64, (BigInteger) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DATE)) { // DATE
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.TIME_OF_DAY)) { // TIME_OF_DAY
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.TOD)) { // TIME_OF_DAY
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DATE_AND_TIME)) { // DATE_AND_TIME
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (year)
      int year = 0;
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (year)).intValue());
      // Simple Field (month)
      short month = 0;
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (month)).shortValue());
      // Simple Field (day)
      short day = 0;
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (day)).shortValue());
      // Simple Field (dayOfWeek)
      short dayOfWeek = 0;
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (dayOfWeek)).shortValue());
      // Simple Field (hour)
      short hour = 0;
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (hour)).shortValue());
      // Simple Field (minutes)
      short minutes = 0;
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (minutes)).shortValue());
      // Simple Field (seconds)
      short seconds = 0;
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (seconds)).shortValue());
      // Simple Field (nanos)
      long nanos = 0l;
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (nanos)).longValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DT)) { // DATE_AND_TIME
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (year)
      int year = 0;
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (year)).intValue());
      // Simple Field (month)
      short month = 0;
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (month)).shortValue());
      // Simple Field (day)
      short day = 0;
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (day)).shortValue());
      // Simple Field (dayOfWeek)
      short dayOfWeek = 0;
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (dayOfWeek)).shortValue());
      // Simple Field (hour)
      short hour = 0;
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (hour)).shortValue());
      // Simple Field (minutes)
      short minutes = 0;
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (minutes)).shortValue());
      // Simple Field (seconds)
      short seconds = 0;
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (seconds)).shortValue());
      // Simple Field (nanos)
      long nanos = 0l;
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (nanos)).longValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Switch)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Bool)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Enable)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Ramp)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Alarm)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BinaryValue)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Step)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_UpDown)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OpenClose)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Start)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_State)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Invert)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DimSendStyle)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_InputSource)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Reset)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Ack)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Trigger)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Occupancy)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Window_Door)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LogicalFunction)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Scene_AB)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ShutterBlinds_Mode)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DayNight)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Heat_Cool)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Switch_Control)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (control)
      boolean control = (boolean) _value.getStruct().get("control").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (control));
      // Simple Field (on)
      boolean on = (boolean) _value.getStruct().get("on").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (on));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Bool_Control)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (control)
      boolean control = (boolean) _value.getStruct().get("control").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (control));
      // Simple Field (valueTrue)
      boolean valueTrue = (boolean) _value.getStruct().get("valueTrue").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (valueTrue));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Enable_Control)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (control)
      boolean control = (boolean) _value.getStruct().get("control").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (control));
      // Simple Field (enable)
      boolean enable = (boolean) _value.getStruct().get("enable").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (enable));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Ramp_Control)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (control)
      boolean control = (boolean) _value.getStruct().get("control").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (control));
      // Simple Field (ramp)
      boolean ramp = (boolean) _value.getStruct().get("ramp").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (ramp));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Alarm_Control)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (control)
      boolean control = (boolean) _value.getStruct().get("control").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (control));
      // Simple Field (alarm)
      boolean alarm = (boolean) _value.getStruct().get("alarm").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (alarm));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_BinaryValue_Control)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (control)
      boolean control = (boolean) _value.getStruct().get("control").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (control));
      // Simple Field (high)
      boolean high = (boolean) _value.getStruct().get("high").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (high));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Step_Control)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (control)
      boolean control = (boolean) _value.getStruct().get("control").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (control));
      // Simple Field (increase)
      boolean increase = (boolean) _value.getStruct().get("increase").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (increase));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Direction1_Control)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (control)
      boolean control = (boolean) _value.getStruct().get("control").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (control));
      // Simple Field (down)
      boolean down = (boolean) _value.getStruct().get("down").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (down));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Direction2_Control)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (control)
      boolean control = (boolean) _value.getStruct().get("control").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (control));
      // Simple Field (close)
      boolean close = (boolean) _value.getStruct().get("close").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (close));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Start_Control)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (control)
      boolean control = (boolean) _value.getStruct().get("control").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (control));
      // Simple Field (start)
      boolean start = (boolean) _value.getStruct().get("start").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (start));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_State_Control)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (control)
      boolean control = (boolean) _value.getStruct().get("control").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (control));
      // Simple Field (active)
      boolean active = (boolean) _value.getStruct().get("active").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (active));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Invert_Control)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (control)
      boolean control = (boolean) _value.getStruct().get("control").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (control));
      // Simple Field (inverted)
      boolean inverted = (boolean) _value.getStruct().get("inverted").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (inverted));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Control_Dimming)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (increase)
      boolean increase = (boolean) _value.getStruct().get("increase").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (increase));
      // Simple Field (stepcode)
      byte stepcode = (byte) _value.getStruct().get("stepcode").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 3, ((Number) (stepcode)).byteValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Control_Blinds)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (down)
      boolean down = (boolean) _value.getStruct().get("down").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (down));
      // Simple Field (stepcode)
      byte stepcode = (byte) _value.getStruct().get("stepcode").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 3, ((Number) (stepcode)).byteValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Char_ASCII)) { // STRING
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      String value = (String) _value.getString();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeString("", 8, "ASCII", (String) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Char_8859_1)) { // STRING
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      String value = (String) _value.getString();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeString("", 8, "ISO-8859-1", (String) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Scaling)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Angle)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_U8)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DecimalFactor)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Tariff)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_1_Ucount)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FanStage)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_V8)) { // SINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      byte value = (byte) _value.getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeSignedByte("", 8, ((Number) (value)).byteValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_1_Count)) { // SINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      byte value = (byte) _value.getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeSignedByte("", 8, ((Number) (value)).byteValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Status_Mode3)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (statusA)
      boolean statusA = (boolean) _value.getStruct().get("statusA").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (statusA));
      // Simple Field (statusB)
      boolean statusB = (boolean) _value.getStruct().get("statusB").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (statusB));
      // Simple Field (statusC)
      boolean statusC = (boolean) _value.getStruct().get("statusC").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (statusC));
      // Simple Field (statusD)
      boolean statusD = (boolean) _value.getStruct().get("statusD").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (statusD));
      // Simple Field (statusE)
      boolean statusE = (boolean) _value.getStruct().get("statusE").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (statusE));
      // Simple Field (mode)
      byte mode = (byte) _value.getStruct().get("mode").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 3, ((Number) (mode)).byteValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_2_Ucount)) { // UINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriodMsec)) { // UINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriod10Msec)) { // UINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriod100Msec)) { // UINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodSec)) { // UINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodMin)) { // UINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodHrs)) { // UINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PropDataType)) { // UINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Length_mm)) { // UINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_UElCurrentmA)) { // UINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Brightness)) { // UINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Absolute_Colour_Temperature)) { // UINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_2_Count)) { // INT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeShort("", 16, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeMsec)) { // INT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeShort("", 16, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaTime10Msec)) { // INT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeShort("", 16, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaTime100Msec)) { // INT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeShort("", 16, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeSec)) { // INT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeShort("", 16, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeMin)) { // INT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeShort("", 16, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeHrs)) { // INT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeShort("", 16, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_V16)) { // INT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeShort("", 16, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Rotation_Angle)) { // INT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeShort("", 16, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Length_m)) { // INT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeShort("", 16, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Temp)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Tempd)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Tempa)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Lux)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Wsp)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Pres)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Humidity)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AirQuality)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_AirFlow)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time1)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time2)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Volt)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Curr)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PowerDensity)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_KelvinPerPercent)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Power)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Volume_Flow)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Rain_Amount)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Temp_F)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Wsp_kmh)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Absolute_Humidity)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Concentration_ygm3)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimeOfDay)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (day)
      byte day = (byte) _value.getStruct().get("day").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 3, ((Number) (day)).byteValue());
      // Simple Field (hour)
      short hour = (short) _value.getStruct().get("hour").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 5, ((Number) (hour)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (byte) 0x00).byteValue());
      // Simple Field (minutes)
      short minutes = (short) _value.getStruct().get("minutes").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 6, ((Number) (minutes)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (byte) 0x00).byteValue());
      // Simple Field (seconds)
      short seconds = (short) _value.getStruct().get("seconds").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 6, ((Number) (seconds)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Date)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 3, ((Number) (byte) 0x00).byteValue());
      // Simple Field (dayOfMonth)
      short dayOfMonth = (short) _value.getStruct().get("dayOfMonth").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (dayOfMonth)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (month)
      byte month = (byte) _value.getStruct().get("month").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (month)).byteValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 1, ((Number) (byte) 0x00).byteValue());
      // Simple Field (year)
      short year = (short) _value.getStruct().get("year").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 7, ((Number) (year)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_4_Ucount)) { // UDINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Sec)) { // UDINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Min)) { // UDINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Hrs)) { // UDINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_VolumeLiquid_Litre)) { // UDINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Volume_m_3)) { // UDINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong("", 32, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_4_Count)) { // DINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeInt("", 32, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FlowRate_m3h)) { // DINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeInt("", 32, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ActiveEnergy)) { // DINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeInt("", 32, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy)) { // DINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeInt("", 32, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy)) { // DINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeInt("", 32, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_kWh)) { // DINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeInt("", 32, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy_kVAh)) { // DINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeInt("", 32, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy_kVARh)) { // DINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeInt("", 32, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_MWh)) { // DINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeInt("", 32, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongDeltaTimeSec)) { // DINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeInt("", 32, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaVolumeLiquid_Litre)) { // DINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeInt("", 32, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaVolume_m_3)) { // DINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      int value = (int) _value.getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeInt("", 32, ((Number) (value)).intValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Acceleration)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Acceleration_Angular)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Activation_Energy)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Activity)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Mol)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Amplitude)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AngleRad)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AngleDeg)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Momentum)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Velocity)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Area)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Capacitance)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Charge_DensitySurface)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Charge_DensityVolume)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Compressibility)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Conductance)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electrical_Conductivity)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Density)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Charge)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Current)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_CurrentDensity)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_DipoleMoment)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Displacement)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_FieldStrength)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Flux)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_FluxDensity)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Polarization)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Potential)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_PotentialDifference)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_ElectromagneticMoment)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electromotive_Force)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Energy)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Force)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Frequency)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Frequency)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_Capacity)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_FlowRate)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_Quantity)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Impedance)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Length)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Light_Quantity)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminance)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminous_Flux)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminous_Intensity)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_FieldStrength)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Flux)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_FluxDensity)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Moment)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Polarization)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetization)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_MagnetomotiveForce)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Mass)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_MassFlux)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Momentum)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Phase_AngleRad)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Phase_AngleDeg)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Power)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Power_Factor)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Pressure)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Reactance)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Resistance)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Resistivity)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_SelfInductance)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_SolidAngle)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Sound_Intensity)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Speed)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Stress)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Surface_Tension)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Common_Temperature)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Absolute_Temperature)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_TemperatureDifference)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Thermal_Capacity)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Thermal_Conductivity)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_ThermoelectricPower)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Torque)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Volume)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Volume_Flux)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Weight)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Work)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Volume_Flux_Meter)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Volume_Flux_ls)) { // REAL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      float value = (float) _value.getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Access_Data)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (hurz)
      byte hurz = (byte) _value.getStruct().get("hurz").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (hurz)).byteValue());
      // Simple Field (value1)
      byte value1 = (byte) _value.getStruct().get("value1").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (value1)).byteValue());
      // Simple Field (value2)
      byte value2 = (byte) _value.getStruct().get("value2").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (value2)).byteValue());
      // Simple Field (value3)
      byte value3 = (byte) _value.getStruct().get("value3").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (value3)).byteValue());
      // Simple Field (value4)
      byte value4 = (byte) _value.getStruct().get("value4").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (value4)).byteValue());
      // Simple Field (value5)
      byte value5 = (byte) _value.getStruct().get("value5").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (value5)).byteValue());
      // Simple Field (detectionError)
      boolean detectionError = (boolean) _value.getStruct().get("detectionError").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (detectionError));
      // Simple Field (permission)
      boolean permission = (boolean) _value.getStruct().get("permission").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (permission));
      // Simple Field (readDirection)
      boolean readDirection = (boolean) _value.getStruct().get("readDirection").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (readDirection));
      // Simple Field (encryptionOfAccessInformation)
      boolean encryptionOfAccessInformation =
          (boolean) _value.getStruct().get("encryptionOfAccessInformation").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (encryptionOfAccessInformation));
      // Simple Field (indexOfAccessIdentificationCode)
      byte indexOfAccessIdentificationCode =
          (byte) _value.getStruct().get("indexOfAccessIdentificationCode").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte(
          "", 4, ((Number) (indexOfAccessIdentificationCode)).byteValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_String_ASCII)) { // STRING
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      String value = (String) _value.getString();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeString("", 112, "ASCII", (String) (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_String_8859_1)) { // STRING
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      String value = (String) _value.getString();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeString("", 112, "ISO-8859-1", (String) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SceneNumber)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (byte) 0x00).byteValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 6, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SceneControl)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (learnTheSceneCorrespondingToTheFieldSceneNumber)
      boolean learnTheSceneCorrespondingToTheFieldSceneNumber =
          (boolean)
              _value
                  .getStruct()
                  .get("learnTheSceneCorrespondingToTheFieldSceneNumber")
                  .getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit(
          "", (boolean) (learnTheSceneCorrespondingToTheFieldSceneNumber));
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 1, ((Number) (byte) 0x00).byteValue());
      // Simple Field (sceneNumber)
      short sceneNumber = (short) _value.getStruct().get("sceneNumber").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (sceneNumber)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DateTime)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (year)
      short year = (short) _value.getStruct().get("year").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (year)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (month)
      byte month = (byte) _value.getStruct().get("month").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (month)).byteValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 3, ((Number) (byte) 0x00).byteValue());
      // Simple Field (dayofmonth)
      short dayofmonth = (short) _value.getStruct().get("dayofmonth").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (dayofmonth)).shortValue());
      // Simple Field (dayofweek)
      byte dayofweek = (byte) _value.getStruct().get("dayofweek").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 3, ((Number) (dayofweek)).byteValue());
      // Simple Field (hourofday)
      short hourofday = (short) _value.getStruct().get("hourofday").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (hourofday)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (byte) 0x00).byteValue());
      // Simple Field (minutes)
      short minutes = (short) _value.getStruct().get("minutes").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 6, ((Number) (minutes)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (byte) 0x00).byteValue());
      // Simple Field (seconds)
      short seconds = (short) _value.getStruct().get("seconds").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 6, ((Number) (seconds)).shortValue());
      // Simple Field (fault)
      boolean fault = (boolean) _value.getStruct().get("fault").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (fault));
      // Simple Field (workingDay)
      boolean workingDay = (boolean) _value.getStruct().get("workingDay").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (workingDay));
      // Simple Field (noWd)
      boolean noWd = (boolean) _value.getStruct().get("noWd").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (noWd));
      // Simple Field (noYear)
      boolean noYear = (boolean) _value.getStruct().get("noYear").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (noYear));
      // Simple Field (noDate)
      boolean noDate = (boolean) _value.getStruct().get("noDate").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (noDate));
      // Simple Field (noDayOfWeek)
      boolean noDayOfWeek = (boolean) _value.getStruct().get("noDayOfWeek").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (noDayOfWeek));
      // Simple Field (noTime)
      boolean noTime = (boolean) _value.getStruct().get("noTime").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (noTime));
      // Simple Field (standardSummerTime)
      boolean standardSummerTime =
          (boolean) _value.getStruct().get("standardSummerTime").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (standardSummerTime));
      // Simple Field (qualityOfClock)
      boolean qualityOfClock = (boolean) _value.getStruct().get("qualityOfClock").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (qualityOfClock));
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SCLOMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BuildingMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OccMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Priority)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LightApplicationMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApplicationArea)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_AlarmClassType)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PSUMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ErrorClass_System)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ErrorClass_HVAC)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Time_Delay)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Beaufort_Wind_Force_Scale)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SensorSelect)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActuatorConnectType)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Cloud_Cover)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_PowerReturnMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FuelType)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BurnerType)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HVACMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DHWMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_LoadPriority)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVACContrMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVACEmergMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ChangeoverMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ValveMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DamperMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HeaterMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FanMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_MasterSlaveMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_StatusRoomSetp)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Metering_DeviceType)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HumDehumMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_EnableHCStage)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ADAType)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BackupMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_StartSynchronization)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Behaviour_Lock_Unlock)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Behaviour_Bus_Power_Up_Down)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DALI_Fade_Time)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BlinkingMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LightControlMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SwitchPBModel)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PBAction)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DimmPBModel)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SwitchOnMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_LoadTypeSet)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LoadTypeDetected)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Converter_Test_Control)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SABExcept_Behaviour)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SABBehaviour_Lock_Unlock)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SSSBMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_BlindsControlMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_CommMode)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_AddInfoTypes)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_RF_ModeSelect)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_RF_FilterSelect)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      short value = (short) _value.getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (value)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusGen)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 3, ((Number) (byte) 0x00).byteValue());
      // Simple Field (alarmStatusOfCorrespondingDatapointIsNotAcknowledged)
      boolean alarmStatusOfCorrespondingDatapointIsNotAcknowledged =
          (boolean)
              _value
                  .getStruct()
                  .get("alarmStatusOfCorrespondingDatapointIsNotAcknowledged")
                  .getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit(
          "", (boolean) (alarmStatusOfCorrespondingDatapointIsNotAcknowledged));
      // Simple Field (correspondingDatapointIsInAlarm)
      boolean correspondingDatapointIsInAlarm =
          (boolean) _value.getStruct().get("correspondingDatapointIsInAlarm").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (correspondingDatapointIsInAlarm));
      // Simple Field (correspondingDatapointMainValueIsOverridden)
      boolean correspondingDatapointMainValueIsOverridden =
          (boolean)
              _value.getStruct().get("correspondingDatapointMainValueIsOverridden").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit(
          "", (boolean) (correspondingDatapointMainValueIsOverridden));
      // Simple Field (correspondingDatapointMainValueIsCorruptedDueToFailure)
      boolean correspondingDatapointMainValueIsCorruptedDueToFailure =
          (boolean)
              _value
                  .getStruct()
                  .get("correspondingDatapointMainValueIsCorruptedDueToFailure")
                  .getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit(
          "", (boolean) (correspondingDatapointMainValueIsCorruptedDueToFailure));
      // Simple Field (correspondingDatapointValueIsOutOfService)
      boolean correspondingDatapointValueIsOutOfService =
          (boolean)
              _value.getStruct().get("correspondingDatapointValueIsOutOfService").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit(
          "", (boolean) (correspondingDatapointValueIsOutOfService));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Device_Control)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (short) 0x00).shortValue());
      // Simple Field (verifyModeIsOn)
      boolean verifyModeIsOn = (boolean) _value.getStruct().get("verifyModeIsOn").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (verifyModeIsOn));
      // Simple Field (aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived)
      boolean aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived =
          (boolean)
              _value
                  .getStruct()
                  .get("aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived")
                  .getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit(
          "", (boolean) (aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived));
      // Simple Field (theUserApplicationIsStopped)
      boolean theUserApplicationIsStopped =
          (boolean) _value.getStruct().get("theUserApplicationIsStopped").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (theUserApplicationIsStopped));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ForceSign)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (roomhmax)
      boolean roomhmax = (boolean) _value.getStruct().get("roomhmax").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (roomhmax));
      // Simple Field (roomhconf)
      boolean roomhconf = (boolean) _value.getStruct().get("roomhconf").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (roomhconf));
      // Simple Field (dhwlegio)
      boolean dhwlegio = (boolean) _value.getStruct().get("dhwlegio").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (dhwlegio));
      // Simple Field (dhwnorm)
      boolean dhwnorm = (boolean) _value.getStruct().get("dhwnorm").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (dhwnorm));
      // Simple Field (overrun)
      boolean overrun = (boolean) _value.getStruct().get("overrun").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (overrun));
      // Simple Field (oversupply)
      boolean oversupply = (boolean) _value.getStruct().get("oversupply").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (oversupply));
      // Simple Field (protection)
      boolean protection = (boolean) _value.getStruct().get("protection").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (protection));
      // Simple Field (forcerequest)
      boolean forcerequest = (boolean) _value.getStruct().get("forcerequest").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (forcerequest));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ForceSignCool)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusRHC)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (summermode)
      boolean summermode = (boolean) _value.getStruct().get("summermode").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (summermode));
      // Simple Field (statusstopoptim)
      boolean statusstopoptim = (boolean) _value.getStruct().get("statusstopoptim").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (statusstopoptim));
      // Simple Field (statusstartoptim)
      boolean statusstartoptim = (boolean) _value.getStruct().get("statusstartoptim").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (statusstartoptim));
      // Simple Field (statusmorningboost)
      boolean statusmorningboost =
          (boolean) _value.getStruct().get("statusmorningboost").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (statusmorningboost));
      // Simple Field (tempreturnlimit)
      boolean tempreturnlimit = (boolean) _value.getStruct().get("tempreturnlimit").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (tempreturnlimit));
      // Simple Field (tempflowlimit)
      boolean tempflowlimit = (boolean) _value.getStruct().get("tempflowlimit").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (tempflowlimit));
      // Simple Field (satuseco)
      boolean satuseco = (boolean) _value.getStruct().get("satuseco").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (satuseco));
      // Simple Field (fault)
      boolean fault = (boolean) _value.getStruct().get("fault").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (fault));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusSDHWC)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (short) 0x00).shortValue());
      // Simple Field (solarloadsufficient)
      boolean solarloadsufficient =
          (boolean) _value.getStruct().get("solarloadsufficient").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (solarloadsufficient));
      // Simple Field (sdhwloadactive)
      boolean sdhwloadactive = (boolean) _value.getStruct().get("sdhwloadactive").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (sdhwloadactive));
      // Simple Field (fault)
      boolean fault = (boolean) _value.getStruct().get("fault").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (fault));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FuelTypeSet)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (short) 0x00).shortValue());
      // Simple Field (solidstate)
      boolean solidstate = (boolean) _value.getStruct().get("solidstate").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (solidstate));
      // Simple Field (gas)
      boolean gas = (boolean) _value.getStruct().get("gas").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (gas));
      // Simple Field (oil)
      boolean oil = (boolean) _value.getStruct().get("oil").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (oil));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusRCC)) { // BOOL
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      boolean value = (boolean) _value.getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (value));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusAHU)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (cool)
      boolean cool = (boolean) _value.getStruct().get("cool").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (cool));
      // Simple Field (heat)
      boolean heat = (boolean) _value.getStruct().get("heat").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (heat));
      // Simple Field (fanactive)
      boolean fanactive = (boolean) _value.getStruct().get("fanactive").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (fanactive));
      // Simple Field (fault)
      boolean fault = (boolean) _value.getStruct().get("fault").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (fault));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedStatus_RTSM)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 3, ((Number) (byte) 0x00).byteValue());
      // Simple Field (statusOfHvacModeUser)
      boolean statusOfHvacModeUser =
          (boolean) _value.getStruct().get("statusOfHvacModeUser").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (statusOfHvacModeUser));
      // Simple Field (statusOfComfortProlongationUser)
      boolean statusOfComfortProlongationUser =
          (boolean) _value.getStruct().get("statusOfComfortProlongationUser").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (statusOfComfortProlongationUser));
      // Simple Field (effectiveValueOfTheComfortPushButton)
      boolean effectiveValueOfTheComfortPushButton =
          (boolean) _value.getStruct().get("effectiveValueOfTheComfortPushButton").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit(
          "", (boolean) (effectiveValueOfTheComfortPushButton));
      // Simple Field (effectiveValueOfThePresenceStatus)
      boolean effectiveValueOfThePresenceStatus =
          (boolean) _value.getStruct().get("effectiveValueOfThePresenceStatus").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (effectiveValueOfThePresenceStatus));
      // Simple Field (effectiveValueOfTheWindowStatus)
      boolean effectiveValueOfTheWindowStatus =
          (boolean) _value.getStruct().get("effectiveValueOfTheWindowStatus").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (effectiveValueOfTheWindowStatus));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LightActuatorErrorInfo)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 1, ((Number) (byte) 0x00).byteValue());
      // Simple Field (overheat)
      boolean overheat = (boolean) _value.getStruct().get("overheat").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (overheat));
      // Simple Field (lampfailure)
      boolean lampfailure = (boolean) _value.getStruct().get("lampfailure").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (lampfailure));
      // Simple Field (defectiveload)
      boolean defectiveload = (boolean) _value.getStruct().get("defectiveload").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (defectiveload));
      // Simple Field (underload)
      boolean underload = (boolean) _value.getStruct().get("underload").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (underload));
      // Simple Field (overcurrent)
      boolean overcurrent = (boolean) _value.getStruct().get("overcurrent").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (overcurrent));
      // Simple Field (undervoltage)
      boolean undervoltage = (boolean) _value.getStruct().get("undervoltage").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (undervoltage));
      // Simple Field (loaddetectionerror)
      boolean loaddetectionerror =
          (boolean) _value.getStruct().get("loaddetectionerror").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (loaddetectionerror));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_RF_ModeInfo)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (short) 0x00).shortValue());
      // Simple Field (bibatSlave)
      boolean bibatSlave = (boolean) _value.getStruct().get("bibatSlave").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (bibatSlave));
      // Simple Field (bibatMaster)
      boolean bibatMaster = (boolean) _value.getStruct().get("bibatMaster").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (bibatMaster));
      // Simple Field (asynchronous)
      boolean asynchronous = (boolean) _value.getStruct().get("asynchronous").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (asynchronous));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_RF_FilterInfo)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (short) 0x00).shortValue());
      // Simple Field (doa)
      boolean doa = (boolean) _value.getStruct().get("doa").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (doa));
      // Simple Field (knxSn)
      boolean knxSn = (boolean) _value.getStruct().get("knxSn").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (knxSn));
      // Simple Field (doaAndKnxSn)
      boolean doaAndKnxSn = (boolean) _value.getStruct().get("doaAndKnxSn").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (doaAndKnxSn));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Channel_Activation_8)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (activationStateOfChannel1)
      boolean activationStateOfChannel1 =
          (boolean) _value.getStruct().get("activationStateOfChannel1").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel1));
      // Simple Field (activationStateOfChannel2)
      boolean activationStateOfChannel2 =
          (boolean) _value.getStruct().get("activationStateOfChannel2").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel2));
      // Simple Field (activationStateOfChannel3)
      boolean activationStateOfChannel3 =
          (boolean) _value.getStruct().get("activationStateOfChannel3").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel3));
      // Simple Field (activationStateOfChannel4)
      boolean activationStateOfChannel4 =
          (boolean) _value.getStruct().get("activationStateOfChannel4").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel4));
      // Simple Field (activationStateOfChannel5)
      boolean activationStateOfChannel5 =
          (boolean) _value.getStruct().get("activationStateOfChannel5").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel5));
      // Simple Field (activationStateOfChannel6)
      boolean activationStateOfChannel6 =
          (boolean) _value.getStruct().get("activationStateOfChannel6").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel6));
      // Simple Field (activationStateOfChannel7)
      boolean activationStateOfChannel7 =
          (boolean) _value.getStruct().get("activationStateOfChannel7").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel7));
      // Simple Field (activationStateOfChannel8)
      boolean activationStateOfChannel8 =
          (boolean) _value.getStruct().get("activationStateOfChannel8").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel8));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusDHWC)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (tempoptimshiftactive)
      boolean tempoptimshiftactive =
          (boolean) _value.getStruct().get("tempoptimshiftactive").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (tempoptimshiftactive));
      // Simple Field (solarenergysupport)
      boolean solarenergysupport =
          (boolean) _value.getStruct().get("solarenergysupport").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (solarenergysupport));
      // Simple Field (solarenergyonly)
      boolean solarenergyonly = (boolean) _value.getStruct().get("solarenergyonly").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (solarenergyonly));
      // Simple Field (otherenergysourceactive)
      boolean otherenergysourceactive =
          (boolean) _value.getStruct().get("otherenergysourceactive").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (otherenergysourceactive));
      // Simple Field (dhwpushactive)
      boolean dhwpushactive = (boolean) _value.getStruct().get("dhwpushactive").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (dhwpushactive));
      // Simple Field (legioprotactive)
      boolean legioprotactive = (boolean) _value.getStruct().get("legioprotactive").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (legioprotactive));
      // Simple Field (dhwloadactive)
      boolean dhwloadactive = (boolean) _value.getStruct().get("dhwloadactive").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (dhwloadactive));
      // Simple Field (fault)
      boolean fault = (boolean) _value.getStruct().get("fault").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (fault));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusRHCC)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 1, ((Number) (byte) 0x00).byteValue());
      // Simple Field (overheatalarm)
      boolean overheatalarm = (boolean) _value.getStruct().get("overheatalarm").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (overheatalarm));
      // Simple Field (frostalarm)
      boolean frostalarm = (boolean) _value.getStruct().get("frostalarm").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (frostalarm));
      // Simple Field (dewpointstatus)
      boolean dewpointstatus = (boolean) _value.getStruct().get("dewpointstatus").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (dewpointstatus));
      // Simple Field (coolingdisabled)
      boolean coolingdisabled = (boolean) _value.getStruct().get("coolingdisabled").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (coolingdisabled));
      // Simple Field (statusprecool)
      boolean statusprecool = (boolean) _value.getStruct().get("statusprecool").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (statusprecool));
      // Simple Field (statusecoc)
      boolean statusecoc = (boolean) _value.getStruct().get("statusecoc").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (statusecoc));
      // Simple Field (heatcoolmode)
      boolean heatcoolmode = (boolean) _value.getStruct().get("heatcoolmode").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (heatcoolmode));
      // Simple Field (heatingdiabled)
      boolean heatingdiabled = (boolean) _value.getStruct().get("heatingdiabled").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (heatingdiabled));
      // Simple Field (statusstopoptim)
      boolean statusstopoptim = (boolean) _value.getStruct().get("statusstopoptim").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (statusstopoptim));
      // Simple Field (statusstartoptim)
      boolean statusstartoptim = (boolean) _value.getStruct().get("statusstartoptim").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (statusstartoptim));
      // Simple Field (statusmorningboosth)
      boolean statusmorningboosth =
          (boolean) _value.getStruct().get("statusmorningboosth").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (statusmorningboosth));
      // Simple Field (tempflowreturnlimit)
      boolean tempflowreturnlimit =
          (boolean) _value.getStruct().get("tempflowreturnlimit").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (tempflowreturnlimit));
      // Simple Field (tempflowlimit)
      boolean tempflowlimit = (boolean) _value.getStruct().get("tempflowlimit").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (tempflowlimit));
      // Simple Field (statusecoh)
      boolean statusecoh = (boolean) _value.getStruct().get("statusecoh").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (statusecoh));
      // Simple Field (fault)
      boolean fault = (boolean) _value.getStruct().get("fault").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (fault));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedStatus_HVA)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (calibrationMode)
      boolean calibrationMode = (boolean) _value.getStruct().get("calibrationMode").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (calibrationMode));
      // Simple Field (lockedPosition)
      boolean lockedPosition = (boolean) _value.getStruct().get("lockedPosition").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (lockedPosition));
      // Simple Field (forcedPosition)
      boolean forcedPosition = (boolean) _value.getStruct().get("forcedPosition").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (forcedPosition));
      // Simple Field (manuaOperationOverridden)
      boolean manuaOperationOverridden =
          (boolean) _value.getStruct().get("manuaOperationOverridden").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (manuaOperationOverridden));
      // Simple Field (serviceMode)
      boolean serviceMode = (boolean) _value.getStruct().get("serviceMode").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (serviceMode));
      // Simple Field (valveKick)
      boolean valveKick = (boolean) _value.getStruct().get("valveKick").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (valveKick));
      // Simple Field (overload)
      boolean overload = (boolean) _value.getStruct().get("overload").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (overload));
      // Simple Field (shortCircuit)
      boolean shortCircuit = (boolean) _value.getStruct().get("shortCircuit").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (shortCircuit));
      // Simple Field (currentValvePosition)
      boolean currentValvePosition =
          (boolean) _value.getStruct().get("currentValvePosition").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (currentValvePosition));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedStatus_RTC)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 7, ((Number) (short) 0x00).shortValue());
      // Simple Field (coolingModeEnabled)
      boolean coolingModeEnabled =
          (boolean) _value.getStruct().get("coolingModeEnabled").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (coolingModeEnabled));
      // Simple Field (heatingModeEnabled)
      boolean heatingModeEnabled =
          (boolean) _value.getStruct().get("heatingModeEnabled").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (heatingModeEnabled));
      // Simple Field (additionalHeatingCoolingStage2Stage)
      boolean additionalHeatingCoolingStage2Stage =
          (boolean) _value.getStruct().get("additionalHeatingCoolingStage2Stage").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit(
          "", (boolean) (additionalHeatingCoolingStage2Stage));
      // Simple Field (controllerInactive)
      boolean controllerInactive =
          (boolean) _value.getStruct().get("controllerInactive").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (controllerInactive));
      // Simple Field (overheatAlarm)
      boolean overheatAlarm = (boolean) _value.getStruct().get("overheatAlarm").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (overheatAlarm));
      // Simple Field (frostAlarm)
      boolean frostAlarm = (boolean) _value.getStruct().get("frostAlarm").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (frostAlarm));
      // Simple Field (dewPointStatus)
      boolean dewPointStatus = (boolean) _value.getStruct().get("dewPointStatus").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (dewPointStatus));
      // Simple Field (activeMode)
      boolean activeMode = (boolean) _value.getStruct().get("activeMode").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activeMode));
      // Simple Field (generalFailureInformation)
      boolean generalFailureInformation =
          (boolean) _value.getStruct().get("generalFailureInformation").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (generalFailureInformation));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Media)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 10, ((Number) (int) 0x00).intValue());
      // Simple Field (knxIp)
      boolean knxIp = (boolean) _value.getStruct().get("knxIp").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (knxIp));
      // Simple Field (rf)
      boolean rf = (boolean) _value.getStruct().get("rf").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (rf));
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 1, ((Number) (byte) 0x00).byteValue());
      // Simple Field (pl110)
      boolean pl110 = (boolean) _value.getStruct().get("pl110").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (pl110));
      // Simple Field (tp1)
      boolean tp1 = (boolean) _value.getStruct().get("tp1").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (tp1));
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 1, ((Number) (byte) 0x00).byteValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Channel_Activation_16)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (activationStateOfChannel1)
      boolean activationStateOfChannel1 =
          (boolean) _value.getStruct().get("activationStateOfChannel1").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel1));
      // Simple Field (activationStateOfChannel2)
      boolean activationStateOfChannel2 =
          (boolean) _value.getStruct().get("activationStateOfChannel2").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel2));
      // Simple Field (activationStateOfChannel3)
      boolean activationStateOfChannel3 =
          (boolean) _value.getStruct().get("activationStateOfChannel3").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel3));
      // Simple Field (activationStateOfChannel4)
      boolean activationStateOfChannel4 =
          (boolean) _value.getStruct().get("activationStateOfChannel4").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel4));
      // Simple Field (activationStateOfChannel5)
      boolean activationStateOfChannel5 =
          (boolean) _value.getStruct().get("activationStateOfChannel5").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel5));
      // Simple Field (activationStateOfChannel6)
      boolean activationStateOfChannel6 =
          (boolean) _value.getStruct().get("activationStateOfChannel6").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel6));
      // Simple Field (activationStateOfChannel7)
      boolean activationStateOfChannel7 =
          (boolean) _value.getStruct().get("activationStateOfChannel7").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel7));
      // Simple Field (activationStateOfChannel8)
      boolean activationStateOfChannel8 =
          (boolean) _value.getStruct().get("activationStateOfChannel8").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel8));
      // Simple Field (activationStateOfChannel9)
      boolean activationStateOfChannel9 =
          (boolean) _value.getStruct().get("activationStateOfChannel9").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel9));
      // Simple Field (activationStateOfChannel10)
      boolean activationStateOfChannel10 =
          (boolean) _value.getStruct().get("activationStateOfChannel10").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel10));
      // Simple Field (activationStateOfChannel11)
      boolean activationStateOfChannel11 =
          (boolean) _value.getStruct().get("activationStateOfChannel11").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel11));
      // Simple Field (activationStateOfChannel12)
      boolean activationStateOfChannel12 =
          (boolean) _value.getStruct().get("activationStateOfChannel12").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel12));
      // Simple Field (activationStateOfChannel13)
      boolean activationStateOfChannel13 =
          (boolean) _value.getStruct().get("activationStateOfChannel13").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel13));
      // Simple Field (activationStateOfChannel14)
      boolean activationStateOfChannel14 =
          (boolean) _value.getStruct().get("activationStateOfChannel14").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel14));
      // Simple Field (activationStateOfChannel15)
      boolean activationStateOfChannel15 =
          (boolean) _value.getStruct().get("activationStateOfChannel15").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel15));
      // Simple Field (activationStateOfChannel16)
      boolean activationStateOfChannel16 =
          (boolean) _value.getStruct().get("activationStateOfChannel16").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel16));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OnOffAction)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      byte value = (byte) _value.getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (value)).byteValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Alarm_Reaction)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      byte value = (byte) _value.getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (value)).byteValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_UpDown_Action)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      byte value = (byte) _value.getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (value)).byteValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVAC_PB_Action)) { // USINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      byte value = (byte) _value.getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (value)).byteValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DoubleNibble)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (busy)
      byte busy = (byte) _value.getStruct().get("busy").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (busy)).byteValue());
      // Simple Field (nak)
      byte nak = (byte) _value.getStruct().get("nak").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (nak)).byteValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SceneInfo)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 1, ((Number) (byte) 0x00).byteValue());
      // Simple Field (sceneIsInactive)
      boolean sceneIsInactive = (boolean) _value.getStruct().get("sceneIsInactive").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (sceneIsInactive));
      // Simple Field (scenenumber)
      short scenenumber = (short) _value.getStruct().get("scenenumber").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (scenenumber)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedInfoOnOff)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (maskBitInfoOnOffOutput16)
      boolean maskBitInfoOnOffOutput16 =
          (boolean) _value.getStruct().get("maskBitInfoOnOffOutput16").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskBitInfoOnOffOutput16));
      // Simple Field (maskBitInfoOnOffOutput15)
      boolean maskBitInfoOnOffOutput15 =
          (boolean) _value.getStruct().get("maskBitInfoOnOffOutput15").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskBitInfoOnOffOutput15));
      // Simple Field (maskBitInfoOnOffOutput14)
      boolean maskBitInfoOnOffOutput14 =
          (boolean) _value.getStruct().get("maskBitInfoOnOffOutput14").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskBitInfoOnOffOutput14));
      // Simple Field (maskBitInfoOnOffOutput13)
      boolean maskBitInfoOnOffOutput13 =
          (boolean) _value.getStruct().get("maskBitInfoOnOffOutput13").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskBitInfoOnOffOutput13));
      // Simple Field (maskBitInfoOnOffOutput12)
      boolean maskBitInfoOnOffOutput12 =
          (boolean) _value.getStruct().get("maskBitInfoOnOffOutput12").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskBitInfoOnOffOutput12));
      // Simple Field (maskBitInfoOnOffOutput11)
      boolean maskBitInfoOnOffOutput11 =
          (boolean) _value.getStruct().get("maskBitInfoOnOffOutput11").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskBitInfoOnOffOutput11));
      // Simple Field (maskBitInfoOnOffOutput10)
      boolean maskBitInfoOnOffOutput10 =
          (boolean) _value.getStruct().get("maskBitInfoOnOffOutput10").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskBitInfoOnOffOutput10));
      // Simple Field (maskBitInfoOnOffOutput9)
      boolean maskBitInfoOnOffOutput9 =
          (boolean) _value.getStruct().get("maskBitInfoOnOffOutput9").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskBitInfoOnOffOutput9));
      // Simple Field (maskBitInfoOnOffOutput8)
      boolean maskBitInfoOnOffOutput8 =
          (boolean) _value.getStruct().get("maskBitInfoOnOffOutput8").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskBitInfoOnOffOutput8));
      // Simple Field (maskBitInfoOnOffOutput7)
      boolean maskBitInfoOnOffOutput7 =
          (boolean) _value.getStruct().get("maskBitInfoOnOffOutput7").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskBitInfoOnOffOutput7));
      // Simple Field (maskBitInfoOnOffOutput6)
      boolean maskBitInfoOnOffOutput6 =
          (boolean) _value.getStruct().get("maskBitInfoOnOffOutput6").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskBitInfoOnOffOutput6));
      // Simple Field (maskBitInfoOnOffOutput5)
      boolean maskBitInfoOnOffOutput5 =
          (boolean) _value.getStruct().get("maskBitInfoOnOffOutput5").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskBitInfoOnOffOutput5));
      // Simple Field (maskBitInfoOnOffOutput4)
      boolean maskBitInfoOnOffOutput4 =
          (boolean) _value.getStruct().get("maskBitInfoOnOffOutput4").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskBitInfoOnOffOutput4));
      // Simple Field (maskBitInfoOnOffOutput3)
      boolean maskBitInfoOnOffOutput3 =
          (boolean) _value.getStruct().get("maskBitInfoOnOffOutput3").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskBitInfoOnOffOutput3));
      // Simple Field (maskBitInfoOnOffOutput2)
      boolean maskBitInfoOnOffOutput2 =
          (boolean) _value.getStruct().get("maskBitInfoOnOffOutput2").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskBitInfoOnOffOutput2));
      // Simple Field (maskBitInfoOnOffOutput1)
      boolean maskBitInfoOnOffOutput1 =
          (boolean) _value.getStruct().get("maskBitInfoOnOffOutput1").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskBitInfoOnOffOutput1));
      // Simple Field (infoOnOffOutput16)
      boolean infoOnOffOutput16 =
          (boolean) _value.getStruct().get("infoOnOffOutput16").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (infoOnOffOutput16));
      // Simple Field (infoOnOffOutput15)
      boolean infoOnOffOutput15 =
          (boolean) _value.getStruct().get("infoOnOffOutput15").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (infoOnOffOutput15));
      // Simple Field (infoOnOffOutput14)
      boolean infoOnOffOutput14 =
          (boolean) _value.getStruct().get("infoOnOffOutput14").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (infoOnOffOutput14));
      // Simple Field (infoOnOffOutput13)
      boolean infoOnOffOutput13 =
          (boolean) _value.getStruct().get("infoOnOffOutput13").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (infoOnOffOutput13));
      // Simple Field (infoOnOffOutput12)
      boolean infoOnOffOutput12 =
          (boolean) _value.getStruct().get("infoOnOffOutput12").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (infoOnOffOutput12));
      // Simple Field (infoOnOffOutput11)
      boolean infoOnOffOutput11 =
          (boolean) _value.getStruct().get("infoOnOffOutput11").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (infoOnOffOutput11));
      // Simple Field (infoOnOffOutput10)
      boolean infoOnOffOutput10 =
          (boolean) _value.getStruct().get("infoOnOffOutput10").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (infoOnOffOutput10));
      // Simple Field (infoOnOffOutput9)
      boolean infoOnOffOutput9 = (boolean) _value.getStruct().get("infoOnOffOutput9").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (infoOnOffOutput9));
      // Simple Field (infoOnOffOutput8)
      boolean infoOnOffOutput8 = (boolean) _value.getStruct().get("infoOnOffOutput8").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (infoOnOffOutput8));
      // Simple Field (infoOnOffOutput7)
      boolean infoOnOffOutput7 = (boolean) _value.getStruct().get("infoOnOffOutput7").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (infoOnOffOutput7));
      // Simple Field (infoOnOffOutput6)
      boolean infoOnOffOutput6 = (boolean) _value.getStruct().get("infoOnOffOutput6").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (infoOnOffOutput6));
      // Simple Field (infoOnOffOutput5)
      boolean infoOnOffOutput5 = (boolean) _value.getStruct().get("infoOnOffOutput5").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (infoOnOffOutput5));
      // Simple Field (infoOnOffOutput4)
      boolean infoOnOffOutput4 = (boolean) _value.getStruct().get("infoOnOffOutput4").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (infoOnOffOutput4));
      // Simple Field (infoOnOffOutput3)
      boolean infoOnOffOutput3 = (boolean) _value.getStruct().get("infoOnOffOutput3").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (infoOnOffOutput3));
      // Simple Field (infoOnOffOutput2)
      boolean infoOnOffOutput2 = (boolean) _value.getStruct().get("infoOnOffOutput2").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (infoOnOffOutput2));
      // Simple Field (infoOnOffOutput1)
      boolean infoOnOffOutput1 = (boolean) _value.getStruct().get("infoOnOffOutput1").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (infoOnOffOutput1));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_V64)) { // LINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeLong("", 64, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy_V64)) { // LINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeLong("", 64, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy_V64)) { // LINT
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      long value = (long) _value.getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeLong("", 64, ((Number) (value)).longValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Channel_Activation_24)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (activationStateOfChannel1)
      boolean activationStateOfChannel1 =
          (boolean) _value.getStruct().get("activationStateOfChannel1").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel1));
      // Simple Field (activationStateOfChannel2)
      boolean activationStateOfChannel2 =
          (boolean) _value.getStruct().get("activationStateOfChannel2").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel2));
      // Simple Field (activationStateOfChannel3)
      boolean activationStateOfChannel3 =
          (boolean) _value.getStruct().get("activationStateOfChannel3").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel3));
      // Simple Field (activationStateOfChannel4)
      boolean activationStateOfChannel4 =
          (boolean) _value.getStruct().get("activationStateOfChannel4").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel4));
      // Simple Field (activationStateOfChannel5)
      boolean activationStateOfChannel5 =
          (boolean) _value.getStruct().get("activationStateOfChannel5").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel5));
      // Simple Field (activationStateOfChannel6)
      boolean activationStateOfChannel6 =
          (boolean) _value.getStruct().get("activationStateOfChannel6").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel6));
      // Simple Field (activationStateOfChannel7)
      boolean activationStateOfChannel7 =
          (boolean) _value.getStruct().get("activationStateOfChannel7").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel7));
      // Simple Field (activationStateOfChannel8)
      boolean activationStateOfChannel8 =
          (boolean) _value.getStruct().get("activationStateOfChannel8").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel8));
      // Simple Field (activationStateOfChannel9)
      boolean activationStateOfChannel9 =
          (boolean) _value.getStruct().get("activationStateOfChannel9").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel9));
      // Simple Field (activationStateOfChannel10)
      boolean activationStateOfChannel10 =
          (boolean) _value.getStruct().get("activationStateOfChannel10").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel10));
      // Simple Field (activationStateOfChannel11)
      boolean activationStateOfChannel11 =
          (boolean) _value.getStruct().get("activationStateOfChannel11").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel11));
      // Simple Field (activationStateOfChannel12)
      boolean activationStateOfChannel12 =
          (boolean) _value.getStruct().get("activationStateOfChannel12").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel12));
      // Simple Field (activationStateOfChannel13)
      boolean activationStateOfChannel13 =
          (boolean) _value.getStruct().get("activationStateOfChannel13").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel13));
      // Simple Field (activationStateOfChannel14)
      boolean activationStateOfChannel14 =
          (boolean) _value.getStruct().get("activationStateOfChannel14").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel14));
      // Simple Field (activationStateOfChannel15)
      boolean activationStateOfChannel15 =
          (boolean) _value.getStruct().get("activationStateOfChannel15").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel15));
      // Simple Field (activationStateOfChannel16)
      boolean activationStateOfChannel16 =
          (boolean) _value.getStruct().get("activationStateOfChannel16").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel16));
      // Simple Field (activationStateOfChannel17)
      boolean activationStateOfChannel17 =
          (boolean) _value.getStruct().get("activationStateOfChannel17").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel17));
      // Simple Field (activationStateOfChannel18)
      boolean activationStateOfChannel18 =
          (boolean) _value.getStruct().get("activationStateOfChannel18").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel18));
      // Simple Field (activationStateOfChannel19)
      boolean activationStateOfChannel19 =
          (boolean) _value.getStruct().get("activationStateOfChannel19").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel19));
      // Simple Field (activationStateOfChannel20)
      boolean activationStateOfChannel20 =
          (boolean) _value.getStruct().get("activationStateOfChannel20").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel20));
      // Simple Field (activationStateOfChannel21)
      boolean activationStateOfChannel21 =
          (boolean) _value.getStruct().get("activationStateOfChannel21").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel21));
      // Simple Field (activationStateOfChannel22)
      boolean activationStateOfChannel22 =
          (boolean) _value.getStruct().get("activationStateOfChannel22").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel22));
      // Simple Field (activationStateOfChannel23)
      boolean activationStateOfChannel23 =
          (boolean) _value.getStruct().get("activationStateOfChannel23").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel23));
      // Simple Field (activationStateOfChannel24)
      boolean activationStateOfChannel24 =
          (boolean) _value.getStruct().get("activationStateOfChannel24").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (activationStateOfChannel24));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVACModeNext)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (delayTimeMin)
      int delayTimeMin = (int) _value.getStruct().get("delayTimeMin").getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt(
          "", 16, ((Number) (delayTimeMin)).intValue());
      // Simple Field (hvacMode)
      short hvacMode = (short) _value.getStruct().get("hvacMode").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (hvacMode)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DHWModeNext)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (delayTimeMin)
      int delayTimeMin = (int) _value.getStruct().get("delayTimeMin").getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt(
          "", 16, ((Number) (delayTimeMin)).intValue());
      // Simple Field (dhwMode)
      short dhwMode = (short) _value.getStruct().get("dhwMode").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (dhwMode)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OccModeNext)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (delayTimeMin)
      int delayTimeMin = (int) _value.getStruct().get("delayTimeMin").getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt(
          "", 16, ((Number) (delayTimeMin)).intValue());
      // Simple Field (occupancyMode)
      short occupancyMode = (short) _value.getStruct().get("occupancyMode").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (occupancyMode)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_BuildingModeNext)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (delayTimeMin)
      int delayTimeMin = (int) _value.getStruct().get("delayTimeMin").getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt(
          "", 16, ((Number) (delayTimeMin)).intValue());
      // Simple Field (buildingMode)
      short buildingMode = (short) _value.getStruct().get("buildingMode").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (buildingMode)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_StatusLightingActuator)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (validactualvalue)
      boolean validactualvalue = (boolean) _value.getStruct().get("validactualvalue").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (validactualvalue));
      // Simple Field (locked)
      boolean locked = (boolean) _value.getStruct().get("locked").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (locked));
      // Simple Field (forced)
      boolean forced = (boolean) _value.getStruct().get("forced").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (forced));
      // Simple Field (nightmodeactive)
      boolean nightmodeactive = (boolean) _value.getStruct().get("nightmodeactive").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (nightmodeactive));
      // Simple Field (staircaselightingFunction)
      boolean staircaselightingFunction =
          (boolean) _value.getStruct().get("staircaselightingFunction").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (staircaselightingFunction));
      // Simple Field (dimming)
      boolean dimming = (boolean) _value.getStruct().get("dimming").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (dimming));
      // Simple Field (localoverride)
      boolean localoverride = (boolean) _value.getStruct().get("localoverride").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (localoverride));
      // Simple Field (failure)
      boolean failure = (boolean) _value.getStruct().get("failure").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (failure));
      // Simple Field (actualvalue)
      short actualvalue = (short) _value.getStruct().get("actualvalue").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (actualvalue)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Version)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (magicNumber)
      short magicNumber = (short) _value.getStruct().get("magicNumber").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (magicNumber)).shortValue());
      // Simple Field (versionNumber)
      short versionNumber = (short) _value.getStruct().get("versionNumber").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (versionNumber)).shortValue());
      // Simple Field (revisionNumber)
      short revisionNumber = (short) _value.getStruct().get("revisionNumber").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (revisionNumber)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_AlarmInfo)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (logNumber)
      short logNumber = (short) _value.getStruct().get("logNumber").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (logNumber)).shortValue());
      // Simple Field (alarmPriority)
      short alarmPriority = (short) _value.getStruct().get("alarmPriority").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (alarmPriority)).shortValue());
      // Simple Field (applicationArea)
      short applicationArea = (short) _value.getStruct().get("applicationArea").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (applicationArea)).shortValue());
      // Simple Field (errorClass)
      short errorClass = (short) _value.getStruct().get("errorClass").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (errorClass)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (errorcodeSup)
      boolean errorcodeSup = (boolean) _value.getStruct().get("errorcodeSup").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (errorcodeSup));
      // Simple Field (alarmtextSup)
      boolean alarmtextSup = (boolean) _value.getStruct().get("alarmtextSup").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (alarmtextSup));
      // Simple Field (timestampSup)
      boolean timestampSup = (boolean) _value.getStruct().get("timestampSup").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (timestampSup));
      // Simple Field (ackSup)
      boolean ackSup = (boolean) _value.getStruct().get("ackSup").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (ackSup));
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (short) 0x00).shortValue());
      // Simple Field (locked)
      boolean locked = (boolean) _value.getStruct().get("locked").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (locked));
      // Simple Field (alarmunack)
      boolean alarmunack = (boolean) _value.getStruct().get("alarmunack").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (alarmunack));
      // Simple Field (inalarm)
      boolean inalarm = (boolean) _value.getStruct().get("inalarm").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (inalarm));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetF16_3)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (tempsetpcomf)
      float tempsetpcomf = (float) _value.getStruct().get("tempsetpcomf").getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (tempsetpcomf));
      // Simple Field (tempsetpstdby)
      float tempsetpstdby = (float) _value.getStruct().get("tempsetpstdby").getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (tempsetpstdby));
      // Simple Field (tempsetpeco)
      float tempsetpeco = (float) _value.getStruct().get("tempsetpeco").getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (tempsetpeco));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetShiftF16_3)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (tempsetpshiftcomf)
      float tempsetpshiftcomf = (float) _value.getStruct().get("tempsetpshiftcomf").getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (tempsetpshiftcomf));
      // Simple Field (tempsetpshiftstdby)
      float tempsetpshiftstdby = (float) _value.getStruct().get("tempsetpshiftstdby").getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (tempsetpshiftstdby));
      // Simple Field (tempsetpshifteco)
      float tempsetpshifteco = (float) _value.getStruct().get("tempsetpshifteco").getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (tempsetpshifteco));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Scaling_Speed)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (timePeriod)
      int timePeriod = (int) _value.getStruct().get("timePeriod").getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (timePeriod)).intValue());
      // Simple Field (percent)
      short percent = (short) _value.getStruct().get("percent").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (percent)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Scaling_Step_Time)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (timePeriod)
      int timePeriod = (int) _value.getStruct().get("timePeriod").getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (timePeriod)).intValue());
      // Simple Field (percent)
      short percent = (short) _value.getStruct().get("percent").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (percent)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_MeteringValue)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (countval)
      int countval = (int) _value.getStruct().get("countval").getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeInt("", 32, ((Number) (countval)).intValue());
      // Simple Field (valinffield)
      short valinffield = (short) _value.getStruct().get("valinffield").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (valinffield)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 3, ((Number) (byte) 0x00).byteValue());
      // Simple Field (alarmunack)
      boolean alarmunack = (boolean) _value.getStruct().get("alarmunack").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (alarmunack));
      // Simple Field (inalarm)
      boolean inalarm = (boolean) _value.getStruct().get("inalarm").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (inalarm));
      // Simple Field (overridden)
      boolean overridden = (boolean) _value.getStruct().get("overridden").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (overridden));
      // Simple Field (fault)
      boolean fault = (boolean) _value.getStruct().get("fault").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (fault));
      // Simple Field (outofservice)
      boolean outofservice = (boolean) _value.getStruct().get("outofservice").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (outofservice));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_MBus_Address)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (manufactid)
      int manufactid = (int) _value.getStruct().get("manufactid").getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (manufactid)).intValue());
      // Simple Field (identnumber)
      long identnumber = (long) _value.getStruct().get("identnumber").getLong();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedLong(
          "", 32, ((Number) (identnumber)).longValue());
      // Simple Field (version)
      short version = (short) _value.getStruct().get("version").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (version)).shortValue());
      // Simple Field (medium)
      short medium = (short) _value.getStruct().get("medium").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (medium)).shortValue());
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Colour_RGB)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (r)
      short r = (short) _value.getStruct().get("r").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (r)).shortValue());
      // Simple Field (g)
      short g = (short) _value.getStruct().get("g").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (g)).shortValue());
      // Simple Field (b)
      short b = (short) _value.getStruct().get("b").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (b)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LanguageCodeAlpha2_ASCII)) { // STRING
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (value)
      String value = (String) _value.getString();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeString("", 16, "ASCII", (String) (value));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Tariff_ActiveEnergy)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (activeelectricalenergy)
      int activeelectricalenergy = (int) _value.getStruct().get("activeelectricalenergy").getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeInt(
          "", 32, ((Number) (activeelectricalenergy)).intValue());
      // Simple Field (tariff)
      short tariff = (short) _value.getStruct().get("tariff").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (tariff)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (electricalengergyvalidity)
      boolean electricalengergyvalidity =
          (boolean) _value.getStruct().get("electricalengergyvalidity").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (electricalengergyvalidity));
      // Simple Field (tariffvalidity)
      boolean tariffvalidity = (boolean) _value.getStruct().get("tariffvalidity").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (tariffvalidity));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Prioritised_Mode_Control)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (deactivationOfPriority)
      boolean deactivationOfPriority =
          (boolean) _value.getStruct().get("deactivationOfPriority").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (deactivationOfPriority));
      // Simple Field (priorityLevel)
      byte priorityLevel = (byte) _value.getStruct().get("priorityLevel").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte(
          "", 3, ((Number) (priorityLevel)).byteValue());
      // Simple Field (modeLevel)
      byte modeLevel = (byte) _value.getStruct().get("modeLevel").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (modeLevel)).byteValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DALI_Control_Gear_Diagnostic)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (short) 0x00).shortValue());
      // Simple Field (convertorError)
      boolean convertorError = (boolean) _value.getStruct().get("convertorError").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (convertorError));
      // Simple Field (ballastFailure)
      boolean ballastFailure = (boolean) _value.getStruct().get("ballastFailure").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (ballastFailure));
      // Simple Field (lampFailure)
      boolean lampFailure = (boolean) _value.getStruct().get("lampFailure").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (lampFailure));
      // Simple Field (readOrResponse)
      boolean readOrResponse = (boolean) _value.getStruct().get("readOrResponse").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (readOrResponse));
      // Simple Field (addressIndicator)
      boolean addressIndicator = (boolean) _value.getStruct().get("addressIndicator").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (addressIndicator));
      // Simple Field (daliDeviceAddressOrDaliGroupAddress)
      short daliDeviceAddressOrDaliGroupAddress =
          (short) _value.getStruct().get("daliDeviceAddressOrDaliGroupAddress").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (daliDeviceAddressOrDaliGroupAddress)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DALI_Diagnostics)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (ballastFailure)
      boolean ballastFailure = (boolean) _value.getStruct().get("ballastFailure").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (ballastFailure));
      // Simple Field (lampFailure)
      boolean lampFailure = (boolean) _value.getStruct().get("lampFailure").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (lampFailure));
      // Simple Field (deviceAddress)
      short deviceAddress = (short) _value.getStruct().get("deviceAddress").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (deviceAddress)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedPosition)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (heightPosition)
      short heightPosition = (short) _value.getStruct().get("heightPosition").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (heightPosition)).shortValue());
      // Simple Field (slatsPosition)
      short slatsPosition = (short) _value.getStruct().get("slatsPosition").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (slatsPosition)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (validityHeightPosition)
      boolean validityHeightPosition =
          (boolean) _value.getStruct().get("validityHeightPosition").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (validityHeightPosition));
      // Simple Field (validitySlatsPosition)
      boolean validitySlatsPosition =
          (boolean) _value.getStruct().get("validitySlatsPosition").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (validitySlatsPosition));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusSAB)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (heightPosition)
      short heightPosition = (short) _value.getStruct().get("heightPosition").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (heightPosition)).shortValue());
      // Simple Field (slatsPosition)
      short slatsPosition = (short) _value.getStruct().get("slatsPosition").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (slatsPosition)).shortValue());
      // Simple Field (upperEndPosReached)
      boolean upperEndPosReached =
          (boolean) _value.getStruct().get("upperEndPosReached").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (upperEndPosReached));
      // Simple Field (lowerEndPosReached)
      boolean lowerEndPosReached =
          (boolean) _value.getStruct().get("lowerEndPosReached").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (lowerEndPosReached));
      // Simple Field (lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent)
      boolean lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent =
          (boolean)
              _value
                  .getStruct()
                  .get("lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent")
                  .getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit(
          "", (boolean) (lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent));
      // Simple Field (targetPosDrive)
      boolean targetPosDrive = (boolean) _value.getStruct().get("targetPosDrive").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (targetPosDrive));
      // Simple Field (restrictionOfTargetHeightPosPosCanNotBeReached)
      boolean restrictionOfTargetHeightPosPosCanNotBeReached =
          (boolean)
              _value.getStruct().get("restrictionOfTargetHeightPosPosCanNotBeReached").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit(
          "", (boolean) (restrictionOfTargetHeightPosPosCanNotBeReached));
      // Simple Field (restrictionOfSlatsHeightPosPosCanNotBeReached)
      boolean restrictionOfSlatsHeightPosPosCanNotBeReached =
          (boolean)
              _value.getStruct().get("restrictionOfSlatsHeightPosPosCanNotBeReached").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit(
          "", (boolean) (restrictionOfSlatsHeightPosPosCanNotBeReached));
      // Simple Field (atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm)
      boolean atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm =
          (boolean)
              _value
                  .getStruct()
                  .get("atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm")
                  .getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit(
          "", (boolean) (atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm));
      // Simple Field (upDownPositionIsForcedByMoveupdownforcedInput)
      boolean upDownPositionIsForcedByMoveupdownforcedInput =
          (boolean)
              _value.getStruct().get("upDownPositionIsForcedByMoveupdownforcedInput").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit(
          "", (boolean) (upDownPositionIsForcedByMoveupdownforcedInput));
      // Simple Field (movementIsLockedEGByDevicelockedInput)
      boolean movementIsLockedEGByDevicelockedInput =
          (boolean) _value.getStruct().get("movementIsLockedEGByDevicelockedInput").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit(
          "", (boolean) (movementIsLockedEGByDevicelockedInput));
      // Simple Field (actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface)
      boolean actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface =
          (boolean)
              _value
                  .getStruct()
                  .get("actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface")
                  .getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit(
          "", (boolean) (actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface));
      // Simple Field (generalFailureOfTheActuatorOrTheDrive)
      boolean generalFailureOfTheActuatorOrTheDrive =
          (boolean) _value.getStruct().get("generalFailureOfTheActuatorOrTheDrive").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit(
          "", (boolean) (generalFailureOfTheActuatorOrTheDrive));
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 3, ((Number) (byte) 0x00).byteValue());
      // Simple Field (validityHeightPos)
      boolean validityHeightPos =
          (boolean) _value.getStruct().get("validityHeightPos").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (validityHeightPos));
      // Simple Field (validitySlatsPos)
      boolean validitySlatsPos = (boolean) _value.getStruct().get("validitySlatsPos").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (validitySlatsPos));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Colour_xyY)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (xAxis)
      int xAxis = (int) _value.getStruct().get("xAxis").getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (xAxis)).intValue());
      // Simple Field (yAxis)
      int yAxis = (int) _value.getStruct().get("yAxis").getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (yAxis)).intValue());
      // Simple Field (brightness)
      short brightness = (short) _value.getStruct().get("brightness").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (brightness)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (validityXy)
      boolean validityXy = (boolean) _value.getStruct().get("validityXy").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (validityXy));
      // Simple Field (validityBrightness)
      boolean validityBrightness =
          (boolean) _value.getStruct().get("validityBrightness").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (validityBrightness));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Converter_Status)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (converterModeAccordingToTheDaliConverterStateMachine)
      byte converterModeAccordingToTheDaliConverterStateMachine =
          (byte)
              _value
                  .getStruct()
                  .get("converterModeAccordingToTheDaliConverterStateMachine")
                  .getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte(
          "", 4, ((Number) (converterModeAccordingToTheDaliConverterStateMachine)).byteValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (byte) 0x00).byteValue());
      // Simple Field (hardwiredSwitchIsActive)
      boolean hardwiredSwitchIsActive =
          (boolean) _value.getStruct().get("hardwiredSwitchIsActive").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (hardwiredSwitchIsActive));
      // Simple Field (hardwiredInhibitIsActive)
      boolean hardwiredInhibitIsActive =
          (boolean) _value.getStruct().get("hardwiredInhibitIsActive").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (hardwiredInhibitIsActive));
      // Simple Field (functionTestPending)
      byte functionTestPending = (byte) _value.getStruct().get("functionTestPending").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte(
          "", 2, ((Number) (functionTestPending)).byteValue());
      // Simple Field (durationTestPending)
      byte durationTestPending = (byte) _value.getStruct().get("durationTestPending").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte(
          "", 2, ((Number) (durationTestPending)).byteValue());
      // Simple Field (partialDurationTestPending)
      byte partialDurationTestPending =
          (byte) _value.getStruct().get("partialDurationTestPending").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte(
          "", 2, ((Number) (partialDurationTestPending)).byteValue());
      // Simple Field (converterFailure)
      byte converterFailure = (byte) _value.getStruct().get("converterFailure").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte(
          "", 2, ((Number) (converterFailure)).byteValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Converter_Test_Result)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (ltrf)
      byte ltrf = (byte) _value.getStruct().get("ltrf").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (ltrf)).byteValue());
      // Simple Field (ltrd)
      byte ltrd = (byte) _value.getStruct().get("ltrd").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (ltrd)).byteValue());
      // Simple Field (ltrp)
      byte ltrp = (byte) _value.getStruct().get("ltrp").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (ltrp)).byteValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (sf)
      byte sf = (byte) _value.getStruct().get("sf").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (sf)).byteValue());
      // Simple Field (sd)
      byte sd = (byte) _value.getStruct().get("sd").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (sd)).byteValue());
      // Simple Field (sp)
      byte sp = (byte) _value.getStruct().get("sp").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (sp)).byteValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 2, ((Number) (byte) 0x00).byteValue());
      // Simple Field (ldtr)
      int ldtr = (int) _value.getStruct().get("ldtr").getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (ldtr)).intValue());
      // Simple Field (lpdtr)
      short lpdtr = (short) _value.getStruct().get("lpdtr").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (lpdtr)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Battery_Info)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (short) 0x00).shortValue());
      // Simple Field (batteryFailure)
      boolean batteryFailure = (boolean) _value.getStruct().get("batteryFailure").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (batteryFailure));
      // Simple Field (batteryDurationFailure)
      boolean batteryDurationFailure =
          (boolean) _value.getStruct().get("batteryDurationFailure").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (batteryDurationFailure));
      // Simple Field (batteryFullyCharged)
      boolean batteryFullyCharged =
          (boolean) _value.getStruct().get("batteryFullyCharged").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (batteryFullyCharged));
      // Simple Field (batteryChargeLevel)
      short batteryChargeLevel = (short) _value.getStruct().get("batteryChargeLevel").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (batteryChargeLevel)).shortValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Brightness_Colour_Temperature_Transition)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (ms)
      int ms = (int) _value.getStruct().get("ms").getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt("", 16, ((Number) (ms)).intValue());
      // Simple Field (temperatureK)
      int temperatureK = (int) _value.getStruct().get("temperatureK").getInt();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedInt(
          "", 16, ((Number) (temperatureK)).intValue());
      // Simple Field (percent)
      short percent = (short) _value.getStruct().get("percent").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort("", 8, ((Number) (percent)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 5, ((Number) (short) 0x00).shortValue());
      // Simple Field (validityOfTheTimePeriod)
      boolean validityOfTheTimePeriod =
          (boolean) _value.getStruct().get("validityOfTheTimePeriod").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (validityOfTheTimePeriod));
      // Simple Field (validityOfTheAbsoluteColourTemperature)
      boolean validityOfTheAbsoluteColourTemperature =
          (boolean) _value.getStruct().get("validityOfTheAbsoluteColourTemperature").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit(
          "", (boolean) (validityOfTheAbsoluteColourTemperature));
      // Simple Field (validityOfTheAbsoluteBrightness)
      boolean validityOfTheAbsoluteBrightness =
          (boolean) _value.getStruct().get("validityOfTheAbsoluteBrightness").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (validityOfTheAbsoluteBrightness));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Brightness_Colour_Temperature_Control)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (cct)
      boolean cct = (boolean) _value.getStruct().get("cct").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (cct));
      // Simple Field (stepCodeColourTemperature)
      byte stepCodeColourTemperature =
          (byte) _value.getStruct().get("stepCodeColourTemperature").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte(
          "", 3, ((Number) (stepCodeColourTemperature)).byteValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (cb)
      boolean cb = (boolean) _value.getStruct().get("cb").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (cb));
      // Simple Field (stepCodeBrightness)
      byte stepCodeBrightness = (byte) _value.getStruct().get("stepCodeBrightness").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte(
          "", 3, ((Number) (stepCodeBrightness)).byteValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 6, ((Number) (short) 0x00).shortValue());
      // Simple Field (cctAndStepCodeColourValidity)
      boolean cctAndStepCodeColourValidity =
          (boolean) _value.getStruct().get("cctAndStepCodeColourValidity").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (cctAndStepCodeColourValidity));
      // Simple Field (cbAndStepCodeBrightnessValidity)
      boolean cbAndStepCodeBrightnessValidity =
          (boolean) _value.getStruct().get("cbAndStepCodeBrightnessValidity").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (cbAndStepCodeBrightnessValidity));
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Colour_RGBW)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (colourLevelRed)
      short colourLevelRed = (short) _value.getStruct().get("colourLevelRed").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (colourLevelRed)).shortValue());
      // Simple Field (colourLevelGreen)
      short colourLevelGreen = (short) _value.getStruct().get("colourLevelGreen").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (colourLevelGreen)).shortValue());
      // Simple Field (colourLevelBlue)
      short colourLevelBlue = (short) _value.getStruct().get("colourLevelBlue").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (colourLevelBlue)).shortValue());
      // Simple Field (colourLevelWhite)
      short colourLevelWhite = (short) _value.getStruct().get("colourLevelWhite").getShort();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (colourLevelWhite)).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (mr)
      boolean mr = (boolean) _value.getStruct().get("mr").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (mr));
      // Simple Field (mg)
      boolean mg = (boolean) _value.getStruct().get("mg").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (mg));
      // Simple Field (mb)
      boolean mb = (boolean) _value.getStruct().get("mb").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (mb));
      // Simple Field (mw)
      boolean mw = (boolean) _value.getStruct().get("mw").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (mw));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Relative_Control_RGBW)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (maskcw)
      boolean maskcw = (boolean) _value.getStruct().get("maskcw").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskcw));
      // Simple Field (maskcb)
      boolean maskcb = (boolean) _value.getStruct().get("maskcb").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskcb));
      // Simple Field (maskcg)
      boolean maskcg = (boolean) _value.getStruct().get("maskcg").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskcg));
      // Simple Field (maskcr)
      boolean maskcr = (boolean) _value.getStruct().get("maskcr").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (maskcr));
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (cw)
      boolean cw = (boolean) _value.getStruct().get("cw").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (cw));
      // Simple Field (stepCodeColourWhite)
      byte stepCodeColourWhite = (byte) _value.getStruct().get("stepCodeColourWhite").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte(
          "", 3, ((Number) (stepCodeColourWhite)).byteValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (cb)
      boolean cb = (boolean) _value.getStruct().get("cb").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (cb));
      // Simple Field (stepCodeColourBlue)
      byte stepCodeColourBlue = (byte) _value.getStruct().get("stepCodeColourBlue").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte(
          "", 3, ((Number) (stepCodeColourBlue)).byteValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (cg)
      boolean cg = (boolean) _value.getStruct().get("cg").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (cg));
      // Simple Field (stepCodeColourGreen)
      byte stepCodeColourGreen = (byte) _value.getStruct().get("stepCodeColourGreen").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte(
          "", 3, ((Number) (stepCodeColourGreen)).byteValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (cr)
      boolean cr = (boolean) _value.getStruct().get("cr").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (cr));
      // Simple Field (stepCodeColourRed)
      byte stepCodeColourRed = (byte) _value.getStruct().get("stepCodeColourRed").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte(
          "", 3, ((Number) (stepCodeColourRed)).byteValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Relative_Control_RGB)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (cb)
      boolean cb = (boolean) _value.getStruct().get("cb").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (cb));
      // Simple Field (stepCodeColourBlue)
      byte stepCodeColourBlue = (byte) _value.getStruct().get("stepCodeColourBlue").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte(
          "", 3, ((Number) (stepCodeColourBlue)).byteValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (cg)
      boolean cg = (boolean) _value.getStruct().get("cg").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (cg));
      // Simple Field (stepCodeColourGreen)
      byte stepCodeColourGreen = (byte) _value.getStruct().get("stepCodeColourGreen").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte(
          "", 3, ((Number) (stepCodeColourGreen)).byteValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
      // Simple Field (cr)
      boolean cr = (boolean) _value.getStruct().get("cr").getBoolean();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeBit("", (boolean) (cr));
      // Simple Field (stepCodeColourRed)
      byte stepCodeColourRed = (byte) _value.getStruct().get("stepCodeColourRed").getByte();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte(
          "", 3, ((Number) (stepCodeColourRed)).byteValue());
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedByte("", 4, ((Number) (byte) 0x00).byteValue());
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_GeographicalLocation)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (longitude)
      float longitude = (float) _value.getStruct().get("longitude").getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (longitude));
      // Simple Field (latitude)
      float latitude = (float) _value.getStruct().get("latitude").getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 32, (latitude));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetF16_4)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (roomTemperatureSetpointComfort)
      float roomTemperatureSetpointComfort =
          (float) _value.getStruct().get("roomTemperatureSetpointComfort").getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (roomTemperatureSetpointComfort));
      // Simple Field (roomTemperatureSetpointStandby)
      float roomTemperatureSetpointStandby =
          (float) _value.getStruct().get("roomTemperatureSetpointStandby").getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (roomTemperatureSetpointStandby));
      // Simple Field (roomTemperatureSetpointEconomy)
      float roomTemperatureSetpointEconomy =
          (float) _value.getStruct().get("roomTemperatureSetpointEconomy").getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (roomTemperatureSetpointEconomy));
      // Simple Field (roomTemperatureSetpointBuildingProtection)
      float roomTemperatureSetpointBuildingProtection =
          (float) _value.getStruct().get("roomTemperatureSetpointBuildingProtection").getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat(
          "", 16, (roomTemperatureSetpointBuildingProtection));
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetShiftF16_4)) { // Struct
      // Reserved Field
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeUnsignedShort(
          "", 8, ((Number) (short) 0x00).shortValue());
      // Simple Field (roomTemperatureSetpointShiftComfort)
      float roomTemperatureSetpointShiftComfort =
          (float) _value.getStruct().get("roomTemperatureSetpointShiftComfort").getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (roomTemperatureSetpointShiftComfort));
      // Simple Field (roomTemperatureSetpointShiftStandby)
      float roomTemperatureSetpointShiftStandby =
          (float) _value.getStruct().get("roomTemperatureSetpointShiftStandby").getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (roomTemperatureSetpointShiftStandby));
      // Simple Field (roomTemperatureSetpointShiftEconomy)
      float roomTemperatureSetpointShiftEconomy =
          (float) _value.getStruct().get("roomTemperatureSetpointShiftEconomy").getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat("", 16, (roomTemperatureSetpointShiftEconomy));
      // Simple Field (roomTemperatureSetpointShiftBuildingProtection)
      float roomTemperatureSetpointShiftBuildingProtection =
          (float)
              _value.getStruct().get("roomTemperatureSetpointShiftBuildingProtection").getFloat();
      /*TODO: migrate me*/
      /*TODO: migrate me*/ writeBuffer.writeFloat(
          "", 16, (roomTemperatureSetpointShiftBuildingProtection));
    }
  }

  public static int getLengthInBytes(PlcValue _value, KnxDatapointType datapointType) {
    return (int) Math.ceil((float) getLengthInBits(_value, datapointType) / 8.0);
  }

  public static int getLengthInBits(PlcValue _value, KnxDatapointType datapointType) {
    int sizeInBits = 0;
    if (EvaluationHelper.equals(datapointType, KnxDatapointType.BOOL)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.BYTE)) { // BYTE
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.WORD)) { // WORD
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DWORD)) { // DWORD
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LWORD)) { // LWORD
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 64;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.USINT)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.SINT)) { // SINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.UINT)) { // UINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.INT)) { // INT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.UDINT)) { // UDINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DINT)) { // DINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.ULINT)) { // ULINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 64;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LINT)) { // LINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 64;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.REAL)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LREAL)) { // LREAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 64;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.CHAR)) { // CHAR
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.WCHAR)) { // WCHAR
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.TIME)) { // TIME
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.LTIME)) { // LTIME
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 64;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DATE)) { // DATE
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.TIME_OF_DAY)) { // TIME_OF_DAY
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.TOD)) { // TIME_OF_DAY
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DATE_AND_TIME)) { // DATE_AND_TIME
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (year)
      sizeInBits += 16;
      // Simple Field (month)
      sizeInBits += 8;
      // Simple Field (day)
      sizeInBits += 8;
      // Simple Field (dayOfWeek)
      sizeInBits += 8;
      // Simple Field (hour)
      sizeInBits += 8;
      // Simple Field (minutes)
      sizeInBits += 8;
      // Simple Field (seconds)
      sizeInBits += 8;
      // Simple Field (nanos)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DT)) { // DATE_AND_TIME
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (year)
      sizeInBits += 16;
      // Simple Field (month)
      sizeInBits += 8;
      // Simple Field (day)
      sizeInBits += 8;
      // Simple Field (dayOfWeek)
      sizeInBits += 8;
      // Simple Field (hour)
      sizeInBits += 8;
      // Simple Field (minutes)
      sizeInBits += 8;
      // Simple Field (seconds)
      sizeInBits += 8;
      // Simple Field (nanos)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Switch)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Bool)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Enable)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Ramp)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Alarm)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BinaryValue)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Step)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_UpDown)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OpenClose)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Start)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_State)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Invert)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DimSendStyle)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_InputSource)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Reset)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Ack)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Trigger)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Occupancy)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Window_Door)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LogicalFunction)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Scene_AB)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ShutterBlinds_Mode)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DayNight)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Heat_Cool)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Switch_Control)) { // Struct
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (control)
      sizeInBits += 1;
      // Simple Field (on)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Bool_Control)) { // Struct
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (control)
      sizeInBits += 1;
      // Simple Field (valueTrue)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Enable_Control)) { // Struct
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (control)
      sizeInBits += 1;
      // Simple Field (enable)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Ramp_Control)) { // Struct
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (control)
      sizeInBits += 1;
      // Simple Field (ramp)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Alarm_Control)) { // Struct
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (control)
      sizeInBits += 1;
      // Simple Field (alarm)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_BinaryValue_Control)) { // Struct
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (control)
      sizeInBits += 1;
      // Simple Field (high)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Step_Control)) { // Struct
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (control)
      sizeInBits += 1;
      // Simple Field (increase)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Direction1_Control)) { // Struct
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (control)
      sizeInBits += 1;
      // Simple Field (down)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Direction2_Control)) { // Struct
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (control)
      sizeInBits += 1;
      // Simple Field (close)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Start_Control)) { // Struct
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (control)
      sizeInBits += 1;
      // Simple Field (start)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_State_Control)) { // Struct
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (control)
      sizeInBits += 1;
      // Simple Field (active)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Invert_Control)) { // Struct
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (control)
      sizeInBits += 1;
      // Simple Field (inverted)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Control_Dimming)) { // Struct
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (increase)
      sizeInBits += 1;
      // Simple Field (stepcode)
      sizeInBits += 3;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Control_Blinds)) { // Struct
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (down)
      sizeInBits += 1;
      // Simple Field (stepcode)
      sizeInBits += 3;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Char_ASCII)) { // STRING
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Char_8859_1)) { // STRING
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Scaling)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Angle)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_U8)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DecimalFactor)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Tariff)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_1_Ucount)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FanStage)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_V8)) { // SINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_1_Count)) { // SINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Status_Mode3)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (statusA)
      sizeInBits += 1;
      // Simple Field (statusB)
      sizeInBits += 1;
      // Simple Field (statusC)
      sizeInBits += 1;
      // Simple Field (statusD)
      sizeInBits += 1;
      // Simple Field (statusE)
      sizeInBits += 1;
      // Simple Field (mode)
      sizeInBits += 3;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_2_Ucount)) { // UINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriodMsec)) { // UINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriod10Msec)) { // UINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TimePeriod100Msec)) { // UINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodSec)) { // UINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodMin)) { // UINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimePeriodHrs)) { // UINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PropDataType)) { // UINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Length_mm)) { // UINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_UElCurrentmA)) { // UINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Brightness)) { // UINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Absolute_Colour_Temperature)) { // UINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_2_Count)) { // INT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeMsec)) { // INT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaTime10Msec)) { // INT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaTime100Msec)) { // INT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeSec)) { // INT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeMin)) { // INT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DeltaTimeHrs)) { // INT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Percent_V16)) { // INT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Rotation_Angle)) { // INT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Length_m)) { // INT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Temp)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Tempd)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Tempa)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Lux)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Wsp)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Pres)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Humidity)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AirQuality)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_AirFlow)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time1)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time2)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Volt)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Curr)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PowerDensity)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_KelvinPerPercent)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Power)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Volume_Flow)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Rain_Amount)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Temp_F)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Wsp_kmh)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Absolute_Humidity)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Concentration_ygm3)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_TimeOfDay)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (day)
      sizeInBits += 3;
      // Simple Field (hour)
      sizeInBits += 5;
      // Reserved Field
      sizeInBits += 2;
      // Simple Field (minutes)
      sizeInBits += 6;
      // Reserved Field
      sizeInBits += 2;
      // Simple Field (seconds)
      sizeInBits += 6;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Date)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 3;
      // Simple Field (dayOfMonth)
      sizeInBits += 5;
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (month)
      sizeInBits += 4;
      // Reserved Field
      sizeInBits += 1;
      // Simple Field (year)
      sizeInBits += 7;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_4_Ucount)) { // UDINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Sec)) { // UDINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Min)) { // UDINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongTimePeriod_Hrs)) { // UDINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_VolumeLiquid_Litre)) { // UDINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Volume_m_3)) { // UDINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_4_Count)) { // DINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FlowRate_m3h)) { // DINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ActiveEnergy)) { // DINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy)) { // DINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy)) { // DINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_kWh)) { // DINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy_kVAh)) { // DINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy_kVARh)) { // DINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_MWh)) { // DINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LongDeltaTimeSec)) { // DINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaVolumeLiquid_Litre)) { // DINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DeltaVolume_m_3)) { // DINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Acceleration)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Acceleration_Angular)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Activation_Energy)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Activity)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Mol)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Amplitude)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AngleRad)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_AngleDeg)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Momentum)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Velocity)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Area)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Capacitance)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Charge_DensitySurface)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Charge_DensityVolume)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Compressibility)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Conductance)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electrical_Conductivity)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Density)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Charge)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Current)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_CurrentDensity)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_DipoleMoment)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Displacement)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_FieldStrength)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Flux)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_FluxDensity)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Polarization)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_Potential)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electric_PotentialDifference)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_ElectromagneticMoment)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Electromotive_Force)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Energy)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Force)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Frequency)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Angular_Frequency)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_Capacity)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_FlowRate)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Heat_Quantity)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Impedance)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Length)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Light_Quantity)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminance)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminous_Flux)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Luminous_Intensity)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_FieldStrength)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Flux)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_FluxDensity)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Moment)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetic_Polarization)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Magnetization)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_MagnetomotiveForce)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Mass)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_MassFlux)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Momentum)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Phase_AngleRad)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Phase_AngleDeg)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Power)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Power_Factor)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Pressure)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Reactance)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Resistance)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Resistivity)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_SelfInductance)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_SolidAngle)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Sound_Intensity)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Speed)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Stress)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Surface_Tension)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Common_Temperature)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Absolute_Temperature)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_TemperatureDifference)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Thermal_Capacity)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Thermal_Conductivity)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_ThermoelectricPower)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Time)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Torque)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Volume)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Value_Volume_Flux)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Weight)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Value_Work)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Volume_Flux_Meter)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Volume_Flux_ls)) { // REAL
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Access_Data)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (hurz)
      sizeInBits += 4;
      // Simple Field (value1)
      sizeInBits += 4;
      // Simple Field (value2)
      sizeInBits += 4;
      // Simple Field (value3)
      sizeInBits += 4;
      // Simple Field (value4)
      sizeInBits += 4;
      // Simple Field (value5)
      sizeInBits += 4;
      // Simple Field (detectionError)
      sizeInBits += 1;
      // Simple Field (permission)
      sizeInBits += 1;
      // Simple Field (readDirection)
      sizeInBits += 1;
      // Simple Field (encryptionOfAccessInformation)
      sizeInBits += 1;
      // Simple Field (indexOfAccessIdentificationCode)
      sizeInBits += 4;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_String_ASCII)) { // STRING
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 112;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_String_8859_1)) { // STRING
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 112;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SceneNumber)) { // USINT
      // Reserved Field
      sizeInBits += 2;
      // Simple Field (value)
      sizeInBits += 6;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SceneControl)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (learnTheSceneCorrespondingToTheFieldSceneNumber)
      sizeInBits += 1;
      // Reserved Field
      sizeInBits += 1;
      // Simple Field (sceneNumber)
      sizeInBits += 6;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DateTime)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (year)
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (month)
      sizeInBits += 4;
      // Reserved Field
      sizeInBits += 3;
      // Simple Field (dayofmonth)
      sizeInBits += 5;
      // Simple Field (dayofweek)
      sizeInBits += 3;
      // Simple Field (hourofday)
      sizeInBits += 5;
      // Reserved Field
      sizeInBits += 2;
      // Simple Field (minutes)
      sizeInBits += 6;
      // Reserved Field
      sizeInBits += 2;
      // Simple Field (seconds)
      sizeInBits += 6;
      // Simple Field (fault)
      sizeInBits += 1;
      // Simple Field (workingDay)
      sizeInBits += 1;
      // Simple Field (noWd)
      sizeInBits += 1;
      // Simple Field (noYear)
      sizeInBits += 1;
      // Simple Field (noDate)
      sizeInBits += 1;
      // Simple Field (noDayOfWeek)
      sizeInBits += 1;
      // Simple Field (noTime)
      sizeInBits += 1;
      // Simple Field (standardSummerTime)
      sizeInBits += 1;
      // Simple Field (qualityOfClock)
      sizeInBits += 1;
      // Reserved Field
      sizeInBits += 7;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SCLOMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BuildingMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OccMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Priority)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LightApplicationMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApplicationArea)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_AlarmClassType)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PSUMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ErrorClass_System)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ErrorClass_HVAC)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Time_Delay)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Beaufort_Wind_Force_Scale)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SensorSelect)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActuatorConnectType)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Cloud_Cover)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_PowerReturnMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FuelType)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BurnerType)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HVACMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DHWMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_LoadPriority)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVACContrMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVACEmergMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ChangeoverMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ValveMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DamperMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HeaterMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FanMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_MasterSlaveMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_StatusRoomSetp)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Metering_DeviceType)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_HumDehumMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_EnableHCStage)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ADAType)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BackupMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_StartSynchronization)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Behaviour_Lock_Unlock)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Behaviour_Bus_Power_Up_Down)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DALI_Fade_Time)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_BlinkingMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LightControlMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SwitchPBModel)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_PBAction)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DimmPBModel)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SwitchOnMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_LoadTypeSet)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LoadTypeDetected)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Converter_Test_Control)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SABExcept_Behaviour)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_SABBehaviour_Lock_Unlock)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SSSBMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_BlindsControlMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_CommMode)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_AddInfoTypes)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_RF_ModeSelect)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_RF_FilterSelect)) { // USINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusGen)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 3;
      // Simple Field (alarmStatusOfCorrespondingDatapointIsNotAcknowledged)
      sizeInBits += 1;
      // Simple Field (correspondingDatapointIsInAlarm)
      sizeInBits += 1;
      // Simple Field (correspondingDatapointMainValueIsOverridden)
      sizeInBits += 1;
      // Simple Field (correspondingDatapointMainValueIsCorruptedDueToFailure)
      sizeInBits += 1;
      // Simple Field (correspondingDatapointValueIsOutOfService)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Device_Control)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 5;
      // Simple Field (verifyModeIsOn)
      sizeInBits += 1;
      // Simple Field (aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived)
      sizeInBits += 1;
      // Simple Field (theUserApplicationIsStopped)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ForceSign)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (roomhmax)
      sizeInBits += 1;
      // Simple Field (roomhconf)
      sizeInBits += 1;
      // Simple Field (dhwlegio)
      sizeInBits += 1;
      // Simple Field (dhwnorm)
      sizeInBits += 1;
      // Simple Field (overrun)
      sizeInBits += 1;
      // Simple Field (oversupply)
      sizeInBits += 1;
      // Simple Field (protection)
      sizeInBits += 1;
      // Simple Field (forcerequest)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_ForceSignCool)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusRHC)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (summermode)
      sizeInBits += 1;
      // Simple Field (statusstopoptim)
      sizeInBits += 1;
      // Simple Field (statusstartoptim)
      sizeInBits += 1;
      // Simple Field (statusmorningboost)
      sizeInBits += 1;
      // Simple Field (tempreturnlimit)
      sizeInBits += 1;
      // Simple Field (tempflowlimit)
      sizeInBits += 1;
      // Simple Field (satuseco)
      sizeInBits += 1;
      // Simple Field (fault)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusSDHWC)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 5;
      // Simple Field (solarloadsufficient)
      sizeInBits += 1;
      // Simple Field (sdhwloadactive)
      sizeInBits += 1;
      // Simple Field (fault)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_FuelTypeSet)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 5;
      // Simple Field (solidstate)
      sizeInBits += 1;
      // Simple Field (gas)
      sizeInBits += 1;
      // Simple Field (oil)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusRCC)) { // BOOL
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (value)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusAHU)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (cool)
      sizeInBits += 1;
      // Simple Field (heat)
      sizeInBits += 1;
      // Simple Field (fanactive)
      sizeInBits += 1;
      // Simple Field (fault)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedStatus_RTSM)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 3;
      // Simple Field (statusOfHvacModeUser)
      sizeInBits += 1;
      // Simple Field (statusOfComfortProlongationUser)
      sizeInBits += 1;
      // Simple Field (effectiveValueOfTheComfortPushButton)
      sizeInBits += 1;
      // Simple Field (effectiveValueOfThePresenceStatus)
      sizeInBits += 1;
      // Simple Field (effectiveValueOfTheWindowStatus)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LightActuatorErrorInfo)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 1;
      // Simple Field (overheat)
      sizeInBits += 1;
      // Simple Field (lampfailure)
      sizeInBits += 1;
      // Simple Field (defectiveload)
      sizeInBits += 1;
      // Simple Field (underload)
      sizeInBits += 1;
      // Simple Field (overcurrent)
      sizeInBits += 1;
      // Simple Field (undervoltage)
      sizeInBits += 1;
      // Simple Field (loaddetectionerror)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_RF_ModeInfo)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 5;
      // Simple Field (bibatSlave)
      sizeInBits += 1;
      // Simple Field (bibatMaster)
      sizeInBits += 1;
      // Simple Field (asynchronous)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_RF_FilterInfo)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 5;
      // Simple Field (doa)
      sizeInBits += 1;
      // Simple Field (knxSn)
      sizeInBits += 1;
      // Simple Field (doaAndKnxSn)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Channel_Activation_8)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (activationStateOfChannel1)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel2)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel3)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel4)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel5)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel6)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel7)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel8)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusDHWC)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (tempoptimshiftactive)
      sizeInBits += 1;
      // Simple Field (solarenergysupport)
      sizeInBits += 1;
      // Simple Field (solarenergyonly)
      sizeInBits += 1;
      // Simple Field (otherenergysourceactive)
      sizeInBits += 1;
      // Simple Field (dhwpushactive)
      sizeInBits += 1;
      // Simple Field (legioprotactive)
      sizeInBits += 1;
      // Simple Field (dhwloadactive)
      sizeInBits += 1;
      // Simple Field (fault)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusRHCC)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 1;
      // Simple Field (overheatalarm)
      sizeInBits += 1;
      // Simple Field (frostalarm)
      sizeInBits += 1;
      // Simple Field (dewpointstatus)
      sizeInBits += 1;
      // Simple Field (coolingdisabled)
      sizeInBits += 1;
      // Simple Field (statusprecool)
      sizeInBits += 1;
      // Simple Field (statusecoc)
      sizeInBits += 1;
      // Simple Field (heatcoolmode)
      sizeInBits += 1;
      // Simple Field (heatingdiabled)
      sizeInBits += 1;
      // Simple Field (statusstopoptim)
      sizeInBits += 1;
      // Simple Field (statusstartoptim)
      sizeInBits += 1;
      // Simple Field (statusmorningboosth)
      sizeInBits += 1;
      // Simple Field (tempflowreturnlimit)
      sizeInBits += 1;
      // Simple Field (tempflowlimit)
      sizeInBits += 1;
      // Simple Field (statusecoh)
      sizeInBits += 1;
      // Simple Field (fault)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedStatus_HVA)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (calibrationMode)
      sizeInBits += 1;
      // Simple Field (lockedPosition)
      sizeInBits += 1;
      // Simple Field (forcedPosition)
      sizeInBits += 1;
      // Simple Field (manuaOperationOverridden)
      sizeInBits += 1;
      // Simple Field (serviceMode)
      sizeInBits += 1;
      // Simple Field (valveKick)
      sizeInBits += 1;
      // Simple Field (overload)
      sizeInBits += 1;
      // Simple Field (shortCircuit)
      sizeInBits += 1;
      // Simple Field (currentValvePosition)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedStatus_RTC)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 7;
      // Simple Field (coolingModeEnabled)
      sizeInBits += 1;
      // Simple Field (heatingModeEnabled)
      sizeInBits += 1;
      // Simple Field (additionalHeatingCoolingStage2Stage)
      sizeInBits += 1;
      // Simple Field (controllerInactive)
      sizeInBits += 1;
      // Simple Field (overheatAlarm)
      sizeInBits += 1;
      // Simple Field (frostAlarm)
      sizeInBits += 1;
      // Simple Field (dewPointStatus)
      sizeInBits += 1;
      // Simple Field (activeMode)
      sizeInBits += 1;
      // Simple Field (generalFailureInformation)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Media)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 10;
      // Simple Field (knxIp)
      sizeInBits += 1;
      // Simple Field (rf)
      sizeInBits += 1;
      // Reserved Field
      sizeInBits += 1;
      // Simple Field (pl110)
      sizeInBits += 1;
      // Simple Field (tp1)
      sizeInBits += 1;
      // Reserved Field
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Channel_Activation_16)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (activationStateOfChannel1)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel2)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel3)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel4)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel5)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel6)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel7)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel8)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel9)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel10)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel11)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel12)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel13)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel14)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel15)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel16)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OnOffAction)) { // USINT
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (value)
      sizeInBits += 2;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Alarm_Reaction)) { // USINT
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (value)
      sizeInBits += 2;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_UpDown_Action)) { // USINT
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (value)
      sizeInBits += 2;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVAC_PB_Action)) { // USINT
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (value)
      sizeInBits += 2;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DoubleNibble)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (busy)
      sizeInBits += 4;
      // Simple Field (nak)
      sizeInBits += 4;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_SceneInfo)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 1;
      // Simple Field (sceneIsInactive)
      sizeInBits += 1;
      // Simple Field (scenenumber)
      sizeInBits += 6;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedInfoOnOff)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (maskBitInfoOnOffOutput16)
      sizeInBits += 1;
      // Simple Field (maskBitInfoOnOffOutput15)
      sizeInBits += 1;
      // Simple Field (maskBitInfoOnOffOutput14)
      sizeInBits += 1;
      // Simple Field (maskBitInfoOnOffOutput13)
      sizeInBits += 1;
      // Simple Field (maskBitInfoOnOffOutput12)
      sizeInBits += 1;
      // Simple Field (maskBitInfoOnOffOutput11)
      sizeInBits += 1;
      // Simple Field (maskBitInfoOnOffOutput10)
      sizeInBits += 1;
      // Simple Field (maskBitInfoOnOffOutput9)
      sizeInBits += 1;
      // Simple Field (maskBitInfoOnOffOutput8)
      sizeInBits += 1;
      // Simple Field (maskBitInfoOnOffOutput7)
      sizeInBits += 1;
      // Simple Field (maskBitInfoOnOffOutput6)
      sizeInBits += 1;
      // Simple Field (maskBitInfoOnOffOutput5)
      sizeInBits += 1;
      // Simple Field (maskBitInfoOnOffOutput4)
      sizeInBits += 1;
      // Simple Field (maskBitInfoOnOffOutput3)
      sizeInBits += 1;
      // Simple Field (maskBitInfoOnOffOutput2)
      sizeInBits += 1;
      // Simple Field (maskBitInfoOnOffOutput1)
      sizeInBits += 1;
      // Simple Field (infoOnOffOutput16)
      sizeInBits += 1;
      // Simple Field (infoOnOffOutput15)
      sizeInBits += 1;
      // Simple Field (infoOnOffOutput14)
      sizeInBits += 1;
      // Simple Field (infoOnOffOutput13)
      sizeInBits += 1;
      // Simple Field (infoOnOffOutput12)
      sizeInBits += 1;
      // Simple Field (infoOnOffOutput11)
      sizeInBits += 1;
      // Simple Field (infoOnOffOutput10)
      sizeInBits += 1;
      // Simple Field (infoOnOffOutput9)
      sizeInBits += 1;
      // Simple Field (infoOnOffOutput8)
      sizeInBits += 1;
      // Simple Field (infoOnOffOutput7)
      sizeInBits += 1;
      // Simple Field (infoOnOffOutput6)
      sizeInBits += 1;
      // Simple Field (infoOnOffOutput5)
      sizeInBits += 1;
      // Simple Field (infoOnOffOutput4)
      sizeInBits += 1;
      // Simple Field (infoOnOffOutput3)
      sizeInBits += 1;
      // Simple Field (infoOnOffOutput2)
      sizeInBits += 1;
      // Simple Field (infoOnOffOutput1)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ActiveEnergy_V64)) { // LINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 64;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ApparantEnergy_V64)) { // LINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 64;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_ReactiveEnergy_V64)) { // LINT
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 64;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Channel_Activation_24)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (activationStateOfChannel1)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel2)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel3)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel4)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel5)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel6)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel7)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel8)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel9)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel10)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel11)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel12)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel13)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel14)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel15)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel16)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel17)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel18)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel19)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel20)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel21)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel22)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel23)
      sizeInBits += 1;
      // Simple Field (activationStateOfChannel24)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_HVACModeNext)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (delayTimeMin)
      sizeInBits += 16;
      // Simple Field (hvacMode)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_DHWModeNext)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (delayTimeMin)
      sizeInBits += 16;
      // Simple Field (dhwMode)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_OccModeNext)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (delayTimeMin)
      sizeInBits += 16;
      // Simple Field (occupancyMode)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_BuildingModeNext)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (delayTimeMin)
      sizeInBits += 16;
      // Simple Field (buildingMode)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_StatusLightingActuator)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (validactualvalue)
      sizeInBits += 1;
      // Simple Field (locked)
      sizeInBits += 1;
      // Simple Field (forced)
      sizeInBits += 1;
      // Simple Field (nightmodeactive)
      sizeInBits += 1;
      // Simple Field (staircaselightingFunction)
      sizeInBits += 1;
      // Simple Field (dimming)
      sizeInBits += 1;
      // Simple Field (localoverride)
      sizeInBits += 1;
      // Simple Field (failure)
      sizeInBits += 1;
      // Simple Field (actualvalue)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Version)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (magicNumber)
      sizeInBits += 5;
      // Simple Field (versionNumber)
      sizeInBits += 5;
      // Simple Field (revisionNumber)
      sizeInBits += 6;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_AlarmInfo)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (logNumber)
      sizeInBits += 8;
      // Simple Field (alarmPriority)
      sizeInBits += 8;
      // Simple Field (applicationArea)
      sizeInBits += 8;
      // Simple Field (errorClass)
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (errorcodeSup)
      sizeInBits += 1;
      // Simple Field (alarmtextSup)
      sizeInBits += 1;
      // Simple Field (timestampSup)
      sizeInBits += 1;
      // Simple Field (ackSup)
      sizeInBits += 1;
      // Reserved Field
      sizeInBits += 5;
      // Simple Field (locked)
      sizeInBits += 1;
      // Simple Field (alarmunack)
      sizeInBits += 1;
      // Simple Field (inalarm)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetF16_3)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (tempsetpcomf)
      sizeInBits += 16;
      // Simple Field (tempsetpstdby)
      sizeInBits += 16;
      // Simple Field (tempsetpeco)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetShiftF16_3)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (tempsetpshiftcomf)
      sizeInBits += 16;
      // Simple Field (tempsetpshiftstdby)
      sizeInBits += 16;
      // Simple Field (tempsetpshifteco)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Scaling_Speed)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (timePeriod)
      sizeInBits += 16;
      // Simple Field (percent)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Scaling_Step_Time)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (timePeriod)
      sizeInBits += 16;
      // Simple Field (percent)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_MeteringValue)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (countval)
      sizeInBits += 32;
      // Simple Field (valinffield)
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 3;
      // Simple Field (alarmunack)
      sizeInBits += 1;
      // Simple Field (inalarm)
      sizeInBits += 1;
      // Simple Field (overridden)
      sizeInBits += 1;
      // Simple Field (fault)
      sizeInBits += 1;
      // Simple Field (outofservice)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_MBus_Address)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (manufactid)
      sizeInBits += 16;
      // Simple Field (identnumber)
      sizeInBits += 32;
      // Simple Field (version)
      sizeInBits += 8;
      // Simple Field (medium)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Colour_RGB)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (r)
      sizeInBits += 8;
      // Simple Field (g)
      sizeInBits += 8;
      // Simple Field (b)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_LanguageCodeAlpha2_ASCII)) { // STRING
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (value)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Tariff_ActiveEnergy)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (activeelectricalenergy)
      sizeInBits += 32;
      // Simple Field (tariff)
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (electricalengergyvalidity)
      sizeInBits += 1;
      // Simple Field (tariffvalidity)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Prioritised_Mode_Control)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (deactivationOfPriority)
      sizeInBits += 1;
      // Simple Field (priorityLevel)
      sizeInBits += 3;
      // Simple Field (modeLevel)
      sizeInBits += 4;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DALI_Control_Gear_Diagnostic)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 5;
      // Simple Field (convertorError)
      sizeInBits += 1;
      // Simple Field (ballastFailure)
      sizeInBits += 1;
      // Simple Field (lampFailure)
      sizeInBits += 1;
      // Simple Field (readOrResponse)
      sizeInBits += 1;
      // Simple Field (addressIndicator)
      sizeInBits += 1;
      // Simple Field (daliDeviceAddressOrDaliGroupAddress)
      sizeInBits += 6;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_DALI_Diagnostics)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (ballastFailure)
      sizeInBits += 1;
      // Simple Field (lampFailure)
      sizeInBits += 1;
      // Simple Field (deviceAddress)
      sizeInBits += 6;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_CombinedPosition)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (heightPosition)
      sizeInBits += 8;
      // Simple Field (slatsPosition)
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (validityHeightPosition)
      sizeInBits += 1;
      // Simple Field (validitySlatsPosition)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_StatusSAB)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (heightPosition)
      sizeInBits += 8;
      // Simple Field (slatsPosition)
      sizeInBits += 8;
      // Simple Field (upperEndPosReached)
      sizeInBits += 1;
      // Simple Field (lowerEndPosReached)
      sizeInBits += 1;
      // Simple Field (lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent)
      sizeInBits += 1;
      // Simple Field (targetPosDrive)
      sizeInBits += 1;
      // Simple Field (restrictionOfTargetHeightPosPosCanNotBeReached)
      sizeInBits += 1;
      // Simple Field (restrictionOfSlatsHeightPosPosCanNotBeReached)
      sizeInBits += 1;
      // Simple Field (atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm)
      sizeInBits += 1;
      // Simple Field (upDownPositionIsForcedByMoveupdownforcedInput)
      sizeInBits += 1;
      // Simple Field (movementIsLockedEGByDevicelockedInput)
      sizeInBits += 1;
      // Simple Field (actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface)
      sizeInBits += 1;
      // Simple Field (generalFailureOfTheActuatorOrTheDrive)
      sizeInBits += 1;
      // Reserved Field
      sizeInBits += 3;
      // Simple Field (validityHeightPos)
      sizeInBits += 1;
      // Simple Field (validitySlatsPos)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Colour_xyY)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (xAxis)
      sizeInBits += 16;
      // Simple Field (yAxis)
      sizeInBits += 16;
      // Simple Field (brightness)
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (validityXy)
      sizeInBits += 1;
      // Simple Field (validityBrightness)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Converter_Status)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (converterModeAccordingToTheDaliConverterStateMachine)
      sizeInBits += 4;
      // Reserved Field
      sizeInBits += 2;
      // Simple Field (hardwiredSwitchIsActive)
      sizeInBits += 1;
      // Simple Field (hardwiredInhibitIsActive)
      sizeInBits += 1;
      // Simple Field (functionTestPending)
      sizeInBits += 2;
      // Simple Field (durationTestPending)
      sizeInBits += 2;
      // Simple Field (partialDurationTestPending)
      sizeInBits += 2;
      // Simple Field (converterFailure)
      sizeInBits += 2;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Converter_Test_Result)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (ltrf)
      sizeInBits += 4;
      // Simple Field (ltrd)
      sizeInBits += 4;
      // Simple Field (ltrp)
      sizeInBits += 4;
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (sf)
      sizeInBits += 2;
      // Simple Field (sd)
      sizeInBits += 2;
      // Simple Field (sp)
      sizeInBits += 2;
      // Reserved Field
      sizeInBits += 2;
      // Simple Field (ldtr)
      sizeInBits += 16;
      // Simple Field (lpdtr)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Battery_Info)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 5;
      // Simple Field (batteryFailure)
      sizeInBits += 1;
      // Simple Field (batteryDurationFailure)
      sizeInBits += 1;
      // Simple Field (batteryFullyCharged)
      sizeInBits += 1;
      // Simple Field (batteryChargeLevel)
      sizeInBits += 8;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Brightness_Colour_Temperature_Transition)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (ms)
      sizeInBits += 16;
      // Simple Field (temperatureK)
      sizeInBits += 16;
      // Simple Field (percent)
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 5;
      // Simple Field (validityOfTheTimePeriod)
      sizeInBits += 1;
      // Simple Field (validityOfTheAbsoluteColourTemperature)
      sizeInBits += 1;
      // Simple Field (validityOfTheAbsoluteBrightness)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Brightness_Colour_Temperature_Control)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (cct)
      sizeInBits += 1;
      // Simple Field (stepCodeColourTemperature)
      sizeInBits += 3;
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (cb)
      sizeInBits += 1;
      // Simple Field (stepCodeBrightness)
      sizeInBits += 3;
      // Reserved Field
      sizeInBits += 6;
      // Simple Field (cctAndStepCodeColourValidity)
      sizeInBits += 1;
      // Simple Field (cbAndStepCodeBrightnessValidity)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(datapointType, KnxDatapointType.DPT_Colour_RGBW)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (colourLevelRed)
      sizeInBits += 8;
      // Simple Field (colourLevelGreen)
      sizeInBits += 8;
      // Simple Field (colourLevelBlue)
      sizeInBits += 8;
      // Simple Field (colourLevelWhite)
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 8;
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (mr)
      sizeInBits += 1;
      // Simple Field (mg)
      sizeInBits += 1;
      // Simple Field (mb)
      sizeInBits += 1;
      // Simple Field (mw)
      sizeInBits += 1;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Relative_Control_RGBW)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (maskcw)
      sizeInBits += 1;
      // Simple Field (maskcb)
      sizeInBits += 1;
      // Simple Field (maskcg)
      sizeInBits += 1;
      // Simple Field (maskcr)
      sizeInBits += 1;
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (cw)
      sizeInBits += 1;
      // Simple Field (stepCodeColourWhite)
      sizeInBits += 3;
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (cb)
      sizeInBits += 1;
      // Simple Field (stepCodeColourBlue)
      sizeInBits += 3;
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (cg)
      sizeInBits += 1;
      // Simple Field (stepCodeColourGreen)
      sizeInBits += 3;
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (cr)
      sizeInBits += 1;
      // Simple Field (stepCodeColourRed)
      sizeInBits += 3;
      // Reserved Field
      sizeInBits += 4;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_Relative_Control_RGB)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (cb)
      sizeInBits += 1;
      // Simple Field (stepCodeColourBlue)
      sizeInBits += 3;
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (cg)
      sizeInBits += 1;
      // Simple Field (stepCodeColourGreen)
      sizeInBits += 3;
      // Reserved Field
      sizeInBits += 4;
      // Simple Field (cr)
      sizeInBits += 1;
      // Simple Field (stepCodeColourRed)
      sizeInBits += 3;
      // Reserved Field
      sizeInBits += 4;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_GeographicalLocation)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (longitude)
      sizeInBits += 32;
      // Simple Field (latitude)
      sizeInBits += 32;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetF16_4)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (roomTemperatureSetpointComfort)
      sizeInBits += 16;
      // Simple Field (roomTemperatureSetpointStandby)
      sizeInBits += 16;
      // Simple Field (roomTemperatureSetpointEconomy)
      sizeInBits += 16;
      // Simple Field (roomTemperatureSetpointBuildingProtection)
      sizeInBits += 16;
    } else if (EvaluationHelper.equals(
        datapointType, KnxDatapointType.DPT_TempRoomSetpSetShiftF16_4)) { // Struct
      // Reserved Field
      sizeInBits += 8;
      // Simple Field (roomTemperatureSetpointShiftComfort)
      sizeInBits += 16;
      // Simple Field (roomTemperatureSetpointShiftStandby)
      sizeInBits += 16;
      // Simple Field (roomTemperatureSetpointShiftEconomy)
      sizeInBits += 16;
      // Simple Field (roomTemperatureSetpointShiftBuildingProtection)
      sizeInBits += 16;
    }
    return sizeInBits;
  }
}
