/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class KnxGroupAddress3Level extends KnxGroupAddress implements Message {

  // Accessors for discriminator values.
  public Byte getNumLevels() {
    return (byte) 3;
  }

  // Properties.
  protected final short mainGroup;
  protected final byte middleGroup;
  protected final short subGroup;

  public KnxGroupAddress3Level(short mainGroup, byte middleGroup, short subGroup) {
    super();
    this.mainGroup = mainGroup;
    this.middleGroup = middleGroup;
    this.subGroup = subGroup;
  }

  public short getMainGroup() {
    return mainGroup;
  }

  public byte getMiddleGroup() {
    return middleGroup;
  }

  public short getSubGroup() {
    return subGroup;
  }

  @Override
  protected void serializeKnxGroupAddressChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("KnxGroupAddress3Level");

    // Simple Field (mainGroup)
    writeSimpleField("mainGroup", mainGroup, writeUnsignedShort(writeBuffer, 5));

    // Simple Field (middleGroup)
    writeSimpleField("middleGroup", middleGroup, writeUnsignedByte(writeBuffer, 3));

    // Simple Field (subGroup)
    writeSimpleField("subGroup", subGroup, writeUnsignedShort(writeBuffer, 8));

    writeBuffer.popContext("KnxGroupAddress3Level");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    KnxGroupAddress3Level _value = this;

    // Simple field (mainGroup)
    lengthInBits += 5;

    // Simple field (middleGroup)
    lengthInBits += 3;

    // Simple field (subGroup)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static KnxGroupAddress3LevelBuilder staticParseBuilder(
      ReadBuffer readBuffer, Byte numLevels) throws ParseException {
    readBuffer.pullContext("KnxGroupAddress3Level");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    short mainGroup = readSimpleField("mainGroup", readUnsignedShort(readBuffer, 5));

    byte middleGroup = readSimpleField("middleGroup", readUnsignedByte(readBuffer, 3));

    short subGroup = readSimpleField("subGroup", readUnsignedShort(readBuffer, 8));

    readBuffer.closeContext("KnxGroupAddress3Level");
    // Create the instance
    return new KnxGroupAddress3LevelBuilder(mainGroup, middleGroup, subGroup);
  }

  public static class KnxGroupAddress3LevelBuilder
      implements KnxGroupAddress.KnxGroupAddressBuilder {
    private final short mainGroup;
    private final byte middleGroup;
    private final short subGroup;

    public KnxGroupAddress3LevelBuilder(short mainGroup, byte middleGroup, short subGroup) {

      this.mainGroup = mainGroup;
      this.middleGroup = middleGroup;
      this.subGroup = subGroup;
    }

    public KnxGroupAddress3Level build() {
      KnxGroupAddress3Level knxGroupAddress3Level =
          new KnxGroupAddress3Level(mainGroup, middleGroup, subGroup);
      return knxGroupAddress3Level;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof KnxGroupAddress3Level)) {
      return false;
    }
    KnxGroupAddress3Level that = (KnxGroupAddress3Level) o;
    return (getMainGroup() == that.getMainGroup())
        && (getMiddleGroup() == that.getMiddleGroup())
        && (getSubGroup() == that.getSubGroup())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getMainGroup(), getMiddleGroup(), getSubGroup());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
