/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum SupportedPhysicalMedia {
  OTHER((short) 0x00, (boolean) true, (String) "used_for_undefined_physical_medium"),
  OIL_METER((short) 0x01, (boolean) true, (String) "measures_volume_of_oil"),
  ELECTRICITY_METER((short) 0x02, (boolean) true, (String) "measures_electric_energy"),
  GAS_METER((short) 0x03, (boolean) true, (String) "measures_volume_of_gaseous_energy"),
  HEAT_METER((short) 0x04, (boolean) true, (String) "heat_energy_measured_in_outlet_pipe"),
  STEAM_METER((short) 0x05, (boolean) true, (String) "measures_weight_of_hot_steam"),
  WARM_WATER_METER((short) 0x06, (boolean) true, (String) "measured_heated_water_volume"),
  WATER_METER((short) 0x07, (boolean) true, (String) "measured_water_volume"),
  HEAT_COST_ALLOCATOR(
      (short) 0x08, (boolean) true, (String) "measured_relative_cumulated_heat_consumption"),
  COMPRESSED_AIR((short) 0x09, (boolean) false, (String) "measures_weight_of_compressed_air"),
  COOLING_LOAD_METER_INLET(
      (short) 0x0A, (boolean) true, (String) "cooling_energy_measured_in_inlet_pipe"),
  COOLING_LOAD_METER_OUTLET(
      (short) 0x0B, (boolean) true, (String) "cooling_energy_measured_in_outlet_pipe"),
  HEAT_INLET((short) 0x0C, (boolean) true, (String) "heat_energy_measured_in_inlet_pipe"),
  HEAT_AND_COOL((short) 0x0D, (boolean) true, (String) "measures_both_heat_and_cool"),
  BUS_OR_SYSTEM((short) 0x0E, (boolean) false, (String) "no_meter"),
  UNKNOWN_DEVICE_TYPE((short) 0x0F, (boolean) false, (String) "used_for_undefined_physical_medium"),
  BREAKER((short) 0x20, (boolean) true, (String) "status_of_electric_energy_supply"),
  VALVE((short) 0x21, (boolean) true, (String) "status_of_supply_of_Gas_or_water"),
  WASTE_WATER_METER((short) 0x28, (boolean) true, (String) "measured_volume_of_disposed_water"),
  GARBAGE((short) 0x29, (boolean) true, (String) "measured_weight_of_disposed_rubbish"),
  RADIO_CONVERTER(
      (short) 0x37,
      (boolean) false,
      (String) "enables_the_radio_transmission_of_a_meter_without_a_radio_interface");
  private static final Map<Short, SupportedPhysicalMedia> map;

  static {
    map = new HashMap<>();
    for (SupportedPhysicalMedia value : SupportedPhysicalMedia.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private short value;
  private boolean knxSupport;
  private String description;

  SupportedPhysicalMedia(short value, boolean knxSupport, String description) {
    this.value = value;
    this.knxSupport = knxSupport;
    this.description = description;
  }

  public short getValue() {
    return value;
  }

  public boolean getKnxSupport() {
    return knxSupport;
  }

  public static SupportedPhysicalMedia firstEnumForFieldKnxSupport(boolean fieldValue) {
    for (SupportedPhysicalMedia _val : SupportedPhysicalMedia.values()) {
      if (_val.getKnxSupport() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<SupportedPhysicalMedia> enumsForFieldKnxSupport(boolean fieldValue) {
    List<SupportedPhysicalMedia> _values = new ArrayList();
    for (SupportedPhysicalMedia _val : SupportedPhysicalMedia.values()) {
      if (_val.getKnxSupport() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public String getDescription() {
    return description;
  }

  public static SupportedPhysicalMedia firstEnumForFieldDescription(String fieldValue) {
    for (SupportedPhysicalMedia _val : SupportedPhysicalMedia.values()) {
      if (_val.getDescription() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<SupportedPhysicalMedia> enumsForFieldDescription(String fieldValue) {
    List<SupportedPhysicalMedia> _values = new ArrayList();
    for (SupportedPhysicalMedia _val : SupportedPhysicalMedia.values()) {
      if (_val.getDescription() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static SupportedPhysicalMedia enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
