/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.math.BigInteger;
import java.util.HashMap;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.knxnetip.readwrite.KnxDatapointType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcCHAR;
import org.apache.plc4x.java.spi.values.PlcDATE;
import org.apache.plc4x.java.spi.values.PlcDATE_AND_TIME;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcDWORD;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcLTIME;
import org.apache.plc4x.java.spi.values.PlcLWORD;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcStruct;
import org.apache.plc4x.java.spi.values.PlcTIME;
import org.apache.plc4x.java.spi.values.PlcTIME_OF_DAY;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.apache.plc4x.java.spi.values.PlcWCHAR;
import org.apache.plc4x.java.spi.values.PlcWORD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnxDatapoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnxDatapoint.class);

    /*
     * Opcode count of 20120 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static PlcValue staticParse(ReadBuffer readBuffer, KnxDatapointType datapointType) throws ParseException {
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.BOOL))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.BYTE))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcBYTE(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.WORD))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcWORD(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DWORD))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcDWORD(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LWORD))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcLWORD(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.USINT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.SINT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte value = readBuffer.readSignedByte("", 8, new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.UINT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.INT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.UDINT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DINT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.ULINT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            BigInteger value = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LINT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readLong("", 64, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.REAL))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LREAL))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Double value = readBuffer.readDouble("", 64, new WithReaderArgs[0]);
            return new PlcLREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.CHAR))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            String value = readBuffer.readString("", 8, new WithReaderArgs[]{WithOption.WithEncoding((String)"UTF-8")});
            return new PlcCHAR(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.WCHAR))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            String value = readBuffer.readString("", 16, new WithReaderArgs[]{WithOption.WithEncoding((String)"UTF-16")});
            return new PlcWCHAR(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.TIME))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long milliseconds = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return PlcTIME.ofMilliseconds((long)milliseconds);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LTIME))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            BigInteger nanoseconds = readBuffer.readUnsignedBigInteger("", 64, new WithReaderArgs[0]);
            return PlcLTIME.ofNanoseconds((BigInteger)nanoseconds);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DATE))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long secondsSinceEpoch = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return PlcDATE.ofSecondsSinceEpoch((long)secondsSinceEpoch);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.TIME_OF_DAY))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long millisecondsSinceMidnight = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return PlcTIME_OF_DAY.ofMillisecondsSinceMidnight((long)millisecondsSinceMidnight);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.TOD))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long millisecondsSinceMidnight = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return PlcTIME_OF_DAY.ofMillisecondsSinceMidnight((long)millisecondsSinceMidnight);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DATE_AND_TIME))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer year = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short month = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short day = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short dayOfWeek = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short hour = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short minutes = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short seconds = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Long nanoseconds = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return PlcDATE_AND_TIME.ofSegments((int)year, (int)(month == 0 ? 1 : month.intValue()), (int)(day == 0 ? 1 : day.intValue()), (int)hour.intValue(), (int)minutes.intValue(), (int)seconds.intValue(), (int)nanoseconds.intValue());
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DT))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer year = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short month = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short day = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short dayOfWeek = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short hour = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short minutes = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short seconds = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Long nanoseconds = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return PlcDATE_AND_TIME.ofSegments((int)year, (int)(month == 0 ? 1 : month.intValue()), (int)(day == 0 ? 1 : day.intValue()), (int)hour.intValue(), (int)minutes.intValue(), (int)seconds.intValue(), (int)nanoseconds.intValue());
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Switch))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Bool))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Enable))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Ramp))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Alarm))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BinaryValue))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Step))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_UpDown))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_OpenClose))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Start))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_State))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Invert))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DimSendStyle))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_InputSource))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Reset))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Ack))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Trigger))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Occupancy))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Window_Door))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LogicalFunction))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Scene_AB))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ShutterBlinds_Mode))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DayNight))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Heat_Cool))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Switch_Control))) {
            byte reserved = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean on = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("on", new PlcBOOL(on));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Bool_Control))) {
            byte reserved = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean valueTrue = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("valueTrue", new PlcBOOL(valueTrue));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Enable_Control))) {
            byte reserved = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean enable = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("enable", new PlcBOOL(enable));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Ramp_Control))) {
            byte reserved = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean ramp = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("ramp", new PlcBOOL(ramp));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Alarm_Control))) {
            byte reserved = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean alarm = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("alarm", new PlcBOOL(alarm));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BinaryValue_Control))) {
            byte reserved = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean high = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("high", new PlcBOOL(high));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Step_Control))) {
            byte reserved = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean increase = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("increase", new PlcBOOL(increase));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Direction1_Control))) {
            byte reserved = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean down = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("down", new PlcBOOL(down));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Direction2_Control))) {
            byte reserved = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean close = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("close", new PlcBOOL(close));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Start_Control))) {
            byte reserved = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean start = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("start", new PlcBOOL(start));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_State_Control))) {
            byte reserved = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean active = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("active", new PlcBOOL(active));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Invert_Control))) {
            byte reserved = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean control = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean inverted = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("control", new PlcBOOL(control));
            _map.put("inverted", new PlcBOOL(inverted));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Control_Dimming))) {
            byte reserved = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean increase = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepcode = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("increase", new PlcBOOL(increase));
            _map.put("stepcode", new PlcSINT(stepcode));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Control_Blinds))) {
            byte reserved = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean down = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepcode = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("down", new PlcBOOL(down));
            _map.put("stepcode", new PlcSINT(stepcode));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Char_ASCII))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            String value = readBuffer.readString("", 8, new WithReaderArgs[]{WithOption.WithEncoding((String)"ASCII")});
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Char_8859_1))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            String value = readBuffer.readString("", 8, new WithReaderArgs[]{WithOption.WithEncoding((String)"ISO-8859-1")});
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Scaling))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Angle))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Percent_U8))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DecimalFactor))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Tariff))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_1_Ucount))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FanStage))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Percent_V8))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte value = readBuffer.readSignedByte("", 8, new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_1_Count))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte value = readBuffer.readSignedByte("", 8, new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Status_Mode3))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean statusA = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusB = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusC = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusD = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusE = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte mode = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("statusA", new PlcBOOL(statusA));
            _map.put("statusB", new PlcBOOL(statusB));
            _map.put("statusC", new PlcBOOL(statusC));
            _map.put("statusD", new PlcBOOL(statusD));
            _map.put("statusE", new PlcBOOL(statusE));
            _map.put("mode", new PlcSINT(mode));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_2_Ucount))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriodMsec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriod10Msec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriod100Msec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriodSec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriodMin))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriodHrs))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PropDataType))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Length_mm))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_UElCurrentmA))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Brightness))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Absolute_Colour_Temperature))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_2_Count))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTimeMsec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTime10Msec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTime100Msec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTimeSec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTimeMin))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTimeHrs))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Percent_V16))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Rotation_Angle))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Length_m))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readShort("", 16, new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Temp))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Tempd))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Tempa))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Lux))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Wsp))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Pres))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Humidity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_AirQuality))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_AirFlow))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Time1))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Time2))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Volt))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Curr))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PowerDensity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_KelvinPerPercent))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Power))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Volume_Flow))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Rain_Amount))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Temp_F))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Wsp_kmh))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Absolute_Humidity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Concentration_ygm3))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Coefficient))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimeOfDay))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte day = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            Byte hour = readBuffer.readUnsignedByte("", 5, new WithReaderArgs[0]);
            byte reserved2 = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved2 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved2 + " for reserved field.");
            }
            Byte minutes = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            byte reserved3 = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved3 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved3 + " for reserved field.");
            }
            Byte seconds = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            HashMap<String, PlcSINT> _map = new HashMap<String, PlcSINT>();
            _map.put("day", new PlcSINT(day));
            _map.put("hour", new PlcSINT(hour));
            _map.put("minutes", new PlcSINT(minutes));
            _map.put("seconds", new PlcSINT(seconds));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Date))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte dayOfMonth = readBuffer.readUnsignedByte("", 5, new WithReaderArgs[0]);
            byte reserved4 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved4 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved4 + " for reserved field.");
            }
            Byte month = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            byte reserved5 = readBuffer.readUnsignedByte("", 1, new WithReaderArgs[0]);
            if (reserved5 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved5 + " for reserved field.");
            }
            Byte year = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            HashMap<String, PlcSINT> _map = new HashMap<String, PlcSINT>();
            _map.put("dayOfMonth", new PlcSINT(dayOfMonth));
            _map.put("month", new PlcSINT(month));
            _map.put("year", new PlcSINT(year));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_4_Ucount))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LongTimePeriod_Sec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LongTimePeriod_Min))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LongTimePeriod_Hrs))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_VolumeLiquid_Litre))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Volume_m_3))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_4_Count))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FlowRate_m3h))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActiveEnergy))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ApparantEnergy))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ReactiveEnergy))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActiveEnergy_kWh))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ApparantEnergy_kVAh))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ReactiveEnergy_kVARh))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActiveEnergy_MWh))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LongDeltaTimeSec))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaVolumeLiquid_Litre))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaVolume_m_3))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer value = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Acceleration))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Acceleration_Angular))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Activation_Energy))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Activity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Mol))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Amplitude))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_AngleRad))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_AngleDeg))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Angular_Momentum))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Angular_Velocity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Area))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Capacitance))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Charge_DensitySurface))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Charge_DensityVolume))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Compressibility))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Conductance))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electrical_Conductivity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Density))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Charge))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Current))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_CurrentDensity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_DipoleMoment))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Displacement))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_FieldStrength))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Flux))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_FluxDensity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Polarization))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Potential))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_PotentialDifference))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_ElectromagneticMoment))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electromotive_Force))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Energy))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Force))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Frequency))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Angular_Frequency))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Heat_Capacity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Heat_FlowRate))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Heat_Quantity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Impedance))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Length))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Light_Quantity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Luminance))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Luminous_Flux))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Luminous_Intensity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_FieldStrength))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_Flux))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_FluxDensity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_Moment))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_Polarization))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetization))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_MagnetomotiveForce))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Mass))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_MassFlux))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Momentum))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Phase_AngleRad))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Phase_AngleDeg))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Power))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Power_Factor))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Pressure))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Reactance))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Resistance))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Resistivity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_SelfInductance))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_SolidAngle))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Sound_Intensity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Speed))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Stress))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Surface_Tension))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Common_Temperature))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Absolute_Temperature))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_TemperatureDifference))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Thermal_Capacity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Thermal_Conductivity))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_ThermoelectricPower))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Time))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Torque))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Volume))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Volume_Flux))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Weight))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Work))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_ApparentPower))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Volume_Flux_Meter))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Volume_Flux_ls))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float value = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Access_Data))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte hurz = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Byte value1 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Byte value2 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Byte value3 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Byte value4 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Byte value5 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Boolean detectionError = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean permission = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean readDirection = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean encryptionOfAccessInformation = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte indexOfAccessIdentificationCode = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("hurz", new PlcSINT(hurz));
            _map.put("value1", new PlcSINT(value1));
            _map.put("value2", new PlcSINT(value2));
            _map.put("value3", new PlcSINT(value3));
            _map.put("value4", new PlcSINT(value4));
            _map.put("value5", new PlcSINT(value5));
            _map.put("detectionError", new PlcBOOL(detectionError));
            _map.put("permission", new PlcBOOL(permission));
            _map.put("readDirection", new PlcBOOL(readDirection));
            _map.put("encryptionOfAccessInformation", new PlcBOOL(encryptionOfAccessInformation));
            _map.put("indexOfAccessIdentificationCode", new PlcSINT(indexOfAccessIdentificationCode));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_String_ASCII))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            String value = readBuffer.readString("", 112, new WithReaderArgs[]{WithOption.WithEncoding((String)"ASCII")});
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_String_8859_1))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            String value = readBuffer.readString("", 112, new WithReaderArgs[]{WithOption.WithEncoding((String)"ISO-8859-1")});
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SceneNumber))) {
            byte reserved = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte value = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SceneControl))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean learnTheSceneCorrespondingToTheFieldSceneNumber = readBuffer.readBit("", new WithReaderArgs[0]);
            byte reserved6 = readBuffer.readUnsignedByte("", 1, new WithReaderArgs[0]);
            if (reserved6 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved6 + " for reserved field.");
            }
            Byte sceneNumber = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("learnTheSceneCorrespondingToTheFieldSceneNumber", new PlcBOOL(learnTheSceneCorrespondingToTheFieldSceneNumber));
            _map.put("sceneNumber", new PlcSINT(sceneNumber));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DateTime))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short year = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            byte reserved7 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved7 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved7 + " for reserved field.");
            }
            Byte month = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            byte reserved8 = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            if (reserved8 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved8 + " for reserved field.");
            }
            Byte dayofmonth = readBuffer.readUnsignedByte("", 5, new WithReaderArgs[0]);
            Byte dayofweek = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            Byte hourofday = readBuffer.readUnsignedByte("", 5, new WithReaderArgs[0]);
            byte reserved9 = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved9 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved9 + " for reserved field.");
            }
            Byte minutes = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            byte reserved10 = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved10 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved10 + " for reserved field.");
            }
            Byte seconds = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            Boolean fault = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean workingDay = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean noWd = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean noYear = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean noDate = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean noDayOfWeek = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean noTime = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean standardSummerTime = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean qualityOfClock = readBuffer.readBit("", new WithReaderArgs[0]);
            byte reserved11 = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved11 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved11 + " for reserved field.");
            }
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("year", new PlcINT(year));
            _map.put("month", new PlcSINT(month));
            _map.put("dayofmonth", new PlcSINT(dayofmonth));
            _map.put("dayofweek", new PlcSINT(dayofweek));
            _map.put("hourofday", new PlcSINT(hourofday));
            _map.put("minutes", new PlcSINT(minutes));
            _map.put("seconds", new PlcSINT(seconds));
            _map.put("fault", new PlcBOOL(fault));
            _map.put("workingDay", new PlcBOOL(workingDay));
            _map.put("noWd", new PlcBOOL(noWd));
            _map.put("noYear", new PlcBOOL(noYear));
            _map.put("noDate", new PlcBOOL(noDate));
            _map.put("noDayOfWeek", new PlcBOOL(noDayOfWeek));
            _map.put("noTime", new PlcBOOL(noTime));
            _map.put("standardSummerTime", new PlcBOOL(standardSummerTime));
            _map.put("qualityOfClock", new PlcBOOL(qualityOfClock));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SCLOMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BuildingMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_OccMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Priority))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LightApplicationMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ApplicationArea))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_AlarmClassType))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PSUMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ErrorClass_System))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ErrorClass_HVAC))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Time_Delay))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Beaufort_Wind_Force_Scale))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SensorSelect))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActuatorConnectType))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Cloud_Cover))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PowerReturnMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FuelType))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BurnerType))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVACMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DHWMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LoadPriority))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVACContrMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVACEmergMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ChangeoverMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ValveMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DamperMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HeaterMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FanMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_MasterSlaveMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusRoomSetp))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Metering_DeviceType))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HumDehumMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_EnableHCStage))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ADAType))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BackupMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StartSynchronization))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Behaviour_Lock_Unlock))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Behaviour_Bus_Power_Up_Down))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DALI_Fade_Time))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BlinkingMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LightControlMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SwitchPBModel))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PBAction))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DimmPBModel))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SwitchOnMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LoadTypeSet))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LoadTypeDetected))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Converter_Test_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SABExcept_Behaviour))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SABBehaviour_Lock_Unlock))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SSSBMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BlindsControlMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CommMode))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_AddInfoTypes))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_RF_ModeSelect))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_RF_FilterSelect))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short value = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusGen))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean alarmStatusOfCorrespondingDatapointIsNotAcknowledged = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean correspondingDatapointIsInAlarm = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean correspondingDatapointMainValueIsOverridden = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean correspondingDatapointMainValueIsCorruptedDueToFailure = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean correspondingDatapointValueIsOutOfService = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("alarmStatusOfCorrespondingDatapointIsNotAcknowledged", new PlcBOOL(alarmStatusOfCorrespondingDatapointIsNotAcknowledged));
            _map.put("correspondingDatapointIsInAlarm", new PlcBOOL(correspondingDatapointIsInAlarm));
            _map.put("correspondingDatapointMainValueIsOverridden", new PlcBOOL(correspondingDatapointMainValueIsOverridden));
            _map.put("correspondingDatapointMainValueIsCorruptedDueToFailure", new PlcBOOL(correspondingDatapointMainValueIsCorruptedDueToFailure));
            _map.put("correspondingDatapointValueIsOutOfService", new PlcBOOL(correspondingDatapointValueIsOutOfService));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Device_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 5, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean verifyModeIsOn = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean theUserApplicationIsStopped = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("verifyModeIsOn", new PlcBOOL(verifyModeIsOn));
            _map.put("aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived", new PlcBOOL(aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived));
            _map.put("theUserApplicationIsStopped", new PlcBOOL(theUserApplicationIsStopped));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ForceSign))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean roomhmax = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean roomhconf = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean dhwlegio = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean dhwnorm = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean overrun = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean oversupply = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean protection = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean forcerequest = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("roomhmax", new PlcBOOL(roomhmax));
            _map.put("roomhconf", new PlcBOOL(roomhconf));
            _map.put("dhwlegio", new PlcBOOL(dhwlegio));
            _map.put("dhwnorm", new PlcBOOL(dhwnorm));
            _map.put("overrun", new PlcBOOL(overrun));
            _map.put("oversupply", new PlcBOOL(oversupply));
            _map.put("protection", new PlcBOOL(protection));
            _map.put("forcerequest", new PlcBOOL(forcerequest));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ForceSignCool))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusRHC))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean summermode = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusstopoptim = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusstartoptim = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusmorningboost = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean tempreturnlimit = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean tempflowlimit = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean satuseco = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean fault = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("summermode", new PlcBOOL(summermode));
            _map.put("statusstopoptim", new PlcBOOL(statusstopoptim));
            _map.put("statusstartoptim", new PlcBOOL(statusstartoptim));
            _map.put("statusmorningboost", new PlcBOOL(statusmorningboost));
            _map.put("tempreturnlimit", new PlcBOOL(tempreturnlimit));
            _map.put("tempflowlimit", new PlcBOOL(tempflowlimit));
            _map.put("satuseco", new PlcBOOL(satuseco));
            _map.put("fault", new PlcBOOL(fault));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusSDHWC))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 5, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean solarloadsufficient = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean sdhwloadactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean fault = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("solarloadsufficient", new PlcBOOL(solarloadsufficient));
            _map.put("sdhwloadactive", new PlcBOOL(sdhwloadactive));
            _map.put("fault", new PlcBOOL(fault));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FuelTypeSet))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 5, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean solidstate = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean gas = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean oil = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("solidstate", new PlcBOOL(solidstate));
            _map.put("gas", new PlcBOOL(gas));
            _map.put("oil", new PlcBOOL(oil));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusRCC))) {
            byte reserved = readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean value = readBuffer.readBit("", new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusAHU))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean cool = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean heat = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean fanactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean fault = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("cool", new PlcBOOL(cool));
            _map.put("heat", new PlcBOOL(heat));
            _map.put("fanactive", new PlcBOOL(fanactive));
            _map.put("fault", new PlcBOOL(fault));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedStatus_RTSM))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean statusOfHvacModeUser = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusOfComfortProlongationUser = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean effectiveValueOfTheComfortPushButton = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean effectiveValueOfThePresenceStatus = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean effectiveValueOfTheWindowStatus = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("statusOfHvacModeUser", new PlcBOOL(statusOfHvacModeUser));
            _map.put("statusOfComfortProlongationUser", new PlcBOOL(statusOfComfortProlongationUser));
            _map.put("effectiveValueOfTheComfortPushButton", new PlcBOOL(effectiveValueOfTheComfortPushButton));
            _map.put("effectiveValueOfThePresenceStatus", new PlcBOOL(effectiveValueOfThePresenceStatus));
            _map.put("effectiveValueOfTheWindowStatus", new PlcBOOL(effectiveValueOfTheWindowStatus));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LightActuatorErrorInfo))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 1, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean overheat = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean lampfailure = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean defectiveload = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean underload = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean overcurrent = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean undervoltage = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean loaddetectionerror = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("overheat", new PlcBOOL(overheat));
            _map.put("lampfailure", new PlcBOOL(lampfailure));
            _map.put("defectiveload", new PlcBOOL(defectiveload));
            _map.put("underload", new PlcBOOL(underload));
            _map.put("overcurrent", new PlcBOOL(overcurrent));
            _map.put("undervoltage", new PlcBOOL(undervoltage));
            _map.put("loaddetectionerror", new PlcBOOL(loaddetectionerror));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_RF_ModeInfo))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 5, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean bibatSlave = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean bibatMaster = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean asynchronous = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("bibatSlave", new PlcBOOL(bibatSlave));
            _map.put("bibatMaster", new PlcBOOL(bibatMaster));
            _map.put("asynchronous", new PlcBOOL(asynchronous));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_RF_FilterInfo))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 5, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean doa = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean knxSn = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean doaAndKnxSn = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("doa", new PlcBOOL(doa));
            _map.put("knxSn", new PlcBOOL(knxSn));
            _map.put("doaAndKnxSn", new PlcBOOL(doaAndKnxSn));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Channel_Activation_8))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean activationStateOfChannel1 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel2 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel3 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel4 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel5 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel6 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel7 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel8 = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("activationStateOfChannel1", new PlcBOOL(activationStateOfChannel1));
            _map.put("activationStateOfChannel2", new PlcBOOL(activationStateOfChannel2));
            _map.put("activationStateOfChannel3", new PlcBOOL(activationStateOfChannel3));
            _map.put("activationStateOfChannel4", new PlcBOOL(activationStateOfChannel4));
            _map.put("activationStateOfChannel5", new PlcBOOL(activationStateOfChannel5));
            _map.put("activationStateOfChannel6", new PlcBOOL(activationStateOfChannel6));
            _map.put("activationStateOfChannel7", new PlcBOOL(activationStateOfChannel7));
            _map.put("activationStateOfChannel8", new PlcBOOL(activationStateOfChannel8));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusDHWC))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean tempoptimshiftactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean solarenergysupport = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean solarenergyonly = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean otherenergysourceactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean dhwpushactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean legioprotactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean dhwloadactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean fault = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("tempoptimshiftactive", new PlcBOOL(tempoptimshiftactive));
            _map.put("solarenergysupport", new PlcBOOL(solarenergysupport));
            _map.put("solarenergyonly", new PlcBOOL(solarenergyonly));
            _map.put("otherenergysourceactive", new PlcBOOL(otherenergysourceactive));
            _map.put("dhwpushactive", new PlcBOOL(dhwpushactive));
            _map.put("legioprotactive", new PlcBOOL(legioprotactive));
            _map.put("dhwloadactive", new PlcBOOL(dhwloadactive));
            _map.put("fault", new PlcBOOL(fault));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusRHCC))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 1, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean overheatalarm = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean frostalarm = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean dewpointstatus = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean coolingdisabled = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusprecool = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusecoc = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean heatcoolmode = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean heatingdiabled = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusstopoptim = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusstartoptim = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusmorningboosth = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean tempflowreturnlimit = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean tempflowlimit = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean statusecoh = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean fault = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("overheatalarm", new PlcBOOL(overheatalarm));
            _map.put("frostalarm", new PlcBOOL(frostalarm));
            _map.put("dewpointstatus", new PlcBOOL(dewpointstatus));
            _map.put("coolingdisabled", new PlcBOOL(coolingdisabled));
            _map.put("statusprecool", new PlcBOOL(statusprecool));
            _map.put("statusecoc", new PlcBOOL(statusecoc));
            _map.put("heatcoolmode", new PlcBOOL(heatcoolmode));
            _map.put("heatingdiabled", new PlcBOOL(heatingdiabled));
            _map.put("statusstopoptim", new PlcBOOL(statusstopoptim));
            _map.put("statusstartoptim", new PlcBOOL(statusstartoptim));
            _map.put("statusmorningboosth", new PlcBOOL(statusmorningboosth));
            _map.put("tempflowreturnlimit", new PlcBOOL(tempflowreturnlimit));
            _map.put("tempflowlimit", new PlcBOOL(tempflowlimit));
            _map.put("statusecoh", new PlcBOOL(statusecoh));
            _map.put("fault", new PlcBOOL(fault));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedStatus_HVA))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean calibrationMode = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean lockedPosition = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean forcedPosition = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean manuaOperationOverridden = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean serviceMode = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean valveKick = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean overload = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean shortCircuit = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean currentValvePosition = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("calibrationMode", new PlcBOOL(calibrationMode));
            _map.put("lockedPosition", new PlcBOOL(lockedPosition));
            _map.put("forcedPosition", new PlcBOOL(forcedPosition));
            _map.put("manuaOperationOverridden", new PlcBOOL(manuaOperationOverridden));
            _map.put("serviceMode", new PlcBOOL(serviceMode));
            _map.put("valveKick", new PlcBOOL(valveKick));
            _map.put("overload", new PlcBOOL(overload));
            _map.put("shortCircuit", new PlcBOOL(shortCircuit));
            _map.put("currentValvePosition", new PlcBOOL(currentValvePosition));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedStatus_RTC))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 7, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean coolingModeEnabled = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean heatingModeEnabled = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean additionalHeatingCoolingStage2Stage = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean controllerInactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean overheatAlarm = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean frostAlarm = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean dewPointStatus = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activeMode = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean generalFailureInformation = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("coolingModeEnabled", new PlcBOOL(coolingModeEnabled));
            _map.put("heatingModeEnabled", new PlcBOOL(heatingModeEnabled));
            _map.put("additionalHeatingCoolingStage2Stage", new PlcBOOL(additionalHeatingCoolingStage2Stage));
            _map.put("controllerInactive", new PlcBOOL(controllerInactive));
            _map.put("overheatAlarm", new PlcBOOL(overheatAlarm));
            _map.put("frostAlarm", new PlcBOOL(frostAlarm));
            _map.put("dewPointStatus", new PlcBOOL(dewPointStatus));
            _map.put("activeMode", new PlcBOOL(activeMode));
            _map.put("generalFailureInformation", new PlcBOOL(generalFailureInformation));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Media))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = readBuffer.readUnsignedShort("", 10, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean knxIp = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean rf = readBuffer.readBit("", new WithReaderArgs[0]);
            byte reserved12 = readBuffer.readUnsignedByte("", 1, new WithReaderArgs[0]);
            if (reserved12 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved12 + " for reserved field.");
            }
            Boolean pl110 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean tp1 = readBuffer.readBit("", new WithReaderArgs[0]);
            byte reserved13 = readBuffer.readUnsignedByte("", 1, new WithReaderArgs[0]);
            if (reserved13 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved13 + " for reserved field.");
            }
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("knxIp", new PlcBOOL(knxIp));
            _map.put("rf", new PlcBOOL(rf));
            _map.put("pl110", new PlcBOOL(pl110));
            _map.put("tp1", new PlcBOOL(tp1));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Channel_Activation_16))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean activationStateOfChannel1 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel2 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel3 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel4 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel5 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel6 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel7 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel8 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel9 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel10 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel11 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel12 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel13 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel14 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel15 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel16 = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("activationStateOfChannel1", new PlcBOOL(activationStateOfChannel1));
            _map.put("activationStateOfChannel2", new PlcBOOL(activationStateOfChannel2));
            _map.put("activationStateOfChannel3", new PlcBOOL(activationStateOfChannel3));
            _map.put("activationStateOfChannel4", new PlcBOOL(activationStateOfChannel4));
            _map.put("activationStateOfChannel5", new PlcBOOL(activationStateOfChannel5));
            _map.put("activationStateOfChannel6", new PlcBOOL(activationStateOfChannel6));
            _map.put("activationStateOfChannel7", new PlcBOOL(activationStateOfChannel7));
            _map.put("activationStateOfChannel8", new PlcBOOL(activationStateOfChannel8));
            _map.put("activationStateOfChannel9", new PlcBOOL(activationStateOfChannel9));
            _map.put("activationStateOfChannel10", new PlcBOOL(activationStateOfChannel10));
            _map.put("activationStateOfChannel11", new PlcBOOL(activationStateOfChannel11));
            _map.put("activationStateOfChannel12", new PlcBOOL(activationStateOfChannel12));
            _map.put("activationStateOfChannel13", new PlcBOOL(activationStateOfChannel13));
            _map.put("activationStateOfChannel14", new PlcBOOL(activationStateOfChannel14));
            _map.put("activationStateOfChannel15", new PlcBOOL(activationStateOfChannel15));
            _map.put("activationStateOfChannel16", new PlcBOOL(activationStateOfChannel16));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_OnOffAction))) {
            byte reserved = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte value = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Alarm_Reaction))) {
            byte reserved = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte value = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_UpDown_Action))) {
            byte reserved = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte value = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVAC_PB_Action))) {
            byte reserved = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte value = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DoubleNibble))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte busy = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Byte nak = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            HashMap<String, PlcSINT> _map = new HashMap<String, PlcSINT>();
            _map.put("busy", new PlcSINT(busy));
            _map.put("nak", new PlcSINT(nak));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SceneInfo))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 1, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean sceneIsInactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte scenenumber = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("sceneIsInactive", new PlcBOOL(sceneIsInactive));
            _map.put("scenenumber", new PlcSINT(scenenumber));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedInfoOnOff))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean maskBitInfoOnOffOutput16 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput15 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput14 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput13 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput12 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput11 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput10 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput9 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput8 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput7 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput6 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput5 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput4 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput3 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput2 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskBitInfoOnOffOutput1 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput16 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput15 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput14 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput13 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput12 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput11 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput10 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput9 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput8 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput7 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput6 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput5 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput4 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput3 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput2 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean infoOnOffOutput1 = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("maskBitInfoOnOffOutput16", new PlcBOOL(maskBitInfoOnOffOutput16));
            _map.put("maskBitInfoOnOffOutput15", new PlcBOOL(maskBitInfoOnOffOutput15));
            _map.put("maskBitInfoOnOffOutput14", new PlcBOOL(maskBitInfoOnOffOutput14));
            _map.put("maskBitInfoOnOffOutput13", new PlcBOOL(maskBitInfoOnOffOutput13));
            _map.put("maskBitInfoOnOffOutput12", new PlcBOOL(maskBitInfoOnOffOutput12));
            _map.put("maskBitInfoOnOffOutput11", new PlcBOOL(maskBitInfoOnOffOutput11));
            _map.put("maskBitInfoOnOffOutput10", new PlcBOOL(maskBitInfoOnOffOutput10));
            _map.put("maskBitInfoOnOffOutput9", new PlcBOOL(maskBitInfoOnOffOutput9));
            _map.put("maskBitInfoOnOffOutput8", new PlcBOOL(maskBitInfoOnOffOutput8));
            _map.put("maskBitInfoOnOffOutput7", new PlcBOOL(maskBitInfoOnOffOutput7));
            _map.put("maskBitInfoOnOffOutput6", new PlcBOOL(maskBitInfoOnOffOutput6));
            _map.put("maskBitInfoOnOffOutput5", new PlcBOOL(maskBitInfoOnOffOutput5));
            _map.put("maskBitInfoOnOffOutput4", new PlcBOOL(maskBitInfoOnOffOutput4));
            _map.put("maskBitInfoOnOffOutput3", new PlcBOOL(maskBitInfoOnOffOutput3));
            _map.put("maskBitInfoOnOffOutput2", new PlcBOOL(maskBitInfoOnOffOutput2));
            _map.put("maskBitInfoOnOffOutput1", new PlcBOOL(maskBitInfoOnOffOutput1));
            _map.put("infoOnOffOutput16", new PlcBOOL(infoOnOffOutput16));
            _map.put("infoOnOffOutput15", new PlcBOOL(infoOnOffOutput15));
            _map.put("infoOnOffOutput14", new PlcBOOL(infoOnOffOutput14));
            _map.put("infoOnOffOutput13", new PlcBOOL(infoOnOffOutput13));
            _map.put("infoOnOffOutput12", new PlcBOOL(infoOnOffOutput12));
            _map.put("infoOnOffOutput11", new PlcBOOL(infoOnOffOutput11));
            _map.put("infoOnOffOutput10", new PlcBOOL(infoOnOffOutput10));
            _map.put("infoOnOffOutput9", new PlcBOOL(infoOnOffOutput9));
            _map.put("infoOnOffOutput8", new PlcBOOL(infoOnOffOutput8));
            _map.put("infoOnOffOutput7", new PlcBOOL(infoOnOffOutput7));
            _map.put("infoOnOffOutput6", new PlcBOOL(infoOnOffOutput6));
            _map.put("infoOnOffOutput5", new PlcBOOL(infoOnOffOutput5));
            _map.put("infoOnOffOutput4", new PlcBOOL(infoOnOffOutput4));
            _map.put("infoOnOffOutput3", new PlcBOOL(infoOnOffOutput3));
            _map.put("infoOnOffOutput2", new PlcBOOL(infoOnOffOutput2));
            _map.put("infoOnOffOutput1", new PlcBOOL(infoOnOffOutput1));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActiveEnergy_V64))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readLong("", 64, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ApparantEnergy_V64))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readLong("", 64, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ReactiveEnergy_V64))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Long value = readBuffer.readLong("", 64, new WithReaderArgs[0]);
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Channel_Activation_24))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean activationStateOfChannel1 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel2 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel3 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel4 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel5 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel6 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel7 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel8 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel9 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel10 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel11 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel12 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel13 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel14 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel15 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel16 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel17 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel18 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel19 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel20 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel21 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel22 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel23 = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean activationStateOfChannel24 = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, PlcBOOL> _map = new HashMap<String, PlcBOOL>();
            _map.put("activationStateOfChannel1", new PlcBOOL(activationStateOfChannel1));
            _map.put("activationStateOfChannel2", new PlcBOOL(activationStateOfChannel2));
            _map.put("activationStateOfChannel3", new PlcBOOL(activationStateOfChannel3));
            _map.put("activationStateOfChannel4", new PlcBOOL(activationStateOfChannel4));
            _map.put("activationStateOfChannel5", new PlcBOOL(activationStateOfChannel5));
            _map.put("activationStateOfChannel6", new PlcBOOL(activationStateOfChannel6));
            _map.put("activationStateOfChannel7", new PlcBOOL(activationStateOfChannel7));
            _map.put("activationStateOfChannel8", new PlcBOOL(activationStateOfChannel8));
            _map.put("activationStateOfChannel9", new PlcBOOL(activationStateOfChannel9));
            _map.put("activationStateOfChannel10", new PlcBOOL(activationStateOfChannel10));
            _map.put("activationStateOfChannel11", new PlcBOOL(activationStateOfChannel11));
            _map.put("activationStateOfChannel12", new PlcBOOL(activationStateOfChannel12));
            _map.put("activationStateOfChannel13", new PlcBOOL(activationStateOfChannel13));
            _map.put("activationStateOfChannel14", new PlcBOOL(activationStateOfChannel14));
            _map.put("activationStateOfChannel15", new PlcBOOL(activationStateOfChannel15));
            _map.put("activationStateOfChannel16", new PlcBOOL(activationStateOfChannel16));
            _map.put("activationStateOfChannel17", new PlcBOOL(activationStateOfChannel17));
            _map.put("activationStateOfChannel18", new PlcBOOL(activationStateOfChannel18));
            _map.put("activationStateOfChannel19", new PlcBOOL(activationStateOfChannel19));
            _map.put("activationStateOfChannel20", new PlcBOOL(activationStateOfChannel20));
            _map.put("activationStateOfChannel21", new PlcBOOL(activationStateOfChannel21));
            _map.put("activationStateOfChannel22", new PlcBOOL(activationStateOfChannel22));
            _map.put("activationStateOfChannel23", new PlcBOOL(activationStateOfChannel23));
            _map.put("activationStateOfChannel24", new PlcBOOL(activationStateOfChannel24));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVACModeNext))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer delayTimeMin = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short hvacMode = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("delayTimeMin", new PlcDINT(delayTimeMin));
            _map.put("hvacMode", new PlcINT(hvacMode));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DHWModeNext))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer delayTimeMin = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short dhwMode = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("delayTimeMin", new PlcDINT(delayTimeMin));
            _map.put("dhwMode", new PlcINT(dhwMode));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_OccModeNext))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer delayTimeMin = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short occupancyMode = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("delayTimeMin", new PlcDINT(delayTimeMin));
            _map.put("occupancyMode", new PlcINT(occupancyMode));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BuildingModeNext))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer delayTimeMin = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short buildingMode = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("delayTimeMin", new PlcDINT(delayTimeMin));
            _map.put("buildingMode", new PlcINT(buildingMode));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusLightingActuator))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean validactualvalue = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean locked = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean forced = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean nightmodeactive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean staircaselightingFunction = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean dimming = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean localoverride = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean failure = readBuffer.readBit("", new WithReaderArgs[0]);
            Short actualvalue = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("validactualvalue", new PlcBOOL(validactualvalue));
            _map.put("locked", new PlcBOOL(locked));
            _map.put("forced", new PlcBOOL(forced));
            _map.put("nightmodeactive", new PlcBOOL(nightmodeactive));
            _map.put("staircaselightingFunction", new PlcBOOL(staircaselightingFunction));
            _map.put("dimming", new PlcBOOL(dimming));
            _map.put("localoverride", new PlcBOOL(localoverride));
            _map.put("failure", new PlcBOOL(failure));
            _map.put("actualvalue", new PlcINT(actualvalue));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Version))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte magicNumber = readBuffer.readUnsignedByte("", 5, new WithReaderArgs[0]);
            Byte versionNumber = readBuffer.readUnsignedByte("", 5, new WithReaderArgs[0]);
            Byte revisionNumber = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            HashMap<String, PlcSINT> _map = new HashMap<String, PlcSINT>();
            _map.put("magicNumber", new PlcSINT(magicNumber));
            _map.put("versionNumber", new PlcSINT(versionNumber));
            _map.put("revisionNumber", new PlcSINT(revisionNumber));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_AlarmInfo))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short logNumber = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short alarmPriority = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short applicationArea = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short errorClass = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            byte reserved14 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved14 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved14 + " for reserved field.");
            }
            Boolean errorcodeSup = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean alarmtextSup = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean timestampSup = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean ackSup = readBuffer.readBit("", new WithReaderArgs[0]);
            byte reserved15 = readBuffer.readUnsignedByte("", 5, new WithReaderArgs[0]);
            if (reserved15 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved15 + " for reserved field.");
            }
            Boolean locked = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean alarmunack = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean inalarm = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("logNumber", new PlcINT(logNumber));
            _map.put("alarmPriority", new PlcINT(alarmPriority));
            _map.put("applicationArea", new PlcINT(applicationArea));
            _map.put("errorClass", new PlcINT(errorClass));
            _map.put("errorcodeSup", new PlcBOOL(errorcodeSup));
            _map.put("alarmtextSup", new PlcBOOL(alarmtextSup));
            _map.put("timestampSup", new PlcBOOL(timestampSup));
            _map.put("ackSup", new PlcBOOL(ackSup));
            _map.put("locked", new PlcBOOL(locked));
            _map.put("alarmunack", new PlcBOOL(alarmunack));
            _map.put("inalarm", new PlcBOOL(inalarm));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TempRoomSetpSetF16_3))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float tempsetpcomf = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float tempsetpstdby = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float tempsetpeco = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            HashMap<String, PlcREAL> _map = new HashMap<String, PlcREAL>();
            _map.put("tempsetpcomf", new PlcREAL(tempsetpcomf));
            _map.put("tempsetpstdby", new PlcREAL(tempsetpstdby));
            _map.put("tempsetpeco", new PlcREAL(tempsetpeco));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TempRoomSetpSetShiftF16_3))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float tempsetpshiftcomf = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float tempsetpshiftstdby = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float tempsetpshifteco = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            HashMap<String, PlcREAL> _map = new HashMap<String, PlcREAL>();
            _map.put("tempsetpshiftcomf", new PlcREAL(tempsetpshiftcomf));
            _map.put("tempsetpshiftstdby", new PlcREAL(tempsetpshiftstdby));
            _map.put("tempsetpshifteco", new PlcREAL(tempsetpshifteco));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Scaling_Speed))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer timePeriod = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short percent = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("timePeriod", new PlcDINT(timePeriod));
            _map.put("percent", new PlcINT(percent));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Scaling_Step_Time))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer timePeriod = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short percent = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("timePeriod", new PlcDINT(timePeriod));
            _map.put("percent", new PlcINT(percent));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_MeteringValue))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer countval = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            Short valinffield = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            byte reserved16 = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            if (reserved16 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved16 + " for reserved field.");
            }
            Boolean alarmunack = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean inalarm = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean overridden = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean fault = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean outofservice = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("countval", new PlcDINT(countval));
            _map.put("valinffield", new PlcINT(valinffield));
            _map.put("alarmunack", new PlcBOOL(alarmunack));
            _map.put("inalarm", new PlcBOOL(inalarm));
            _map.put("overridden", new PlcBOOL(overridden));
            _map.put("fault", new PlcBOOL(fault));
            _map.put("outofservice", new PlcBOOL(outofservice));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_MBus_Address))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer manufactid = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Long identnumber = readBuffer.readUnsignedLong("", 32, new WithReaderArgs[0]);
            Short version = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short medium = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("manufactid", new PlcDINT(manufactid));
            _map.put("identnumber", new PlcLINT(identnumber));
            _map.put("version", new PlcINT(version));
            _map.put("medium", new PlcINT(medium));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Colour_RGB))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short r = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short g = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short b = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, PlcINT> _map = new HashMap<String, PlcINT>();
            _map.put("r", new PlcINT(r));
            _map.put("g", new PlcINT(g));
            _map.put("b", new PlcINT(b));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LanguageCodeAlpha2_ASCII))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            String value = readBuffer.readString("", 16, new WithReaderArgs[]{WithOption.WithEncoding((String)"ASCII")});
            return new PlcSTRING(value);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Tariff_ActiveEnergy))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer activeelectricalenergy = readBuffer.readInt("", 32, new WithReaderArgs[0]);
            Short tariff = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            byte reserved17 = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved17 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved17 + " for reserved field.");
            }
            Boolean electricalengergyvalidity = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean tariffvalidity = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("activeelectricalenergy", new PlcDINT(activeelectricalenergy));
            _map.put("tariff", new PlcINT(tariff));
            _map.put("electricalengergyvalidity", new PlcBOOL(electricalengergyvalidity));
            _map.put("tariffvalidity", new PlcBOOL(tariffvalidity));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Prioritised_Mode_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean deactivationOfPriority = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte priorityLevel = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            Byte modeLevel = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("deactivationOfPriority", new PlcBOOL(deactivationOfPriority));
            _map.put("priorityLevel", new PlcSINT(priorityLevel));
            _map.put("modeLevel", new PlcSINT(modeLevel));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DALI_Control_Gear_Diagnostic))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 5, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean convertorError = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean ballastFailure = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean lampFailure = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean readOrResponse = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean addressIndicator = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte daliDeviceAddressOrDaliGroupAddress = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("convertorError", new PlcBOOL(convertorError));
            _map.put("ballastFailure", new PlcBOOL(ballastFailure));
            _map.put("lampFailure", new PlcBOOL(lampFailure));
            _map.put("readOrResponse", new PlcBOOL(readOrResponse));
            _map.put("addressIndicator", new PlcBOOL(addressIndicator));
            _map.put("daliDeviceAddressOrDaliGroupAddress", new PlcSINT(daliDeviceAddressOrDaliGroupAddress));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DALI_Diagnostics))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean ballastFailure = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean lampFailure = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte deviceAddress = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("ballastFailure", new PlcBOOL(ballastFailure));
            _map.put("lampFailure", new PlcBOOL(lampFailure));
            _map.put("deviceAddress", new PlcSINT(deviceAddress));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedPosition))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short heightPosition = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short slatsPosition = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            byte reserved18 = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved18 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved18 + " for reserved field.");
            }
            Boolean validitySlatsPosition = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean validityHeightPosition = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("heightPosition", new PlcINT(heightPosition));
            _map.put("slatsPosition", new PlcINT(slatsPosition));
            _map.put("validitySlatsPosition", new PlcBOOL(validitySlatsPosition));
            _map.put("validityHeightPosition", new PlcBOOL(validityHeightPosition));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusSAB))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short heightPosition = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short slatsPosition = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Boolean upperEndPosReached = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean lowerEndPosReached = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean targetPosDrive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean restrictionOfTargetHeightPosPosCanNotBeReached = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean restrictionOfSlatsHeightPosPosCanNotBeReached = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean upDownPositionIsForcedByMoveupdownforcedInput = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean movementIsLockedEGByDevicelockedInput = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean generalFailureOfTheActuatorOrTheDrive = readBuffer.readBit("", new WithReaderArgs[0]);
            byte reserved19 = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            if (reserved19 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved19 + " for reserved field.");
            }
            Boolean validityHeightPos = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean validitySlatsPos = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("heightPosition", new PlcINT(heightPosition));
            _map.put("slatsPosition", new PlcINT(slatsPosition));
            _map.put("upperEndPosReached", new PlcBOOL(upperEndPosReached));
            _map.put("lowerEndPosReached", new PlcBOOL(lowerEndPosReached));
            _map.put("lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent", new PlcBOOL(lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent));
            _map.put("targetPosDrive", new PlcBOOL(targetPosDrive));
            _map.put("restrictionOfTargetHeightPosPosCanNotBeReached", new PlcBOOL(restrictionOfTargetHeightPosPosCanNotBeReached));
            _map.put("restrictionOfSlatsHeightPosPosCanNotBeReached", new PlcBOOL(restrictionOfSlatsHeightPosPosCanNotBeReached));
            _map.put("atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm", new PlcBOOL(atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm));
            _map.put("upDownPositionIsForcedByMoveupdownforcedInput", new PlcBOOL(upDownPositionIsForcedByMoveupdownforcedInput));
            _map.put("movementIsLockedEGByDevicelockedInput", new PlcBOOL(movementIsLockedEGByDevicelockedInput));
            _map.put("actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface", new PlcBOOL(actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface));
            _map.put("generalFailureOfTheActuatorOrTheDrive", new PlcBOOL(generalFailureOfTheActuatorOrTheDrive));
            _map.put("validityHeightPos", new PlcBOOL(validityHeightPos));
            _map.put("validitySlatsPos", new PlcBOOL(validitySlatsPos));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Colour_xyY))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer xAxis = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Integer yAxis = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short brightness = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            byte reserved20 = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved20 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved20 + " for reserved field.");
            }
            Boolean validityXy = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean validityBrightness = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("xAxis", new PlcDINT(xAxis));
            _map.put("yAxis", new PlcDINT(yAxis));
            _map.put("brightness", new PlcINT(brightness));
            _map.put("validityXy", new PlcBOOL(validityXy));
            _map.put("validityBrightness", new PlcBOOL(validityBrightness));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Converter_Status))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte converterModeAccordingToTheDaliConverterStateMachine = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            byte reserved21 = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved21 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved21 + " for reserved field.");
            }
            Boolean hardwiredSwitchIsActive = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean hardwiredInhibitIsActive = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte functionTestPending = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            Byte durationTestPending = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            Byte partialDurationTestPending = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            Byte converterFailure = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("converterModeAccordingToTheDaliConverterStateMachine", new PlcSINT(converterModeAccordingToTheDaliConverterStateMachine));
            _map.put("hardwiredSwitchIsActive", new PlcBOOL(hardwiredSwitchIsActive));
            _map.put("hardwiredInhibitIsActive", new PlcBOOL(hardwiredInhibitIsActive));
            _map.put("functionTestPending", new PlcSINT(functionTestPending));
            _map.put("durationTestPending", new PlcSINT(durationTestPending));
            _map.put("partialDurationTestPending", new PlcSINT(partialDurationTestPending));
            _map.put("converterFailure", new PlcSINT(converterFailure));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Converter_Test_Result))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Byte ltrf = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Byte ltrd = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            Byte ltrp = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            byte reserved22 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved22 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved22 + " for reserved field.");
            }
            Byte sf = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            Byte sd = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            Byte sp = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            byte reserved23 = readBuffer.readUnsignedByte("", 2, new WithReaderArgs[0]);
            if (reserved23 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved23 + " for reserved field.");
            }
            Integer ldtr = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short lpdtr = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("ltrf", new PlcSINT(ltrf));
            _map.put("ltrd", new PlcSINT(ltrd));
            _map.put("ltrp", new PlcSINT(ltrp));
            _map.put("sf", new PlcSINT(sf));
            _map.put("sd", new PlcSINT(sd));
            _map.put("sp", new PlcSINT(sp));
            _map.put("ldtr", new PlcDINT(ldtr));
            _map.put("lpdtr", new PlcINT(lpdtr));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Battery_Info))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 5, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean batteryFailure = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean batteryDurationFailure = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean batteryFullyCharged = readBuffer.readBit("", new WithReaderArgs[0]);
            Short batteryChargeLevel = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("batteryFailure", new PlcBOOL(batteryFailure));
            _map.put("batteryDurationFailure", new PlcBOOL(batteryDurationFailure));
            _map.put("batteryFullyCharged", new PlcBOOL(batteryFullyCharged));
            _map.put("batteryChargeLevel", new PlcINT(batteryChargeLevel));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Brightness_Colour_Temperature_Transition))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Integer ms = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Integer temperatureK = readBuffer.readUnsignedInt("", 16, new WithReaderArgs[0]);
            Short percent = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            byte reserved24 = readBuffer.readUnsignedByte("", 5, new WithReaderArgs[0]);
            if (reserved24 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved24 + " for reserved field.");
            }
            Boolean validityOfTheTimePeriod = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean validityOfTheAbsoluteColourTemperature = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean validityOfTheAbsoluteBrightness = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("ms", new PlcDINT(ms));
            _map.put("temperatureK", new PlcDINT(temperatureK));
            _map.put("percent", new PlcINT(percent));
            _map.put("validityOfTheTimePeriod", new PlcBOOL(validityOfTheTimePeriod));
            _map.put("validityOfTheAbsoluteColourTemperature", new PlcBOOL(validityOfTheAbsoluteColourTemperature));
            _map.put("validityOfTheAbsoluteBrightness", new PlcBOOL(validityOfTheAbsoluteBrightness));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Brightness_Colour_Temperature_Control))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean cct = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeColourTemperature = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            byte reserved25 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved25 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved25 + " for reserved field.");
            }
            Boolean cb = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeBrightness = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            byte reserved26 = readBuffer.readUnsignedByte("", 6, new WithReaderArgs[0]);
            if (reserved26 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved26 + " for reserved field.");
            }
            Boolean cctAndStepCodeColourValidity = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean cbAndStepCodeBrightnessValidity = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("cct", new PlcBOOL(cct));
            _map.put("stepCodeColourTemperature", new PlcSINT(stepCodeColourTemperature));
            _map.put("cb", new PlcBOOL(cb));
            _map.put("stepCodeBrightness", new PlcSINT(stepCodeBrightness));
            _map.put("cctAndStepCodeColourValidity", new PlcBOOL(cctAndStepCodeColourValidity));
            _map.put("cbAndStepCodeBrightnessValidity", new PlcBOOL(cbAndStepCodeBrightnessValidity));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Colour_RGBW))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Short colourLevelRed = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short colourLevelGreen = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short colourLevelBlue = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            Short colourLevelWhite = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            short reserved27 = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved27 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved27 + " for reserved field.");
            }
            if ((reserved27 = (short)readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved27 + " for reserved field.");
            }
            Boolean mr = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean mg = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean mb = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean mw = readBuffer.readBit("", new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("colourLevelRed", new PlcINT(colourLevelRed));
            _map.put("colourLevelGreen", new PlcINT(colourLevelGreen));
            _map.put("colourLevelBlue", new PlcINT(colourLevelBlue));
            _map.put("colourLevelWhite", new PlcINT(colourLevelWhite));
            _map.put("mr", new PlcBOOL(mr));
            _map.put("mg", new PlcBOOL(mg));
            _map.put("mb", new PlcBOOL(mb));
            _map.put("mw", new PlcBOOL(mw));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Relative_Control_RGBW))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean maskcw = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskcb = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskcg = readBuffer.readBit("", new WithReaderArgs[0]);
            Boolean maskcr = readBuffer.readBit("", new WithReaderArgs[0]);
            byte reserved28 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved28 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved28 + " for reserved field.");
            }
            Boolean cw = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeColourWhite = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            byte reserved29 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved29 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved29 + " for reserved field.");
            }
            Boolean cb = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeColourBlue = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            byte reserved30 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved30 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved30 + " for reserved field.");
            }
            Boolean cg = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeColourGreen = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            byte reserved31 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved31 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved31 + " for reserved field.");
            }
            Boolean cr = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeColourRed = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("maskcw", new PlcBOOL(maskcw));
            _map.put("maskcb", new PlcBOOL(maskcb));
            _map.put("maskcg", new PlcBOOL(maskcg));
            _map.put("maskcr", new PlcBOOL(maskcr));
            _map.put("cw", new PlcBOOL(cw));
            _map.put("stepCodeColourWhite", new PlcSINT(stepCodeColourWhite));
            _map.put("cb", new PlcBOOL(cb));
            _map.put("stepCodeColourBlue", new PlcSINT(stepCodeColourBlue));
            _map.put("cg", new PlcBOOL(cg));
            _map.put("stepCodeColourGreen", new PlcSINT(stepCodeColourGreen));
            _map.put("cr", new PlcBOOL(cr));
            _map.put("stepCodeColourRed", new PlcSINT(stepCodeColourRed));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Relative_Control_RGB))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            if ((reserved = (short)readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0])) != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Boolean cb = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeColourBlue = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            byte reserved32 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved32 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved32 + " for reserved field.");
            }
            Boolean cg = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeColourGreen = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            byte reserved33 = readBuffer.readUnsignedByte("", 4, new WithReaderArgs[0]);
            if (reserved33 != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved33 + " for reserved field.");
            }
            Boolean cr = readBuffer.readBit("", new WithReaderArgs[0]);
            Byte stepCodeColourRed = readBuffer.readUnsignedByte("", 3, new WithReaderArgs[0]);
            HashMap<String, Object> _map = new HashMap<String, Object>();
            _map.put("cb", new PlcBOOL(cb));
            _map.put("stepCodeColourBlue", new PlcSINT(stepCodeColourBlue));
            _map.put("cg", new PlcBOOL(cg));
            _map.put("stepCodeColourGreen", new PlcSINT(stepCodeColourGreen));
            _map.put("cr", new PlcBOOL(cr));
            _map.put("stepCodeColourRed", new PlcSINT(stepCodeColourRed));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_GeographicalLocation))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float longitude = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            Float latitude = Float.valueOf(readBuffer.readFloat("", 32, new WithReaderArgs[0]));
            HashMap<String, PlcREAL> _map = new HashMap<String, PlcREAL>();
            _map.put("longitude", new PlcREAL(longitude));
            _map.put("latitude", new PlcREAL(latitude));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TempRoomSetpSetF16_4))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float roomTemperatureSetpointComfort = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float roomTemperatureSetpointStandby = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float roomTemperatureSetpointEconomy = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float roomTemperatureSetpointBuildingProtection = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            HashMap<String, PlcREAL> _map = new HashMap<String, PlcREAL>();
            _map.put("roomTemperatureSetpointComfort", new PlcREAL(roomTemperatureSetpointComfort));
            _map.put("roomTemperatureSetpointStandby", new PlcREAL(roomTemperatureSetpointStandby));
            _map.put("roomTemperatureSetpointEconomy", new PlcREAL(roomTemperatureSetpointEconomy));
            _map.put("roomTemperatureSetpointBuildingProtection", new PlcREAL(roomTemperatureSetpointBuildingProtection));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TempRoomSetpSetShiftF16_4))) {
            short reserved = readBuffer.readUnsignedShort("", 8, new WithReaderArgs[0]);
            if (reserved != 0) {
                LOGGER.info("Expected constant value 0 but got " + reserved + " for reserved field.");
            }
            Float roomTemperatureSetpointShiftComfort = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float roomTemperatureSetpointShiftStandby = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float roomTemperatureSetpointShiftEconomy = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            Float roomTemperatureSetpointShiftBuildingProtection = Float.valueOf(readBuffer.readFloat("", 16, new WithReaderArgs[0]));
            HashMap<String, PlcREAL> _map = new HashMap<String, PlcREAL>();
            _map.put("roomTemperatureSetpointShiftComfort", new PlcREAL(roomTemperatureSetpointShiftComfort));
            _map.put("roomTemperatureSetpointShiftStandby", new PlcREAL(roomTemperatureSetpointShiftStandby));
            _map.put("roomTemperatureSetpointShiftEconomy", new PlcREAL(roomTemperatureSetpointShiftEconomy));
            _map.put("roomTemperatureSetpointShiftBuildingProtection", new PlcREAL(roomTemperatureSetpointShiftBuildingProtection));
            return new PlcStruct(_map);
        }
        return null;
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, KnxDatapointType datapointType) throws SerializationException {
        KnxDatapoint.staticSerialize(writeBuffer, _value, datapointType, ByteOrder.BIG_ENDIAN);
    }

    /*
     * Opcode count of 14566 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, KnxDatapointType datapointType, ByteOrder byteOrder) throws SerializationException {
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.BOOL))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.BYTE))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.WORD))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DWORD))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LWORD))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            BigInteger value = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.USINT))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.SINT))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            byte value = _value.getByte();
            writeBuffer.writeSignedByte("", 8, ((Number)value).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.UINT))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.INT))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.UDINT))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DINT))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.ULINT))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            BigInteger value = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 64, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LINT))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            long value = _value.getLong();
            writeBuffer.writeLong("", 64, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.REAL))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LREAL))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            double value = _value.getDouble();
            writeBuffer.writeDouble("", 64, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.CHAR))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            String value = _value.getString();
            writeBuffer.writeString("", 8, value, new WithWriterArgs[]{WithOption.WithEncoding((String)"UTF-8")});
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.WCHAR))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            String value = _value.getString();
            writeBuffer.writeString("", 16, value, new WithWriterArgs[]{WithOption.WithEncoding((String)"UTF-16")});
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.TIME))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            long milliseconds = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)milliseconds).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LTIME))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            BigInteger nanoseconds = _value.getBigInteger();
            writeBuffer.writeUnsignedBigInteger("", 64, nanoseconds, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DATE))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            long secondsSinceEpoch = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)secondsSinceEpoch).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.TIME_OF_DAY))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            long millisecondsSinceMidnight = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)millisecondsSinceMidnight).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.TOD))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            long millisecondsSinceMidnight = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)millisecondsSinceMidnight).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DATE_AND_TIME))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int year = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)year).intValue(), new WithWriterArgs[0]);
            short month = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)month).shortValue(), new WithWriterArgs[0]);
            short day = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)day).shortValue(), new WithWriterArgs[0]);
            short dayOfWeek = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)dayOfWeek).shortValue(), new WithWriterArgs[0]);
            short hour = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)hour).shortValue(), new WithWriterArgs[0]);
            short minutes = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)minutes).shortValue(), new WithWriterArgs[0]);
            short seconds = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)seconds).shortValue(), new WithWriterArgs[0]);
            long nanoseconds = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)nanoseconds).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DT))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int year = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)year).intValue(), new WithWriterArgs[0]);
            short month = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)month).shortValue(), new WithWriterArgs[0]);
            short day = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)day).shortValue(), new WithWriterArgs[0]);
            short dayOfWeek = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)dayOfWeek).shortValue(), new WithWriterArgs[0]);
            short hour = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)hour).shortValue(), new WithWriterArgs[0]);
            short minutes = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)minutes).shortValue(), new WithWriterArgs[0]);
            short seconds = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)seconds).shortValue(), new WithWriterArgs[0]);
            long nanoseconds = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)nanoseconds).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Switch))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Bool))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Enable))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Ramp))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Alarm))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BinaryValue))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Step))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_UpDown))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_OpenClose))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Start))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_State))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Invert))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DimSendStyle))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_InputSource))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Reset))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Ack))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Trigger))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Occupancy))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Window_Door))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LogicalFunction))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Scene_AB))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ShutterBlinds_Mode))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DayNight))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Heat_Cool))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Switch_Control))) {
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
            writeBuffer.writeBit("", control, new WithWriterArgs[0]);
            boolean on = ((PlcValue)_value.getStruct().get("on")).getBoolean();
            writeBuffer.writeBit("", on, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Bool_Control))) {
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
            writeBuffer.writeBit("", control, new WithWriterArgs[0]);
            boolean valueTrue = ((PlcValue)_value.getStruct().get("valueTrue")).getBoolean();
            writeBuffer.writeBit("", valueTrue, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Enable_Control))) {
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
            writeBuffer.writeBit("", control, new WithWriterArgs[0]);
            boolean enable = ((PlcValue)_value.getStruct().get("enable")).getBoolean();
            writeBuffer.writeBit("", enable, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Ramp_Control))) {
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
            writeBuffer.writeBit("", control, new WithWriterArgs[0]);
            boolean ramp = ((PlcValue)_value.getStruct().get("ramp")).getBoolean();
            writeBuffer.writeBit("", ramp, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Alarm_Control))) {
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
            writeBuffer.writeBit("", control, new WithWriterArgs[0]);
            boolean alarm = ((PlcValue)_value.getStruct().get("alarm")).getBoolean();
            writeBuffer.writeBit("", alarm, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BinaryValue_Control))) {
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
            writeBuffer.writeBit("", control, new WithWriterArgs[0]);
            boolean high = ((PlcValue)_value.getStruct().get("high")).getBoolean();
            writeBuffer.writeBit("", high, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Step_Control))) {
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
            writeBuffer.writeBit("", control, new WithWriterArgs[0]);
            boolean increase = ((PlcValue)_value.getStruct().get("increase")).getBoolean();
            writeBuffer.writeBit("", increase, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Direction1_Control))) {
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
            writeBuffer.writeBit("", control, new WithWriterArgs[0]);
            boolean down = ((PlcValue)_value.getStruct().get("down")).getBoolean();
            writeBuffer.writeBit("", down, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Direction2_Control))) {
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
            writeBuffer.writeBit("", control, new WithWriterArgs[0]);
            boolean close = ((PlcValue)_value.getStruct().get("close")).getBoolean();
            writeBuffer.writeBit("", close, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Start_Control))) {
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
            writeBuffer.writeBit("", control, new WithWriterArgs[0]);
            boolean start = ((PlcValue)_value.getStruct().get("start")).getBoolean();
            writeBuffer.writeBit("", start, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_State_Control))) {
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
            writeBuffer.writeBit("", control, new WithWriterArgs[0]);
            boolean active = ((PlcValue)_value.getStruct().get("active")).getBoolean();
            writeBuffer.writeBit("", active, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Invert_Control))) {
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean control = ((PlcValue)_value.getStruct().get("control")).getBoolean();
            writeBuffer.writeBit("", control, new WithWriterArgs[0]);
            boolean inverted = ((PlcValue)_value.getStruct().get("inverted")).getBoolean();
            writeBuffer.writeBit("", inverted, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Control_Dimming))) {
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean increase = ((PlcValue)_value.getStruct().get("increase")).getBoolean();
            writeBuffer.writeBit("", increase, new WithWriterArgs[0]);
            byte stepcode = ((PlcValue)_value.getStruct().get("stepcode")).getByte();
            writeBuffer.writeUnsignedByte("", 3, ((Number)stepcode).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Control_Blinds))) {
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean down = ((PlcValue)_value.getStruct().get("down")).getBoolean();
            writeBuffer.writeBit("", down, new WithWriterArgs[0]);
            byte stepcode = ((PlcValue)_value.getStruct().get("stepcode")).getByte();
            writeBuffer.writeUnsignedByte("", 3, ((Number)stepcode).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Char_ASCII))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            String value = _value.getString();
            writeBuffer.writeString("", 8, value, new WithWriterArgs[]{WithOption.WithEncoding((String)"ASCII")});
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Char_8859_1))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            String value = _value.getString();
            writeBuffer.writeString("", 8, value, new WithWriterArgs[]{WithOption.WithEncoding((String)"ISO-8859-1")});
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Scaling))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Angle))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Percent_U8))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DecimalFactor))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Tariff))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_1_Ucount))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FanStage))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Percent_V8))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            byte value = _value.getByte();
            writeBuffer.writeSignedByte("", 8, ((Number)value).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_1_Count))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            byte value = _value.getByte();
            writeBuffer.writeSignedByte("", 8, ((Number)value).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Status_Mode3))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            boolean statusA = ((PlcValue)_value.getStruct().get("statusA")).getBoolean();
            writeBuffer.writeBit("", statusA, new WithWriterArgs[0]);
            boolean statusB = ((PlcValue)_value.getStruct().get("statusB")).getBoolean();
            writeBuffer.writeBit("", statusB, new WithWriterArgs[0]);
            boolean statusC = ((PlcValue)_value.getStruct().get("statusC")).getBoolean();
            writeBuffer.writeBit("", statusC, new WithWriterArgs[0]);
            boolean statusD = ((PlcValue)_value.getStruct().get("statusD")).getBoolean();
            writeBuffer.writeBit("", statusD, new WithWriterArgs[0]);
            boolean statusE = ((PlcValue)_value.getStruct().get("statusE")).getBoolean();
            writeBuffer.writeBit("", statusE, new WithWriterArgs[0]);
            byte mode = ((PlcValue)_value.getStruct().get("mode")).getByte();
            writeBuffer.writeUnsignedByte("", 3, ((Number)mode).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_2_Ucount))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriodMsec))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriod10Msec))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriod100Msec))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriodSec))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriodMin))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriodHrs))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PropDataType))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Length_mm))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_UElCurrentmA))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Brightness))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Absolute_Colour_Temperature))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_2_Count))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTimeMsec))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTime10Msec))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTime100Msec))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTimeSec))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTimeMin))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTimeHrs))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Percent_V16))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Rotation_Angle))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Length_m))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeShort("", 16, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Temp))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Tempd))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Tempa))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Lux))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Wsp))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Pres))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Humidity))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_AirQuality))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_AirFlow))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Time1))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Time2))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Volt))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Curr))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PowerDensity))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_KelvinPerPercent))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Power))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Volume_Flow))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Rain_Amount))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Temp_F))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Wsp_kmh))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Absolute_Humidity))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Concentration_ygm3))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Coefficient))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimeOfDay))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            byte day = ((PlcValue)_value.getStruct().get("day")).getByte();
            writeBuffer.writeUnsignedByte("", 3, ((Number)day).byteValue(), new WithWriterArgs[0]);
            byte hour = ((PlcValue)_value.getStruct().get("hour")).getByte();
            writeBuffer.writeUnsignedByte("", 5, ((Number)hour).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 2, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte minutes = ((PlcValue)_value.getStruct().get("minutes")).getByte();
            writeBuffer.writeUnsignedByte("", 6, ((Number)minutes).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 2, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte seconds = ((PlcValue)_value.getStruct().get("seconds")).getByte();
            writeBuffer.writeUnsignedByte("", 6, ((Number)seconds).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Date))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 3, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte dayOfMonth = ((PlcValue)_value.getStruct().get("dayOfMonth")).getByte();
            writeBuffer.writeUnsignedByte("", 5, ((Number)dayOfMonth).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte month = ((PlcValue)_value.getStruct().get("month")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)month).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 1, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte year = ((PlcValue)_value.getStruct().get("year")).getByte();
            writeBuffer.writeUnsignedByte("", 7, ((Number)year).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_4_Ucount))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LongTimePeriod_Sec))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LongTimePeriod_Min))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LongTimePeriod_Hrs))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_VolumeLiquid_Litre))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Volume_m_3))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            long value = _value.getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_4_Count))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FlowRate_m3h))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActiveEnergy))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ApparantEnergy))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ReactiveEnergy))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActiveEnergy_kWh))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ApparantEnergy_kVAh))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ReactiveEnergy_kVARh))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActiveEnergy_MWh))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LongDeltaTimeSec))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaVolumeLiquid_Litre))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaVolume_m_3))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int value = _value.getInt();
            writeBuffer.writeInt("", 32, ((Number)value).intValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Acceleration))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Acceleration_Angular))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Activation_Energy))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Activity))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Mol))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Amplitude))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_AngleRad))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_AngleDeg))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Angular_Momentum))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Angular_Velocity))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Area))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Capacitance))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Charge_DensitySurface))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Charge_DensityVolume))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Compressibility))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Conductance))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electrical_Conductivity))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Density))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Charge))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Current))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_CurrentDensity))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_DipoleMoment))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Displacement))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_FieldStrength))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Flux))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_FluxDensity))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Polarization))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Potential))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_PotentialDifference))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_ElectromagneticMoment))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electromotive_Force))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Energy))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Force))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Frequency))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Angular_Frequency))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Heat_Capacity))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Heat_FlowRate))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Heat_Quantity))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Impedance))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Length))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Light_Quantity))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Luminance))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Luminous_Flux))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Luminous_Intensity))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_FieldStrength))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_Flux))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_FluxDensity))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_Moment))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_Polarization))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetization))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_MagnetomotiveForce))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Mass))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_MassFlux))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Momentum))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Phase_AngleRad))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Phase_AngleDeg))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Power))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Power_Factor))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Pressure))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Reactance))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Resistance))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Resistivity))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_SelfInductance))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_SolidAngle))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Sound_Intensity))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Speed))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Stress))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Surface_Tension))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Common_Temperature))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Absolute_Temperature))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_TemperatureDifference))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Thermal_Capacity))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Thermal_Conductivity))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_ThermoelectricPower))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Time))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Torque))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Volume))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Volume_Flux))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Weight))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Work))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_ApparentPower))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 32, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Volume_Flux_Meter))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Volume_Flux_ls))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float value = _value.getFloat();
            writeBuffer.writeFloat("", 16, value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Access_Data))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            byte hurz = ((PlcValue)_value.getStruct().get("hurz")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)hurz).byteValue(), new WithWriterArgs[0]);
            byte value1 = ((PlcValue)_value.getStruct().get("value1")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)value1).byteValue(), new WithWriterArgs[0]);
            byte value2 = ((PlcValue)_value.getStruct().get("value2")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)value2).byteValue(), new WithWriterArgs[0]);
            byte value3 = ((PlcValue)_value.getStruct().get("value3")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)value3).byteValue(), new WithWriterArgs[0]);
            byte value4 = ((PlcValue)_value.getStruct().get("value4")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)value4).byteValue(), new WithWriterArgs[0]);
            byte value5 = ((PlcValue)_value.getStruct().get("value5")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)value5).byteValue(), new WithWriterArgs[0]);
            boolean detectionError = ((PlcValue)_value.getStruct().get("detectionError")).getBoolean();
            writeBuffer.writeBit("", detectionError, new WithWriterArgs[0]);
            boolean permission = ((PlcValue)_value.getStruct().get("permission")).getBoolean();
            writeBuffer.writeBit("", permission, new WithWriterArgs[0]);
            boolean readDirection = ((PlcValue)_value.getStruct().get("readDirection")).getBoolean();
            writeBuffer.writeBit("", readDirection, new WithWriterArgs[0]);
            boolean encryptionOfAccessInformation = ((PlcValue)_value.getStruct().get("encryptionOfAccessInformation")).getBoolean();
            writeBuffer.writeBit("", encryptionOfAccessInformation, new WithWriterArgs[0]);
            byte indexOfAccessIdentificationCode = ((PlcValue)_value.getStruct().get("indexOfAccessIdentificationCode")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)indexOfAccessIdentificationCode).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_String_ASCII))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            String value = _value.getString();
            writeBuffer.writeString("", 112, value, new WithWriterArgs[]{WithOption.WithEncoding((String)"ASCII")});
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_String_8859_1))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            String value = _value.getString();
            writeBuffer.writeString("", 112, value, new WithWriterArgs[]{WithOption.WithEncoding((String)"ISO-8859-1")});
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SceneNumber))) {
            writeBuffer.writeUnsignedByte("", 2, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte value = _value.getByte();
            writeBuffer.writeUnsignedByte("", 6, ((Number)value).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SceneControl))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            boolean learnTheSceneCorrespondingToTheFieldSceneNumber = ((PlcValue)_value.getStruct().get("learnTheSceneCorrespondingToTheFieldSceneNumber")).getBoolean();
            writeBuffer.writeBit("", learnTheSceneCorrespondingToTheFieldSceneNumber, new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 1, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte sceneNumber = ((PlcValue)_value.getStruct().get("sceneNumber")).getByte();
            writeBuffer.writeUnsignedByte("", 6, ((Number)sceneNumber).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DateTime))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short year = ((PlcValue)_value.getStruct().get("year")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)year).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte month = ((PlcValue)_value.getStruct().get("month")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)month).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 3, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte dayofmonth = ((PlcValue)_value.getStruct().get("dayofmonth")).getByte();
            writeBuffer.writeUnsignedByte("", 5, ((Number)dayofmonth).byteValue(), new WithWriterArgs[0]);
            byte dayofweek = ((PlcValue)_value.getStruct().get("dayofweek")).getByte();
            writeBuffer.writeUnsignedByte("", 3, ((Number)dayofweek).byteValue(), new WithWriterArgs[0]);
            byte hourofday = ((PlcValue)_value.getStruct().get("hourofday")).getByte();
            writeBuffer.writeUnsignedByte("", 5, ((Number)hourofday).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 2, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte minutes = ((PlcValue)_value.getStruct().get("minutes")).getByte();
            writeBuffer.writeUnsignedByte("", 6, ((Number)minutes).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 2, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte seconds = ((PlcValue)_value.getStruct().get("seconds")).getByte();
            writeBuffer.writeUnsignedByte("", 6, ((Number)seconds).byteValue(), new WithWriterArgs[0]);
            boolean fault = ((PlcValue)_value.getStruct().get("fault")).getBoolean();
            writeBuffer.writeBit("", fault, new WithWriterArgs[0]);
            boolean workingDay = ((PlcValue)_value.getStruct().get("workingDay")).getBoolean();
            writeBuffer.writeBit("", workingDay, new WithWriterArgs[0]);
            boolean noWd = ((PlcValue)_value.getStruct().get("noWd")).getBoolean();
            writeBuffer.writeBit("", noWd, new WithWriterArgs[0]);
            boolean noYear = ((PlcValue)_value.getStruct().get("noYear")).getBoolean();
            writeBuffer.writeBit("", noYear, new WithWriterArgs[0]);
            boolean noDate = ((PlcValue)_value.getStruct().get("noDate")).getBoolean();
            writeBuffer.writeBit("", noDate, new WithWriterArgs[0]);
            boolean noDayOfWeek = ((PlcValue)_value.getStruct().get("noDayOfWeek")).getBoolean();
            writeBuffer.writeBit("", noDayOfWeek, new WithWriterArgs[0]);
            boolean noTime = ((PlcValue)_value.getStruct().get("noTime")).getBoolean();
            writeBuffer.writeBit("", noTime, new WithWriterArgs[0]);
            boolean standardSummerTime = ((PlcValue)_value.getStruct().get("standardSummerTime")).getBoolean();
            writeBuffer.writeBit("", standardSummerTime, new WithWriterArgs[0]);
            boolean qualityOfClock = ((PlcValue)_value.getStruct().get("qualityOfClock")).getBoolean();
            writeBuffer.writeBit("", qualityOfClock, new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SCLOMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BuildingMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_OccMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Priority))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LightApplicationMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ApplicationArea))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_AlarmClassType))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PSUMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ErrorClass_System))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ErrorClass_HVAC))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Time_Delay))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Beaufort_Wind_Force_Scale))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SensorSelect))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActuatorConnectType))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Cloud_Cover))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PowerReturnMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FuelType))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BurnerType))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVACMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DHWMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LoadPriority))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVACContrMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVACEmergMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ChangeoverMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ValveMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DamperMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HeaterMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FanMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_MasterSlaveMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusRoomSetp))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Metering_DeviceType))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HumDehumMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_EnableHCStage))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ADAType))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BackupMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StartSynchronization))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Behaviour_Lock_Unlock))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Behaviour_Bus_Power_Up_Down))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DALI_Fade_Time))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BlinkingMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LightControlMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SwitchPBModel))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PBAction))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DimmPBModel))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SwitchOnMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LoadTypeSet))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LoadTypeDetected))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Converter_Test_Control))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SABExcept_Behaviour))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SABBehaviour_Lock_Unlock))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SSSBMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BlindsControlMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CommMode))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_AddInfoTypes))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_RF_ModeSelect))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_RF_FilterSelect))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short value = _value.getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)value).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusGen))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 3, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean alarmStatusOfCorrespondingDatapointIsNotAcknowledged = ((PlcValue)_value.getStruct().get("alarmStatusOfCorrespondingDatapointIsNotAcknowledged")).getBoolean();
            writeBuffer.writeBit("", alarmStatusOfCorrespondingDatapointIsNotAcknowledged, new WithWriterArgs[0]);
            boolean correspondingDatapointIsInAlarm = ((PlcValue)_value.getStruct().get("correspondingDatapointIsInAlarm")).getBoolean();
            writeBuffer.writeBit("", correspondingDatapointIsInAlarm, new WithWriterArgs[0]);
            boolean correspondingDatapointMainValueIsOverridden = ((PlcValue)_value.getStruct().get("correspondingDatapointMainValueIsOverridden")).getBoolean();
            writeBuffer.writeBit("", correspondingDatapointMainValueIsOverridden, new WithWriterArgs[0]);
            boolean correspondingDatapointMainValueIsCorruptedDueToFailure = ((PlcValue)_value.getStruct().get("correspondingDatapointMainValueIsCorruptedDueToFailure")).getBoolean();
            writeBuffer.writeBit("", correspondingDatapointMainValueIsCorruptedDueToFailure, new WithWriterArgs[0]);
            boolean correspondingDatapointValueIsOutOfService = ((PlcValue)_value.getStruct().get("correspondingDatapointValueIsOutOfService")).getBoolean();
            writeBuffer.writeBit("", correspondingDatapointValueIsOutOfService, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Device_Control))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 5, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean verifyModeIsOn = ((PlcValue)_value.getStruct().get("verifyModeIsOn")).getBoolean();
            writeBuffer.writeBit("", verifyModeIsOn, new WithWriterArgs[0]);
            boolean aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived = ((PlcValue)_value.getStruct().get("aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived")).getBoolean();
            writeBuffer.writeBit("", aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived, new WithWriterArgs[0]);
            boolean theUserApplicationIsStopped = ((PlcValue)_value.getStruct().get("theUserApplicationIsStopped")).getBoolean();
            writeBuffer.writeBit("", theUserApplicationIsStopped, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ForceSign))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            boolean roomhmax = ((PlcValue)_value.getStruct().get("roomhmax")).getBoolean();
            writeBuffer.writeBit("", roomhmax, new WithWriterArgs[0]);
            boolean roomhconf = ((PlcValue)_value.getStruct().get("roomhconf")).getBoolean();
            writeBuffer.writeBit("", roomhconf, new WithWriterArgs[0]);
            boolean dhwlegio = ((PlcValue)_value.getStruct().get("dhwlegio")).getBoolean();
            writeBuffer.writeBit("", dhwlegio, new WithWriterArgs[0]);
            boolean dhwnorm = ((PlcValue)_value.getStruct().get("dhwnorm")).getBoolean();
            writeBuffer.writeBit("", dhwnorm, new WithWriterArgs[0]);
            boolean overrun = ((PlcValue)_value.getStruct().get("overrun")).getBoolean();
            writeBuffer.writeBit("", overrun, new WithWriterArgs[0]);
            boolean oversupply = ((PlcValue)_value.getStruct().get("oversupply")).getBoolean();
            writeBuffer.writeBit("", oversupply, new WithWriterArgs[0]);
            boolean protection = ((PlcValue)_value.getStruct().get("protection")).getBoolean();
            writeBuffer.writeBit("", protection, new WithWriterArgs[0]);
            boolean forcerequest = ((PlcValue)_value.getStruct().get("forcerequest")).getBoolean();
            writeBuffer.writeBit("", forcerequest, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ForceSignCool))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusRHC))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            boolean summermode = ((PlcValue)_value.getStruct().get("summermode")).getBoolean();
            writeBuffer.writeBit("", summermode, new WithWriterArgs[0]);
            boolean statusstopoptim = ((PlcValue)_value.getStruct().get("statusstopoptim")).getBoolean();
            writeBuffer.writeBit("", statusstopoptim, new WithWriterArgs[0]);
            boolean statusstartoptim = ((PlcValue)_value.getStruct().get("statusstartoptim")).getBoolean();
            writeBuffer.writeBit("", statusstartoptim, new WithWriterArgs[0]);
            boolean statusmorningboost = ((PlcValue)_value.getStruct().get("statusmorningboost")).getBoolean();
            writeBuffer.writeBit("", statusmorningboost, new WithWriterArgs[0]);
            boolean tempreturnlimit = ((PlcValue)_value.getStruct().get("tempreturnlimit")).getBoolean();
            writeBuffer.writeBit("", tempreturnlimit, new WithWriterArgs[0]);
            boolean tempflowlimit = ((PlcValue)_value.getStruct().get("tempflowlimit")).getBoolean();
            writeBuffer.writeBit("", tempflowlimit, new WithWriterArgs[0]);
            boolean satuseco = ((PlcValue)_value.getStruct().get("satuseco")).getBoolean();
            writeBuffer.writeBit("", satuseco, new WithWriterArgs[0]);
            boolean fault = ((PlcValue)_value.getStruct().get("fault")).getBoolean();
            writeBuffer.writeBit("", fault, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusSDHWC))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 5, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean solarloadsufficient = ((PlcValue)_value.getStruct().get("solarloadsufficient")).getBoolean();
            writeBuffer.writeBit("", solarloadsufficient, new WithWriterArgs[0]);
            boolean sdhwloadactive = ((PlcValue)_value.getStruct().get("sdhwloadactive")).getBoolean();
            writeBuffer.writeBit("", sdhwloadactive, new WithWriterArgs[0]);
            boolean fault = ((PlcValue)_value.getStruct().get("fault")).getBoolean();
            writeBuffer.writeBit("", fault, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FuelTypeSet))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 5, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean solidstate = ((PlcValue)_value.getStruct().get("solidstate")).getBoolean();
            writeBuffer.writeBit("", solidstate, new WithWriterArgs[0]);
            boolean gas = ((PlcValue)_value.getStruct().get("gas")).getBoolean();
            writeBuffer.writeBit("", gas, new WithWriterArgs[0]);
            boolean oil = ((PlcValue)_value.getStruct().get("oil")).getBoolean();
            writeBuffer.writeBit("", oil, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusRCC))) {
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean value = _value.getBoolean();
            writeBuffer.writeBit("", value, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusAHU))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean cool = ((PlcValue)_value.getStruct().get("cool")).getBoolean();
            writeBuffer.writeBit("", cool, new WithWriterArgs[0]);
            boolean heat = ((PlcValue)_value.getStruct().get("heat")).getBoolean();
            writeBuffer.writeBit("", heat, new WithWriterArgs[0]);
            boolean fanactive = ((PlcValue)_value.getStruct().get("fanactive")).getBoolean();
            writeBuffer.writeBit("", fanactive, new WithWriterArgs[0]);
            boolean fault = ((PlcValue)_value.getStruct().get("fault")).getBoolean();
            writeBuffer.writeBit("", fault, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedStatus_RTSM))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 3, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean statusOfHvacModeUser = ((PlcValue)_value.getStruct().get("statusOfHvacModeUser")).getBoolean();
            writeBuffer.writeBit("", statusOfHvacModeUser, new WithWriterArgs[0]);
            boolean statusOfComfortProlongationUser = ((PlcValue)_value.getStruct().get("statusOfComfortProlongationUser")).getBoolean();
            writeBuffer.writeBit("", statusOfComfortProlongationUser, new WithWriterArgs[0]);
            boolean effectiveValueOfTheComfortPushButton = ((PlcValue)_value.getStruct().get("effectiveValueOfTheComfortPushButton")).getBoolean();
            writeBuffer.writeBit("", effectiveValueOfTheComfortPushButton, new WithWriterArgs[0]);
            boolean effectiveValueOfThePresenceStatus = ((PlcValue)_value.getStruct().get("effectiveValueOfThePresenceStatus")).getBoolean();
            writeBuffer.writeBit("", effectiveValueOfThePresenceStatus, new WithWriterArgs[0]);
            boolean effectiveValueOfTheWindowStatus = ((PlcValue)_value.getStruct().get("effectiveValueOfTheWindowStatus")).getBoolean();
            writeBuffer.writeBit("", effectiveValueOfTheWindowStatus, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LightActuatorErrorInfo))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 1, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean overheat = ((PlcValue)_value.getStruct().get("overheat")).getBoolean();
            writeBuffer.writeBit("", overheat, new WithWriterArgs[0]);
            boolean lampfailure = ((PlcValue)_value.getStruct().get("lampfailure")).getBoolean();
            writeBuffer.writeBit("", lampfailure, new WithWriterArgs[0]);
            boolean defectiveload = ((PlcValue)_value.getStruct().get("defectiveload")).getBoolean();
            writeBuffer.writeBit("", defectiveload, new WithWriterArgs[0]);
            boolean underload = ((PlcValue)_value.getStruct().get("underload")).getBoolean();
            writeBuffer.writeBit("", underload, new WithWriterArgs[0]);
            boolean overcurrent = ((PlcValue)_value.getStruct().get("overcurrent")).getBoolean();
            writeBuffer.writeBit("", overcurrent, new WithWriterArgs[0]);
            boolean undervoltage = ((PlcValue)_value.getStruct().get("undervoltage")).getBoolean();
            writeBuffer.writeBit("", undervoltage, new WithWriterArgs[0]);
            boolean loaddetectionerror = ((PlcValue)_value.getStruct().get("loaddetectionerror")).getBoolean();
            writeBuffer.writeBit("", loaddetectionerror, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_RF_ModeInfo))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 5, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean bibatSlave = ((PlcValue)_value.getStruct().get("bibatSlave")).getBoolean();
            writeBuffer.writeBit("", bibatSlave, new WithWriterArgs[0]);
            boolean bibatMaster = ((PlcValue)_value.getStruct().get("bibatMaster")).getBoolean();
            writeBuffer.writeBit("", bibatMaster, new WithWriterArgs[0]);
            boolean asynchronous = ((PlcValue)_value.getStruct().get("asynchronous")).getBoolean();
            writeBuffer.writeBit("", asynchronous, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_RF_FilterInfo))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 5, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean doa = ((PlcValue)_value.getStruct().get("doa")).getBoolean();
            writeBuffer.writeBit("", doa, new WithWriterArgs[0]);
            boolean knxSn = ((PlcValue)_value.getStruct().get("knxSn")).getBoolean();
            writeBuffer.writeBit("", knxSn, new WithWriterArgs[0]);
            boolean doaAndKnxSn = ((PlcValue)_value.getStruct().get("doaAndKnxSn")).getBoolean();
            writeBuffer.writeBit("", doaAndKnxSn, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Channel_Activation_8))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            boolean activationStateOfChannel1 = ((PlcValue)_value.getStruct().get("activationStateOfChannel1")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel1, new WithWriterArgs[0]);
            boolean activationStateOfChannel2 = ((PlcValue)_value.getStruct().get("activationStateOfChannel2")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel2, new WithWriterArgs[0]);
            boolean activationStateOfChannel3 = ((PlcValue)_value.getStruct().get("activationStateOfChannel3")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel3, new WithWriterArgs[0]);
            boolean activationStateOfChannel4 = ((PlcValue)_value.getStruct().get("activationStateOfChannel4")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel4, new WithWriterArgs[0]);
            boolean activationStateOfChannel5 = ((PlcValue)_value.getStruct().get("activationStateOfChannel5")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel5, new WithWriterArgs[0]);
            boolean activationStateOfChannel6 = ((PlcValue)_value.getStruct().get("activationStateOfChannel6")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel6, new WithWriterArgs[0]);
            boolean activationStateOfChannel7 = ((PlcValue)_value.getStruct().get("activationStateOfChannel7")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel7, new WithWriterArgs[0]);
            boolean activationStateOfChannel8 = ((PlcValue)_value.getStruct().get("activationStateOfChannel8")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel8, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusDHWC))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            boolean tempoptimshiftactive = ((PlcValue)_value.getStruct().get("tempoptimshiftactive")).getBoolean();
            writeBuffer.writeBit("", tempoptimshiftactive, new WithWriterArgs[0]);
            boolean solarenergysupport = ((PlcValue)_value.getStruct().get("solarenergysupport")).getBoolean();
            writeBuffer.writeBit("", solarenergysupport, new WithWriterArgs[0]);
            boolean solarenergyonly = ((PlcValue)_value.getStruct().get("solarenergyonly")).getBoolean();
            writeBuffer.writeBit("", solarenergyonly, new WithWriterArgs[0]);
            boolean otherenergysourceactive = ((PlcValue)_value.getStruct().get("otherenergysourceactive")).getBoolean();
            writeBuffer.writeBit("", otherenergysourceactive, new WithWriterArgs[0]);
            boolean dhwpushactive = ((PlcValue)_value.getStruct().get("dhwpushactive")).getBoolean();
            writeBuffer.writeBit("", dhwpushactive, new WithWriterArgs[0]);
            boolean legioprotactive = ((PlcValue)_value.getStruct().get("legioprotactive")).getBoolean();
            writeBuffer.writeBit("", legioprotactive, new WithWriterArgs[0]);
            boolean dhwloadactive = ((PlcValue)_value.getStruct().get("dhwloadactive")).getBoolean();
            writeBuffer.writeBit("", dhwloadactive, new WithWriterArgs[0]);
            boolean fault = ((PlcValue)_value.getStruct().get("fault")).getBoolean();
            writeBuffer.writeBit("", fault, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusRHCC))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 1, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean overheatalarm = ((PlcValue)_value.getStruct().get("overheatalarm")).getBoolean();
            writeBuffer.writeBit("", overheatalarm, new WithWriterArgs[0]);
            boolean frostalarm = ((PlcValue)_value.getStruct().get("frostalarm")).getBoolean();
            writeBuffer.writeBit("", frostalarm, new WithWriterArgs[0]);
            boolean dewpointstatus = ((PlcValue)_value.getStruct().get("dewpointstatus")).getBoolean();
            writeBuffer.writeBit("", dewpointstatus, new WithWriterArgs[0]);
            boolean coolingdisabled = ((PlcValue)_value.getStruct().get("coolingdisabled")).getBoolean();
            writeBuffer.writeBit("", coolingdisabled, new WithWriterArgs[0]);
            boolean statusprecool = ((PlcValue)_value.getStruct().get("statusprecool")).getBoolean();
            writeBuffer.writeBit("", statusprecool, new WithWriterArgs[0]);
            boolean statusecoc = ((PlcValue)_value.getStruct().get("statusecoc")).getBoolean();
            writeBuffer.writeBit("", statusecoc, new WithWriterArgs[0]);
            boolean heatcoolmode = ((PlcValue)_value.getStruct().get("heatcoolmode")).getBoolean();
            writeBuffer.writeBit("", heatcoolmode, new WithWriterArgs[0]);
            boolean heatingdiabled = ((PlcValue)_value.getStruct().get("heatingdiabled")).getBoolean();
            writeBuffer.writeBit("", heatingdiabled, new WithWriterArgs[0]);
            boolean statusstopoptim = ((PlcValue)_value.getStruct().get("statusstopoptim")).getBoolean();
            writeBuffer.writeBit("", statusstopoptim, new WithWriterArgs[0]);
            boolean statusstartoptim = ((PlcValue)_value.getStruct().get("statusstartoptim")).getBoolean();
            writeBuffer.writeBit("", statusstartoptim, new WithWriterArgs[0]);
            boolean statusmorningboosth = ((PlcValue)_value.getStruct().get("statusmorningboosth")).getBoolean();
            writeBuffer.writeBit("", statusmorningboosth, new WithWriterArgs[0]);
            boolean tempflowreturnlimit = ((PlcValue)_value.getStruct().get("tempflowreturnlimit")).getBoolean();
            writeBuffer.writeBit("", tempflowreturnlimit, new WithWriterArgs[0]);
            boolean tempflowlimit = ((PlcValue)_value.getStruct().get("tempflowlimit")).getBoolean();
            writeBuffer.writeBit("", tempflowlimit, new WithWriterArgs[0]);
            boolean statusecoh = ((PlcValue)_value.getStruct().get("statusecoh")).getBoolean();
            writeBuffer.writeBit("", statusecoh, new WithWriterArgs[0]);
            boolean fault = ((PlcValue)_value.getStruct().get("fault")).getBoolean();
            writeBuffer.writeBit("", fault, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedStatus_HVA))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean calibrationMode = ((PlcValue)_value.getStruct().get("calibrationMode")).getBoolean();
            writeBuffer.writeBit("", calibrationMode, new WithWriterArgs[0]);
            boolean lockedPosition = ((PlcValue)_value.getStruct().get("lockedPosition")).getBoolean();
            writeBuffer.writeBit("", lockedPosition, new WithWriterArgs[0]);
            boolean forcedPosition = ((PlcValue)_value.getStruct().get("forcedPosition")).getBoolean();
            writeBuffer.writeBit("", forcedPosition, new WithWriterArgs[0]);
            boolean manuaOperationOverridden = ((PlcValue)_value.getStruct().get("manuaOperationOverridden")).getBoolean();
            writeBuffer.writeBit("", manuaOperationOverridden, new WithWriterArgs[0]);
            boolean serviceMode = ((PlcValue)_value.getStruct().get("serviceMode")).getBoolean();
            writeBuffer.writeBit("", serviceMode, new WithWriterArgs[0]);
            boolean valveKick = ((PlcValue)_value.getStruct().get("valveKick")).getBoolean();
            writeBuffer.writeBit("", valveKick, new WithWriterArgs[0]);
            boolean overload = ((PlcValue)_value.getStruct().get("overload")).getBoolean();
            writeBuffer.writeBit("", overload, new WithWriterArgs[0]);
            boolean shortCircuit = ((PlcValue)_value.getStruct().get("shortCircuit")).getBoolean();
            writeBuffer.writeBit("", shortCircuit, new WithWriterArgs[0]);
            boolean currentValvePosition = ((PlcValue)_value.getStruct().get("currentValvePosition")).getBoolean();
            writeBuffer.writeBit("", currentValvePosition, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedStatus_RTC))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 7, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean coolingModeEnabled = ((PlcValue)_value.getStruct().get("coolingModeEnabled")).getBoolean();
            writeBuffer.writeBit("", coolingModeEnabled, new WithWriterArgs[0]);
            boolean heatingModeEnabled = ((PlcValue)_value.getStruct().get("heatingModeEnabled")).getBoolean();
            writeBuffer.writeBit("", heatingModeEnabled, new WithWriterArgs[0]);
            boolean additionalHeatingCoolingStage2Stage = ((PlcValue)_value.getStruct().get("additionalHeatingCoolingStage2Stage")).getBoolean();
            writeBuffer.writeBit("", additionalHeatingCoolingStage2Stage, new WithWriterArgs[0]);
            boolean controllerInactive = ((PlcValue)_value.getStruct().get("controllerInactive")).getBoolean();
            writeBuffer.writeBit("", controllerInactive, new WithWriterArgs[0]);
            boolean overheatAlarm = ((PlcValue)_value.getStruct().get("overheatAlarm")).getBoolean();
            writeBuffer.writeBit("", overheatAlarm, new WithWriterArgs[0]);
            boolean frostAlarm = ((PlcValue)_value.getStruct().get("frostAlarm")).getBoolean();
            writeBuffer.writeBit("", frostAlarm, new WithWriterArgs[0]);
            boolean dewPointStatus = ((PlcValue)_value.getStruct().get("dewPointStatus")).getBoolean();
            writeBuffer.writeBit("", dewPointStatus, new WithWriterArgs[0]);
            boolean activeMode = ((PlcValue)_value.getStruct().get("activeMode")).getBoolean();
            writeBuffer.writeBit("", activeMode, new WithWriterArgs[0]);
            boolean generalFailureInformation = ((PlcValue)_value.getStruct().get("generalFailureInformation")).getBoolean();
            writeBuffer.writeBit("", generalFailureInformation, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Media))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedShort("", 10, ((Number)0).shortValue(), new WithWriterArgs[0]);
            boolean knxIp = ((PlcValue)_value.getStruct().get("knxIp")).getBoolean();
            writeBuffer.writeBit("", knxIp, new WithWriterArgs[0]);
            boolean rf = ((PlcValue)_value.getStruct().get("rf")).getBoolean();
            writeBuffer.writeBit("", rf, new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 1, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean pl110 = ((PlcValue)_value.getStruct().get("pl110")).getBoolean();
            writeBuffer.writeBit("", pl110, new WithWriterArgs[0]);
            boolean tp1 = ((PlcValue)_value.getStruct().get("tp1")).getBoolean();
            writeBuffer.writeBit("", tp1, new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 1, ((Number)0).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Channel_Activation_16))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            boolean activationStateOfChannel1 = ((PlcValue)_value.getStruct().get("activationStateOfChannel1")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel1, new WithWriterArgs[0]);
            boolean activationStateOfChannel2 = ((PlcValue)_value.getStruct().get("activationStateOfChannel2")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel2, new WithWriterArgs[0]);
            boolean activationStateOfChannel3 = ((PlcValue)_value.getStruct().get("activationStateOfChannel3")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel3, new WithWriterArgs[0]);
            boolean activationStateOfChannel4 = ((PlcValue)_value.getStruct().get("activationStateOfChannel4")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel4, new WithWriterArgs[0]);
            boolean activationStateOfChannel5 = ((PlcValue)_value.getStruct().get("activationStateOfChannel5")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel5, new WithWriterArgs[0]);
            boolean activationStateOfChannel6 = ((PlcValue)_value.getStruct().get("activationStateOfChannel6")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel6, new WithWriterArgs[0]);
            boolean activationStateOfChannel7 = ((PlcValue)_value.getStruct().get("activationStateOfChannel7")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel7, new WithWriterArgs[0]);
            boolean activationStateOfChannel8 = ((PlcValue)_value.getStruct().get("activationStateOfChannel8")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel8, new WithWriterArgs[0]);
            boolean activationStateOfChannel9 = ((PlcValue)_value.getStruct().get("activationStateOfChannel9")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel9, new WithWriterArgs[0]);
            boolean activationStateOfChannel10 = ((PlcValue)_value.getStruct().get("activationStateOfChannel10")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel10, new WithWriterArgs[0]);
            boolean activationStateOfChannel11 = ((PlcValue)_value.getStruct().get("activationStateOfChannel11")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel11, new WithWriterArgs[0]);
            boolean activationStateOfChannel12 = ((PlcValue)_value.getStruct().get("activationStateOfChannel12")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel12, new WithWriterArgs[0]);
            boolean activationStateOfChannel13 = ((PlcValue)_value.getStruct().get("activationStateOfChannel13")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel13, new WithWriterArgs[0]);
            boolean activationStateOfChannel14 = ((PlcValue)_value.getStruct().get("activationStateOfChannel14")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel14, new WithWriterArgs[0]);
            boolean activationStateOfChannel15 = ((PlcValue)_value.getStruct().get("activationStateOfChannel15")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel15, new WithWriterArgs[0]);
            boolean activationStateOfChannel16 = ((PlcValue)_value.getStruct().get("activationStateOfChannel16")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel16, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_OnOffAction))) {
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte value = _value.getByte();
            writeBuffer.writeUnsignedByte("", 2, ((Number)value).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Alarm_Reaction))) {
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte value = _value.getByte();
            writeBuffer.writeUnsignedByte("", 2, ((Number)value).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_UpDown_Action))) {
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte value = _value.getByte();
            writeBuffer.writeUnsignedByte("", 2, ((Number)value).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVAC_PB_Action))) {
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte value = _value.getByte();
            writeBuffer.writeUnsignedByte("", 2, ((Number)value).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DoubleNibble))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            byte busy = ((PlcValue)_value.getStruct().get("busy")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)busy).byteValue(), new WithWriterArgs[0]);
            byte nak = ((PlcValue)_value.getStruct().get("nak")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)nak).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SceneInfo))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 1, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean sceneIsInactive = ((PlcValue)_value.getStruct().get("sceneIsInactive")).getBoolean();
            writeBuffer.writeBit("", sceneIsInactive, new WithWriterArgs[0]);
            byte scenenumber = ((PlcValue)_value.getStruct().get("scenenumber")).getByte();
            writeBuffer.writeUnsignedByte("", 6, ((Number)scenenumber).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedInfoOnOff))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            boolean maskBitInfoOnOffOutput16 = ((PlcValue)_value.getStruct().get("maskBitInfoOnOffOutput16")).getBoolean();
            writeBuffer.writeBit("", maskBitInfoOnOffOutput16, new WithWriterArgs[0]);
            boolean maskBitInfoOnOffOutput15 = ((PlcValue)_value.getStruct().get("maskBitInfoOnOffOutput15")).getBoolean();
            writeBuffer.writeBit("", maskBitInfoOnOffOutput15, new WithWriterArgs[0]);
            boolean maskBitInfoOnOffOutput14 = ((PlcValue)_value.getStruct().get("maskBitInfoOnOffOutput14")).getBoolean();
            writeBuffer.writeBit("", maskBitInfoOnOffOutput14, new WithWriterArgs[0]);
            boolean maskBitInfoOnOffOutput13 = ((PlcValue)_value.getStruct().get("maskBitInfoOnOffOutput13")).getBoolean();
            writeBuffer.writeBit("", maskBitInfoOnOffOutput13, new WithWriterArgs[0]);
            boolean maskBitInfoOnOffOutput12 = ((PlcValue)_value.getStruct().get("maskBitInfoOnOffOutput12")).getBoolean();
            writeBuffer.writeBit("", maskBitInfoOnOffOutput12, new WithWriterArgs[0]);
            boolean maskBitInfoOnOffOutput11 = ((PlcValue)_value.getStruct().get("maskBitInfoOnOffOutput11")).getBoolean();
            writeBuffer.writeBit("", maskBitInfoOnOffOutput11, new WithWriterArgs[0]);
            boolean maskBitInfoOnOffOutput10 = ((PlcValue)_value.getStruct().get("maskBitInfoOnOffOutput10")).getBoolean();
            writeBuffer.writeBit("", maskBitInfoOnOffOutput10, new WithWriterArgs[0]);
            boolean maskBitInfoOnOffOutput9 = ((PlcValue)_value.getStruct().get("maskBitInfoOnOffOutput9")).getBoolean();
            writeBuffer.writeBit("", maskBitInfoOnOffOutput9, new WithWriterArgs[0]);
            boolean maskBitInfoOnOffOutput8 = ((PlcValue)_value.getStruct().get("maskBitInfoOnOffOutput8")).getBoolean();
            writeBuffer.writeBit("", maskBitInfoOnOffOutput8, new WithWriterArgs[0]);
            boolean maskBitInfoOnOffOutput7 = ((PlcValue)_value.getStruct().get("maskBitInfoOnOffOutput7")).getBoolean();
            writeBuffer.writeBit("", maskBitInfoOnOffOutput7, new WithWriterArgs[0]);
            boolean maskBitInfoOnOffOutput6 = ((PlcValue)_value.getStruct().get("maskBitInfoOnOffOutput6")).getBoolean();
            writeBuffer.writeBit("", maskBitInfoOnOffOutput6, new WithWriterArgs[0]);
            boolean maskBitInfoOnOffOutput5 = ((PlcValue)_value.getStruct().get("maskBitInfoOnOffOutput5")).getBoolean();
            writeBuffer.writeBit("", maskBitInfoOnOffOutput5, new WithWriterArgs[0]);
            boolean maskBitInfoOnOffOutput4 = ((PlcValue)_value.getStruct().get("maskBitInfoOnOffOutput4")).getBoolean();
            writeBuffer.writeBit("", maskBitInfoOnOffOutput4, new WithWriterArgs[0]);
            boolean maskBitInfoOnOffOutput3 = ((PlcValue)_value.getStruct().get("maskBitInfoOnOffOutput3")).getBoolean();
            writeBuffer.writeBit("", maskBitInfoOnOffOutput3, new WithWriterArgs[0]);
            boolean maskBitInfoOnOffOutput2 = ((PlcValue)_value.getStruct().get("maskBitInfoOnOffOutput2")).getBoolean();
            writeBuffer.writeBit("", maskBitInfoOnOffOutput2, new WithWriterArgs[0]);
            boolean maskBitInfoOnOffOutput1 = ((PlcValue)_value.getStruct().get("maskBitInfoOnOffOutput1")).getBoolean();
            writeBuffer.writeBit("", maskBitInfoOnOffOutput1, new WithWriterArgs[0]);
            boolean infoOnOffOutput16 = ((PlcValue)_value.getStruct().get("infoOnOffOutput16")).getBoolean();
            writeBuffer.writeBit("", infoOnOffOutput16, new WithWriterArgs[0]);
            boolean infoOnOffOutput15 = ((PlcValue)_value.getStruct().get("infoOnOffOutput15")).getBoolean();
            writeBuffer.writeBit("", infoOnOffOutput15, new WithWriterArgs[0]);
            boolean infoOnOffOutput14 = ((PlcValue)_value.getStruct().get("infoOnOffOutput14")).getBoolean();
            writeBuffer.writeBit("", infoOnOffOutput14, new WithWriterArgs[0]);
            boolean infoOnOffOutput13 = ((PlcValue)_value.getStruct().get("infoOnOffOutput13")).getBoolean();
            writeBuffer.writeBit("", infoOnOffOutput13, new WithWriterArgs[0]);
            boolean infoOnOffOutput12 = ((PlcValue)_value.getStruct().get("infoOnOffOutput12")).getBoolean();
            writeBuffer.writeBit("", infoOnOffOutput12, new WithWriterArgs[0]);
            boolean infoOnOffOutput11 = ((PlcValue)_value.getStruct().get("infoOnOffOutput11")).getBoolean();
            writeBuffer.writeBit("", infoOnOffOutput11, new WithWriterArgs[0]);
            boolean infoOnOffOutput10 = ((PlcValue)_value.getStruct().get("infoOnOffOutput10")).getBoolean();
            writeBuffer.writeBit("", infoOnOffOutput10, new WithWriterArgs[0]);
            boolean infoOnOffOutput9 = ((PlcValue)_value.getStruct().get("infoOnOffOutput9")).getBoolean();
            writeBuffer.writeBit("", infoOnOffOutput9, new WithWriterArgs[0]);
            boolean infoOnOffOutput8 = ((PlcValue)_value.getStruct().get("infoOnOffOutput8")).getBoolean();
            writeBuffer.writeBit("", infoOnOffOutput8, new WithWriterArgs[0]);
            boolean infoOnOffOutput7 = ((PlcValue)_value.getStruct().get("infoOnOffOutput7")).getBoolean();
            writeBuffer.writeBit("", infoOnOffOutput7, new WithWriterArgs[0]);
            boolean infoOnOffOutput6 = ((PlcValue)_value.getStruct().get("infoOnOffOutput6")).getBoolean();
            writeBuffer.writeBit("", infoOnOffOutput6, new WithWriterArgs[0]);
            boolean infoOnOffOutput5 = ((PlcValue)_value.getStruct().get("infoOnOffOutput5")).getBoolean();
            writeBuffer.writeBit("", infoOnOffOutput5, new WithWriterArgs[0]);
            boolean infoOnOffOutput4 = ((PlcValue)_value.getStruct().get("infoOnOffOutput4")).getBoolean();
            writeBuffer.writeBit("", infoOnOffOutput4, new WithWriterArgs[0]);
            boolean infoOnOffOutput3 = ((PlcValue)_value.getStruct().get("infoOnOffOutput3")).getBoolean();
            writeBuffer.writeBit("", infoOnOffOutput3, new WithWriterArgs[0]);
            boolean infoOnOffOutput2 = ((PlcValue)_value.getStruct().get("infoOnOffOutput2")).getBoolean();
            writeBuffer.writeBit("", infoOnOffOutput2, new WithWriterArgs[0]);
            boolean infoOnOffOutput1 = ((PlcValue)_value.getStruct().get("infoOnOffOutput1")).getBoolean();
            writeBuffer.writeBit("", infoOnOffOutput1, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActiveEnergy_V64))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            long value = _value.getLong();
            writeBuffer.writeLong("", 64, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ApparantEnergy_V64))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            long value = _value.getLong();
            writeBuffer.writeLong("", 64, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ReactiveEnergy_V64))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            long value = _value.getLong();
            writeBuffer.writeLong("", 64, ((Number)value).longValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Channel_Activation_24))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            boolean activationStateOfChannel1 = ((PlcValue)_value.getStruct().get("activationStateOfChannel1")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel1, new WithWriterArgs[0]);
            boolean activationStateOfChannel2 = ((PlcValue)_value.getStruct().get("activationStateOfChannel2")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel2, new WithWriterArgs[0]);
            boolean activationStateOfChannel3 = ((PlcValue)_value.getStruct().get("activationStateOfChannel3")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel3, new WithWriterArgs[0]);
            boolean activationStateOfChannel4 = ((PlcValue)_value.getStruct().get("activationStateOfChannel4")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel4, new WithWriterArgs[0]);
            boolean activationStateOfChannel5 = ((PlcValue)_value.getStruct().get("activationStateOfChannel5")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel5, new WithWriterArgs[0]);
            boolean activationStateOfChannel6 = ((PlcValue)_value.getStruct().get("activationStateOfChannel6")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel6, new WithWriterArgs[0]);
            boolean activationStateOfChannel7 = ((PlcValue)_value.getStruct().get("activationStateOfChannel7")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel7, new WithWriterArgs[0]);
            boolean activationStateOfChannel8 = ((PlcValue)_value.getStruct().get("activationStateOfChannel8")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel8, new WithWriterArgs[0]);
            boolean activationStateOfChannel9 = ((PlcValue)_value.getStruct().get("activationStateOfChannel9")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel9, new WithWriterArgs[0]);
            boolean activationStateOfChannel10 = ((PlcValue)_value.getStruct().get("activationStateOfChannel10")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel10, new WithWriterArgs[0]);
            boolean activationStateOfChannel11 = ((PlcValue)_value.getStruct().get("activationStateOfChannel11")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel11, new WithWriterArgs[0]);
            boolean activationStateOfChannel12 = ((PlcValue)_value.getStruct().get("activationStateOfChannel12")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel12, new WithWriterArgs[0]);
            boolean activationStateOfChannel13 = ((PlcValue)_value.getStruct().get("activationStateOfChannel13")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel13, new WithWriterArgs[0]);
            boolean activationStateOfChannel14 = ((PlcValue)_value.getStruct().get("activationStateOfChannel14")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel14, new WithWriterArgs[0]);
            boolean activationStateOfChannel15 = ((PlcValue)_value.getStruct().get("activationStateOfChannel15")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel15, new WithWriterArgs[0]);
            boolean activationStateOfChannel16 = ((PlcValue)_value.getStruct().get("activationStateOfChannel16")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel16, new WithWriterArgs[0]);
            boolean activationStateOfChannel17 = ((PlcValue)_value.getStruct().get("activationStateOfChannel17")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel17, new WithWriterArgs[0]);
            boolean activationStateOfChannel18 = ((PlcValue)_value.getStruct().get("activationStateOfChannel18")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel18, new WithWriterArgs[0]);
            boolean activationStateOfChannel19 = ((PlcValue)_value.getStruct().get("activationStateOfChannel19")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel19, new WithWriterArgs[0]);
            boolean activationStateOfChannel20 = ((PlcValue)_value.getStruct().get("activationStateOfChannel20")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel20, new WithWriterArgs[0]);
            boolean activationStateOfChannel21 = ((PlcValue)_value.getStruct().get("activationStateOfChannel21")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel21, new WithWriterArgs[0]);
            boolean activationStateOfChannel22 = ((PlcValue)_value.getStruct().get("activationStateOfChannel22")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel22, new WithWriterArgs[0]);
            boolean activationStateOfChannel23 = ((PlcValue)_value.getStruct().get("activationStateOfChannel23")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel23, new WithWriterArgs[0]);
            boolean activationStateOfChannel24 = ((PlcValue)_value.getStruct().get("activationStateOfChannel24")).getBoolean();
            writeBuffer.writeBit("", activationStateOfChannel24, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVACModeNext))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int delayTimeMin = ((PlcValue)_value.getStruct().get("delayTimeMin")).getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)delayTimeMin).intValue(), new WithWriterArgs[0]);
            short hvacMode = ((PlcValue)_value.getStruct().get("hvacMode")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)hvacMode).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DHWModeNext))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int delayTimeMin = ((PlcValue)_value.getStruct().get("delayTimeMin")).getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)delayTimeMin).intValue(), new WithWriterArgs[0]);
            short dhwMode = ((PlcValue)_value.getStruct().get("dhwMode")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)dhwMode).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_OccModeNext))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int delayTimeMin = ((PlcValue)_value.getStruct().get("delayTimeMin")).getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)delayTimeMin).intValue(), new WithWriterArgs[0]);
            short occupancyMode = ((PlcValue)_value.getStruct().get("occupancyMode")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)occupancyMode).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BuildingModeNext))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int delayTimeMin = ((PlcValue)_value.getStruct().get("delayTimeMin")).getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)delayTimeMin).intValue(), new WithWriterArgs[0]);
            short buildingMode = ((PlcValue)_value.getStruct().get("buildingMode")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)buildingMode).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusLightingActuator))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            boolean validactualvalue = ((PlcValue)_value.getStruct().get("validactualvalue")).getBoolean();
            writeBuffer.writeBit("", validactualvalue, new WithWriterArgs[0]);
            boolean locked = ((PlcValue)_value.getStruct().get("locked")).getBoolean();
            writeBuffer.writeBit("", locked, new WithWriterArgs[0]);
            boolean forced = ((PlcValue)_value.getStruct().get("forced")).getBoolean();
            writeBuffer.writeBit("", forced, new WithWriterArgs[0]);
            boolean nightmodeactive = ((PlcValue)_value.getStruct().get("nightmodeactive")).getBoolean();
            writeBuffer.writeBit("", nightmodeactive, new WithWriterArgs[0]);
            boolean staircaselightingFunction = ((PlcValue)_value.getStruct().get("staircaselightingFunction")).getBoolean();
            writeBuffer.writeBit("", staircaselightingFunction, new WithWriterArgs[0]);
            boolean dimming = ((PlcValue)_value.getStruct().get("dimming")).getBoolean();
            writeBuffer.writeBit("", dimming, new WithWriterArgs[0]);
            boolean localoverride = ((PlcValue)_value.getStruct().get("localoverride")).getBoolean();
            writeBuffer.writeBit("", localoverride, new WithWriterArgs[0]);
            boolean failure = ((PlcValue)_value.getStruct().get("failure")).getBoolean();
            writeBuffer.writeBit("", failure, new WithWriterArgs[0]);
            short actualvalue = ((PlcValue)_value.getStruct().get("actualvalue")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)actualvalue).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Version))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            byte magicNumber = ((PlcValue)_value.getStruct().get("magicNumber")).getByte();
            writeBuffer.writeUnsignedByte("", 5, ((Number)magicNumber).byteValue(), new WithWriterArgs[0]);
            byte versionNumber = ((PlcValue)_value.getStruct().get("versionNumber")).getByte();
            writeBuffer.writeUnsignedByte("", 5, ((Number)versionNumber).byteValue(), new WithWriterArgs[0]);
            byte revisionNumber = ((PlcValue)_value.getStruct().get("revisionNumber")).getByte();
            writeBuffer.writeUnsignedByte("", 6, ((Number)revisionNumber).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_AlarmInfo))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short logNumber = ((PlcValue)_value.getStruct().get("logNumber")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)logNumber).shortValue(), new WithWriterArgs[0]);
            short alarmPriority = ((PlcValue)_value.getStruct().get("alarmPriority")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)alarmPriority).shortValue(), new WithWriterArgs[0]);
            short applicationArea = ((PlcValue)_value.getStruct().get("applicationArea")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)applicationArea).shortValue(), new WithWriterArgs[0]);
            short errorClass = ((PlcValue)_value.getStruct().get("errorClass")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)errorClass).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean errorcodeSup = ((PlcValue)_value.getStruct().get("errorcodeSup")).getBoolean();
            writeBuffer.writeBit("", errorcodeSup, new WithWriterArgs[0]);
            boolean alarmtextSup = ((PlcValue)_value.getStruct().get("alarmtextSup")).getBoolean();
            writeBuffer.writeBit("", alarmtextSup, new WithWriterArgs[0]);
            boolean timestampSup = ((PlcValue)_value.getStruct().get("timestampSup")).getBoolean();
            writeBuffer.writeBit("", timestampSup, new WithWriterArgs[0]);
            boolean ackSup = ((PlcValue)_value.getStruct().get("ackSup")).getBoolean();
            writeBuffer.writeBit("", ackSup, new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 5, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean locked = ((PlcValue)_value.getStruct().get("locked")).getBoolean();
            writeBuffer.writeBit("", locked, new WithWriterArgs[0]);
            boolean alarmunack = ((PlcValue)_value.getStruct().get("alarmunack")).getBoolean();
            writeBuffer.writeBit("", alarmunack, new WithWriterArgs[0]);
            boolean inalarm = ((PlcValue)_value.getStruct().get("inalarm")).getBoolean();
            writeBuffer.writeBit("", inalarm, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TempRoomSetpSetF16_3))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float tempsetpcomf = ((PlcValue)_value.getStruct().get("tempsetpcomf")).getFloat();
            writeBuffer.writeFloat("", 16, tempsetpcomf, new WithWriterArgs[0]);
            float tempsetpstdby = ((PlcValue)_value.getStruct().get("tempsetpstdby")).getFloat();
            writeBuffer.writeFloat("", 16, tempsetpstdby, new WithWriterArgs[0]);
            float tempsetpeco = ((PlcValue)_value.getStruct().get("tempsetpeco")).getFloat();
            writeBuffer.writeFloat("", 16, tempsetpeco, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TempRoomSetpSetShiftF16_3))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float tempsetpshiftcomf = ((PlcValue)_value.getStruct().get("tempsetpshiftcomf")).getFloat();
            writeBuffer.writeFloat("", 16, tempsetpshiftcomf, new WithWriterArgs[0]);
            float tempsetpshiftstdby = ((PlcValue)_value.getStruct().get("tempsetpshiftstdby")).getFloat();
            writeBuffer.writeFloat("", 16, tempsetpshiftstdby, new WithWriterArgs[0]);
            float tempsetpshifteco = ((PlcValue)_value.getStruct().get("tempsetpshifteco")).getFloat();
            writeBuffer.writeFloat("", 16, tempsetpshifteco, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Scaling_Speed))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int timePeriod = ((PlcValue)_value.getStruct().get("timePeriod")).getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)timePeriod).intValue(), new WithWriterArgs[0]);
            short percent = ((PlcValue)_value.getStruct().get("percent")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)percent).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Scaling_Step_Time))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int timePeriod = ((PlcValue)_value.getStruct().get("timePeriod")).getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)timePeriod).intValue(), new WithWriterArgs[0]);
            short percent = ((PlcValue)_value.getStruct().get("percent")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)percent).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_MeteringValue))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int countval = ((PlcValue)_value.getStruct().get("countval")).getInt();
            writeBuffer.writeInt("", 32, ((Number)countval).intValue(), new WithWriterArgs[0]);
            short valinffield = ((PlcValue)_value.getStruct().get("valinffield")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)valinffield).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 3, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean alarmunack = ((PlcValue)_value.getStruct().get("alarmunack")).getBoolean();
            writeBuffer.writeBit("", alarmunack, new WithWriterArgs[0]);
            boolean inalarm = ((PlcValue)_value.getStruct().get("inalarm")).getBoolean();
            writeBuffer.writeBit("", inalarm, new WithWriterArgs[0]);
            boolean overridden = ((PlcValue)_value.getStruct().get("overridden")).getBoolean();
            writeBuffer.writeBit("", overridden, new WithWriterArgs[0]);
            boolean fault = ((PlcValue)_value.getStruct().get("fault")).getBoolean();
            writeBuffer.writeBit("", fault, new WithWriterArgs[0]);
            boolean outofservice = ((PlcValue)_value.getStruct().get("outofservice")).getBoolean();
            writeBuffer.writeBit("", outofservice, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_MBus_Address))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int manufactid = ((PlcValue)_value.getStruct().get("manufactid")).getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)manufactid).intValue(), new WithWriterArgs[0]);
            long identnumber = ((PlcValue)_value.getStruct().get("identnumber")).getLong();
            writeBuffer.writeUnsignedLong("", 32, ((Number)identnumber).longValue(), new WithWriterArgs[0]);
            short version = ((PlcValue)_value.getStruct().get("version")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)version).shortValue(), new WithWriterArgs[0]);
            short medium = ((PlcValue)_value.getStruct().get("medium")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)medium).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Colour_RGB))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short r = ((PlcValue)_value.getStruct().get("r")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)r).shortValue(), new WithWriterArgs[0]);
            short g = ((PlcValue)_value.getStruct().get("g")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)g).shortValue(), new WithWriterArgs[0]);
            short b = ((PlcValue)_value.getStruct().get("b")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)b).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LanguageCodeAlpha2_ASCII))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            String value = _value.getString();
            writeBuffer.writeString("", 16, value, new WithWriterArgs[]{WithOption.WithEncoding((String)"ASCII")});
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Tariff_ActiveEnergy))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int activeelectricalenergy = ((PlcValue)_value.getStruct().get("activeelectricalenergy")).getInt();
            writeBuffer.writeInt("", 32, ((Number)activeelectricalenergy).intValue(), new WithWriterArgs[0]);
            short tariff = ((PlcValue)_value.getStruct().get("tariff")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)tariff).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean electricalengergyvalidity = ((PlcValue)_value.getStruct().get("electricalengergyvalidity")).getBoolean();
            writeBuffer.writeBit("", electricalengergyvalidity, new WithWriterArgs[0]);
            boolean tariffvalidity = ((PlcValue)_value.getStruct().get("tariffvalidity")).getBoolean();
            writeBuffer.writeBit("", tariffvalidity, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Prioritised_Mode_Control))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            boolean deactivationOfPriority = ((PlcValue)_value.getStruct().get("deactivationOfPriority")).getBoolean();
            writeBuffer.writeBit("", deactivationOfPriority, new WithWriterArgs[0]);
            byte priorityLevel = ((PlcValue)_value.getStruct().get("priorityLevel")).getByte();
            writeBuffer.writeUnsignedByte("", 3, ((Number)priorityLevel).byteValue(), new WithWriterArgs[0]);
            byte modeLevel = ((PlcValue)_value.getStruct().get("modeLevel")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)modeLevel).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DALI_Control_Gear_Diagnostic))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 5, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean convertorError = ((PlcValue)_value.getStruct().get("convertorError")).getBoolean();
            writeBuffer.writeBit("", convertorError, new WithWriterArgs[0]);
            boolean ballastFailure = ((PlcValue)_value.getStruct().get("ballastFailure")).getBoolean();
            writeBuffer.writeBit("", ballastFailure, new WithWriterArgs[0]);
            boolean lampFailure = ((PlcValue)_value.getStruct().get("lampFailure")).getBoolean();
            writeBuffer.writeBit("", lampFailure, new WithWriterArgs[0]);
            boolean readOrResponse = ((PlcValue)_value.getStruct().get("readOrResponse")).getBoolean();
            writeBuffer.writeBit("", readOrResponse, new WithWriterArgs[0]);
            boolean addressIndicator = ((PlcValue)_value.getStruct().get("addressIndicator")).getBoolean();
            writeBuffer.writeBit("", addressIndicator, new WithWriterArgs[0]);
            byte daliDeviceAddressOrDaliGroupAddress = ((PlcValue)_value.getStruct().get("daliDeviceAddressOrDaliGroupAddress")).getByte();
            writeBuffer.writeUnsignedByte("", 6, ((Number)daliDeviceAddressOrDaliGroupAddress).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DALI_Diagnostics))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            boolean ballastFailure = ((PlcValue)_value.getStruct().get("ballastFailure")).getBoolean();
            writeBuffer.writeBit("", ballastFailure, new WithWriterArgs[0]);
            boolean lampFailure = ((PlcValue)_value.getStruct().get("lampFailure")).getBoolean();
            writeBuffer.writeBit("", lampFailure, new WithWriterArgs[0]);
            byte deviceAddress = ((PlcValue)_value.getStruct().get("deviceAddress")).getByte();
            writeBuffer.writeUnsignedByte("", 6, ((Number)deviceAddress).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedPosition))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short heightPosition = ((PlcValue)_value.getStruct().get("heightPosition")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)heightPosition).shortValue(), new WithWriterArgs[0]);
            short slatsPosition = ((PlcValue)_value.getStruct().get("slatsPosition")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)slatsPosition).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean validitySlatsPosition = ((PlcValue)_value.getStruct().get("validitySlatsPosition")).getBoolean();
            writeBuffer.writeBit("", validitySlatsPosition, new WithWriterArgs[0]);
            boolean validityHeightPosition = ((PlcValue)_value.getStruct().get("validityHeightPosition")).getBoolean();
            writeBuffer.writeBit("", validityHeightPosition, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusSAB))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short heightPosition = ((PlcValue)_value.getStruct().get("heightPosition")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)heightPosition).shortValue(), new WithWriterArgs[0]);
            short slatsPosition = ((PlcValue)_value.getStruct().get("slatsPosition")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)slatsPosition).shortValue(), new WithWriterArgs[0]);
            boolean upperEndPosReached = ((PlcValue)_value.getStruct().get("upperEndPosReached")).getBoolean();
            writeBuffer.writeBit("", upperEndPosReached, new WithWriterArgs[0]);
            boolean lowerEndPosReached = ((PlcValue)_value.getStruct().get("lowerEndPosReached")).getBoolean();
            writeBuffer.writeBit("", lowerEndPosReached, new WithWriterArgs[0]);
            boolean lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent = ((PlcValue)_value.getStruct().get("lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent")).getBoolean();
            writeBuffer.writeBit("", lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent, new WithWriterArgs[0]);
            boolean targetPosDrive = ((PlcValue)_value.getStruct().get("targetPosDrive")).getBoolean();
            writeBuffer.writeBit("", targetPosDrive, new WithWriterArgs[0]);
            boolean restrictionOfTargetHeightPosPosCanNotBeReached = ((PlcValue)_value.getStruct().get("restrictionOfTargetHeightPosPosCanNotBeReached")).getBoolean();
            writeBuffer.writeBit("", restrictionOfTargetHeightPosPosCanNotBeReached, new WithWriterArgs[0]);
            boolean restrictionOfSlatsHeightPosPosCanNotBeReached = ((PlcValue)_value.getStruct().get("restrictionOfSlatsHeightPosPosCanNotBeReached")).getBoolean();
            writeBuffer.writeBit("", restrictionOfSlatsHeightPosPosCanNotBeReached, new WithWriterArgs[0]);
            boolean atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm = ((PlcValue)_value.getStruct().get("atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm")).getBoolean();
            writeBuffer.writeBit("", atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm, new WithWriterArgs[0]);
            boolean upDownPositionIsForcedByMoveupdownforcedInput = ((PlcValue)_value.getStruct().get("upDownPositionIsForcedByMoveupdownforcedInput")).getBoolean();
            writeBuffer.writeBit("", upDownPositionIsForcedByMoveupdownforcedInput, new WithWriterArgs[0]);
            boolean movementIsLockedEGByDevicelockedInput = ((PlcValue)_value.getStruct().get("movementIsLockedEGByDevicelockedInput")).getBoolean();
            writeBuffer.writeBit("", movementIsLockedEGByDevicelockedInput, new WithWriterArgs[0]);
            boolean actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface = ((PlcValue)_value.getStruct().get("actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface")).getBoolean();
            writeBuffer.writeBit("", actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface, new WithWriterArgs[0]);
            boolean generalFailureOfTheActuatorOrTheDrive = ((PlcValue)_value.getStruct().get("generalFailureOfTheActuatorOrTheDrive")).getBoolean();
            writeBuffer.writeBit("", generalFailureOfTheActuatorOrTheDrive, new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 3, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean validityHeightPos = ((PlcValue)_value.getStruct().get("validityHeightPos")).getBoolean();
            writeBuffer.writeBit("", validityHeightPos, new WithWriterArgs[0]);
            boolean validitySlatsPos = ((PlcValue)_value.getStruct().get("validitySlatsPos")).getBoolean();
            writeBuffer.writeBit("", validitySlatsPos, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Colour_xyY))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int xAxis = ((PlcValue)_value.getStruct().get("xAxis")).getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)xAxis).intValue(), new WithWriterArgs[0]);
            int yAxis = ((PlcValue)_value.getStruct().get("yAxis")).getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)yAxis).intValue(), new WithWriterArgs[0]);
            short brightness = ((PlcValue)_value.getStruct().get("brightness")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)brightness).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean validityXy = ((PlcValue)_value.getStruct().get("validityXy")).getBoolean();
            writeBuffer.writeBit("", validityXy, new WithWriterArgs[0]);
            boolean validityBrightness = ((PlcValue)_value.getStruct().get("validityBrightness")).getBoolean();
            writeBuffer.writeBit("", validityBrightness, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Converter_Status))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            byte converterModeAccordingToTheDaliConverterStateMachine = ((PlcValue)_value.getStruct().get("converterModeAccordingToTheDaliConverterStateMachine")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)converterModeAccordingToTheDaliConverterStateMachine).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 2, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean hardwiredSwitchIsActive = ((PlcValue)_value.getStruct().get("hardwiredSwitchIsActive")).getBoolean();
            writeBuffer.writeBit("", hardwiredSwitchIsActive, new WithWriterArgs[0]);
            boolean hardwiredInhibitIsActive = ((PlcValue)_value.getStruct().get("hardwiredInhibitIsActive")).getBoolean();
            writeBuffer.writeBit("", hardwiredInhibitIsActive, new WithWriterArgs[0]);
            byte functionTestPending = ((PlcValue)_value.getStruct().get("functionTestPending")).getByte();
            writeBuffer.writeUnsignedByte("", 2, ((Number)functionTestPending).byteValue(), new WithWriterArgs[0]);
            byte durationTestPending = ((PlcValue)_value.getStruct().get("durationTestPending")).getByte();
            writeBuffer.writeUnsignedByte("", 2, ((Number)durationTestPending).byteValue(), new WithWriterArgs[0]);
            byte partialDurationTestPending = ((PlcValue)_value.getStruct().get("partialDurationTestPending")).getByte();
            writeBuffer.writeUnsignedByte("", 2, ((Number)partialDurationTestPending).byteValue(), new WithWriterArgs[0]);
            byte converterFailure = ((PlcValue)_value.getStruct().get("converterFailure")).getByte();
            writeBuffer.writeUnsignedByte("", 2, ((Number)converterFailure).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Converter_Test_Result))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            byte ltrf = ((PlcValue)_value.getStruct().get("ltrf")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)ltrf).byteValue(), new WithWriterArgs[0]);
            byte ltrd = ((PlcValue)_value.getStruct().get("ltrd")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)ltrd).byteValue(), new WithWriterArgs[0]);
            byte ltrp = ((PlcValue)_value.getStruct().get("ltrp")).getByte();
            writeBuffer.writeUnsignedByte("", 4, ((Number)ltrp).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            byte sf = ((PlcValue)_value.getStruct().get("sf")).getByte();
            writeBuffer.writeUnsignedByte("", 2, ((Number)sf).byteValue(), new WithWriterArgs[0]);
            byte sd = ((PlcValue)_value.getStruct().get("sd")).getByte();
            writeBuffer.writeUnsignedByte("", 2, ((Number)sd).byteValue(), new WithWriterArgs[0]);
            byte sp = ((PlcValue)_value.getStruct().get("sp")).getByte();
            writeBuffer.writeUnsignedByte("", 2, ((Number)sp).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 2, ((Number)0).byteValue(), new WithWriterArgs[0]);
            int ldtr = ((PlcValue)_value.getStruct().get("ldtr")).getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)ldtr).intValue(), new WithWriterArgs[0]);
            short lpdtr = ((PlcValue)_value.getStruct().get("lpdtr")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)lpdtr).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Battery_Info))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 5, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean batteryFailure = ((PlcValue)_value.getStruct().get("batteryFailure")).getBoolean();
            writeBuffer.writeBit("", batteryFailure, new WithWriterArgs[0]);
            boolean batteryDurationFailure = ((PlcValue)_value.getStruct().get("batteryDurationFailure")).getBoolean();
            writeBuffer.writeBit("", batteryDurationFailure, new WithWriterArgs[0]);
            boolean batteryFullyCharged = ((PlcValue)_value.getStruct().get("batteryFullyCharged")).getBoolean();
            writeBuffer.writeBit("", batteryFullyCharged, new WithWriterArgs[0]);
            short batteryChargeLevel = ((PlcValue)_value.getStruct().get("batteryChargeLevel")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)batteryChargeLevel).shortValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Brightness_Colour_Temperature_Transition))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            int ms = ((PlcValue)_value.getStruct().get("ms")).getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)ms).intValue(), new WithWriterArgs[0]);
            int temperatureK = ((PlcValue)_value.getStruct().get("temperatureK")).getInt();
            writeBuffer.writeUnsignedInt("", 16, ((Number)temperatureK).intValue(), new WithWriterArgs[0]);
            short percent = ((PlcValue)_value.getStruct().get("percent")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)percent).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 5, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean validityOfTheTimePeriod = ((PlcValue)_value.getStruct().get("validityOfTheTimePeriod")).getBoolean();
            writeBuffer.writeBit("", validityOfTheTimePeriod, new WithWriterArgs[0]);
            boolean validityOfTheAbsoluteColourTemperature = ((PlcValue)_value.getStruct().get("validityOfTheAbsoluteColourTemperature")).getBoolean();
            writeBuffer.writeBit("", validityOfTheAbsoluteColourTemperature, new WithWriterArgs[0]);
            boolean validityOfTheAbsoluteBrightness = ((PlcValue)_value.getStruct().get("validityOfTheAbsoluteBrightness")).getBoolean();
            writeBuffer.writeBit("", validityOfTheAbsoluteBrightness, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Brightness_Colour_Temperature_Control))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean cct = ((PlcValue)_value.getStruct().get("cct")).getBoolean();
            writeBuffer.writeBit("", cct, new WithWriterArgs[0]);
            byte stepCodeColourTemperature = ((PlcValue)_value.getStruct().get("stepCodeColourTemperature")).getByte();
            writeBuffer.writeUnsignedByte("", 3, ((Number)stepCodeColourTemperature).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean cb = ((PlcValue)_value.getStruct().get("cb")).getBoolean();
            writeBuffer.writeBit("", cb, new WithWriterArgs[0]);
            byte stepCodeBrightness = ((PlcValue)_value.getStruct().get("stepCodeBrightness")).getByte();
            writeBuffer.writeUnsignedByte("", 3, ((Number)stepCodeBrightness).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 6, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean cctAndStepCodeColourValidity = ((PlcValue)_value.getStruct().get("cctAndStepCodeColourValidity")).getBoolean();
            writeBuffer.writeBit("", cctAndStepCodeColourValidity, new WithWriterArgs[0]);
            boolean cbAndStepCodeBrightnessValidity = ((PlcValue)_value.getStruct().get("cbAndStepCodeBrightnessValidity")).getBoolean();
            writeBuffer.writeBit("", cbAndStepCodeBrightnessValidity, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Colour_RGBW))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            short colourLevelRed = ((PlcValue)_value.getStruct().get("colourLevelRed")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)colourLevelRed).shortValue(), new WithWriterArgs[0]);
            short colourLevelGreen = ((PlcValue)_value.getStruct().get("colourLevelGreen")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)colourLevelGreen).shortValue(), new WithWriterArgs[0]);
            short colourLevelBlue = ((PlcValue)_value.getStruct().get("colourLevelBlue")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)colourLevelBlue).shortValue(), new WithWriterArgs[0]);
            short colourLevelWhite = ((PlcValue)_value.getStruct().get("colourLevelWhite")).getShort();
            writeBuffer.writeUnsignedShort("", 8, ((Number)colourLevelWhite).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean mr = ((PlcValue)_value.getStruct().get("mr")).getBoolean();
            writeBuffer.writeBit("", mr, new WithWriterArgs[0]);
            boolean mg = ((PlcValue)_value.getStruct().get("mg")).getBoolean();
            writeBuffer.writeBit("", mg, new WithWriterArgs[0]);
            boolean mb = ((PlcValue)_value.getStruct().get("mb")).getBoolean();
            writeBuffer.writeBit("", mb, new WithWriterArgs[0]);
            boolean mw = ((PlcValue)_value.getStruct().get("mw")).getBoolean();
            writeBuffer.writeBit("", mw, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Relative_Control_RGBW))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean maskcw = ((PlcValue)_value.getStruct().get("maskcw")).getBoolean();
            writeBuffer.writeBit("", maskcw, new WithWriterArgs[0]);
            boolean maskcb = ((PlcValue)_value.getStruct().get("maskcb")).getBoolean();
            writeBuffer.writeBit("", maskcb, new WithWriterArgs[0]);
            boolean maskcg = ((PlcValue)_value.getStruct().get("maskcg")).getBoolean();
            writeBuffer.writeBit("", maskcg, new WithWriterArgs[0]);
            boolean maskcr = ((PlcValue)_value.getStruct().get("maskcr")).getBoolean();
            writeBuffer.writeBit("", maskcr, new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean cw = ((PlcValue)_value.getStruct().get("cw")).getBoolean();
            writeBuffer.writeBit("", cw, new WithWriterArgs[0]);
            byte stepCodeColourWhite = ((PlcValue)_value.getStruct().get("stepCodeColourWhite")).getByte();
            writeBuffer.writeUnsignedByte("", 3, ((Number)stepCodeColourWhite).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean cb = ((PlcValue)_value.getStruct().get("cb")).getBoolean();
            writeBuffer.writeBit("", cb, new WithWriterArgs[0]);
            byte stepCodeColourBlue = ((PlcValue)_value.getStruct().get("stepCodeColourBlue")).getByte();
            writeBuffer.writeUnsignedByte("", 3, ((Number)stepCodeColourBlue).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean cg = ((PlcValue)_value.getStruct().get("cg")).getBoolean();
            writeBuffer.writeBit("", cg, new WithWriterArgs[0]);
            byte stepCodeColourGreen = ((PlcValue)_value.getStruct().get("stepCodeColourGreen")).getByte();
            writeBuffer.writeUnsignedByte("", 3, ((Number)stepCodeColourGreen).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean cr = ((PlcValue)_value.getStruct().get("cr")).getBoolean();
            writeBuffer.writeBit("", cr, new WithWriterArgs[0]);
            byte stepCodeColourRed = ((PlcValue)_value.getStruct().get("stepCodeColourRed")).getByte();
            writeBuffer.writeUnsignedByte("", 3, ((Number)stepCodeColourRed).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Relative_Control_RGB))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean cb = ((PlcValue)_value.getStruct().get("cb")).getBoolean();
            writeBuffer.writeBit("", cb, new WithWriterArgs[0]);
            byte stepCodeColourBlue = ((PlcValue)_value.getStruct().get("stepCodeColourBlue")).getByte();
            writeBuffer.writeUnsignedByte("", 3, ((Number)stepCodeColourBlue).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean cg = ((PlcValue)_value.getStruct().get("cg")).getBoolean();
            writeBuffer.writeBit("", cg, new WithWriterArgs[0]);
            byte stepCodeColourGreen = ((PlcValue)_value.getStruct().get("stepCodeColourGreen")).getByte();
            writeBuffer.writeUnsignedByte("", 3, ((Number)stepCodeColourGreen).byteValue(), new WithWriterArgs[0]);
            writeBuffer.writeUnsignedByte("", 4, ((Number)0).byteValue(), new WithWriterArgs[0]);
            boolean cr = ((PlcValue)_value.getStruct().get("cr")).getBoolean();
            writeBuffer.writeBit("", cr, new WithWriterArgs[0]);
            byte stepCodeColourRed = ((PlcValue)_value.getStruct().get("stepCodeColourRed")).getByte();
            writeBuffer.writeUnsignedByte("", 3, ((Number)stepCodeColourRed).byteValue(), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_GeographicalLocation))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float longitude = ((PlcValue)_value.getStruct().get("longitude")).getFloat();
            writeBuffer.writeFloat("", 32, longitude, new WithWriterArgs[0]);
            float latitude = ((PlcValue)_value.getStruct().get("latitude")).getFloat();
            writeBuffer.writeFloat("", 32, latitude, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TempRoomSetpSetF16_4))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float roomTemperatureSetpointComfort = ((PlcValue)_value.getStruct().get("roomTemperatureSetpointComfort")).getFloat();
            writeBuffer.writeFloat("", 16, roomTemperatureSetpointComfort, new WithWriterArgs[0]);
            float roomTemperatureSetpointStandby = ((PlcValue)_value.getStruct().get("roomTemperatureSetpointStandby")).getFloat();
            writeBuffer.writeFloat("", 16, roomTemperatureSetpointStandby, new WithWriterArgs[0]);
            float roomTemperatureSetpointEconomy = ((PlcValue)_value.getStruct().get("roomTemperatureSetpointEconomy")).getFloat();
            writeBuffer.writeFloat("", 16, roomTemperatureSetpointEconomy, new WithWriterArgs[0]);
            float roomTemperatureSetpointBuildingProtection = ((PlcValue)_value.getStruct().get("roomTemperatureSetpointBuildingProtection")).getFloat();
            writeBuffer.writeFloat("", 16, roomTemperatureSetpointBuildingProtection, new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TempRoomSetpSetShiftF16_4))) {
            writeBuffer.writeUnsignedShort("", 8, ((Number)0).shortValue(), new WithWriterArgs[0]);
            float roomTemperatureSetpointShiftComfort = ((PlcValue)_value.getStruct().get("roomTemperatureSetpointShiftComfort")).getFloat();
            writeBuffer.writeFloat("", 16, roomTemperatureSetpointShiftComfort, new WithWriterArgs[0]);
            float roomTemperatureSetpointShiftStandby = ((PlcValue)_value.getStruct().get("roomTemperatureSetpointShiftStandby")).getFloat();
            writeBuffer.writeFloat("", 16, roomTemperatureSetpointShiftStandby, new WithWriterArgs[0]);
            float roomTemperatureSetpointShiftEconomy = ((PlcValue)_value.getStruct().get("roomTemperatureSetpointShiftEconomy")).getFloat();
            writeBuffer.writeFloat("", 16, roomTemperatureSetpointShiftEconomy, new WithWriterArgs[0]);
            float roomTemperatureSetpointShiftBuildingProtection = ((PlcValue)_value.getStruct().get("roomTemperatureSetpointShiftBuildingProtection")).getFloat();
            writeBuffer.writeFloat("", 16, roomTemperatureSetpointShiftBuildingProtection, new WithWriterArgs[0]);
        }
    }

    public static int getLengthInBytes(PlcValue _value, KnxDatapointType datapointType) {
        return (int)Math.ceil((double)KnxDatapoint.getLengthInBits(_value, datapointType) / 8.0);
    }

    public static int getLengthInBits(PlcValue _value, KnxDatapointType datapointType) {
        int sizeInBits = 0;
        if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.BOOL))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.BYTE))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.WORD))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DWORD))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LWORD))) {
            sizeInBits += 8;
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.USINT))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.SINT))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.UINT))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.INT))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.UDINT))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DINT))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.ULINT))) {
            sizeInBits += 8;
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LINT))) {
            sizeInBits += 8;
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.REAL))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LREAL))) {
            sizeInBits += 8;
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.CHAR))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.WCHAR))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.TIME))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.LTIME))) {
            sizeInBits += 8;
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DATE))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.TIME_OF_DAY))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.TOD))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DATE_AND_TIME))) {
            sizeInBits += 8;
            sizeInBits += 16;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DT))) {
            sizeInBits += 8;
            sizeInBits += 16;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Switch))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Bool))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Enable))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Ramp))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Alarm))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BinaryValue))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Step))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_UpDown))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_OpenClose))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Start))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_State))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Invert))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DimSendStyle))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_InputSource))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Reset))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Ack))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Trigger))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Occupancy))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Window_Door))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LogicalFunction))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Scene_AB))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ShutterBlinds_Mode))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DayNight))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Heat_Cool))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Switch_Control))) {
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Bool_Control))) {
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Enable_Control))) {
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Ramp_Control))) {
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Alarm_Control))) {
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BinaryValue_Control))) {
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Step_Control))) {
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Direction1_Control))) {
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Direction2_Control))) {
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Start_Control))) {
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_State_Control))) {
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Invert_Control))) {
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Control_Dimming))) {
            sizeInBits += 4;
            ++sizeInBits;
            sizeInBits += 3;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Control_Blinds))) {
            sizeInBits += 4;
            ++sizeInBits;
            sizeInBits += 3;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Char_ASCII))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Char_8859_1))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Scaling))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Angle))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Percent_U8))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DecimalFactor))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Tariff))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_1_Ucount))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FanStage))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Percent_V8))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_1_Count))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Status_Mode3))) {
            sizeInBits += 8;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            sizeInBits += 3;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_2_Ucount))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriodMsec))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriod10Msec))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriod100Msec))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriodSec))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriodMin))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimePeriodHrs))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PropDataType))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Length_mm))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_UElCurrentmA))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Brightness))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Absolute_Colour_Temperature))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_2_Count))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTimeMsec))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTime10Msec))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTime100Msec))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTimeSec))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTimeMin))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaTimeHrs))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Percent_V16))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Rotation_Angle))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Length_m))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Temp))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Tempd))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Tempa))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Lux))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Wsp))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Pres))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Humidity))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_AirQuality))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_AirFlow))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Time1))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Time2))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Volt))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Curr))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PowerDensity))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_KelvinPerPercent))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Power))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Volume_Flow))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Rain_Amount))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Temp_F))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Wsp_kmh))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Absolute_Humidity))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Concentration_ygm3))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Coefficient))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TimeOfDay))) {
            sizeInBits += 8;
            sizeInBits += 3;
            sizeInBits += 5;
            sizeInBits += 2;
            sizeInBits += 6;
            sizeInBits += 2;
            sizeInBits += 6;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Date))) {
            sizeInBits += 8;
            sizeInBits += 3;
            sizeInBits += 5;
            sizeInBits += 4;
            sizeInBits += 4;
            ++sizeInBits;
            sizeInBits += 7;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_4_Ucount))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LongTimePeriod_Sec))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LongTimePeriod_Min))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LongTimePeriod_Hrs))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_VolumeLiquid_Litre))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Volume_m_3))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_4_Count))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FlowRate_m3h))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActiveEnergy))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ApparantEnergy))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ReactiveEnergy))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActiveEnergy_kWh))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ApparantEnergy_kVAh))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ReactiveEnergy_kVARh))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActiveEnergy_MWh))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LongDeltaTimeSec))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaVolumeLiquid_Litre))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DeltaVolume_m_3))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Acceleration))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Acceleration_Angular))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Activation_Energy))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Activity))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Mol))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Amplitude))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_AngleRad))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_AngleDeg))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Angular_Momentum))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Angular_Velocity))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Area))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Capacitance))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Charge_DensitySurface))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Charge_DensityVolume))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Compressibility))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Conductance))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electrical_Conductivity))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Density))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Charge))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Current))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_CurrentDensity))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_DipoleMoment))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Displacement))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_FieldStrength))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Flux))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_FluxDensity))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Polarization))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_Potential))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electric_PotentialDifference))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_ElectromagneticMoment))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Electromotive_Force))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Energy))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Force))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Frequency))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Angular_Frequency))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Heat_Capacity))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Heat_FlowRate))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Heat_Quantity))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Impedance))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Length))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Light_Quantity))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Luminance))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Luminous_Flux))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Luminous_Intensity))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_FieldStrength))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_Flux))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_FluxDensity))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_Moment))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetic_Polarization))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Magnetization))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_MagnetomotiveForce))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Mass))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_MassFlux))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Momentum))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Phase_AngleRad))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Phase_AngleDeg))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Power))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Power_Factor))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Pressure))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Reactance))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Resistance))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Resistivity))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_SelfInductance))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_SolidAngle))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Sound_Intensity))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Speed))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Stress))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Surface_Tension))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Common_Temperature))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Absolute_Temperature))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_TemperatureDifference))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Thermal_Capacity))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Thermal_Conductivity))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_ThermoelectricPower))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Time))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Torque))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Volume))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Volume_Flux))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Weight))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_Work))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Value_ApparentPower))) {
            sizeInBits += 8;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Volume_Flux_Meter))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Volume_Flux_ls))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Access_Data))) {
            sizeInBits += 8;
            sizeInBits += 4;
            sizeInBits += 4;
            sizeInBits += 4;
            sizeInBits += 4;
            sizeInBits += 4;
            sizeInBits += 4;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            sizeInBits += 4;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_String_ASCII))) {
            sizeInBits += 8;
            sizeInBits += 112;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_String_8859_1))) {
            sizeInBits += 8;
            sizeInBits += 112;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SceneNumber))) {
            sizeInBits += 2;
            sizeInBits += 6;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SceneControl))) {
            sizeInBits += 8;
            ++sizeInBits;
            ++sizeInBits;
            sizeInBits += 6;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DateTime))) {
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 4;
            sizeInBits += 4;
            sizeInBits += 3;
            sizeInBits += 5;
            sizeInBits += 3;
            sizeInBits += 5;
            sizeInBits += 2;
            sizeInBits += 6;
            sizeInBits += 2;
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            sizeInBits += 7;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SCLOMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BuildingMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_OccMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Priority))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LightApplicationMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ApplicationArea))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_AlarmClassType))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PSUMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ErrorClass_System))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ErrorClass_HVAC))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Time_Delay))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Beaufort_Wind_Force_Scale))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SensorSelect))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActuatorConnectType))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Cloud_Cover))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PowerReturnMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FuelType))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BurnerType))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVACMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DHWMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LoadPriority))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVACContrMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVACEmergMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ChangeoverMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ValveMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DamperMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HeaterMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FanMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_MasterSlaveMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusRoomSetp))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Metering_DeviceType))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HumDehumMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_EnableHCStage))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ADAType))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BackupMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StartSynchronization))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Behaviour_Lock_Unlock))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Behaviour_Bus_Power_Up_Down))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DALI_Fade_Time))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BlinkingMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LightControlMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SwitchPBModel))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_PBAction))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DimmPBModel))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SwitchOnMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LoadTypeSet))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LoadTypeDetected))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Converter_Test_Control))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SABExcept_Behaviour))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SABBehaviour_Lock_Unlock))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SSSBMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BlindsControlMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CommMode))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_AddInfoTypes))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_RF_ModeSelect))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_RF_FilterSelect))) {
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusGen))) {
            sizeInBits += 8;
            sizeInBits += 3;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Device_Control))) {
            sizeInBits += 8;
            sizeInBits += 5;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ForceSign))) {
            sizeInBits += 8;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ForceSignCool))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusRHC))) {
            sizeInBits += 8;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusSDHWC))) {
            sizeInBits += 8;
            sizeInBits += 5;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_FuelTypeSet))) {
            sizeInBits += 8;
            sizeInBits += 5;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusRCC))) {
            sizeInBits += 7;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusAHU))) {
            sizeInBits += 8;
            sizeInBits += 4;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedStatus_RTSM))) {
            sizeInBits += 8;
            sizeInBits += 3;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LightActuatorErrorInfo))) {
            sizeInBits += 8;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_RF_ModeInfo))) {
            sizeInBits += 8;
            sizeInBits += 5;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_RF_FilterInfo))) {
            sizeInBits += 8;
            sizeInBits += 5;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Channel_Activation_8))) {
            sizeInBits += 8;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusDHWC))) {
            sizeInBits += 8;
            sizeInBits += 8;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusRHCC))) {
            sizeInBits += 8;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedStatus_HVA))) {
            sizeInBits += 8;
            sizeInBits += 7;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedStatus_RTC))) {
            sizeInBits += 8;
            sizeInBits += 7;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Media))) {
            sizeInBits += 8;
            sizeInBits += 10;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Channel_Activation_16))) {
            sizeInBits += 8;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_OnOffAction))) {
            sizeInBits += 6;
            sizeInBits += 2;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Alarm_Reaction))) {
            sizeInBits += 6;
            sizeInBits += 2;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_UpDown_Action))) {
            sizeInBits += 6;
            sizeInBits += 2;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVAC_PB_Action))) {
            sizeInBits += 6;
            sizeInBits += 2;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DoubleNibble))) {
            sizeInBits += 8;
            sizeInBits += 4;
            sizeInBits += 4;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_SceneInfo))) {
            sizeInBits += 8;
            ++sizeInBits;
            ++sizeInBits;
            sizeInBits += 6;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedInfoOnOff))) {
            sizeInBits += 8;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ActiveEnergy_V64))) {
            sizeInBits += 8;
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ApparantEnergy_V64))) {
            sizeInBits += 8;
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_ReactiveEnergy_V64))) {
            sizeInBits += 8;
            sizeInBits += 64;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Channel_Activation_24))) {
            sizeInBits += 8;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_HVACModeNext))) {
            sizeInBits += 8;
            sizeInBits += 16;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DHWModeNext))) {
            sizeInBits += 8;
            sizeInBits += 16;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_OccModeNext))) {
            sizeInBits += 8;
            sizeInBits += 16;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_BuildingModeNext))) {
            sizeInBits += 8;
            sizeInBits += 16;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusLightingActuator))) {
            sizeInBits += 8;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Version))) {
            sizeInBits += 8;
            sizeInBits += 5;
            sizeInBits += 5;
            sizeInBits += 6;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_AlarmInfo))) {
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 4;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            sizeInBits += 5;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TempRoomSetpSetF16_3))) {
            sizeInBits += 8;
            sizeInBits += 16;
            sizeInBits += 16;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TempRoomSetpSetShiftF16_3))) {
            sizeInBits += 8;
            sizeInBits += 16;
            sizeInBits += 16;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Scaling_Speed))) {
            sizeInBits += 8;
            sizeInBits += 16;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Scaling_Step_Time))) {
            sizeInBits += 8;
            sizeInBits += 16;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_MeteringValue))) {
            sizeInBits += 8;
            sizeInBits += 32;
            sizeInBits += 8;
            sizeInBits += 3;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_MBus_Address))) {
            sizeInBits += 8;
            sizeInBits += 16;
            sizeInBits += 32;
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Colour_RGB))) {
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_LanguageCodeAlpha2_ASCII))) {
            sizeInBits += 8;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Tariff_ActiveEnergy))) {
            sizeInBits += 8;
            sizeInBits += 32;
            sizeInBits += 8;
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Prioritised_Mode_Control))) {
            sizeInBits += 8;
            ++sizeInBits;
            sizeInBits += 3;
            sizeInBits += 4;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DALI_Control_Gear_Diagnostic))) {
            sizeInBits += 8;
            sizeInBits += 5;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            sizeInBits += 6;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_DALI_Diagnostics))) {
            sizeInBits += 8;
            ++sizeInBits;
            ++sizeInBits;
            sizeInBits += 6;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_CombinedPosition))) {
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_StatusSAB))) {
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            sizeInBits += 3;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Colour_xyY))) {
            sizeInBits += 8;
            sizeInBits += 16;
            sizeInBits += 16;
            sizeInBits += 8;
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Converter_Status))) {
            sizeInBits += 8;
            sizeInBits += 4;
            sizeInBits += 2;
            ++sizeInBits;
            ++sizeInBits;
            sizeInBits += 2;
            sizeInBits += 2;
            sizeInBits += 2;
            sizeInBits += 2;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Converter_Test_Result))) {
            sizeInBits += 8;
            sizeInBits += 4;
            sizeInBits += 4;
            sizeInBits += 4;
            sizeInBits += 4;
            sizeInBits += 2;
            sizeInBits += 2;
            sizeInBits += 2;
            sizeInBits += 2;
            sizeInBits += 16;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Battery_Info))) {
            sizeInBits += 8;
            sizeInBits += 5;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            sizeInBits += 8;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Brightness_Colour_Temperature_Transition))) {
            sizeInBits += 8;
            sizeInBits += 16;
            sizeInBits += 16;
            sizeInBits += 8;
            sizeInBits += 5;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Brightness_Colour_Temperature_Control))) {
            sizeInBits += 8;
            sizeInBits += 4;
            ++sizeInBits;
            sizeInBits += 3;
            sizeInBits += 4;
            ++sizeInBits;
            sizeInBits += 3;
            sizeInBits += 6;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Colour_RGBW))) {
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 8;
            sizeInBits += 4;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Relative_Control_RGBW))) {
            sizeInBits += 8;
            sizeInBits += 4;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            ++sizeInBits;
            sizeInBits += 4;
            ++sizeInBits;
            sizeInBits += 3;
            sizeInBits += 4;
            ++sizeInBits;
            sizeInBits += 3;
            sizeInBits += 4;
            ++sizeInBits;
            sizeInBits += 3;
            sizeInBits += 4;
            ++sizeInBits;
            sizeInBits += 3;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_Relative_Control_RGB))) {
            sizeInBits += 8;
            sizeInBits += 4;
            ++sizeInBits;
            sizeInBits += 3;
            sizeInBits += 4;
            ++sizeInBits;
            sizeInBits += 3;
            sizeInBits += 4;
            ++sizeInBits;
            sizeInBits += 3;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_GeographicalLocation))) {
            sizeInBits += 8;
            sizeInBits += 32;
            sizeInBits += 32;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TempRoomSetpSetF16_4))) {
            sizeInBits += 8;
            sizeInBits += 16;
            sizeInBits += 16;
            sizeInBits += 16;
            sizeInBits += 16;
        } else if (EvaluationHelper.equals((Object)((Object)datapointType), (Object)((Object)KnxDatapointType.DPT_TempRoomSetpSetShiftF16_4))) {
            sizeInBits += 8;
            sizeInBits += 16;
            sizeInBits += 16;
            sizeInBits += 16;
            sizeInBits += 16;
        }
        return sizeInBits;
    }
}

