/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.knxnetip.configuration.KnxNetIpConfiguration;
import org.apache.plc4x.java.knxnetip.configuration.KnxNetIpPcapReplayTransportConfiguration;
import org.apache.plc4x.java.knxnetip.configuration.KnxNetIpRawSocketTransportConfiguration;
import org.apache.plc4x.java.knxnetip.configuration.KnxNetIpUdpTransportConfiguration;
import org.apache.plc4x.java.knxnetip.context.KnxNetIpDriverContext;
import org.apache.plc4x.java.knxnetip.protocol.KnxNetIpProtocolLogic;
import org.apache.plc4x.java.knxnetip.readwrite.KnxNetIpMessage;
import org.apache.plc4x.java.knxnetip.tag.KnxNetIpTag;
import org.apache.plc4x.java.knxnetip.tag.KnxNetIpTagHandler;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.optimizer.SingleTagOptimizer;
import org.apache.plc4x.java.spi.values.PlcValueHandler;

public class KnxNetIpDriver
extends GeneratedDriverBase<KnxNetIpMessage> {
    public static final int KNXNET_IP_PORT = 3671;

    public String getProtocolCode() {
        return "knxnet-ip";
    }

    public String getProtocolName() {
        return "KNXNet/IP";
    }

    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return KnxNetIpConfiguration.class;
    }

    protected Optional<Class<? extends PlcTransportConfiguration>> getTransportConfigurationClass(String transportCode) {
        switch (transportCode) {
            case "udp": {
                return Optional.of(KnxNetIpUdpTransportConfiguration.class);
            }
            case "pcap": {
                return Optional.of(KnxNetIpPcapReplayTransportConfiguration.class);
            }
            case "raw": {
                return Optional.of(KnxNetIpRawSocketTransportConfiguration.class);
            }
        }
        return Optional.empty();
    }

    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("udp");
    }

    protected List<String> getSupportedTransportCodes() {
        return Arrays.asList("udp", "pcap", "raw");
    }

    protected boolean canPing() {
        return true;
    }

    protected boolean canRead() {
        return false;
    }

    protected boolean canWrite() {
        return true;
    }

    protected boolean canSubscribe() {
        return true;
    }

    protected BaseOptimizer getOptimizer() {
        return new SingleTagOptimizer();
    }

    protected PlcTagHandler getTagHandler() {
        return new KnxNetIpTagHandler();
    }

    protected org.apache.plc4x.java.api.value.PlcValueHandler getValueHandler() {
        return new PlcValueHandler();
    }

    protected boolean awaitDisconnectComplete() {
        return true;
    }

    protected ProtocolStackConfigurer<KnxNetIpMessage> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(KnxNetIpMessage.class, (readBuffer, objectArray) -> KnxNetIpMessage.staticParse(readBuffer, objectArray)).withProtocol(KnxNetIpProtocolLogic.class).withDriverContext(KnxNetIpDriverContext.class).withPacketSizeEstimator(PacketSizeEstimator.class).build();
    }

    public KnxNetIpTag prepareTag(String tagAddress) {
        return KnxNetIpTag.of(tagAddress);
    }

    public static class PacketSizeEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 6) {
                return byteBuf.getUnsignedShort(byteBuf.readerIndex() + 4);
            }
            return -1;
        }
    }
}

