/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.knxnetip.readwrite.ApduData;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ApduDataDeviceDescriptorResponse
extends ApduData
implements Message {
    protected final byte descriptorType;
    protected final byte[] data;

    @Override
    public Byte getApciType() {
        return (byte)13;
    }

    public ApduDataDeviceDescriptorResponse(byte descriptorType, byte[] data) {
        this.descriptorType = descriptorType;
        this.data = data;
    }

    public byte getDescriptorType() {
        return this.descriptorType;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected void serializeApduDataChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ApduDataDeviceDescriptorResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"descriptorType", (Object)this.descriptorType, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)6), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"data", (byte[])this.data, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ApduDataDeviceDescriptorResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ApduDataDeviceDescriptorResponse _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 6;
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public static ApduData.ApduDataBuilder staticParseApduDataBuilder(ReadBuffer readBuffer, Short dataLength) throws ParseException {
        readBuffer.pullContext("ApduDataDeviceDescriptorResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        byte descriptorType = (Byte)FieldReaderFactory.readSimpleField((String)"descriptorType", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)6), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(dataLength < 1 ? 0 : dataLength - 1), new WithReaderArgs[0]);
        readBuffer.closeContext("ApduDataDeviceDescriptorResponse", new WithReaderArgs[0]);
        return new ApduDataDeviceDescriptorResponseBuilderImpl(descriptorType, data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApduDataDeviceDescriptorResponse)) {
            return false;
        }
        ApduDataDeviceDescriptorResponse that = (ApduDataDeviceDescriptorResponse)o;
        return this.getDescriptorType() == that.getDescriptorType() && this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDescriptorType(), this.getData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ApduDataDeviceDescriptorResponseBuilderImpl
    implements ApduData.ApduDataBuilder {
        private final byte descriptorType;
        private final byte[] data;

        public ApduDataDeviceDescriptorResponseBuilderImpl(byte descriptorType, byte[] data) {
            this.descriptorType = descriptorType;
            this.data = data;
        }

        @Override
        public ApduDataDeviceDescriptorResponse build() {
            ApduDataDeviceDescriptorResponse apduDataDeviceDescriptorResponse = new ApduDataDeviceDescriptorResponse(this.descriptorType, this.data);
            return apduDataDeviceDescriptorResponse;
        }
    }
}

